/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqForwardDiffBezier;
import net.cellcomputing.himawari.library.CqParameter;
import net.cellcomputing.himawari.library.CqParameterTyped;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.CqSurface;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.RendermanInterface;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;
import net.cellcomputing.himawari.library.types.PublicFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqSurfacePatchBicubic
extends CqSurface {
    public CqSurfacePatchBicubic() {
        CqStats.STATS_INC(13);
    }

    public CqSurfacePatchBicubic(CqSurfacePatchBicubic From) {
        super(From);
        this.assignment(From);
        CqStats.STATS_INC(13);
    }

    @Override
    public void destruct() {
    }

    @Override
    public <T, SLT> void TypedNaturalDice(float uSize, float vSize, CqParameterTyped<T, SLT> pParam, IqShaderData pData) {
        CqForwardDiffBezier<T> vFD0 = new CqForwardDiffBezier<T>(1.0f / vSize, pParam.TClass);
        CqForwardDiffBezier<T> vFD1 = new CqForwardDiffBezier<T>(1.0f / vSize, pParam.TClass);
        CqForwardDiffBezier<T> vFD2 = new CqForwardDiffBezier<T>(1.0f / vSize, pParam.TClass);
        CqForwardDiffBezier<T> vFD3 = new CqForwardDiffBezier<T>(1.0f / vSize, pParam.TClass);
        CqForwardDiffBezier uFD0 = new CqForwardDiffBezier(1.0f / uSize, pParam.TClass);
        vFD0.CalcForwardDiff(pParam.pValue_get(0, 0), pParam.pValue_get(0, 4), pParam.pValue_get(0, 8), pParam.pValue_get(0, 12));
        vFD1.CalcForwardDiff(pParam.pValue_get(0, 1), pParam.pValue_get(0, 5), pParam.pValue_get(0, 9), pParam.pValue_get(0, 13));
        vFD2.CalcForwardDiff(pParam.pValue_get(0, 2), pParam.pValue_get(0, 6), pParam.pValue_get(0, 10), pParam.pValue_get(0, 14));
        vFD3.CalcForwardDiff(pParam.pValue_get(0, 3), pParam.pValue_get(0, 7), pParam.pValue_get(0, 11), pParam.pValue_get(0, 15));
        int iv = 0;
        while ((float)iv <= vSize) {
            Object vA = vFD0.GetValue();
            Object vB = vFD1.GetValue();
            Object vC = vFD2.GetValue();
            Object vD = vFD3.GetValue();
            uFD0.CalcForwardDiff(vA, vB, vC, vD);
            int iu = 0;
            while ((float)iu <= uSize) {
                Object vec = uFD0.GetValue();
                int igrid = (int)((float)iv * (uSize + 1.0f)) + iu;
                pData.SetValue(vec, igrid, vec.getClass());
                ++iu;
            }
            ++iv;
        }
    }

    @Override
    public <T, SLT> void TypedNaturalSubdivide(CqParameterTyped<T, SLT> pParam, CqParameterTyped<T, SLT> pResult1, CqParameterTyped<T, SLT> pResult2, boolean u) {
        block35: {
            int iu;
            int ivo;
            int iv;
            CqParameterTyped<T, SLT> pTParam = pParam;
            CqParameterTyped<T, SLT> pTResult1 = pResult1;
            CqParameterTyped<T, SLT> pTResult2 = pResult2;
            T t = pParam.pValue_get(0, 0);
            if (t instanceof p_float) {
                if (u) {
                    iv = 0;
                    while (iv < 4) {
                        ivo = iv * 4;
                        ((p_float)pTResult1.pValue_get((int)0, (int)(ivo + 0))).value = ((p_float)pTParam.pValue_get((int)0, (int)(ivo + 0))).value;
                        ((p_float)pTResult1.pValue_get((int)0, (int)(ivo + 1))).value = (((p_float)pTParam.pValue_get((int)0, (int)(ivo + 0))).value + ((p_float)pTParam.pValue_get((int)0, (int)(ivo + 1))).value) / 2.0f;
                        ((p_float)pTResult1.pValue_get((int)0, (int)(ivo + 2))).value = ((p_float)pTResult1.pValue_get((int)0, (int)(ivo + 1))).value / 2.0f + (((p_float)pTParam.pValue_get((int)0, (int)(ivo + 1))).value + ((p_float)pTParam.pValue_get((int)0, (int)(ivo + 2))).value) / 4.0f;
                        ((p_float)pTResult2.pValue_get((int)0, (int)(ivo + 3))).value = ((p_float)pTParam.pValue_get((int)0, (int)(ivo + 3))).value;
                        ((p_float)pTResult2.pValue_get((int)0, (int)(ivo + 2))).value = (((p_float)pTParam.pValue_get((int)0, (int)(ivo + 2))).value + ((p_float)pTParam.pValue_get((int)0, (int)(ivo + 3))).value) / 2.0f;
                        ((p_float)pTResult2.pValue_get((int)0, (int)(ivo + 1))).value = ((p_float)pTResult2.pValue_get((int)0, (int)(ivo + 2))).value / 2.0f + (((p_float)pTParam.pValue_get((int)0, (int)(ivo + 1))).value + ((p_float)pTParam.pValue_get((int)0, (int)(ivo + 2))).value) / 4.0f;
                        ((p_float)pTResult2.pValue_get((int)0, (int)(ivo + 0))).value = ((p_float)pTResult1.pValue_get((int)0, (int)(ivo + 3))).value = (((p_float)pTResult1.pValue_get((int)0, (int)(ivo + 2))).value + ((p_float)pTResult2.pValue_get((int)0, (int)(ivo + 1))).value) / 2.0f;
                        ++iv;
                    }
                } else {
                    iu = 0;
                    while (iu < 4) {
                        ((p_float)pTResult1.pValue_get((int)0, (int)(0 + iu))).value = ((p_float)pTParam.pValue_get((int)0, (int)(0 + iu))).value;
                        ((p_float)pTResult1.pValue_get((int)0, (int)(4 + iu))).value = (((p_float)pTParam.pValue_get((int)0, (int)(0 + iu))).value + ((p_float)pTParam.pValue_get((int)0, (int)(4 + iu))).value) / 2.0f;
                        ((p_float)pTResult1.pValue_get((int)0, (int)(8 + iu))).value = ((p_float)pTResult1.pValue_get((int)0, (int)(4 + iu))).value / 2.0f + (((p_float)pTParam.pValue_get((int)0, (int)(4 + iu))).value + ((p_float)pTParam.pValue_get((int)0, (int)(8 + iu))).value) / 4.0f;
                        ((p_float)pTResult2.pValue_get((int)0, (int)(12 + iu))).value = ((p_float)pTParam.pValue_get((int)0, (int)(12 + iu))).value;
                        ((p_float)pTResult2.pValue_get((int)0, (int)(8 + iu))).value = (((p_float)pTParam.pValue_get((int)0, (int)(8 + iu))).value + ((p_float)pTParam.pValue_get((int)0, (int)(12 + iu))).value) / 2.0f;
                        ((p_float)pTResult2.pValue_get((int)0, (int)(4 + iu))).value = ((p_float)pTResult2.pValue_get((int)0, (int)(8 + iu))).value / 2.0f + (((p_float)pTParam.pValue_get((int)0, (int)(4 + iu))).value + ((p_float)pTParam.pValue_get((int)0, (int)(8 + iu))).value) / 4.0f;
                        ((p_float)pTResult2.pValue_get((int)0, (int)(0 + iu))).value = ((p_float)pTResult1.pValue_get((int)0, (int)(12 + iu))).value = (((p_float)pTResult1.pValue_get((int)0, (int)(8 + iu))).value + ((p_float)pTResult2.pValue_get((int)0, (int)(4 + iu))).value) / 2.0f;
                        ++iu;
                    }
                }
            } else if (t instanceof CqVector3D) {
                if (u) {
                    iv = 0;
                    while (iv < 4) {
                        ivo = iv * 4;
                        ((CqVector3D)pTResult1.pValue_get(0, ivo + 0)).assignment((CqVector3D)pTParam.pValue_get(0, ivo + 0));
                        ((CqVector3D)pTResult1.pValue_get(0, ivo + 1)).assignment(((CqVector3D)pTParam.pValue_get(0, ivo + 0)).add((CqVector3D)pTParam.pValue_get(0, ivo + 1)).div(2.0f));
                        ((CqVector3D)pTResult1.pValue_get(0, ivo + 2)).assignment(((CqVector3D)pTResult1.pValue_get(0, ivo + 1)).div(2.0f).add(((CqVector3D)pTParam.pValue_get(0, ivo + 1)).add((CqVector3D)pTParam.pValue_get(0, ivo + 2)).div(4.0f)));
                        ((CqVector3D)pTResult2.pValue_get(0, ivo + 3)).assignment((CqVector3D)pTParam.pValue_get(0, ivo + 3));
                        ((CqVector3D)pTResult2.pValue_get(0, ivo + 2)).assignment(((CqVector3D)pTParam.pValue_get(0, ivo + 2)).add((CqVector3D)pTParam.pValue_get(0, ivo + 3)).div(2.0f));
                        ((CqVector3D)pTResult2.pValue_get(0, ivo + 1)).assignment(((CqVector3D)pTResult2.pValue_get(0, ivo + 2)).div(2.0f).add(((CqVector3D)pTParam.pValue_get(0, ivo + 1)).add((CqVector3D)pTParam.pValue_get(0, ivo + 2)).div(4.0f)));
                        ((CqVector3D)pTResult1.pValue_get(0, ivo + 3)).assignment(((CqVector3D)pTResult1.pValue_get(0, ivo + 2)).add((CqVector3D)pTResult2.pValue_get(0, ivo + 1)).div(2.0f));
                        ((CqVector3D)pTResult2.pValue_get(0, ivo + 0)).assignment((CqVector3D)pTResult1.pValue_get(0, ivo + 3));
                        ++iv;
                    }
                } else {
                    iu = 0;
                    while (iu < 4) {
                        ((CqVector3D)pTResult1.pValue_get(0, 0 + iu)).assignment((CqVector3D)pTParam.pValue_get(0, 0 + iu));
                        ((CqVector3D)pTResult1.pValue_get(0, 4 + iu)).assignment(((CqVector3D)pTParam.pValue_get(0, 0 + iu)).add((CqVector3D)pTParam.pValue_get(0, 4 + iu)).div(2.0f));
                        ((CqVector3D)pTResult1.pValue_get(0, 8 + iu)).assignment(((CqVector3D)pTResult1.pValue_get(0, 4 + iu)).div(2.0f).add(((CqVector3D)pTParam.pValue_get(0, 4 + iu)).add((CqVector3D)pTParam.pValue_get(0, 8 + iu)).div(4.0f)));
                        ((CqVector3D)pTResult2.pValue_get(0, 12 + iu)).assignment((CqVector3D)pTParam.pValue_get(0, 12 + iu));
                        ((CqVector3D)pTResult2.pValue_get(0, 8 + iu)).assignment(((CqVector3D)pTParam.pValue_get(0, 8 + iu)).add((CqVector3D)pTParam.pValue_get(0, 12 + iu)).div(2.0f));
                        ((CqVector3D)pTResult2.pValue_get(0, 4 + iu)).assignment(((CqVector3D)pTResult2.pValue_get(0, 8 + iu)).div(2.0f).add(((CqVector3D)pTParam.pValue_get(0, 4 + iu)).add((CqVector3D)pTParam.pValue_get(0, 8 + iu)).div(4.0f)));
                        ((CqVector3D)pTResult1.pValue_get(0, 12 + iu)).assignment(((CqVector3D)pTResult1.pValue_get(0, 8 + iu)).add((CqVector3D)pTResult2.pValue_get(0, 4 + iu)).div(2.0f));
                        ((CqVector3D)pTResult2.pValue_get(0, 0 + iu)).assignment((CqVector3D)pTResult1.pValue_get(0, 12 + iu));
                        ++iu;
                    }
                }
            }
            if (t instanceof CqVector4D) {
                if (u) {
                    iv = 0;
                    while (iv < 4) {
                        ivo = iv * 4;
                        ((CqVector4D)pTResult1.pValue_get(0, ivo + 0)).assignment((CqVector4D)pTParam.pValue_get(0, ivo + 0));
                        ((CqVector4D)pTResult1.pValue_get(0, ivo + 1)).assignment(((CqVector4D)pTParam.pValue_get(0, ivo + 0)).add((CqVector4D)pTParam.pValue_get(0, ivo + 1)).div(2.0f));
                        ((CqVector4D)pTResult1.pValue_get(0, ivo + 2)).assignment(((CqVector4D)pTResult1.pValue_get(0, ivo + 1)).div(2.0f).add(((CqVector4D)pTParam.pValue_get(0, ivo + 1)).add((CqVector4D)pTParam.pValue_get(0, ivo + 2)).div(4.0f)));
                        ((CqVector4D)pTResult2.pValue_get(0, ivo + 3)).assignment((CqVector4D)pTParam.pValue_get(0, ivo + 3));
                        ((CqVector4D)pTResult2.pValue_get(0, ivo + 2)).assignment(((CqVector4D)pTParam.pValue_get(0, ivo + 2)).add((CqVector4D)pTParam.pValue_get(0, ivo + 3)).div(2.0f));
                        ((CqVector4D)pTResult2.pValue_get(0, ivo + 1)).assignment(((CqVector4D)pTResult2.pValue_get(0, ivo + 2)).div(2.0f).add(((CqVector4D)pTParam.pValue_get(0, ivo + 1)).add((CqVector4D)pTParam.pValue_get(0, ivo + 2)).div(4.0f)));
                        ((CqVector4D)pTResult1.pValue_get(0, ivo + 3)).assignment(((CqVector4D)pTResult1.pValue_get(0, ivo + 2)).add((CqVector4D)pTResult2.pValue_get(0, ivo + 1)).div(2.0f));
                        ((CqVector4D)pTResult2.pValue_get(0, ivo + 0)).assignment((CqVector4D)pTResult1.pValue_get(0, ivo + 3));
                        ++iv;
                    }
                } else {
                    iu = 0;
                    while (iu < 4) {
                        ((CqVector4D)pTResult1.pValue_get(0, 0 + iu)).assignment((CqVector4D)pTParam.pValue_get(0, 0 + iu));
                        ((CqVector4D)pTResult1.pValue_get(0, 4 + iu)).assignment(((CqVector4D)pTParam.pValue_get(0, 0 + iu)).add((CqVector4D)pTParam.pValue_get(0, 4 + iu)).div(2.0f));
                        ((CqVector4D)pTResult1.pValue_get(0, 8 + iu)).assignment(((CqVector4D)pTResult1.pValue_get(0, 4 + iu)).div(2.0f).add(((CqVector4D)pTParam.pValue_get(0, 4 + iu)).add((CqVector4D)pTParam.pValue_get(0, 8 + iu)).div(4.0f)));
                        ((CqVector4D)pTResult2.pValue_get(0, 12 + iu)).assignment((CqVector4D)pTParam.pValue_get(0, 12 + iu));
                        ((CqVector4D)pTResult2.pValue_get(0, 8 + iu)).assignment(((CqVector4D)pTParam.pValue_get(0, 8 + iu)).add((CqVector4D)pTParam.pValue_get(0, 12 + iu)).div(2.0f));
                        ((CqVector4D)pTResult2.pValue_get(0, 4 + iu)).assignment(((CqVector4D)pTResult2.pValue_get(0, 8 + iu)).div(2.0f).add(((CqVector4D)pTParam.pValue_get(0, 4 + iu)).add((CqVector4D)pTParam.pValue_get(0, 8 + iu)).div(4.0f)));
                        ((CqVector4D)pTResult1.pValue_get(0, 12 + iu)).assignment(((CqVector4D)pTResult1.pValue_get(0, 8 + iu)).add((CqVector4D)pTResult2.pValue_get(0, 4 + iu)).div(2.0f));
                        ((CqVector4D)pTResult2.pValue_get(0, 0 + iu)).assignment((CqVector4D)pTResult1.pValue_get(0, 12 + iu));
                        ++iu;
                    }
                }
            }
            if (t instanceof CqColor) {
                if (u) {
                    iv = 0;
                    while (iv < 4) {
                        ivo = iv * 4;
                        ((CqColor)pTResult1.pValue_get(0, ivo + 0)).assignment((CqColor)pTParam.pValue_get(0, ivo + 0));
                        ((CqColor)pTResult1.pValue_get(0, ivo + 1)).assignment(((CqColor)pTParam.pValue_get(0, ivo + 0)).add((CqColor)pTParam.pValue_get(0, ivo + 1)).div(2.0f));
                        ((CqColor)pTResult1.pValue_get(0, ivo + 2)).assignment(((CqColor)pTResult1.pValue_get(0, ivo + 1)).div(2.0f).add(((CqColor)pTParam.pValue_get(0, ivo + 1)).add((CqColor)pTParam.pValue_get(0, ivo + 2)).div(4.0f)));
                        ((CqColor)pTResult2.pValue_get(0, ivo + 3)).assignment((CqColor)pTParam.pValue_get(0, ivo + 3));
                        ((CqColor)pTResult2.pValue_get(0, ivo + 2)).assignment(((CqColor)pTParam.pValue_get(0, ivo + 2)).add((CqColor)pTParam.pValue_get(0, ivo + 3)).div(2.0f));
                        ((CqColor)pTResult2.pValue_get(0, ivo + 1)).assignment(((CqColor)pTResult2.pValue_get(0, ivo + 2)).div(2.0f).add(((CqColor)pTParam.pValue_get(0, ivo + 1)).add((CqColor)pTParam.pValue_get(0, ivo + 2)).div(4.0f)));
                        ((CqColor)pTResult1.pValue_get(0, ivo + 3)).assignment(((CqColor)pTResult1.pValue_get(0, ivo + 2)).add((CqColor)pTResult2.pValue_get(0, ivo + 1)).div(2.0f));
                        ((CqColor)pTResult2.pValue_get(0, ivo + 0)).assignment((CqColor)pTResult1.pValue_get(0, ivo + 3));
                        ++iv;
                    }
                } else {
                    iu = 0;
                    while (iu < 4) {
                        ((CqColor)pTResult1.pValue_get(0, 0 + iu)).assignment((CqColor)pTParam.pValue_get(0, 0 + iu));
                        ((CqColor)pTResult1.pValue_get(0, 4 + iu)).assignment(((CqColor)pTParam.pValue_get(0, 0 + iu)).add((CqColor)pTParam.pValue_get(0, 4 + iu)).div(2.0f));
                        ((CqColor)pTResult1.pValue_get(0, 8 + iu)).assignment(((CqColor)pTResult1.pValue_get(0, 4 + iu)).div(2.0f).add(((CqColor)pTParam.pValue_get(0, 4 + iu)).add((CqColor)pTParam.pValue_get(0, 8 + iu)).div(4.0f)));
                        ((CqColor)pTResult2.pValue_get(0, 12 + iu)).assignment((CqColor)pTParam.pValue_get(0, 12 + iu));
                        ((CqColor)pTResult2.pValue_get(0, 8 + iu)).assignment(((CqColor)pTParam.pValue_get(0, 8 + iu)).add((CqColor)pTParam.pValue_get(0, 12 + iu)).div(2.0f));
                        ((CqColor)pTResult2.pValue_get(0, 4 + iu)).assignment(((CqColor)pTResult2.pValue_get(0, 8 + iu)).div(2.0f).add(((CqColor)pTParam.pValue_get(0, 4 + iu)).add((CqColor)pTParam.pValue_get(0, 8 + iu)).div(4.0f)));
                        ((CqColor)pTResult1.pValue_get(0, 12 + iu)).assignment(((CqColor)pTResult1.pValue_get(0, 8 + iu)).add((CqColor)pTResult2.pValue_get(0, 4 + iu)).div(2.0f));
                        ((CqColor)pTResult2.pValue_get(0, 0 + iu)).assignment((CqColor)pTResult1.pValue_get(0, 12 + iu));
                        ++iu;
                    }
                }
            }
            if (t instanceof CqMatrix) {
                if (u) {
                    iv = 0;
                    while (iv < 4) {
                        ivo = iv * 4;
                        ((CqMatrix)pTResult1.pValue_get(0, ivo + 0)).assignment((CqMatrix)pTParam.pValue_get(0, ivo + 0));
                        ((CqMatrix)pTResult1.pValue_get(0, ivo + 1)).assignment(((CqMatrix)pTParam.pValue_get(0, ivo + 0)).add((CqMatrix)pTParam.pValue_get(0, ivo + 1)).mulInv(0.5f));
                        ((CqMatrix)pTResult1.pValue_get(0, ivo + 2)).assignment(((CqMatrix)pTResult1.pValue_get(0, ivo + 1)).mulInv(0.5f).add(((CqMatrix)pTParam.pValue_get(0, ivo + 1)).add((CqMatrix)pTParam.pValue_get(0, ivo + 2)).mulInv(0.25f)));
                        ((CqMatrix)pTResult2.pValue_get(0, ivo + 3)).assignment((CqMatrix)pTParam.pValue_get(0, ivo + 3));
                        ((CqMatrix)pTResult2.pValue_get(0, ivo + 2)).assignment(((CqMatrix)pTParam.pValue_get(0, ivo + 2)).add((CqMatrix)pTParam.pValue_get(0, ivo + 3)).mulInv(0.5f));
                        ((CqMatrix)pTResult2.pValue_get(0, ivo + 1)).assignment(((CqMatrix)pTResult2.pValue_get(0, ivo + 2)).mulInv(0.5f).add(((CqMatrix)pTParam.pValue_get(0, ivo + 1)).add((CqMatrix)pTParam.pValue_get(0, ivo + 2)).mulInv(0.25f)));
                        ((CqMatrix)pTResult1.pValue_get(0, ivo + 3)).assignment(((CqMatrix)pTResult1.pValue_get(0, ivo + 2)).add((CqMatrix)pTResult2.pValue_get(0, ivo + 1)).mulInv(0.5f));
                        ((CqMatrix)pTResult2.pValue_get(0, ivo + 0)).assignment((CqMatrix)pTResult1.pValue_get(0, ivo + 3));
                        ++iv;
                    }
                } else {
                    iu = 0;
                    while (iu < 4) {
                        ((CqMatrix)pTResult1.pValue_get(0, 0 + iu)).assignment((CqMatrix)pTParam.pValue_get(0, 0 + iu));
                        ((CqMatrix)pTResult1.pValue_get(0, 4 + iu)).assignment(((CqMatrix)pTParam.pValue_get(0, 0 + iu)).add((CqMatrix)pTParam.pValue_get(0, 4 + iu)).mulInv(0.5f));
                        ((CqMatrix)pTResult1.pValue_get(0, 8 + iu)).assignment(((CqMatrix)pTResult1.pValue_get(0, 4 + iu)).mulInv(0.5f).add(((CqMatrix)pTParam.pValue_get(0, 4 + iu)).add((CqMatrix)pTParam.pValue_get(0, 8 + iu)).mulInv(0.25f)));
                        ((CqMatrix)pTResult2.pValue_get(0, 12 + iu)).assignment((CqMatrix)pTParam.pValue_get(0, 12 + iu));
                        ((CqMatrix)pTResult2.pValue_get(0, 8 + iu)).assignment(((CqMatrix)pTParam.pValue_get(0, 8 + iu)).add((CqMatrix)pTParam.pValue_get(0, 12 + iu)).mulInv(0.5f));
                        ((CqMatrix)pTResult2.pValue_get(0, 4 + iu)).assignment(((CqMatrix)pTResult2.pValue_get(0, 8 + iu)).mulInv(0.5f).add(((CqMatrix)pTParam.pValue_get(0, 4 + iu)).add((CqMatrix)pTParam.pValue_get(0, 8 + iu)).mulInv(0.25f)));
                        ((CqMatrix)pTResult1.pValue_get(0, 12 + iu)).assignment(((CqMatrix)pTResult1.pValue_get(0, 8 + iu)).add((CqMatrix)pTResult2.pValue_get(0, 4 + iu)).mulInv(0.5f));
                        ((CqMatrix)pTResult2.pValue_get(0, 0 + iu)).assignment((CqMatrix)pTResult1.pValue_get(0, 12 + iu));
                        ++iu;
                    }
                }
            }
            if (t instanceof p_int) {
                if (u) {
                    iv = 0;
                    while (iv < 4) {
                        ivo = iv * 4;
                        ((p_int)pTResult1.pValue_get((int)0, (int)(ivo + 0))).value = ((p_int)pTParam.pValue_get((int)0, (int)(ivo + 0))).value;
                        ((p_int)pTResult1.pValue_get((int)0, (int)(ivo + 1))).value = (int)((float)(((p_int)pTParam.pValue_get((int)0, (int)(ivo + 0))).value + ((p_int)pTParam.pValue_get((int)0, (int)(ivo + 1))).value) / 2.0f);
                        ((p_int)pTResult1.pValue_get((int)0, (int)(ivo + 2))).value = (int)((float)((p_int)pTResult1.pValue_get((int)0, (int)(ivo + 1))).value / 2.0f + (float)(((p_int)pTParam.pValue_get((int)0, (int)(ivo + 1))).value + ((p_int)pTParam.pValue_get((int)0, (int)(ivo + 2))).value) / 4.0f);
                        ((p_int)pTResult2.pValue_get((int)0, (int)(ivo + 3))).value = ((p_int)pTParam.pValue_get((int)0, (int)(ivo + 3))).value;
                        ((p_int)pTResult2.pValue_get((int)0, (int)(ivo + 2))).value = (int)((float)(((p_int)pTParam.pValue_get((int)0, (int)(ivo + 2))).value + ((p_int)pTParam.pValue_get((int)0, (int)(ivo + 3))).value) / 2.0f);
                        ((p_int)pTResult2.pValue_get((int)0, (int)(ivo + 1))).value = (int)((float)((p_int)pTResult2.pValue_get((int)0, (int)(ivo + 2))).value / 2.0f + (float)(((p_int)pTParam.pValue_get((int)0, (int)(ivo + 1))).value + ((p_int)pTParam.pValue_get((int)0, (int)(ivo + 2))).value) / 4.0f);
                        ((p_int)pTResult2.pValue_get((int)0, (int)(ivo + 0))).value = ((p_int)pTResult1.pValue_get((int)0, (int)(ivo + 3))).value = (int)((float)(((p_int)pTResult1.pValue_get((int)0, (int)(ivo + 2))).value + ((p_int)pTResult2.pValue_get((int)0, (int)(ivo + 1))).value) / 2.0f);
                        ++iv;
                    }
                } else {
                    iu = 0;
                    while (iu < 4) {
                        ((p_int)pTResult1.pValue_get((int)0, (int)(0 + iu))).value = ((p_int)pTParam.pValue_get((int)0, (int)(0 + iu))).value;
                        ((p_int)pTResult1.pValue_get((int)0, (int)(4 + iu))).value = (int)((float)(((p_int)pTParam.pValue_get((int)0, (int)(0 + iu))).value + ((p_int)pTParam.pValue_get((int)0, (int)(4 + iu))).value) / 2.0f);
                        ((p_int)pTResult1.pValue_get((int)0, (int)(8 + iu))).value = (int)((float)((p_int)pTResult1.pValue_get((int)0, (int)(4 + iu))).value / 2.0f + (float)(((p_int)pTParam.pValue_get((int)0, (int)(4 + iu))).value + ((p_int)pTParam.pValue_get((int)0, (int)(8 + iu))).value) / 4.0f);
                        ((p_int)pTResult2.pValue_get((int)0, (int)(12 + iu))).value = ((p_int)pTParam.pValue_get((int)0, (int)(12 + iu))).value;
                        ((p_int)pTResult2.pValue_get((int)0, (int)(8 + iu))).value = (int)((float)(((p_int)pTParam.pValue_get((int)0, (int)(8 + iu))).value + ((p_int)pTParam.pValue_get((int)0, (int)(12 + iu))).value) / 2.0f);
                        ((p_int)pTResult2.pValue_get((int)0, (int)(4 + iu))).value = (int)((float)((p_int)pTResult2.pValue_get((int)0, (int)(8 + iu))).value / 2.0f + (float)(((p_int)pTParam.pValue_get((int)0, (int)(4 + iu))).value + ((p_int)pTParam.pValue_get((int)0, (int)(8 + iu))).value) / 4.0f);
                        ((p_int)pTResult2.pValue_get((int)0, (int)(0 + iu))).value = ((p_int)pTResult1.pValue_get((int)0, (int)(12 + iu))).value = (int)((float)(((p_int)pTResult1.pValue_get((int)0, (int)(8 + iu))).value + ((p_int)pTResult2.pValue_get((int)0, (int)(4 + iu))).value) / 2.0f);
                        ++iu;
                    }
                }
            }
            if (!(t instanceof p_String)) break block35;
            if (u) {
                iv = 0;
                while (iv < 4) {
                    ivo = iv * 4;
                    ((p_String)pTResult1.pValue_get((int)0, (int)(ivo + 0))).value = ((p_String)pTParam.pValue_get((int)0, (int)(ivo + 0))).value;
                    ((p_String)pTResult1.pValue_get((int)0, (int)(ivo + 1))).value = String.valueOf(((p_String)pTParam.pValue_get((int)0, (int)(ivo + 0))).value) + ((p_String)pTParam.pValue_get((int)0, (int)(ivo + 1))).value;
                    ((p_String)pTResult1.pValue_get((int)0, (int)(ivo + 2))).value = String.valueOf(((p_String)pTResult1.pValue_get((int)0, (int)(ivo + 1))).value) + ((p_String)pTParam.pValue_get((int)0, (int)(ivo + 1))).value + ((p_String)pTParam.pValue_get((int)0, (int)(ivo + 2))).value;
                    ((p_String)pTResult2.pValue_get((int)0, (int)(ivo + 3))).value = ((p_String)pTParam.pValue_get((int)0, (int)(ivo + 3))).value;
                    ((p_String)pTResult2.pValue_get((int)0, (int)(ivo + 2))).value = String.valueOf(((p_String)pTParam.pValue_get((int)0, (int)(ivo + 2))).value) + ((p_String)pTParam.pValue_get((int)0, (int)(ivo + 3))).value;
                    ((p_String)pTResult2.pValue_get((int)0, (int)(ivo + 1))).value = String.valueOf(((p_String)pTResult2.pValue_get((int)0, (int)(ivo + 2))).value) + ((p_String)pTParam.pValue_get((int)0, (int)(ivo + 1))).value + ((p_String)pTParam.pValue_get((int)0, (int)(ivo + 2))).value;
                    ((p_String)pTResult2.pValue_get((int)0, (int)(ivo + 0))).value = ((p_String)pTResult1.pValue_get((int)0, (int)(ivo + 3))).value = String.valueOf(((p_String)pTResult1.pValue_get((int)0, (int)(ivo + 2))).value) + ((p_String)pTResult2.pValue_get((int)0, (int)(ivo + 1))).value;
                    ++iv;
                }
            } else {
                iu = 0;
                while (iu < 4) {
                    ((p_String)pTResult1.pValue_get((int)0, (int)(0 + iu))).value = ((p_String)pTParam.pValue_get((int)0, (int)(0 + iu))).value;
                    ((p_String)pTResult1.pValue_get((int)0, (int)(4 + iu))).value = String.valueOf(((p_String)pTParam.pValue_get((int)0, (int)(0 + iu))).value) + ((p_String)pTParam.pValue_get((int)0, (int)(4 + iu))).value;
                    ((p_String)pTResult1.pValue_get((int)0, (int)(8 + iu))).value = String.valueOf(((p_String)pTResult1.pValue_get((int)0, (int)(4 + iu))).value) + ((p_String)pTParam.pValue_get((int)0, (int)(4 + iu))).value + ((p_String)pTParam.pValue_get((int)0, (int)(8 + iu))).value;
                    ((p_String)pTResult2.pValue_get((int)0, (int)(12 + iu))).value = ((p_String)pTParam.pValue_get((int)0, (int)(12 + iu))).value;
                    ((p_String)pTResult2.pValue_get((int)0, (int)(8 + iu))).value = String.valueOf(((p_String)pTParam.pValue_get((int)0, (int)(8 + iu))).value) + ((p_String)pTParam.pValue_get((int)0, (int)(12 + iu))).value;
                    ((p_String)pTResult2.pValue_get((int)0, (int)(4 + iu))).value = String.valueOf(((p_String)pTResult2.pValue_get((int)0, (int)(8 + iu))).value) + ((p_String)pTParam.pValue_get((int)0, (int)(4 + iu))).value + ((p_String)pTParam.pValue_get((int)0, (int)(8 + iu))).value;
                    ((p_String)pTResult2.pValue_get((int)0, (int)(0 + iu))).value = ((p_String)pTResult1.pValue_get((int)0, (int)(12 + iu))).value = String.valueOf(((p_String)pTResult1.pValue_get((int)0, (int)(8 + iu))).value) + ((p_String)pTResult2.pValue_get((int)0, (int)(4 + iu))).value;
                    ++iu;
                }
            }
        }
    }

    public final CqVector4D CP(int iRow, int iCol) {
        return this.P().pValue_get(iRow * 4 + iCol, 0);
    }

    public CqSurfacePatchBicubic assignment(CqSurfacePatchBicubic From) {
        super.assignment(From);
        return this;
    }

    @Override
    public CqBound Bound() {
        CqVector3D vecA = new CqVector3D(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        CqVector3D vecB = new CqVector3D(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        int i = 0;
        while (i < 16) {
            CqVector3D vecV = new CqVector3D(this.P().pValue_get(i, 0));
            if (vecV.x < vecA.x) {
                vecA.x(vecV.x);
            }
            if (vecV.y < vecA.y) {
                vecA.y(vecV.y);
            }
            if (vecV.x > vecB.x) {
                vecB.x(vecV.x);
            }
            if (vecV.y > vecB.y) {
                vecB.y(vecV.y);
            }
            if (vecV.z < vecA.z) {
                vecA.z(vecV.z);
            }
            if (vecV.z > vecB.z) {
                vecB.z(vecV.z);
            }
            ++i;
        }
        CqBound B = new CqBound();
        B.vecMin().assignment(vecA);
        B.vecMax().assignment(vecB);
        return this.AdjustBoundForTransformationMotion(B);
    }

    @Override
    public boolean Diceable() {
        CqVector2D Vec3;
        CqVector2D Vec2;
        CqVector2D Vec1;
        assert (this.P() != null);
        if (!this.m_fDiceable) {
            return false;
        }
        CqMatrix matCtoR = RiGlobal.QGetRenderContext().matSpaceToSpace("camera", "raster", new CqMatrix(), new CqMatrix(), RiGlobal.QGetRenderContext().Time());
        CqVector2D[] avecHull = new CqVector2D[16];
        float ShadingRate = this.pAttributes().GetFloatAttribute("System", "ShadingRate")[0];
        int i = 0;
        i = 0;
        while (i < 16) {
            avecHull[i] = new CqVector2D(matCtoR.multiply(this.P().pValue_get(i, 0)));
            ++i;
        }
        this.m_SplitDir.setValue(0);
        int u = 0;
        while (u < 16) {
            float Len = 0.0f;
            CqVector2D vec0 = new CqVector2D(avecHull[u]);
            CqVector2D vecL = new CqVector2D();
            i = 4;
            while (i-- > 0 && Len < 1.1920929E-7f) {
                vecL = avecHull[u + i].sub(vec0);
                Len = vecL.Magnitude();
            }
            vecL.assignDiv(Len);
            i = 0;
            while (++i < 4) {
                if (u + i == 16) break;
                CqVector3D vec = new CqVector3D(avecHull[u + i].sub(vec0));
                vec.Unit();
                vec.assignMod(new CqVector3D(vecL));
                if (!(vec.Magnitude() > 1.0f)) continue;
                return false;
            }
            u += 4;
        }
        this.m_SplitDir.setValue(1);
        int v = 0;
        while (v < 4) {
            float Len = 0.0f;
            CqVector2D vec0 = new CqVector2D(avecHull[v]);
            CqVector2D vecL = new CqVector2D();
            i = 4;
            while (i-- > 0 && Len < 1.1920929E-7f) {
                vecL = avecHull[v + i * 4].sub(vec0);
                Len = vecL.Magnitude();
            }
            vecL.assignDiv(Len);
            i = 0;
            while (++i < 4) {
                if (v + i * 4 >= 16) break;
                CqVector3D vec = new CqVector3D(avecHull[v + i * 4].sub(vec0));
                vec.Unit();
                vec.assignMod(new CqVector3D(vecL));
                if (!(vec.Magnitude() > 1.0f)) continue;
                return false;
            }
            ++v;
        }
        float uLen = 0.0f;
        float vLen = 0.0f;
        u = 0;
        while (u < 16) {
            Vec1 = new CqVector2D(avecHull[u + 1].sub(avecHull[u]));
            Vec2 = new CqVector2D(avecHull[u + 2].sub(avecHull[u + 1]));
            Vec3 = new CqVector2D(avecHull[u + 3].sub(avecHull[u + 2]));
            if (Vec1.Magnitude2() > uLen) {
                uLen = Vec1.Magnitude2();
            }
            if (Vec2.Magnitude2() > uLen) {
                uLen = Vec2.Magnitude2();
            }
            if (Vec3.Magnitude2() > uLen) {
                uLen = Vec3.Magnitude2();
            }
            u += 4;
        }
        v = 0;
        while (v < 4) {
            Vec1 = new CqVector2D(avecHull[v + 4].sub(avecHull[v]));
            Vec2 = new CqVector2D(avecHull[v + 8].sub(avecHull[v + 4]));
            Vec3 = new CqVector2D(avecHull[v + 12].sub(avecHull[v + 8]));
            if (Vec1.Magnitude2() > vLen) {
                vLen = Vec1.Magnitude2();
            }
            if (Vec2.Magnitude2() > vLen) {
                vLen = Vec2.Magnitude2();
            }
            if (Vec3.Magnitude2() > vLen) {
                vLen = Vec3.Magnitude2();
            }
            ++v;
        }
        if (ShadingRate > 0.0f) {
            uLen = (float)StrictMath.sqrt(uLen / ShadingRate);
            vLen = (float)StrictMath.sqrt(vLen / ShadingRate);
        } else {
            uLen = 0.0f;
            vLen = 0.0f;
        }
        this.m_SplitDir.setValue(uLen > vLen ? 0 : 1);
        this.m_uDiceSize = StrictMath.max(StrictMath.round(uLen *= 3.0f), 1);
        this.m_vDiceSize = StrictMath.max(StrictMath.round(vLen *= 3.0f), 1);
        int[] binary = this.pAttributes().GetIntegerAttribute("dice", "binary");
        if (binary != null && binary[0] != 0) {
            this.m_uDiceSize = (int)PublicFunctions.CEIL_POW2(this.m_uDiceSize);
            this.m_vDiceSize = (int)PublicFunctions.CEIL_POW2(this.m_vDiceSize);
        }
        if (uLen < 1.1920929E-7f || vLen < 1.1920929E-7f) {
            this.m_fDiscard = true;
            return false;
        }
        float gs = 16.0f;
        float[] poptGridSize = RiGlobal.QGetRenderContext().optCurrent().GetFloatOption("System", "SqrtGridSize");
        if (poptGridSize != null) {
            gs = poptGridSize[0];
        }
        return !((float)(this.m_uDiceSize * this.m_vDiceSize) > gs * gs);
    }

    @Override
    public boolean IsMotionBlurMatch(CqBasicSurface pSurf) {
        return false;
    }

    @Override
    public int cUniform() {
        return 1;
    }

    @Override
    public int cVarying() {
        return 4;
    }

    @Override
    public int cVertex() {
        return 16;
    }

    @Override
    public int cFaceVarying() {
        return 1;
    }

    @Override
    public void NaturalDice(CqParameter pParameter, int uDiceSize, int vDiceSize, IqShaderData pData) {
        switch (pParameter.Type().getValue()) {
            case 1: {
                CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                this.TypedNaturalDice(uDiceSize, vDiceSize, pTParam, pData);
                break;
            }
            case 2: {
                CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                this.TypedNaturalDice(uDiceSize, vDiceSize, pTParam, pData);
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                this.TypedNaturalDice(uDiceSize, vDiceSize, pTParam, pData);
                break;
            }
            case 7: {
                CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                this.TypedNaturalDice(uDiceSize, vDiceSize, pTParam, pData);
                break;
            }
            case 5: {
                CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                this.TypedNaturalDice(uDiceSize, vDiceSize, pTParam, pData);
                break;
            }
            case 4: {
                CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                this.TypedNaturalDice(uDiceSize, vDiceSize, pTParam, pData);
                break;
            }
            case 11: {
                CqParameterTyped pTParam = (CqParameterTyped)pParameter;
                this.TypedNaturalDice(uDiceSize, vDiceSize, pTParam, pData);
                break;
            }
        }
    }

    @Override
    public int PreSubdivide(STLVector<CqBasicSurface> aSplits, boolean u) {
        aSplits.add(new CqSurfacePatchBicubic());
        aSplits.add(new CqSurfacePatchBicubic());
        return 2;
    }

    @Override
    public void NaturalSubdivide(CqParameter pParam, CqParameter pParam1, CqParameter pParam2, boolean u) {
        switch (pParam.Type().getValue()) {
            case 1: {
                CqParameterTyped pTParam = (CqParameterTyped)pParam;
                CqParameterTyped pTResult1 = (CqParameterTyped)pParam1;
                CqParameterTyped pTResult2 = (CqParameterTyped)pParam2;
                this.TypedNaturalSubdivide(pTParam, pTResult1, pTResult2, u);
                break;
            }
            case 2: {
                CqParameterTyped pTParam = (CqParameterTyped)pParam;
                CqParameterTyped pTResult1 = (CqParameterTyped)pParam1;
                CqParameterTyped pTResult2 = (CqParameterTyped)pParam2;
                this.TypedNaturalSubdivide(pTParam, pTResult1, pTResult2, u);
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                CqParameterTyped pTParam = (CqParameterTyped)pParam;
                CqParameterTyped pTResult1 = (CqParameterTyped)pParam1;
                CqParameterTyped pTResult2 = (CqParameterTyped)pParam2;
                this.TypedNaturalSubdivide(pTParam, pTResult1, pTResult2, u);
                break;
            }
            case 7: {
                CqParameterTyped pTParam = (CqParameterTyped)pParam;
                CqParameterTyped pTResult1 = (CqParameterTyped)pParam1;
                CqParameterTyped pTResult2 = (CqParameterTyped)pParam2;
                this.TypedNaturalSubdivide(pTParam, pTResult1, pTResult2, u);
                break;
            }
            case 5: {
                CqParameterTyped pTParam = (CqParameterTyped)pParam;
                CqParameterTyped pTResult1 = (CqParameterTyped)pParam1;
                CqParameterTyped pTResult2 = (CqParameterTyped)pParam2;
                this.TypedNaturalSubdivide(pTParam, pTResult1, pTResult2, u);
                break;
            }
            case 4: {
                CqParameterTyped pTParam = (CqParameterTyped)pParam;
                CqParameterTyped pTResult1 = (CqParameterTyped)pParam1;
                CqParameterTyped pTResult2 = (CqParameterTyped)pParam2;
                this.TypedNaturalSubdivide(pTParam, pTResult1, pTResult2, u);
                break;
            }
        }
    }

    public void ConvertToBezierBasis(CqMatrix matuBasis, CqMatrix matvBasis) {
        int j;
        int i;
        CqMatrix matMim1 = new CqMatrix();
        if (matMim1.fIdentity()) {
            i = 0;
            while (i < 4) {
                j = 0;
                while (j < 4) {
                    matMim1.m_aaElement[i][j] = RendermanInterface.RiBezierBasis[i][j];
                    ++j;
                }
                ++i;
            }
            matMim1.SetfIdentity(false);
            matMim1 = matMim1.Inverse();
        }
        CqMatrix matuMj = matuBasis;
        CqMatrix matvMj = matvBasis;
        CqMatrix matuConv = matuMj.multiply(matMim1);
        CqMatrix matvConv = matvMj.multiply(matMim1);
        block8: for (CqParameter iUP : this.aUserParams()) {
            if (iUP.Class().getValue() != 4) continue;
            int ptype = iUP.Type().getValue();
            switch (ptype) {
                case 3: 
                case 8: 
                case 9: {
                    CqParameterTyped pParam = (CqParameterTyped)iUP;
                    CqMatrix matCPx = new CqMatrix();
                    CqMatrix matCPy = new CqMatrix();
                    CqMatrix matCPz = new CqMatrix();
                    CqMatrix matCPh = new CqMatrix();
                    i = 0;
                    while (i < 4) {
                        j = 0;
                        while (j < 4) {
                            matCPx.m_aaElement[i][j] = ((CqVector3D)pParam.pValue_get(i * 4 + j, 0)).valueAt(0);
                            matCPy.m_aaElement[i][j] = ((CqVector3D)pParam.pValue_get(i * 4 + j, 0)).valueAt(1);
                            matCPz.m_aaElement[i][j] = ((CqVector3D)pParam.pValue_get(i * 4 + j, 0)).valueAt(2);
                            matCPh.m_aaElement[i][j] = 1.0f;
                            ++j;
                        }
                        ++i;
                    }
                    matCPx.SetfIdentity(false);
                    matCPy.SetfIdentity(false);
                    matCPz.SetfIdentity(false);
                    matCPh.SetfIdentity(false);
                    matCPx = matuConv.Transpose().multiply(matCPx).multiply(matvConv);
                    matCPy = matuConv.Transpose().multiply(matCPy).multiply(matvConv);
                    matCPz = matuConv.Transpose().multiply(matCPz).multiply(matvConv);
                    matCPh = matuConv.Transpose().multiply(matCPh).multiply(matvConv);
                    i = 0;
                    while (i < 4) {
                        j = 0;
                        while (j < 4) {
                            ((CqVector3D)pParam.pValue_get(i * 4 + j, 0)).x(matCPx.m_aaElement[i][j]);
                            ((CqVector3D)pParam.pValue_get(i * 4 + j, 0)).y(matCPy.m_aaElement[i][j]);
                            ((CqVector3D)pParam.pValue_get(i * 4 + j, 0)).z(matCPz.m_aaElement[i][j]);
                            ++j;
                        }
                        ++i;
                    }
                    continue block8;
                }
                case 7: {
                    CqParameterTyped pParam = (CqParameterTyped)iUP;
                    CqMatrix matCPx = new CqMatrix();
                    CqMatrix matCPy = new CqMatrix();
                    CqMatrix matCPz = new CqMatrix();
                    CqMatrix matCPh = new CqMatrix();
                    i = 0;
                    while (i < 4) {
                        j = 0;
                        while (j < 4) {
                            matCPx.m_aaElement[i][j] = ((CqVector4D)pParam.pValue_get(i * 4 + j, 0)).valueAt(0);
                            matCPy.m_aaElement[i][j] = ((CqVector4D)pParam.pValue_get(i * 4 + j, 0)).valueAt(1);
                            matCPz.m_aaElement[i][j] = ((CqVector4D)pParam.pValue_get(i * 4 + j, 0)).valueAt(2);
                            matCPh.m_aaElement[i][j] = ((CqVector4D)pParam.pValue_get(i * 4 + j, 0)).valueAt(3);
                            ++j;
                        }
                        ++i;
                    }
                    matCPx.SetfIdentity(false);
                    matCPy.SetfIdentity(false);
                    matCPz.SetfIdentity(false);
                    matCPh.SetfIdentity(false);
                    matCPx = matuConv.Transpose().multiply(matCPx).multiply(matvConv);
                    matCPy = matuConv.Transpose().multiply(matCPy).multiply(matvConv);
                    matCPz = matuConv.Transpose().multiply(matCPz).multiply(matvConv);
                    matCPh = matuConv.Transpose().multiply(matCPh).multiply(matvConv);
                    i = 0;
                    while (i < 4) {
                        j = 0;
                        while (j < 4) {
                            ((CqVector4D)pParam.pValue_get(i * 4 + j, 0)).x(matCPx.m_aaElement[i][j]);
                            ((CqVector4D)pParam.pValue_get(i * 4 + j, 0)).y(matCPy.m_aaElement[i][j]);
                            ((CqVector4D)pParam.pValue_get(i * 4 + j, 0)).z(matCPz.m_aaElement[i][j]);
                            ((CqVector4D)pParam.pValue_get(i * 4 + j, 0)).h(matCPh.m_aaElement[i][j]);
                            ++j;
                        }
                        ++i;
                    }
                    continue block8;
                }
                case 5: {
                    CqParameterTyped pParam = (CqParameterTyped)iUP;
                    CqMatrix matRed = new CqMatrix();
                    CqMatrix matGreen = new CqMatrix();
                    CqMatrix matBlue = new CqMatrix();
                    i = 0;
                    while (i < 4) {
                        j = 0;
                        while (j < 4) {
                            matRed.m_aaElement[i][j] = ((CqColor)pParam.pValue_get(i * 4 + j, 0)).valueAt(0);
                            matGreen.m_aaElement[i][j] = ((CqColor)pParam.pValue_get(i * 4 + j, 0)).valueAt(1);
                            matBlue.m_aaElement[i][j] = ((CqColor)pParam.pValue_get(i * 4 + j, 0)).valueAt(2);
                            ++j;
                        }
                        ++i;
                    }
                    matRed.SetfIdentity(false);
                    matGreen.SetfIdentity(false);
                    matBlue.SetfIdentity(false);
                    matRed = matuConv.Transpose().multiply(matRed).multiply(matvConv);
                    matGreen = matuConv.Transpose().multiply(matGreen).multiply(matvConv);
                    matBlue = matuConv.Transpose().multiply(matBlue).multiply(matvConv);
                    i = 0;
                    while (i < 4) {
                        j = 0;
                        while (j < 4) {
                            ((CqColor)pParam.pValue_get(i * 4 + j, 0)).setValueAt(0, matRed.m_aaElement[i][j]);
                            ((CqColor)pParam.pValue_get(i * 4 + j, 0)).setValueAt(1, matGreen.m_aaElement[i][j]);
                            ((CqColor)pParam.pValue_get(i * 4 + j, 0)).setValueAt(2, matBlue.m_aaElement[i][j]);
                            ++j;
                        }
                        ++i;
                    }
                    continue block8;
                }
                case 1: {
                    CqParameterTyped pParam = (CqParameterTyped)iUP;
                    CqMatrix matCPx = new CqMatrix();
                    i = 0;
                    while (i < 4) {
                        j = 0;
                        while (j < 4) {
                            matCPx.m_aaElement[i][j] = ((p_float)pParam.pValue_get((int)(i * 4 + j), (int)0)).value;
                            ++j;
                        }
                        ++i;
                    }
                    matCPx.SetfIdentity(false);
                    matCPx = matuConv.Transpose().multiply(matCPx).multiply(matvConv);
                    i = 0;
                    while (i < 4) {
                        j = 0;
                        while (j < 4) {
                            ((p_float)pParam.pValue_get((int)(i * 4 + j), (int)0)).value = matCPx.m_aaElement[i][j];
                            ++j;
                        }
                        ++i;
                    }
                    continue block8;
                }
            }
        }
    }
}

