/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqQuadric;
import net.cellcomputing.himawari.library.types.CqVector3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqParaboloid
extends CqQuadric {
    private float m_RMax;
    private float m_ZMin;
    private float m_ZMax;
    private float m_ThetaMin;
    private float m_ThetaMax;

    public CqParaboloid() {
        this(1.0f, -1.0f, 1.0f, 0.0f, 360.0f);
    }

    public CqParaboloid(float rmax) {
        this(rmax, -1.0f, 1.0f, 0.0f, 360.0f);
    }

    public CqParaboloid(float rmax, float zmin) {
        this(rmax, zmin, 1.0f, 0.0f, 360.0f);
    }

    public CqParaboloid(float rmax, float zmin, float zmax) {
        this(rmax, zmin, zmax, 0.0f, 360.0f);
    }

    public CqParaboloid(float rmax, float zmin, float zmax, float thetamin) {
        this(rmax, zmin, zmax, thetamin, 360.0f);
    }

    public CqParaboloid(float rmax, float zmin, float zmax, float thetamin, float thetamax) {
        this.m_RMax = rmax;
        this.m_ZMin = zmin;
        this.m_ZMax = zmax;
        this.m_ThetaMin = thetamin;
        this.m_ThetaMax = thetamax;
    }

    public CqParaboloid(CqParaboloid From) {
        this.assignment(From);
    }

    @Override
    public void destruct() {
    }

    @Override
    public CqBound Bound() {
        float x1 = (float)((double)this.m_RMax * Math.cos(Math.toRadians(0.0)));
        float x2 = (float)((double)this.m_RMax * Math.cos(Math.toRadians(180.0)));
        float y1 = (float)((double)this.m_RMax * Math.sin(Math.toRadians(90.0)));
        float y2 = (float)((double)this.m_RMax * Math.sin(Math.toRadians(270.0)));
        CqVector3D vecMin = new CqVector3D(Math.min(x1, x2), Math.min(y1, y2), Math.min(this.m_ZMin, this.m_ZMax));
        CqVector3D vecMax = new CqVector3D(Math.max(x1, x2), Math.max(y1, y2), Math.max(this.m_ZMin, this.m_ZMax));
        CqBound B = new CqBound(vecMin, vecMax);
        B.Transform(this.m_matTx);
        return this.AdjustBoundForTransformationMotion(B);
    }

    @Override
    public CqVector3D DicePoint(int u, int v) {
        float theta = (float)Math.toRadians(this.m_ThetaMin + (this.m_ThetaMax - this.m_ThetaMin) * (float)u / (float)this.m_uDiceSize);
        float z = this.m_ZMin + (float)v * (this.m_ZMax - this.m_ZMin) / (float)this.m_vDiceSize;
        float r = this.m_RMax * (float)Math.sqrt(z / this.m_ZMax);
        return new CqVector3D((float)((double)r * Math.cos(theta)), (float)((double)r * Math.sin(theta)), z);
    }

    @Override
    public CqVector3D DicePoint(int u, int v, CqVector3D Normal) {
        float theta = (float)Math.toRadians(this.m_ThetaMin + (this.m_ThetaMax - this.m_ThetaMin) * (float)u / (float)this.m_uDiceSize);
        float sin_theta = (float)Math.sin(theta);
        float cos_theta = (float)Math.cos(theta);
        float z = this.m_ZMin + (float)v * (this.m_ZMax - this.m_ZMin) / (float)this.m_vDiceSize;
        float r = this.m_RMax * (float)Math.sqrt(z / this.m_ZMax);
        float dzdr = r * 2.0f * this.m_ZMax / (this.m_RMax * this.m_RMax);
        float normalAngle = (float)(1.5707963267948966 - Math.atan(dzdr));
        Normal.x((float)((double)cos_theta * Math.cos(normalAngle)));
        Normal.y((float)((double)sin_theta * Math.cos(normalAngle)));
        Normal.z((float)(-Math.sin(normalAngle)));
        return new CqVector3D(r * cos_theta, r * sin_theta, z);
    }

    @Override
    public int PreSubdivide(STLVector<CqBasicSurface> aSplits, boolean u) {
        float zcent = (float)((double)(this.m_ZMin + this.m_ZMax) * 0.5);
        float arccent = (float)((double)(this.m_ThetaMin + this.m_ThetaMax) * 0.5);
        float rcent = (float)((double)this.m_RMax * Math.sqrt(zcent / this.m_ZMax));
        CqParaboloid pNew1 = new CqParaboloid(this);
        CqParaboloid pNew2 = new CqParaboloid(this);
        if (u) {
            pNew1.m_ThetaMax = arccent;
            pNew2.m_ThetaMin = arccent;
        } else {
            pNew1.m_ZMax = zcent;
            pNew1.m_RMax = rcent;
            pNew2.m_ZMin = zcent;
        }
        aSplits.add(pNew1);
        aSplits.add(pNew2);
        return 2;
    }

    public CqParaboloid assignment(CqParaboloid From) {
        super.assignment(From);
        this.m_RMax = From.m_RMax;
        this.m_ZMin = From.m_ZMin;
        this.m_ZMax = From.m_ZMax;
        this.m_ThetaMin = From.m_ThetaMin;
        this.m_ThetaMax = From.m_ThetaMax;
        return this;
    }
}

