/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqQuadric;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqCylinder
extends CqQuadric {
    private float m_Radius;
    private float m_ZMin;
    private float m_ZMax;
    private float m_ThetaMin;
    private float m_ThetaMax;
    static /* synthetic */ Class class$0;

    public CqCylinder() {
        this(1.0f, -1.0f, 1.0f, 0.0f, 360.0f);
    }

    public CqCylinder(float radius) {
        this(radius, -1.0f, 1.0f, 0.0f, 360.0f);
    }

    public CqCylinder(float radius, float zmin) {
        this(radius, zmin, 1.0f, 0.0f, 360.0f);
    }

    public CqCylinder(float radius, float zmin, float zmax) {
        this(radius, zmin, zmax, 0.0f, 360.0f);
    }

    public CqCylinder(float radius, float zmin, float zmax, float thetamin) {
        this(radius, zmin, zmax, thetamin, 360.0f);
    }

    public CqCylinder(float radius, float zmin, float zmax, float thetamin, float thetamax) {
        this.m_Radius = radius;
        this.m_ZMin = zmin;
        this.m_ZMax = zmax;
        this.m_ThetaMin = thetamin;
        this.m_ThetaMax = thetamax;
    }

    public CqCylinder(CqCylinder From) {
        this.assignment(From);
    }

    @Override
    public void destruct() {
    }

    @Override
    public CqBound Bound() {
        STLVector<CqVector3D> curve = new STLVector<CqVector3D>(CqVector3D.class);
        CqVector3D vA = new CqVector3D(this.m_Radius, 0.0f, this.m_ZMin);
        CqVector3D vB = new CqVector3D(this.m_Radius, 0.0f, this.m_ZMax);
        CqVector3D vC = new CqVector3D(0.0f, 0.0f, 0.0f);
        CqVector3D vD = new CqVector3D(0.0f, 0.0f, 1.0f);
        curve.add(vA);
        curve.add(vB);
        CqMatrix matRot = new CqMatrix((float)Math.toRadians(this.m_ThetaMin), vD);
        for (CqVector3D i : curve) {
            i.assignment(matRot.multiply(i));
        }
        CqBound B = new CqBound(this.RevolveForBound(curve, vC, vD, (float)Math.toRadians(this.m_ThetaMax - this.m_ThetaMin)));
        B.Transform(this.m_matTx);
        return this.AdjustBoundForTransformationMotion(B);
    }

    @Override
    public CqVector3D DicePoint(int u, int v) {
        float theta = (float)Math.toRadians(this.m_ThetaMin + (this.m_ThetaMax - this.m_ThetaMin) * (float)u / (float)this.m_uDiceSize);
        float vz = this.m_ZMin + (float)v * (this.m_ZMax - this.m_ZMin) / (float)this.m_vDiceSize;
        return new CqVector3D((float)((double)this.m_Radius * Math.cos(theta)), (float)((double)this.m_Radius * Math.sin(theta)), vz);
    }

    @Override
    public CqVector3D DicePoint(int u, int v, CqVector3D Normal) {
        CqVector3D p = new CqVector3D(this.DicePoint(u, v));
        Normal.assignment(p);
        Normal.z(0.0f);
        Normal.Unit();
        return p;
    }

    @Override
    public boolean CanGenerateNormals() {
        return true;
    }

    @Override
    public int PreSubdivide(STLVector<CqBasicSurface> aSplits, boolean u) {
        float zcent = (float)((double)(this.m_ZMin + this.m_ZMax) * 0.5);
        float arccent = (float)((double)(this.m_ThetaMin + this.m_ThetaMax) * 0.5);
        CqCylinder pNew1 = new CqCylinder(this);
        CqCylinder pNew2 = new CqCylinder(this);
        if (u) {
            pNew1.m_ThetaMax = arccent;
            pNew2.m_ThetaMin = arccent;
        } else {
            pNew1.m_ZMax = zcent;
            pNew2.m_ZMin = zcent;
        }
        aSplits.add(pNew1);
        aSplits.add(pNew2);
        return 2;
    }

    public CqCylinder assignment(CqCylinder From) {
        super.assignment(From);
        this.m_Radius = From.m_Radius;
        this.m_ZMin = From.m_ZMin;
        this.m_ZMax = From.m_ZMax;
        this.m_ThetaMin = From.m_ThetaMin;
        this.m_ThetaMax = From.m_ThetaMax;
        return this;
    }
}

