/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.cellcomputing.himawari.accessory.STLPriorityQueue;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.Valarray;
import net.cellcomputing.himawari.accessory.ValarrayInt;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqImageBuffer;
import net.cellcomputing.himawari.library.CqImagePixel;
import net.cellcomputing.himawari.library.CqMicroPolyGridBase;
import net.cellcomputing.himawari.library.CqMicroPolygon;
import net.cellcomputing.himawari.library.CqRenderer;
import net.cellcomputing.himawari.library.IqBucket;
import net.cellcomputing.himawari.library.RendermanInterface;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.SqImageSample;
import net.cellcomputing.himawari.library.SqSampleData;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqRandom;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.PublicFunctions;
import net.cellcomputing.himawari.util.HimawariLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqBucket
implements IqBucket {
    static boolean FirstInitialiseFilterValues = true;
    static boolean FirstFilterBucket = true;
    public static CqRandom random = new CqRandom(61);
    private static int m_XOrigin;
    private static int m_YOrigin;
    private static int m_XSize;
    private static int m_YSize;
    private static int m_RealWidth;
    private static int m_RealHeight;
    private static int m_DiscreteShiftX;
    private static int m_DiscreteShiftY;
    private static int m_PixelXSamples;
    private static int m_PixelYSamples;
    private static float m_FilterXWidth;
    private static float m_FilterYWidth;
    private static int m_NumTimeRanges;
    private static int m_NumDofBounds;
    private static CqBound[] m_DofBounds;
    private static STLVector<CqImagePixel> m_aieImage;
    private static STLVector<STLVector<CqVector2D>> m_aSamplePositions;
    private static p_float[] m_aFilterValues;
    private static p_float[] m_aDatas;
    private static p_float[] m_aCoverages;
    private static CqImageBuffer m_ImageBuffer;
    private STLVector<CqMicroPolygon> m_ampgWaiting = new STLVector<CqMicroPolygon>(CqMicroPolygon.class);
    private STLVector<CqMicroPolyGridBase> m_agridWaiting = new STLVector<CqMicroPolyGridBase>(CqMicroPolyGridBase.class);
    private STLPriorityQueue<CqBasicSurface> m_aGPrims = new STLPriorityQueue<CqBasicSurface>(1, new closest_surface());
    private boolean m_bProcessed;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    static {
        m_aieImage = new STLVector<CqImagePixel>(CqImagePixel.class);
        m_aSamplePositions = new STLVector(2, CqVector2D.class);
    }

    public CqBucket() {
        this.m_bProcessed = false;
    }

    public CqBucket(CqBucket From) {
        this.assignment(From);
    }

    public void destract() {
        this.m_aGPrims.clear();
        this.m_ampgWaiting.clear();
        this.m_agridWaiting.clear();
    }

    public CqBucket assignment(CqBucket From) {
        this.m_ampgWaiting = From.m_ampgWaiting;
        this.m_agridWaiting = From.m_agridWaiting;
        this.m_bProcessed = From.m_bProcessed;
        return this;
    }

    @Override
    public int Width() {
        return m_XSize;
    }

    @Override
    public int Height() {
        return m_YSize;
    }

    @Override
    public int RealWidth() {
        return m_RealWidth;
    }

    @Override
    public int RealHeight() {
        return m_RealHeight;
    }

    @Override
    public int XOrigin() {
        return m_XOrigin;
    }

    @Override
    public int YOrigin() {
        return m_YOrigin;
    }

    public static int PixelXSamples() {
        return m_PixelXSamples;
    }

    public static int PixelYSamples() {
        return m_PixelYSamples;
    }

    public static float FilterXWidth() {
        return m_FilterXWidth;
    }

    public static float FilterYWidth() {
        return m_FilterYWidth;
    }

    public static int NumTimeRanges() {
        return m_NumTimeRanges;
    }

    public static int NumDofBounds() {
        return m_NumDofBounds;
    }

    public static final CqBound DofSubBound(int index) {
        assert (index < m_NumDofBounds);
        return m_DofBounds[index];
    }

    @Override
    public CqColor Color(int iXPos, int iYPos) {
        int pie = CqBucket.ImageElement(iXPos, iYPos);
        try {
            return ((CqImagePixel)m_aieImage.get(pie)).Color();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return RiGlobal.gColBlack;
        }
    }

    @Override
    public CqColor Opacity(int iXPos, int iYPos) {
        int pie = CqBucket.ImageElement(iXPos, iYPos);
        try {
            return ((CqImagePixel)m_aieImage.get(pie)).Opacity();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return RiGlobal.gColBlack;
        }
    }

    @Override
    public float Coverage(int iXPos, int iYPos) {
        int pie = CqBucket.ImageElement(iXPos, iYPos);
        try {
            return ((CqImagePixel)m_aieImage.get(pie)).Coverage();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0.0f;
        }
    }

    @Override
    public float Depth(int iXPos, int iYPos) {
        int pie = CqBucket.ImageElement(iXPos, iYPos);
        try {
            return ((CqImagePixel)m_aieImage.get(pie)).Depth();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Float.MAX_VALUE;
        }
    }

    public float MaxDepth(int iXPos, int iYPos) {
        int pie = CqBucket.ImageElement(iXPos, iYPos);
        try {
            return ((CqImagePixel)m_aieImage.get(pie)).MaxDepth();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Float.MAX_VALUE;
        }
    }

    @Override
    public int DataSize(int iXPos, int iYPos) {
        int pie = CqBucket.ImageElement(iXPos, iYPos);
        try {
            return ((CqImagePixel)m_aieImage.get(pie)).DataSize();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0;
        }
    }

    @Override
    public final Valarray Data(int iXPos, int iYPos) {
        int pie = CqBucket.ImageElement(iXPos, iYPos);
        try {
            return ((CqImagePixel)m_aieImage.get(pie)).Data();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public static void InitialiseBucket(int xorigin, int yorigin, int xsize, int ysize) {
        CqBucket.InitialiseBucket(xorigin, yorigin, xsize, ysize, true, false);
    }

    public static void InitialiseBucket(int xorigin, int yorigin, int xsize, int ysize, boolean fJitter) {
        CqBucket.InitialiseBucket(xorigin, yorigin, xsize, ysize, fJitter, false);
    }

    public static void InitialiseBucket(int xorigin, int yorigin, int xsize, int ysize, boolean fJitter, boolean empty) {
        int j;
        int i;
        int which;
        m_XOrigin = xorigin;
        m_YOrigin = yorigin;
        m_XSize = xsize;
        m_YSize = ysize;
        m_PixelXSamples = m_ImageBuffer.PixelXSamples();
        m_PixelYSamples = m_ImageBuffer.PixelYSamples();
        m_FilterXWidth = m_ImageBuffer.FilterXWidth();
        m_FilterYWidth = m_ImageBuffer.FilterYWidth();
        m_DiscreteShiftX = (int)Math.floor(m_FilterXWidth / 2.0f);
        m_DiscreteShiftY = (int)Math.floor(m_FilterYWidth / 2.0f);
        m_RealWidth = m_XSize + m_DiscreteShiftX * 2;
        m_RealHeight = m_YSize + m_DiscreteShiftY * 2;
        m_NumTimeRanges = Math.max(4, m_PixelXSamples * m_PixelYSamples);
        if (m_aieImage.isEmpty()) {
            m_aieImage.setSize(m_RealWidth * m_RealHeight);
            m_aSamplePositions.setSize(m_RealWidth * m_RealHeight);
            CqBucket.CalculateDofBounds();
            which = 0;
            i = 0;
            while (i < m_RealHeight) {
                j = 0;
                while (j < m_RealWidth) {
                    ((CqImagePixel)m_aieImage.get(which)).Clear();
                    ((CqImagePixel)m_aieImage.get(which)).AllocateSamples(m_PixelXSamples, m_PixelYSamples);
                    ((CqImagePixel)m_aieImage.get(which)).InitialiseSamples((STLVector)m_aSamplePositions.get(which), fJitter);
                    ((CqImagePixel)m_aieImage.get(which)).ShuffleSamples();
                    ++which;
                    ++j;
                }
                ++i;
            }
        }
        Collections.shuffle(m_aieImage, RiGlobal.rand);
        which = 0;
        i = 0;
        while (i < m_RealHeight) {
            j = 0;
            while (j < m_RealWidth) {
                CqVector2D bPos2 = new CqVector2D(m_XOrigin, m_YOrigin);
                bPos2.assignAdd(new CqVector2D(j - m_DiscreteShiftX, i - m_DiscreteShiftY));
                if (!empty) {
                    ((CqImagePixel)m_aieImage.get(which)).Clear();
                }
                ((CqImagePixel)m_aieImage.get(which)).OffsetSamples(bPos2, (STLVector)m_aSamplePositions.get(which));
                ++which;
                ++j;
            }
            ++i;
        }
    }

    public static void CalculateDofBounds() {
        m_NumDofBounds = m_PixelXSamples * m_PixelYSamples;
        m_DofBounds = new CqBound[m_NumDofBounds];
        int i = 0;
        while (i < m_NumDofBounds) {
            CqBucket.m_DofBounds[i] = new CqBound();
            ++i;
        }
        float dx = 2.0f / (float)m_PixelXSamples;
        float dy = 2.0f / (float)m_PixelYSamples;
        float minX = -1.0f;
        float minY = -1.0f;
        int which = 0;
        int j = 0;
        while (j < m_PixelYSamples) {
            int i2 = 0;
            while (i2 < m_PixelXSamples) {
                CqVector2D topLeft = new CqVector2D(minX, minY);
                CqVector2D topRight = new CqVector2D(minX + dx, minY);
                CqVector2D bottomLeft = new CqVector2D(minX, minY + dy);
                CqVector2D bottomRight = new CqVector2D(minX + dx, minY + dy);
                CqImagePixel.ProjectToCircle(topLeft);
                CqImagePixel.ProjectToCircle(topRight);
                CqImagePixel.ProjectToCircle(bottomLeft);
                CqImagePixel.ProjectToCircle(bottomRight);
                if ((double)topLeft.y > 0.0 && (double)bottomLeft.y < 0.0 || (double)topLeft.y < 0.0 && (double)bottomLeft.y > 0.0) {
                    topLeft.x(minX);
                    bottomLeft.x(minX);
                    topRight.x(minX + dx);
                    bottomRight.x(minX + dx);
                }
                if ((double)topLeft.x > 0.0 && (double)topRight.x < 0.0 || (double)topLeft.x < 0.0 && (double)topRight.x > 0.0) {
                    topLeft.y(minY);
                    bottomLeft.y(minY + dy);
                    topRight.y(minY);
                    bottomRight.y(minY + dy);
                }
                m_DofBounds[which].vecMin().assignment(topLeft);
                m_DofBounds[which].vecMax().assignment(topLeft);
                m_DofBounds[which].Encapsulate(topRight);
                m_DofBounds[which].Encapsulate(bottomLeft);
                m_DofBounds[which].Encapsulate(bottomRight);
                ++which;
                minX += dx;
                ++i2;
            }
            minX = -1.0f;
            minY += dy;
            ++j;
        }
    }

    public static void InitialiseFilterValues() {
        Method pFilter;
        if (m_aFilterValues != null) {
            return;
        }
        int numsubpixels = CqBucket.PixelXSamples() * CqBucket.PixelYSamples();
        int numperpixel = numsubpixels * numsubpixels;
        int numvalues = (int)((Math.ceil(CqBucket.FilterXWidth()) + 1.0) * (Math.ceil(CqBucket.FilterYWidth()) + 1.0) * (double)numperpixel);
        if (FirstInitialiseFilterValues) {
            m_aFilterValues = new p_float[numvalues];
            int i = 0;
            while (i < numvalues) {
                CqBucket.m_aFilterValues[i] = new p_float();
                ++i;
            }
            FirstInitialiseFilterValues = false;
        }
        if ((pFilter = RiGlobal.QGetRenderContext().optCurrent().funcFilter()) == null) {
            try {
                pFilter = RendermanInterface.class.getMethod("RiBoxFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            }
            catch (Exception e) {
                HimawariLogger.outputException(e);
            }
        }
        float xmax = m_DiscreteShiftX;
        float ymax = m_DiscreteShiftY;
        float xfwo2 = (float)Math.ceil(CqBucket.FilterXWidth()) * 0.5f;
        float yfwo2 = (float)Math.ceil(CqBucket.FilterYWidth()) * 0.5f;
        float xfw = (float)Math.ceil(CqBucket.FilterXWidth());
        float subcellwidth = 1.0f / (float)numsubpixels;
        float subcellcentre = subcellwidth * 0.5f;
        int py = (int)(-ymax);
        while (py <= (int)ymax) {
            int px = (int)(-xmax);
            while (px <= (int)xmax) {
                int index = (int)((((float)py + ymax) * xfw + ((float)px + xmax)) * (float)numperpixel);
                float pfx = (float)px - 0.5f;
                float pfy = (float)py - 0.5f;
                int sy = 0;
                while (sy < CqBucket.PixelYSamples()) {
                    int sx = 0;
                    while (sx < CqBucket.PixelXSamples()) {
                        int sindex = index + (sy * CqBucket.PixelXSamples() + sx) * numsubpixels;
                        float sfx = (float)sx / (float)CqBucket.PixelXSamples();
                        float sfy = (float)sy / (float)CqBucket.PixelYSamples();
                        int cy = 0;
                        while (cy < CqBucket.PixelXSamples()) {
                            int cx = 0;
                            while (cx < CqBucket.PixelYSamples()) {
                                int cindex = sindex + (cy * CqBucket.PixelYSamples() + cx);
                                float fx = (float)cx * subcellwidth + sfx + pfx + subcellcentre;
                                float fy = (float)cy * subcellwidth + sfy + pfy + subcellcentre;
                                float w = 0.0f;
                                if (fx >= -xfwo2 && fy >= -yfwo2 && fx <= xfwo2 && fy <= yfwo2) {
                                    try {
                                        w = ((Float)pFilter.invoke(null, Float.valueOf(fx), Float.valueOf(fy), Float.valueOf((float)Math.ceil(CqBucket.FilterXWidth())), Float.valueOf((float)Math.ceil(CqBucket.FilterYWidth())))).floatValue();
                                    }
                                    catch (Exception e) {
                                        HimawariLogger.outputException(e);
                                    }
                                }
                                CqBucket.m_aFilterValues[cindex].value = w;
                                ++cx;
                            }
                            ++cy;
                        }
                        ++sx;
                    }
                    ++sy;
                }
                ++px;
            }
            ++py;
        }
    }

    public static int ImageElement(int iXPos, int iYPos) {
        int i = ((iYPos -= m_YOrigin) + m_DiscreteShiftY) * m_RealWidth + ((iXPos -= m_XOrigin) + m_DiscreteShiftX);
        return i;
    }

    public static void CombineElements() {
        for (CqImagePixel CIP : m_aieImage) {
            CIP.Combine();
        }
    }

    public void FilterBucket(boolean empty) {
        int pie2;
        int pie;
        int x;
        int y;
        int size;
        int datasize = RiGlobal.QGetRenderContext().GetOutputDataTotalSize();
        if (FirstFilterBucket) {
            m_aDatas = new p_float[datasize * this.RealWidth() * this.RealHeight()];
            int i = 0;
            while (i < m_aDatas.length) {
                CqBucket.m_aDatas[i] = new p_float();
                ++i;
            }
            m_aCoverages = new p_float[this.RealWidth() * this.RealHeight()];
            i = 0;
            while (i < m_aCoverages.length) {
                CqBucket.m_aCoverages[i] = new p_float();
                ++i;
            }
            FirstFilterBucket = false;
        }
        int xmax = m_DiscreteShiftX;
        int ymax = m_DiscreteShiftY;
        float xfwo2 = (float)Math.ceil(CqBucket.FilterXWidth()) * 0.5f;
        float yfwo2 = (float)Math.ceil(CqBucket.FilterYWidth()) * 0.5f;
        int numsubpixels = CqBucket.PixelXSamples() * CqBucket.PixelYSamples();
        int numperpixel = numsubpixels * numsubpixels;
        int xlen = this.RealWidth();
        int SampleCount = 0;
        int i = 0;
        boolean fImager = false;
        String[] systemOptions = RiGlobal.QGetRenderContext().optCurrent().GetStringOption("System", "Imager");
        if (systemOptions != null && systemOptions[0].compareTo("null") != 0) {
            fImager = true;
        }
        int endy = this.YOrigin() + this.Height();
        int endx = this.XOrigin() + this.Width();
        boolean useSeperable = true;
        if (!empty) {
            if ((double)CqBucket.FilterXWidth() <= 1.0 || (double)CqBucket.FilterYWidth() <= 1.0) {
                useSeperable = false;
            }
            if (useSeperable) {
                int sindex;
                size = this.Width() * this.RealHeight() * CqBucket.PixelYSamples();
                Valarray intermediateSamples = new Valarray(0.0f, size * datasize);
                ValarrayInt sampleCounts = new ValarrayInt(0, size);
                y = this.YOrigin() - ymax;
                while (y < endy + ymax) {
                    float ycent = (float)y + 0.5f;
                    int pixelRow = (y - (this.YOrigin() - ymax)) * CqBucket.PixelYSamples();
                    x = this.XOrigin();
                    while (x < endx) {
                        float xcent = (float)x + 0.5f;
                        pie = CqBucket.ImageElement(x - xmax, y);
                        int pixelIndex = pixelRow * this.Width() + x - this.XOrigin();
                        int sy = 0;
                        while (sy < m_PixelYSamples) {
                            float gTot = 0.0f;
                            SampleCount = 0;
                            Valarray samples = new Valarray(0.0f, datasize);
                            int pie22 = pie;
                            int fx = -xmax;
                            while (fx <= xmax) {
                                int index = (int)(((double)ymax * Math.ceil(CqBucket.FilterXWidth()) + (double)(fx + xmax)) * (double)numperpixel);
                                int sampleIndex = sy * CqBucket.PixelXSamples();
                                sindex = index + sy * CqBucket.PixelXSamples() * numsubpixels;
                                int sx = 0;
                                while (sx < m_PixelXSamples) {
                                    SqSampleData sampleData = CqBucket.aieImage(pie22).SampleData(sampleIndex);
                                    CqVector2D vecS = new CqVector2D(sampleData.m_Position.x - xcent, sampleData.m_Position.y - ycent);
                                    if (vecS.x >= -xfwo2 && vecS.y >= -yfwo2 && vecS.x <= xfwo2 && vecS.y <= yfwo2) {
                                        int cindex = sindex + sampleData.m_SubCellIndex;
                                        float g = CqBucket.m_aFilterValues[cindex].value;
                                        gTot += g;
                                        if ((CqBucket.aieImage((int)pie22).OpaqueValues((int)sampleIndex).m_flags & 4) != 0) {
                                            SqImageSample pSample = CqBucket.aieImage(pie22).OpaqueValues(sampleIndex);
                                            int k = 0;
                                            while (k < datasize) {
                                                samples.setValueAt(k, samples.valueAt(k) + pSample.m_Data.valueAt(k) * g);
                                                ++k;
                                            }
                                            sampleCounts.setValueAt(pixelIndex, sampleCounts.valueAt(pixelIndex) + 1);
                                        }
                                    }
                                    ++sampleIndex;
                                    sindex += numsubpixels;
                                    ++sx;
                                }
                                ++pie22;
                                ++fx;
                            }
                            int k = 0;
                            while (k < datasize) {
                                intermediateSamples.setValueAt(pixelIndex * datasize + k, samples.valueAt(k) / gTot);
                                ++k;
                            }
                            pixelIndex += this.Width();
                            ++sy;
                        }
                        ++x;
                    }
                    ++y;
                }
                y = this.YOrigin();
                while (y < endy) {
                    float ycent = (float)y + 0.5f;
                    x = this.XOrigin();
                    while (x < endx) {
                        float xcent = (float)x + 0.5f;
                        float gTot = 0.0f;
                        SampleCount = 0;
                        Valarray samples = new Valarray(0.0f, datasize);
                        pie = CqBucket.ImageElement(x, y - ymax);
                        int fy = -ymax;
                        while (fy <= ymax) {
                            int pie23 = pie;
                            int index = (int)(((double)(fy + ymax) * Math.ceil(CqBucket.FilterXWidth()) + (double)xmax) * (double)numperpixel);
                            int sx = CqBucket.PixelXSamples() / 2;
                            int sy = 0;
                            int sampleIndex = sx;
                            int pixelRow = (y + fy - (this.YOrigin() - ymax)) * CqBucket.PixelYSamples();
                            int pixelIndex = pixelRow * this.Width() + x - this.XOrigin();
                            sy = 0;
                            while (sy < m_PixelYSamples) {
                                sindex = index + (sy * CqBucket.PixelXSamples() + sx) * numsubpixels;
                                SqSampleData sampleData = CqBucket.aieImage(pie23).SampleData(sampleIndex);
                                CqVector2D vecS = new CqVector2D(sampleData.m_Position.x - xcent, sampleData.m_Position.y - ycent);
                                if (vecS.x >= -xfwo2 && vecS.y >= -yfwo2 && vecS.x <= xfwo2 && vecS.y <= yfwo2) {
                                    int cindex = sindex + sampleData.m_SubCellIndex;
                                    float g = CqBucket.m_aFilterValues[cindex].value;
                                    gTot += g;
                                    if (sampleCounts.valueAt(pixelIndex) > 0) {
                                        SampleCount += sampleCounts.valueAt(pixelIndex);
                                        int k = 0;
                                        while (k < datasize) {
                                            samples.setValueAt(k, samples.valueAt(k) + intermediateSamples.valueAt(pixelIndex * datasize + k) * g);
                                            ++k;
                                        }
                                    }
                                }
                                sampleIndex += CqBucket.PixelXSamples();
                                pixelIndex += this.Width();
                                ++sy;
                            }
                            pie += xlen;
                            ++fy;
                        }
                        if (SampleCount == 0) {
                            int k = 0;
                            while (k < datasize) {
                                CqBucket.m_aDatas[i * datasize + k].value = 0.0f;
                                ++k;
                            }
                            CqBucket.m_aDatas[i * datasize + 6].value = Float.MAX_VALUE;
                            CqBucket.m_aCoverages[i].value = 0.0f;
                        } else {
                            float oneOverGTot = (float)(1.0 / (double)gTot);
                            int k = 0;
                            while (k < datasize) {
                                CqBucket.m_aDatas[i * datasize + k].value = samples.valueAt(k) * oneOverGTot;
                                ++k;
                            }
                            CqBucket.m_aCoverages[i].value = SampleCount >= numsubpixels ? 1.0f : (float)SampleCount / (float)numsubpixels;
                        }
                        ++i;
                        ++x;
                    }
                    ++y;
                }
            } else {
                y = this.YOrigin();
                while (y < endy) {
                    float ycent = (float)y + 0.5f;
                    x = this.XOrigin();
                    while (x < endx) {
                        float xcent = (float)x + 0.5f;
                        float gTot = 0.0f;
                        SampleCount = 0;
                        Valarray samples = new Valarray(0.0f, datasize);
                        pie = CqBucket.ImageElement(x - xmax, y - ymax);
                        int fy = -ymax;
                        while (fy <= ymax) {
                            int pie24 = pie;
                            int fx = -xmax;
                            while (fx <= xmax) {
                                int index = (int)(((double)(fy + ymax) * Math.ceil(CqBucket.FilterXWidth()) + (double)(fx + xmax)) * (double)numperpixel);
                                int sampleIndex = 0;
                                int sy = 0;
                                while (sy < m_PixelYSamples) {
                                    int sx = 0;
                                    while (sx < m_PixelXSamples) {
                                        int sindex = index + (sy * CqBucket.PixelXSamples() + sx) * numsubpixels;
                                        SqSampleData sampleData = CqBucket.aieImage(pie24).SampleData(sampleIndex);
                                        CqVector2D vecS = new CqVector2D(sampleData.m_Position);
                                        vecS.assignSub(new CqVector2D(xcent, ycent));
                                        if (vecS.x >= -xfwo2 && vecS.y >= -yfwo2 && vecS.x <= xfwo2 && vecS.y <= yfwo2) {
                                            int cindex = sindex + sampleData.m_SubCellIndex;
                                            float g = CqBucket.m_aFilterValues[cindex].value;
                                            gTot += g;
                                            if ((CqBucket.aieImage((int)pie24).OpaqueValues((int)sampleIndex).m_flags & 4) != 0) {
                                                SqImageSample pSample = CqBucket.aieImage(pie24).OpaqueValues(sampleIndex);
                                                int k = 0;
                                                while (k < datasize) {
                                                    samples.setValueAt(k, samples.valueAt(k) + pSample.m_Data.valueAt(k) * g);
                                                    ++k;
                                                }
                                                ++SampleCount;
                                            }
                                        }
                                        ++sampleIndex;
                                        ++sx;
                                    }
                                    ++sy;
                                }
                                ++pie24;
                                ++fx;
                            }
                            pie += xlen;
                            ++fy;
                        }
                        if (SampleCount == 0) {
                            int k = 0;
                            while (k < datasize) {
                                CqBucket.m_aDatas[i * datasize + k].value = 0.0f;
                                ++k;
                            }
                            CqBucket.m_aDatas[i * datasize + 6].value = Float.MAX_VALUE;
                            CqBucket.m_aCoverages[i].value = 0.0f;
                        } else {
                            float oneOverGTot = (float)(1.0 / (double)gTot);
                            int k = 0;
                            while (k < datasize) {
                                CqBucket.m_aDatas[i * datasize + k].value = samples.valueAt(k) * oneOverGTot;
                                ++k;
                            }
                            CqBucket.m_aCoverages[i].value = SampleCount >= numsubpixels ? 1.0f : (float)SampleCount / (float)numsubpixels;
                        }
                        ++i;
                        ++x;
                    }
                    ++y;
                }
            }
        } else {
            size = this.Width() * this.Height();
            int k = i * datasize;
            while (k < size * datasize) {
                CqBucket.m_aDatas[i * datasize + k].value = 0.0f;
                ++k;
            }
            k = i * datasize;
            while (k < size) {
                CqBucket.m_aCoverages[i * datasize + k].value = 0.0f;
                ++k;
            }
            i = 0;
            while (i < size) {
                CqBucket.m_aDatas[i * datasize + 6].value = Float.MAX_VALUE;
                ++i;
            }
        }
        i = 0;
        pie = CqBucket.ImageElement(this.XOrigin(), this.YOrigin());
        endy = this.Height();
        endx = this.Width();
        y = 0;
        while (y < endy) {
            pie2 = pie;
            x = 0;
            while (x < endx) {
                SqImageSample spl = CqBucket.aieImage(pie2).GetPixelSample();
                int k = 0;
                while (k < datasize) {
                    spl.m_Data.setValueAt(k, CqBucket.m_aDatas[i * datasize + k].value);
                    ++k;
                }
                spl.SetCoverage(CqBucket.m_aCoverages[i++].value);
                float a = (spl.Os().fRed() + spl.Os().fGreen() + spl.Os().fBlue()) / 3.0f;
                CqBucket.aieImage(pie2).SetAlpha(a * spl.Coverage());
                CqBucket.aieImage(pie2).setfColor(null);
                ++pie2;
                ++x;
            }
            pie += xlen;
            ++y;
        }
        endy = this.YOrigin() + this.Height();
        endx = this.XOrigin() + this.Width();
        if (RiGlobal.QGetRenderContext().optCurrent().pshadImager() != null && RiGlobal.QGetRenderContext().optCurrent().pshadImager().pShader() != null) {
            RiGlobal.QGetRenderContext().Stats().MakeFilterBucket().Stop();
            RiGlobal.QGetRenderContext().optCurrent().InitialiseColorImager(this);
            if (fImager) {
                i = 0;
                pie = CqBucket.ImageElement(this.XOrigin(), this.YOrigin());
                y = this.YOrigin();
                while (y < endy) {
                    pie2 = pie;
                    x = this.XOrigin();
                    while (x < endx) {
                        CqColor imager = RiGlobal.QGetRenderContext().optCurrent().GetColorImager(x, y);
                        CqBucket.aieImage(pie2).SetColor(imager);
                        imager = RiGlobal.QGetRenderContext().optCurrent().GetOpacityImager(x, y);
                        CqBucket.aieImage(pie2).SetOpacity(imager);
                        ++pie2;
                        ++i;
                        ++x;
                    }
                    pie += xlen;
                    ++y;
                }
            }
            RiGlobal.QGetRenderContext().Stats().MakeFilterBucket().Start();
        }
    }

    public void ExposeBucket() {
        if ((double)RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"Exposure", (int)0).value == 1.0 && (double)RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"Exposure", (int)1).value == 1.0) {
            return;
        }
        int pie = CqBucket.ImageElement(this.XOrigin(), this.YOrigin());
        float exposegain = RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"Exposure", (int)0).value;
        float exposegamma = RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"Exposure", (int)1).value;
        float oneovergamma = 1.0f / exposegamma;
        float endy = this.Height();
        float endx = this.Width();
        int nextx = this.RealWidth();
        int y = 0;
        while ((float)y < endy) {
            int pie2 = pie;
            int x = 0;
            while ((float)x < endx) {
                if ((double)exposegain != 1.0) {
                    ((CqImagePixel)m_aieImage.get(pie2)).SetColor(((CqImagePixel)m_aieImage.get(pie2)).Color().mul(exposegain));
                }
                if ((double)exposegamma != 1.0) {
                    CqColor col = ((CqImagePixel)m_aieImage.get(pie2)).Color();
                    col.SetfRed((float)Math.pow(col.fRed(), oneovergamma));
                    col.SetfGreen((float)Math.pow(col.fGreen(), oneovergamma));
                    col.SetfBlue((float)Math.pow(col.fBlue(), oneovergamma));
                    ((CqImagePixel)m_aieImage.get(pie2)).SetColor(col);
                }
                ++pie2;
                ++x;
            }
            pie += nextx;
            ++y;
        }
    }

    public void QuantizeBucket() {
        int x;
        int pie2;
        int y;
        int pie;
        double ditheramplitude;
        int max;
        int min;
        int one;
        float[] pQuant;
        float endy = this.Height();
        float endx = this.Width();
        int nextx = this.RealWidth();
        if ((RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"DisplayMode", (int)0).value & 1) != 0) {
            pQuant = RiGlobal.QGetRenderContext().optCurrent().GetFloatOption("Quantize", "Color");
            one = (int)pQuant[0];
            min = (int)pQuant[1];
            max = (int)pQuant[2];
            ditheramplitude = pQuant[3];
            if (one == 0 && min == 0 && max == 0) {
                return;
            }
            pie = CqBucket.ImageElement(this.XOrigin(), this.YOrigin());
            y = 0;
            while ((float)y < endy) {
                pie2 = pie;
                x = 0;
                while ((float)x < endx) {
                    double s = random.RandomFloat();
                    CqColor col = ((CqImagePixel)m_aieImage.get(pie2)).Color();
                    CqColor opa = ((CqImagePixel)m_aieImage.get(pie2)).Opacity();
                    float alpha = ((CqImagePixel)m_aieImage.get(pie2)).Alpha();
                    ((CqImagePixel)m_aieImage.get(pie2)).setfColor(new CqColor(col));
                    double r = Math.round((double)((float)one * col.fRed()) + ditheramplitude * s);
                    double g = Math.round((double)((float)one * col.fGreen()) + ditheramplitude * s);
                    double b = Math.round((double)((float)one * col.fBlue()) + ditheramplitude * s);
                    double _or = Math.round((double)((float)one * opa.fRed()) + ditheramplitude * s);
                    double _og = Math.round((double)((float)one * opa.fGreen()) + ditheramplitude * s);
                    double _ob = Math.round((double)((float)one * opa.fBlue()) + ditheramplitude * s);
                    double a = Math.round((double)((float)one * alpha) + ditheramplitude * s);
                    r = PublicFunctions.CLAMP((float)r, min, max);
                    g = PublicFunctions.CLAMP((float)g, min, max);
                    b = PublicFunctions.CLAMP((float)b, min, max);
                    _or = PublicFunctions.CLAMP((float)_or, min, max);
                    _og = PublicFunctions.CLAMP((float)_og, min, max);
                    _ob = PublicFunctions.CLAMP((float)_ob, min, max);
                    a = PublicFunctions.CLAMP((float)a, min, max);
                    col.SetfRed((float)r);
                    col.SetfGreen((float)g);
                    col.SetfBlue((float)b);
                    opa.SetfRed((float)_or);
                    opa.SetfGreen((float)_og);
                    opa.SetfBlue((float)_ob);
                    ((CqImagePixel)m_aieImage.get(pie2)).SetColor(col);
                    ((CqImagePixel)m_aieImage.get(pie2)).SetOpacity(opa);
                    ((CqImagePixel)m_aieImage.get(pie2)).SetAlpha((float)a);
                    ++pie2;
                    ++x;
                }
                pie += nextx;
                ++y;
            }
        }
        if ((RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"DisplayMode", (int)0).value & 4) != 0) {
            pQuant = RiGlobal.QGetRenderContext().optCurrent().GetFloatOption("Quantize", "Depth");
            one = (int)pQuant[0];
            min = (int)pQuant[1];
            max = (int)pQuant[2];
            ditheramplitude = pQuant[3];
            if (ditheramplitude == 0.0 && one == 0 && min == 0 && max == 0) {
                return;
            }
            pie = CqBucket.ImageElement(this.XOrigin(), this.YOrigin());
            y = 0;
            while ((float)y < endy) {
                pie2 = pie;
                x = 0;
                while ((float)x < endx) {
                    double d = Math.round((double)((float)one * ((CqImagePixel)m_aieImage.get(pie2)).Depth()) + ditheramplitude * (double)random.RandomFloat());
                    d = PublicFunctions.CLAMP((float)d, min, max);
                    ((CqImagePixel)m_aieImage.get(pie2)).SetDepth((float)d);
                    ++pie2;
                    ++x;
                }
                pie += nextx;
                ++y;
            }
        }
        HashMap<String, CqRenderer.SqOutputDataEntry> DataMap = RiGlobal.QGetRenderContext().GetMapOfOutputDataEntries();
        for (Map.Entry<String, CqRenderer.SqOutputDataEntry> entry : DataMap.entrySet()) {
            float[] pQuant2 = RiGlobal.QGetRenderContext().optCurrent().GetFloatOption("Quantize", entry.getKey());
            if (pQuant2 == null) continue;
            int startindex = entry.getValue().m_Offset;
            int endindex = startindex + entry.getValue().m_NumSamples;
            int one2 = (int)pQuant2[0];
            int min2 = (int)pQuant2[1];
            int max2 = (int)pQuant2[2];
            double ditheramplitude2 = pQuant2[3];
            int pie3 = CqBucket.ImageElement(this.XOrigin(), this.YOrigin());
            int y2 = 0;
            while ((float)y2 < endy) {
                int pie22 = pie3;
                int x2 = 0;
                while ((float)x2 < endx) {
                    int sampleindex = startindex;
                    while (sampleindex < endindex) {
                        double d = Math.round((double)((float)one2 * ((CqImagePixel)CqBucket.m_aieImage.get((int)pie22)).GetPixelSample().m_Data.valueAt(sampleindex)) + ditheramplitude2 * (double)random.RandomFloat());
                        d = PublicFunctions.CLAMP((float)d, min2, max2);
                        ((CqImagePixel)CqBucket.m_aieImage.get((int)pie22)).GetPixelSample().m_Data.setValueAt(sampleindex, (float)d);
                        ++sampleindex;
                    }
                    ++pie22;
                    ++x2;
                }
                pie3 += nextx;
                ++y2;
            }
        }
    }

    public static void ShutdownBucket() {
        m_aieImage.clear();
        int i = 0;
        while (i < m_aFilterValues.length) {
            CqBucket.m_aFilterValues[i] = null;
            ++i;
        }
        m_aFilterValues = null;
        FirstInitialiseFilterValues = true;
        i = 0;
        while (i < m_aCoverages.length) {
            CqBucket.m_aCoverages[i] = null;
            ++i;
        }
        m_aCoverages = null;
        i = 0;
        while (i < m_aDatas.length) {
            CqBucket.m_aDatas[i] = null;
            ++i;
        }
        m_aDatas = null;
        FirstFilterBucket = true;
        m_aSamplePositions.clear();
    }

    public void AddGPrim(CqBasicSurface pGPrim) {
        this.m_aGPrims.add(pGPrim);
    }

    public void AddMPG(CqMicroPolygon pmpgNew) {
        this.m_ampgWaiting.add(pmpgNew);
    }

    public void AddGrid(CqMicroPolyGridBase pgridNew) {
        this.m_agridWaiting.add(pgridNew);
    }

    public CqBasicSurface pTopSurface() {
        if (!this.m_aGPrims.isEmpty()) {
            return this.m_aGPrims.peek();
        }
        return null;
    }

    public void popSurface() {
        this.m_aGPrims.poll();
    }

    public int cGPrims() {
        return this.m_aGPrims.size();
    }

    public STLVector<CqMicroPolygon> aMPGs() {
        return this.m_ampgWaiting;
    }

    public STLVector<CqMicroPolyGridBase> aGrids() {
        return this.m_agridWaiting;
    }

    public boolean IsProcessed() {
        return this.m_bProcessed;
    }

    public void SetProcessed() {
        this.SetProcessed(true);
    }

    public void SetProcessed(boolean bProc) {
        this.m_bProcessed = bProc;
    }

    public static void SetImageBuffer(CqImageBuffer pBuffer) {
        m_ImageBuffer = pBuffer;
    }

    public static CqImagePixel aieImage(int i) {
        return (CqImagePixel)m_aieImage.get(i);
    }

    public CqColor getFColor(int iXPos, int iYPos) {
        int pie = CqBucket.ImageElement(iXPos, iYPos);
        try {
            CqColor col = ((CqImagePixel)m_aieImage.get(pie)).getFColor();
            if (col != null) {
                return col;
            }
            return RiGlobal.gColBlack;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return RiGlobal.gColBlack;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private strictfp class closest_surface
    implements Comparator<CqBasicSurface> {
        closest_surface() {
        }

        @Override
        public int compare(CqBasicSurface s1, CqBasicSurface s2) {
            if (s1.fCachedBound() && s2.fCachedBound()) {
                if (s1.GetCachedRasterBound().vecMin().z > s2.GetCachedRasterBound().vecMin().z) {
                    return 1;
                }
                if (s1.GetCachedRasterBound().vecMin().z < s2.GetCachedRasterBound().vecMin().z) {
                    return -1;
                }
                return 0;
            }
            return -1;
        }
    }
}

