/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.display;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.cellcomputing.himawari.display.DisplayRequest;
import net.cellcomputing.himawari.display.ImageData;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.util.HimawariLogger;

public strictfp class ZFileRequest
extends DisplayRequest {
    public static final String START_SHADOW_HEADER = "START_SHADOW_HEADER";
    public static final String END_SHADOW_HEADER = "END_SHADOW_HEADER";
    public static final String SHADOW_WIDTH = "SHADOW_WIDTH";
    public static final String SHADOW_HEIGHT = "SHADOW_HEIGHT";
    public static final String SHADOW_CAMERA_POINT = "SHADOW_CAMERA_POINT";
    public static final String SHADOW_SCREEN_POINT = "SHADOW_SCREEN_POINT";
    private int imageWidth;
    private int imageHeight;
    CqMatrix matWorldToScreen;
    CqMatrix matWorldToCamera;

    public ZFileRequest(String name, String type, String mode, int modeID, int dataOffset, int dataSize, ImageData imageData) {
        super(name, type, mode, modeID, dataOffset, dataSize, imageData);
    }

    public void openRequest() {
        this.imageWidth = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"Resolution", (int)0).value;
        this.imageHeight = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"Resolution", (int)1).value;
        this.matWorldToCamera = RiGlobal.QGetRenderContext().matSpaceToSpace("world", "camera", new CqMatrix(), new CqMatrix(), RiGlobal.QGetRenderContextI().Time());
        this.matWorldToScreen = RiGlobal.QGetRenderContext().matSpaceToSpace("world", "screen", new CqMatrix(), new CqMatrix(), RiGlobal.QGetRenderContextI().Time());
    }

    public void display() {
    }

    private void writeHeader(RandomAccessFile file) throws IOException {
        String ret = "\n";
        file.write(START_SHADOW_HEADER.getBytes());
        file.write(ret.getBytes());
        file.write(SHADOW_WIDTH.getBytes());
        file.write((" " + this.imageWidth).getBytes());
        file.write(ret.getBytes());
        file.write(SHADOW_HEIGHT.getBytes());
        file.write((" " + this.imageWidth).getBytes());
        file.write(ret.getBytes());
        file.write(SHADOW_CAMERA_POINT.getBytes());
        file.write(ret.getBytes());
        this.writeMatrix(file, this.matWorldToCamera);
        file.write(ret.getBytes());
        file.write(SHADOW_SCREEN_POINT.getBytes());
        file.write(ret.getBytes());
        this.writeMatrix(file, this.matWorldToScreen);
        file.write(ret.getBytes());
        file.write(END_SHADOW_HEADER.getBytes());
        file.write(ret.getBytes());
    }

    private void writeMatrix(RandomAccessFile file, CqMatrix matrix) throws IOException {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                file.writeFloat(matrix.m_aaElement[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public void closeRequest() {
        RandomAccessFile file = null;
        float[][] bucketList = (float[][])this.imageData.getImage();
        try {
            try {
                file = new RandomAccessFile(this.name, "rw");
                file.seek(0L);
                file.setLength(0L);
                this.writeHeader(file);
                int y = 0;
                while (y < bucketList.length) {
                    int x = 0;
                    while (x < bucketList[0].length) {
                        file.writeFloat(bucketList[y][x]);
                        ++x;
                    }
                    ++y;
                }
            }
            catch (FileNotFoundException e) {
                HimawariLogger.outputException(e);
                HimawariLogger.getLogger().error("Cannot open output image file: " + this.name + "\n");
            }
            catch (IOException e) {
                HimawariLogger.outputException(e);
                HimawariLogger.getLogger().error("Cannot open output image file: " + this.name + "\n");
            }
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException e) {
                HimawariLogger.outputException(e);
            }
        }
        this.imageData = null;
    }
}

