/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.display;

import java.awt.image.BufferedImage;
import net.cellcomputing.himawari.display.ImageData;
import net.cellcomputing.himawari.library.IqBucket;
import net.cellcomputing.himawari.library.RiGlobal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class ZFileImage
extends ImageData<float[][]> {
    private BufferedImage zImage;
    public final int DATA_SIZE = 3;
    private float max_depth = Float.MIN_NORMAL;
    private float min_depth = Float.MAX_VALUE;
    private final float[] whiteData = new float[]{255.0f, 255.0f, 255.0f};
    private final float[] blackData = new float[]{0.0f, 0.0f, 0.0f};
    public final int Z_COLOR = 2;

    protected ZFileImage(int offset) {
        super(offset);
    }

    @Override
    public void setBucket(IqBucket pBucket) {
        if (pBucket.Width() == 0 || pBucket.Height() == 0) {
            return;
        }
        int xmin = pBucket.XOrigin();
        int ymin = pBucket.YOrigin();
        int xmaxplus1 = xmin + pBucket.Width();
        int ymaxplus1 = ymin + pBucket.Height();
        if (xmaxplus1 <= RiGlobal.QGetRenderContext().pImage().CropWindowXMin() || ymaxplus1 <= RiGlobal.QGetRenderContext().pImage().CropWindowYMin() || xmin > RiGlobal.QGetRenderContext().pImage().CropWindowXMax() || ymin > RiGlobal.QGetRenderContext().pImage().CropWindowYMax()) {
            return;
        }
        int y = ymin;
        while (y < ymaxplus1) {
            int x = xmin;
            while (x < xmaxplus1) {
                if (x >= RiGlobal.QGetRenderContext().pImage().CropWindowXMin() && y >= RiGlobal.QGetRenderContext().pImage().CropWindowYMin() && x < RiGlobal.QGetRenderContext().pImage().CropWindowXMax() && y < RiGlobal.QGetRenderContext().pImage().CropWindowYMax()) {
                    float depth;
                    ((float[][])this.imageData)[y][x] = depth = pBucket.Depth(x, y);
                    if (depth != Float.MAX_VALUE) {
                        if (depth > this.max_depth) {
                            this.max_depth = depth;
                        } else if (this.min_depth > depth) {
                            this.min_depth = depth;
                        }
                        this.raster.setPixel(x - RiGlobal.QGetRenderContext().pImage().CropWindowXMin(), y - RiGlobal.QGetRenderContext().pImage().CropWindowYMin(), this.whiteData);
                    } else {
                        this.raster.setPixel(x - RiGlobal.QGetRenderContext().pImage().CropWindowXMin(), y - RiGlobal.QGetRenderContext().pImage().CropWindowYMin(), this.blackData);
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    public float getMinDepth() {
        return this.min_depth;
    }

    public float getMaxDepth() {
        return this.max_depth;
    }

    @Override
    public float[][] getImage() {
        return (float[][])this.imageData;
    }

    public BufferedImage getZImage() {
        return this.zImage;
    }

    @Override
    public void init() {
        super.init();
        this.imageData = new float[this.height][this.width];
        this.zImage = new BufferedImage(this.width, this.height, 1);
        this.raster = this.zImage.getRaster();
        this.dataSize = 3;
        this.pixelData = new float[3];
    }
}

