/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.display;

import com.keypoint.PngEncoder;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import net.cellcomputing.himawari.display.DisplayRequest;
import net.cellcomputing.himawari.display.ImageData;
import net.cellcomputing.himawari.util.HimawariLogger;

public strictfp class PngRequest
extends DisplayRequest {
    private static final String IMAGE_EXT = "png";

    public PngRequest(String name, String type, String mode, int modeID, int dataOffset, int dataSize, ImageData imageData) {
        super(name, type, mode, modeID, dataOffset, dataSize, imageData);
    }

    public void openRequest() {
    }

    public void display() {
    }

    public void saveImage(BufferedImage image) {
        int num = image.getSampleModel().getNumBands();
        boolean alpha = num == 4;
        PngEncoder png = new PngEncoder(image, alpha, 0, 9);
        try {
            FileOutputStream outfile = new FileOutputStream(this.name);
            byte[] pngbytes = png.pngEncode();
            if (pngbytes == null) {
                HimawariLogger.getLogger().error("Cannot open output image file: " + this.name + "\n");
            } else {
                outfile.write(pngbytes);
            }
            outfile.flush();
            outfile.close();
        }
        catch (IOException e) {
            HimawariLogger.outputException(e);
        }
    }

    public void closeRequest() {
        BufferedImage image = (BufferedImage)this.imageData.getImage();
        this.saveImage(image);
        this.imageData = null;
    }
}

