/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.accessory;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Collection;
import net.cellcomputing.himawari.accessory.Vector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;
import net.cellcomputing.himawari.util.HimawariLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class STLVector<T>
extends Vector<T> {
    private static final long serialVersionUID = 5325093071986534510L;
    private Class<? extends T> myClass;
    private int nests = 1;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;

    public STLVector(Class<? extends T> cls, int initialCapacity, int capacityIncrement) {
        super(initialCapacity, capacityIncrement);
        this.myClass = cls;
        this.fillInstance(0, initialCapacity);
    }

    public STLVector(Class<? extends T> cls, int initialCapacity) {
        super(initialCapacity);
        this.myClass = cls;
        this.fillInstance(0, initialCapacity);
    }

    public STLVector(Class<? extends T> cls) {
        this.myClass = cls;
    }

    public STLVector(Class<? extends T> cls, Collection<? extends T> c) {
        super(c);
        this.myClass = cls;
    }

    public STLVector(int nests, Class cls, int initialCapacity, int capacityIncrement) {
        super(initialCapacity, capacityIncrement);
        this.myClass = cls;
        this.fillInstance(0, initialCapacity);
    }

    public STLVector(int nests, Class cls, int initialCapacity) {
        super(initialCapacity);
        this.myClass = cls;
        this.nests = nests;
        this.fillInstance(0, initialCapacity);
    }

    public STLVector(int nests, Class cls) {
        this.myClass = cls;
        this.nests = nests;
    }

    public void resize(int newSize) {
        int oldSize = this.elementCount;
        if (newSize > oldSize) {
            this.fillInstance(oldSize, newSize);
        }
        super.setSize(newSize);
    }

    @Override
    public void setSize(int newSize) {
        this.resize(newSize);
    }

    @Override
    public T[] toArray() {
        Object[] array;
        if (this.nests <= 1) {
            array = (Object[])Array.newInstance(this.myClass, this.elementCount);
            System.arraycopy(this.elementData, 0, array, 0, this.elementCount);
        } else {
            array = (Object[])Array.newInstance(this.getClass(), this.elementCount);
            System.arraycopy(this.elementData, 0, array, 0, this.elementCount);
        }
        return array;
    }

    public T[] toArray(int StartPoint) {
        Object[] array;
        if (this.nests <= 1) {
            array = (Object[])Array.newInstance(this.myClass, this.elementCount - StartPoint);
            System.arraycopy(this.elementData, StartPoint, array, 0, this.elementCount - StartPoint);
        } else {
            array = (Object[])Array.newInstance(this.getClass(), this.elementCount - StartPoint);
            System.arraycopy(this.elementData, StartPoint, array, 0, this.elementCount - StartPoint);
        }
        return array;
    }

    public void assign(int num, T val) {
        this.resize(num);
        if (this.myClass.equals(CqVector3D.class)) {
            for (Object ele : this) {
                ((CqVector3D)ele).assignment((CqVector3D)val);
            }
        } else if (this.myClass.equals(CqVector4D.class)) {
            for (Object ele : this) {
                ((CqVector4D)ele).assignment((CqVector4D)val);
            }
        } else if (this.myClass.equals(p_float.class)) {
            for (Object ele : this) {
                ((p_float)ele).value = ((p_float)val).value;
            }
        } else if (this.myClass.equals(CqColor.class)) {
            for (Object ele : this) {
                ((CqColor)ele).assignment((CqColor)val);
            }
        } else if (this.myClass.equals(CqMatrix.class)) {
            for (Object ele : this) {
                ((CqMatrix)ele).assignment((CqMatrix)val);
            }
        } else if (this.myClass.equals(p_int.class)) {
            for (Object ele : this) {
                ((p_int)ele).value = ((p_int)val).value;
            }
        } else if (this.myClass.equals(p_String.class)) {
            for (Object ele : this) {
                ((p_String)ele).value = ((p_String)val).value;
            }
        } else {
            int i = 0;
            while (i < this.elementCount) {
                this.set(i, val);
                ++i;
            }
        }
    }

    private void fillInstance(int start, int end) {
        int i = start;
        while (i < end) {
            try {
                if (this.nests > 1) {
                    this.add(i, this.newThisInstance());
                } else {
                    this.add(i, this.newInstance(this.myClass));
                }
            }
            catch (Exception e) {
                this.add(null);
            }
            ++i;
        }
    }

    private T newInstance(Class<? extends T> cls) {
        try {
            Class<T> superClass = cls.getSuperclass();
            if (superClass.equals(Number.class)) {
                Class primitiveClass = (Class)cls.getField("TYPE").get(cls);
                Constructor<T> cnst = cls.getConstructor(primitiveClass);
                return cnst.newInstance((byte)0);
            }
            if (cls.equals(Boolean.class)) {
                Constructor<T> cnst = cls.getConstructor(Boolean.TYPE);
                return cnst.newInstance(false);
            }
            return cls.newInstance();
        }
        catch (Exception e) {
            int mod = cls.getModifiers();
            if (!Modifier.isInterface(mod) && !Modifier.isAbstract(mod)) {
                HimawariLogger.outputException(e);
            }
            return null;
        }
    }

    private T newThisInstance() {
        try {
            Class<?> cls = this.getClass();
            Constructor<?> cnst = cls.getConstructor(Integer.TYPE, Class.class);
            return (T)cnst.newInstance(this.nests - 1, this.myClass);
        }
        catch (Exception e) {
            int mod = this.myClass.getModifiers();
            if (!Modifier.isInterface(mod) && !Modifier.isAbstract(mod)) {
                HimawariLogger.outputException(e);
            }
            return null;
        }
    }
}

