/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.util;

import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

/**
 *@Logo͂̂߂̃tH[}bg`ĂNX
 * @author NTT DATA Corporation
 */
public class HimawariLogFormatter extends Formatter {
	private Date date;
	private final DateFormat df = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.MEDIUM);

	/**
	 * tH[}bg쐬<br> 
	 * 2005/12/31 [LEVEL]: [MSG]<br>
	 * Ƃ`ɂȂ
	 * @param record OR[h
	 */
	public String format(LogRecord record) {
        date = new Date();
        
		StringBuffer strbuf = new StringBuffer();
		strbuf.append(df.format(date));
		strbuf.append(" ");
//		strbuf.append(record.getLevel());
		//xɓĂ镶ɂAx쐬B
		Level level = record.getLevel();
		
		if(level.equals(Level.SEVERE)){
			strbuf.append("CRITICAL");
		}else if(level.equals(Level.WARNING)){
			strbuf.append("ERROR");
		}else if(level.equals(Level.INFO)){
			strbuf.append("WARNING");
		}else if(level.equals(Level.CONFIG)){
			strbuf.append("INFO");
		}else if(level.equals(Level.FINE)){
			strbuf.append("DEBUG");
		}
		
		strbuf.append(": ");
		strbuf.append(record.getMessage());
		
		return strbuf.toString();
	}
	
}
