// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.shadervm;

import static net.cellcomputing.himawari.library.EqIntIndex.SHD_Var_varying_init;
import static net.cellcomputing.himawari.library.EqIntIndex.SHD_var_varying_color;
import net.cellcomputing.himawari.accessory.STLArray;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_boolean;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.types.CqColor;

/**
 * CqShaderVariableVaryingNXCqColorɓ
 * NX
 * @author NTT DATA Corporation
 */
public strictfp class CqShaderVariableVaryingColor extends CqShaderVariableVarying<CqColor> {
    
	/**
	 * RXgN^B
	 * Vector̔z1ɃZbgāA
	 * vXVB
	 */
	public CqShaderVariableVaryingColor( )
    {
    	super(new EqVariableType(EqVariableType.type_color));
		//Ϗ̂
		//m_aValue = new STLVector<CqColor>(CqColor.class);
		m_aValue = new STLArray<CqColor>(CqColor.class);
		m_aValue.resize( 1 );
 
        CqStats.STATS_INC( SHD_var_varying_color );
    }
    
	/**
	 * RXgN^B
	 * Vector̔z1ɃZbgāA
	 * vXVB
	 * 
	 * @param strName
	 * @param fParameter
	 */
    public CqShaderVariableVaryingColor( final String strName, boolean fParameter)
    {
    	super(strName,fParameter,new EqVariableType(EqVariableType.type_color));
		//Ϗ̂
		//m_aValue = new STLVector<CqColor>(CqColor.class);
    	m_aValue = new STLArray<CqColor>(CqColor.class);
		m_aValue.resize( 1 );
        CqStats.STATS_INC( SHD_var_varying_color );
    }
    
	/**
	 * RXgN^B
	 * Vector̔z1ɃZbgāA
	 * vXVB
	 * 
	 * @param strName
	 */
    public CqShaderVariableVaryingColor( final String strName){
    	this(strName,false);
    }
    
    /**
     * Rs[RXgN^
     * @param val
     */
    public CqShaderVariableVaryingColor(CqShaderVariableVaryingColor val){
    	super(val,new EqVariableType(EqVariableType.type_color));
    	//m_aValue = new STLVector<CqColor>(CqColor.class);
    	m_aValue = new STLArray<CqColor>(CqColor.class);
		m_aValue.resize( val.m_aValue.size() );
//		m_aValue.assign( val.m_aValue.begin(), val.m_aValue.begin() );
		//R[hɏC 2005/11/2 nttdata
		for(int i = 0; i < val.m_aValue.size(); i++)
			m_aValue.elementAt(i).assignment(val.m_aValue.elementAt(i));
    }
	/**
	 * u=vZq̃I[o[[h
	 *  Vector̒lRs[B
	 * @param From
	 */
	public void assignment(CqShaderVariableVarying From) {
		m_aValue.resize(From.m_aValue.size());
		for(int i = 0; i < From.m_aValue.size();i++){
			m_aValue.elementAt(i).assignment((CqColor)From.m_aValue.elementAt(i));
		}

	}
	/**
	 * eNXŒ`ꂽ֐
	 * Vector̃TCY1ȏł
	 * w肳ꂽ擪̒lVector𖄂ߐsB
	 * Vector̃TCY0ȉł΁A
	 * lŖߐsB
	 * 
	 * ߐs(uGridRes+1) * (vGridRes)B
	 * 
	 * @param uGridRes
	 * @param vGridRes
	 */
	public void Initialise(int uGridRes, int vGridRes) {
		CqColor Def = new CqColor();
		
		if ( m_aValue.size() > 0 )
			Def.assignment(m_aValue.elementAt(0));
		
		if( Def.m_fRed == 0.0f && Def.m_fGreen == 0.0f && Def.m_fBlue == 0.0f )
		{
			m_aValue.resize( (( uGridRes + 1 ) * ( vGridRes + 1 )) );
		}
		else
		{
			m_aValue.assign( (( uGridRes + 1 ) * ( vGridRes + 1 )), Def );
		}
		
		//܂
		CqStats.STATS_INC( SHD_Var_varying_init );

	}

	/**
	 * w肳ꂽꏊShaderData̒l擾
	 * @param res 擾li[ϐ
	 * @param index 擾ꏊ
	 */
    public	void	GetColor( CqColor res, int index ) 
    {
        res.assignment(m_aValue.elementAt( index ));
    }
    
	/**
	 * ShaderData̎ACqColor^̃|C^擾B
	 * 
	 * @param res ʂi[BgύXShaderData̒le󂯂
	 */
    //public	void	GetColorPtr( STLVector<CqColor> res )
    public	void	GetColorPtr( STLArray<CqColor> res )
    {
		res.resize(m_aValue.size());
		for(int i=0;i < m_aValue.size();i++){
			res.setElementAt(m_aValue.elementAt(i),i);
		}
    }
    //nttdata 
    //public	STLVector<CqColor> GetColorPtr_2( )
    public	STLArray<CqColor> GetColorPtr_2( )
    {
    	return m_aValue;
    }
    
	/**
	 * ShaderData̎w肳ꂽꏊ̒lύXB
	 * 
	 * @param c ύXl
	 * @param index ύXꏊ
	 */
    public	void	SetColor( final CqColor c, int index )
    {
        m_aValue.elementAt( index ).assignment( c );
    }
    
	/**
	 * ShaderData̒lύXB
	 * Ŏw肳ꂽlVector𖄂ߐs
	 * @param  ύXl
	 */
    public	void	SetColor( final CqColor c )
    {
        m_aValue.assign( m_aValue.size(), c );
    }
    
	/** Copy the values from the passed variable into this, taking into account any class differences.
	 * Ŏw肳ꂽϐlARs[B
	 * Rs[̃TCY1ȉ̏ꍇ́A̒l
	 * Vector̒Rs[B
	 *  
	 * Rs[Vector̃TCY1傫
	 * Vector̃TCY菬ꍇErrorƂȂB
	 * 
	 * @param pVal The variable to copy from.
	 */
    public	void	SetValueFromVariable( final IqShaderData pVal )
    {
        int i;
        if ( pVal.Size() > 1 )
        {
//             STLVector<CqColor> pData = new STLVector<CqColor>(CqColor.class);
//            pVal.GetColorPtr( pData );
            
        	//STLVector<CqColor> pData ;
        	STLArray<CqColor> pData ;
            pData = pVal.GetColorPtr_2( );
            
            for ( i = 0; i < Size(); i++ )
                m_aValue.elementAt( i ).assignment( pData.elementAt( i ));
        }
        else
        {
            CqColor temp = new CqColor();
            pVal.GetColor( temp );
            m_aValue.assign( m_aValue.size(), temp );
        }
    }
    
	/**
	 * w肳ꂽꏊ̒lׂ0̎falseA
	 * ȊOtrue1ɑB
	 * 
	 * @param res li[ϐ
	 * @param index w肷ꏊ
	 */
    public void	GetBool( p_boolean res, int index ) 
    {
        res.value = ( ( m_aValue.elementAt( index ).fRed() != 0.0f ) || ( m_aValue.elementAt( index ).fGreen() != 0.0f ) || ( m_aValue.elementAt( index ).fBlue() != 0.0f ) );
    }

	/** 
	 * Set the all SIMD data ased on a state vector, only indexes whose bit is set are modified.
	 * Ŏw肳ꂽϐVector̎w肳ꂽꏊ̒l
	 * gVector̓ꏊɃRs[B
	 * 
	 * AgA܂̓Rs[̎Vector̒ȏ̏ꏊw肷
	 * G[B(C++ł͓ɃG[NȂ)
	 * @param pVal Rs[ The stack entry to assign.
	 * @param index Rs[ꏊ Integer SIMD index.
	 */
    public	void	SetValueFromVariable( final IqShaderData pVal, int index )
    {
        pVal.GetColor( m_aValue.elementAt( index ), index );
    }
    
	/**
	 * ƓlCX^XԂ
	 * 
	 * @return g̃Rs[
	 */
    public	IqShaderData Clone() 
    {
        CqShaderVariableVaryingColor newVar = new CqShaderVariableVaryingColor( this );
        newVar.SetSize( (int)Size() );
        newVar.SetValueFromVariable( this );
        return ( newVar );
    }

}
