// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.shadervm;

import static  net.cellcomputing.himawari.library.EqIntIndex.*;

import java.util.Iterator;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.EqIntIndex;
import net.cellcomputing.himawari.library.EqVariableClass;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;

/**
 * Array of variable pointers.
 * ShaderData𕡐ێłNXB
 * lXȃ^CvShaderDataǗ邱ƂoB
 * Ai[ShaderData͓^̂̂]܂B
 * قȂ^ShaderDatai[ꍇ͗\ʓ\B
 * @author NTT DATA Corporation
 */
public strictfp class CqShaderVariableArray extends CqShaderVariable {
	
	private STLVector<IqShaderData>	m_aVariables = new STLVector<IqShaderData>(IqShaderData.class);		///< Array of pointers to variables.
	
	
	/** Default constructor.
	 * 
	 * @param name ShaderData̖O Character pointer to the name to use.
	 * @param Count ̎z̒ Count the size of the array.
	 * @param fParmeter VF[_̃p[^ł邱ƂtO fParameter Boolean value, true indicates the shader variable is a shader parameter.
	 */
	CqShaderVariableArray( final String name, int Count, boolean fParameter)
	{
		super(name,fParameter);
		assert( Count > 0 );
		m_aVariables.resize( Count );
		CqStats.STATS_INC( SHD_var_array );
		CqStats.STATS_INC( SHD_var_array_current );
		int cvArr = CqStats.STATS_GETI( SHD_var_array_current );
		int cPeak = CqStats.STATS_GETI( SHD_var_array_peak );
		CqStats.STATS_SETI( SHD_var_array_peak, cvArr > cPeak ? cvArr : cPeak );
	}
	
	/** 
	 * RXgN^
	 * @param name ShaderData̖O Character pointer to the name to use.
	 * @param Count ̎z̒ the size of the array.
	 * @param fParameter VF[_̃p[^ł邱ƂtO Boolean value, true indicates the shader variable is a shader parameter.
	 */
	CqShaderVariableArray( final String name, int Count)
	{
		this(name,Count,false);
	}
	
	
	/** Copy constructor.
	 * Rs[RXgN^
	 * @param From Rs[
	 */
	public CqShaderVariableArray( final CqShaderVariableArray From )
	{
		super(From.m_strName);
		//fParameterɂĂ̓Rs[Ȃ
		m_aVariables.resize( From.m_aVariables.size() );
		for ( int i = 0; i < From.m_aVariables.size(); i++ )
			m_aVariables.setElementAt(From.m_aVariables.elementAt(i).Clone(),i);
		//m_aVariables.elementAt(i) = From.m_aVariables.elementAt(i).Clone();
		CqStats.STATS_INC( SHD_var_array );
		CqStats.STATS_INC( SHD_var_array_current );
		int cvArr = CqStats.STATS_GETI( SHD_var_array_current );
		int cPeak = CqStats.STATS_GETI( SHD_var_array_peak );
		CqStats.STATS_SETI( SHD_var_array_peak, cvArr > cPeak ? cvArr : cPeak );
	}
	
	/**
	 * fXgN^
	 * vXVB
	 */
	public void destruct()
	{
		CqStats.STATS_DEC( EqIntIndex.SHD_var_array_current );
		super.destruct();
	}
	
	/**
	 * VectoȓSĂ̗vfɑ΂
	 * Initialize(uGridRes,vGridRes)ĂяoAsB
	 * @param uGridRes
	 * @param vGridRes
	 */
	public void	Initialise( final int uGridRes, final int vGridRes )
	{
		for ( Iterator<IqShaderData> i = m_aVariables.iterator(); i.hasNext();)
			i.next().Initialise( uGridRes, vGridRes );
		CqStats.STATS_INC( SHD_var_array_init );
	}
	
	/**
	 * SĂShaderDataSetSize()\bhĂяo
	 * TCYύXB
	 * @param size TCY
	 */
	public void	SetSize( final int size )
	{
		for ( Iterator<IqShaderData> i = m_aVariables.iterator(); i.hasNext();)
			( i ).next().SetSize( size );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	GetFloat(p_float res ,int index)
	{
		assert( false ); 
//		m_aVariables.elementAt(0).GetFloat( res, index );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	GetString( p_String res,int index)
	{
		assert( false); //m_aVariables.elementAt(0).GetString( res, index );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	GetPoint( CqVector3D res,int index)
	{
		assert( false); //m_aVariables.elementAt(0).GetPoint( res, index );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	GetVector( CqVector3D res,int index)
	{
		assert( false); //m_aVariables.elementAt(0).GetVector( res, index );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	GetNormal( CqVector3D res,int index)
	{
		assert( false); //m_aVariables.elementAt(0).GetNormal( res, index );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	GetColor( CqColor res,int index)
	{
		assert( false); //m_aVariables.elementAt(0).GetColor( res, index );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	GetMatrix( CqMatrix res,int index)
	{
		assert( false); //m_aVariables.elementAt(0).GetMatrix( res, index );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	GetFloatPtr( final STLVector<p_float> res)
	{
		assert( false ); 
//		m_aVariables.elementAt(0).GetFloatPtr( res );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	GetStringPtr( final STLVector<p_String> res )
	{
		assert( false); //m_aVariables.elementAt(0).GetStringPtr( res );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	GetPointPtr( final STLVector<CqVector3D> res )
	{
		assert( false); //m_aVariables.elementAt(0).GetPointPtr( res );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	GetVectorPtr( final STLVector<CqVector3D> res )
	{
		assert( false); //m_aVariables.elementAt(0).GetVectorPtr( res );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	GetNormalPtr( final STLVector<CqVector3D> res )
	{
		assert( false); //m_aVariables.elementAt(0).GetNormalPtr( res );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	GetColorPtr( final STLVector<CqColor> res )
	{
		assert( false); //m_aVariables.elementAt(0).GetColorPtr( res );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	GetMatrixPtr( final STLVector<CqMatrix> res )
	{
		assert( false); //m_aVariables.elementAt(0).GetMatrixPtr( res );
	}
	
	
	/**
	 * Ɏs郁\bh
	 */
	public void	SetFloat( final float f )
	{
		assert( false ); m_aVariables.elementAt(0).SetFloat( f );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	SetString( final String s )
	{
		assert( false ); m_aVariables.elementAt(0).SetString( s );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	SetPoint( final CqVector3D p )
	{
		assert( false ); m_aVariables.elementAt(0).SetPoint( p );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	SetVector( final CqVector3D v )
	{
		assert( false ); m_aVariables.elementAt(0).SetVector( v );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	SetNormal( final CqVector3D n )
	{
		assert( false ); m_aVariables.elementAt(0).SetNormal( n );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	SetColor( final CqColor c )
	{
		assert( false ); m_aVariables.elementAt(0).SetColor( c );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	SetMatrix( final CqMatrix m )
	{
		assert( false ); m_aVariables.elementAt(0).SetMatrix( m );
	}
	
	
	/**
	 * Ɏs郁\bh
	 */
	public void	SetFloat( final float f, int index )
	{
		assert( false ); m_aVariables.elementAt(0).SetFloat( f, index );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	SetString( final String s, int index )
	{
		assert( false ); m_aVariables.elementAt(0).SetString( s, index );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	SetPoint( final CqVector3D p, int index )
	{
		assert( false ); m_aVariables.elementAt(0).SetPoint( p, index );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	SetVector( final CqVector3D v, int index )
	{
		assert( false ); m_aVariables.elementAt(0).SetVector( v, index );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	SetNormal( final CqVector3D n, int index )
	{
		assert( false ); m_aVariables.elementAt(0).SetNormal( n, index );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	SetColor( final CqColor c, int index )
	{
		assert( false ); m_aVariables.elementAt(0).SetColor( c, index );
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void	SetMatrix( final CqMatrix m, int index )
	{
		assert( false ); m_aVariables.elementAt(0).SetMatrix( m, index );
	}
	
	/** 
	 * Copy the values from the passed variable into this, taking into account any class differences.<br>
	 * œnꂽϐ̒lAgVector̐擪ɂ
	 * ShaderDataɃRs[B
	 * 
	 * @param pVal Rs[ShaderData The variable to copy from.
	 */
	public void	SetValueFromVariable( final IqShaderData pVal )
	{
		m_aVariables.elementAt( 0 ).SetValueFromVariable( pVal );
	}
	/** Set the all SIMD data ased on a state vector, only indexes whose bit is set are modified.<br>
	 * œnꂽϐ̎w肳ꂽlAgVector̐擪ɂ
	 * ShaderData̎w肳ꂽꏊɃRs[B
	 * 
	 * @param pVal Rs[ShaderData The stack entry to assign.
	 * @param index indexl Integer SIMD index.
	 */
	public void	SetValueFromVariable( final IqShaderData pVal, int index )
	{
		m_aVariables.elementAt( 0 ).SetValueFromVariable( pVal, index );
	}
	
	/**
	 * ƓlCX^X𐶐
	 */
	public IqShaderData Clone()
	{
		return ( new CqShaderVariableArray( this ) );
	}
	
	/**
	 * Vector̐擪ɂShaderData
	 * EqVariableClassԂ
	 * 
	 * @return Vector̐擪ɂShaderDataEqVariableClassԂ
	 */
	public EqVariableClass	Class()
	{
		return ( m_aVariables.elementAt(0).Class()  );
	}
	
	/**
	 * Vector̐擪ɂShaderData
	 * EqVariableTypeԂ
	 * 
	 * @return Vector̐擪ɂShaderDataEqVariableTypeԂ
	 */
	public EqVariableType	Type()
	{
		return ( ( m_aVariables.elementAt(0).Type() ) );
	}
	
	/**
	 * Vector̐擪AhXɊi[Ă
	 * ShaderData̎vfԂB
	 * Ȃ킿m_aVariables[0].Size()ŕԂlԂB
	 * 
	 * @return Vector̐擪AhXɓĂShaderDatavf
	 */
	public long	Size()
	{
		return ( m_aVariables.elementAt(0).Size() );
	}
	
	/**
	 * Vector̒Ԃ\bh
	 * 
	 * @return Vector
	 */
	public int	ArrayLength()
	{
		return ( m_aVariables.size() );
	}
	
	/**
	 * VectoriԒnڂ̒lԂ
	 * 
	 * @int i indexl 
	 */
	public  IqShaderData	ArrayEntry( int i )
	{
		assert( i < this.ArrayLength() );
		return ( ( this ).valueAt(i) );
	}
	
	/** Get a reference to the variable array.
	 * Vector m_aVariablesGetter
	 */
	public STLVector<IqShaderData> aVariables()
	{
		return ( m_aVariables );
	}
	
	/** 
	 * Array index access to the values in the array.
	 * VectoriԒnڂ̒lԂ
	 * @param index indexl Integer index intot he array.
	 */
	public IqShaderData valueAt ( long index )
	{
		return( m_aVariables.elementAt((int)index) );
	}
	
	
}
