// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//SIGGRAPH 2002; Larry G. Bake functions

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.shaderexecenv;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

import net.cellcomputing.himawari.util.HimawariLogger;


/**
 * BakingChannelASY
 * 
 * 
 * @author NTT DATA Corporation
 */
public strictfp class BakingChannel {

	public final int batchsize = 10240; // elements to buffer before writing
	//Make sure we're thread-safe on those file writes
	
	
	private int elsize; // element size (e.g., 3 for colors)
	private int buffered; // how many elements are currently buffered
	private float[] data; // pointer to the allocated buffer (new'ed)
	private String filename; // pointer to filename (strdup'ed)
	// Write any buffered data to the file
	
	
	// A "BakingChannel" is the buffer for a single baking output file.
	// We buffer up samples until "batchsize" has been accepted, then
	// write them all at once. This keeps us from constantly accessing
	// the disk. Note that we are careful to use a mutex to keep
	// simultaneous multithreaded writes from clobbering each other.

	// Constructors
	public BakingChannel ()
	{
		buffered = 0;
		data = null;
		filename = null;
	}
	
	public BakingChannel( String _filename, int _elsize )
	{
		init( _filename, _elsize );
	}
	
	// Initialize - allocate memory, etc.
	public void init( final String _filename, int _elsize )
	{
		elsize = _elsize + 2;
		buffered = 0;
		data = new float [ elsize * batchsize ];
		filename =  _filename ;
	}
	
	// Destructor: write buffered output, close file, deallocate
	public void destruct()
	{
		writedata();
//		free ( filename );
//		delete [] data;
	}
	
	// Add one more data item
	public void moredata( float s, float t, float[] newdata )
	{
		if ( buffered >= batchsize )
			writedata();
		float[] f = data;
		int f_idx = elsize * buffered;
		f[ f_idx + 0 ] = s;
		f[ f_idx + 1 ] = t;
		for ( int j = 2; j < elsize; ++j )
			f[ f_idx + j ] = newdata[ j - 2 ];
		++buffered;
	}

	private void writedata()
	{
		try {
			if ( buffered > 0 && filename != null )
			{
				FileOutputStream fos = new FileOutputStream( filename, true );
				PrintWriter file = new PrintWriter( fos );
				float[] f = data;
				int f_idx = 0;
				for ( int i = 0; i < buffered; ++i, f_idx += elsize )
				{
					for ( int j = 0; j < elsize; ++j )
						file.printf (  "%g ", f[ f_idx + j ] );
					file.printf ( "\n" );
				}
				file.close();
				fos.close();
			}

			buffered = 0;
			
			
		} catch (IOException e) {
			HimawariLogger.outputException( e );
		}
	}
	
	
	
}
