package net.cellcomputing.himawari.parser.keywords;

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
import net.cellcomputing.himawari.library.RendermanInterface;
import net.cellcomputing.himawari.parser.Tokenizer;

public strictfp class KeywordMakeOcclusion extends AbstractKeywordParser {
	
	public void parse(Tokenizer st) throws Exception {
		

		// Expect picfiles 
		parseArray(st);
		String[] picfiles = toStringArray();

		// Expect npocs
		int npics = picfiles.length;
		
		// Expect shadowfile
		match(st, TK_STRING);
		String shadowfile =  st.sval ;
	
		// Expect parameter list
		parseParameterList(st);
		
		RendermanInterface.RiMakeOcclusionV( npics, picfiles, shadowfile, count(), tokens(), values() );
	
	}	
}
