// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.cache;

import net.cellcomputing.himawari.library.RendermanInterface;

/**
 * 
 * RiBasis̃LbV
 * 
 * @author NTT DATA Corporation
 */
public strictfp class RiBasisCache extends RiCacheBase {
	
	public RiBasisCache(float[][] ubasis, int ustep, float[][] vbasis, int vstep)
	{
		m_ubasis = new float[ 4 ][ 4 ];
		int __ubasis_i, __ubasis_j;
		for(__ubasis_j = 0; __ubasis_j<4; __ubasis_j++)
			for(__ubasis_i = 0; __ubasis_i<4; __ubasis_i++)
				m_ubasis[__ubasis_j][__ubasis_i] = ubasis[__ubasis_j][__ubasis_i];
		m_ustep = ustep;
		
		m_vbasis = new float[ 4 ][ 4 ];
		int __vbasis_i, __vbasis_j;
		for(__vbasis_j = 0; __vbasis_j<4; __vbasis_j++)
			for(__vbasis_i = 0; __vbasis_i<4; __vbasis_i++)
				m_vbasis[__vbasis_j][__vbasis_i] = vbasis[__vbasis_j][__vbasis_i];
		m_vstep = vstep;
	}
	
	@Override
	public void destruct()
	{
		super.destruct();
	}
	
	@Override
	public void ReCall()
	{
		RendermanInterface.RiBasis(m_ubasis, m_ustep, m_vbasis, m_vstep);
	}
	
	private float[][] m_ubasis;
	private int m_ustep;
	private float[][] m_vbasis;
	private int m_vstep;
	
}
