// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import java.util.HashMap;

import net.cellcomputing.himawari.accessory.Valarray;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;

/**
 * Interface for access to texture map objects.
 * 
 * 
 * @author NTT DATA Corporation
 */
abstract public strictfp class IqTextureMap {
    
    /** 
     * Get the horizontal resolution of this image.
     * @return
     */
	abstract public long	XRes();
    
    /** 
     * Get the vertical resolution of this image.
     * @return
     */
	abstract public long	YRes();
    
    /** 
     * Get the number of samples per pixel.
     * @return
     */
	abstract public int	SamplesPerPixel();
    
    /** 
     * Get the storage format of this image.
     * @return
     */
	abstract public	EqTexFormat	Format();
    
    /** 
     * Get the image type.
     * @return
     */
	abstract public	EqMapType	Type();
    
    /** 
     * Open this image ready for reading.
     * @return
     */
	abstract public	void	Open();
    
    /** 
     * Close this image file.
     * @return
     */
	abstract public	void	Close();
    
    /** 
     * Determine if this image file is valid, i.e. has been found and opened successfully.
     * @return
     */
	abstract public boolean		IsValid();

	abstract public void	PrepareSampleOptions( HashMap<String, IqShaderData> paramMap );

	abstract public	void	SampleMap( float s1, float t1, float swidth, float twidth, Valarray val);
	abstract public	void	SampleMap( float s1, float t1, float s2, float t2, float s3, float t3, float s4, float t4, Valarray val );
	abstract public	void	SampleMap( CqVector3D R, CqVector3D swidth, CqVector3D twidth, Valarray val, int index, p_float average_depth, p_float shadow_depth );
	final public void SampleMap( CqVector3D R, CqVector3D swidth, CqVector3D twidth, Valarray val, int index, p_float average_depth ){
		SampleMap( R, swidth, twidth, val, index, average_depth, null );
	}
	final public	void	SampleMap( CqVector3D R, CqVector3D swidth, CqVector3D twidth, Valarray val, int index ){
		SampleMap( R, swidth, twidth, val, index, null, null );
	}
	final public	void	SampleMap( CqVector3D R, CqVector3D swidth, CqVector3D twidth, Valarray val ){
		SampleMap( R, swidth, twidth, val, 0, null, null );
	}
	
	abstract public	void	SampleMap( CqVector3D R1, CqVector3D R2, CqVector3D R3, CqVector3D R4, Valarray val, int index, p_float average_depth, p_float shadow_depth );
	final public void SampleMap( CqVector3D R1, CqVector3D R2, CqVector3D R3, CqVector3D R4, Valarray val, int index, p_float average_depth ){
		SampleMap( R1, R2, R3, R4, val, index, average_depth, null );
	}
	final public void SampleMap( CqVector3D R1, CqVector3D R2, CqVector3D R3, CqVector3D R4, Valarray val, int index ){
		SampleMap( R1, R2, R3, R4, val, index, null, null );
	}
	final public void SampleMap( CqVector3D R1, CqVector3D R2, CqVector3D R3, CqVector3D R4, Valarray val ){
		SampleMap( R1, R2, R3, R4, val, 0, null, null );
	}
	
	abstract public CqMatrix GetMatrix( int which, int index );
	final public CqMatrix GetMatrix( int which ){
		return GetMatrix( which, 0 );
	}

	abstract public	int	NumPages();
}
