// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import static net.cellcomputing.himawari.library.EqVariableType.*;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;

/**
 * 
 * Class encapsulating the functionality of teapot geometry.
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqTeapot extends CqSurface {
	
	private boolean m_CrowBase = true;			///< Utah teapot was missing a bottom.  F. Crow added one.
	
	protected CqMatrix m_matTx   = new CqMatrix();		///< Transformation matrix from object to camera.
	protected CqMatrix m_matITTx = new CqMatrix();		///< Inverse transpose transformation matrix, for transforming normals.
	
	public CqSurface[] pPatchMeshBicubic = new CqSurface[7];
	
	public int cNbrPatchMeshBicubic;
	
	
	public CqTeapot( boolean addCrowBase )
	{
		int i;
//		int lUses;
		CqSurfacePatchMeshBicubic pSurface = new CqSurfacePatchMeshBicubic( 13, 10, true, true );
//		lUses = pSurface.Uses();
		
		
		// Fill in default values for all primitive variables not explicitly specified.
		// Fill in primitive variables specified.
		pSurface.AddPrimitiveVariable( new CqParameterTypedVertex<CqVector4D, CqVector3D>( "P", 1, new EqVariableType(type_hpoint), CqVector4D.class, CqVector3D.class ) );
		pSurface.P() .SetSize( 13 * 10 );
		for ( i = 0; i < 13*10; i++ )
			((CqVector4D)pSurface.P().pValue_get( i , 0 )).assignment( Patch01[ i ] );
		pSurface.SetDefaultPrimitiveVariables();
		pSurface.SetSurfaceParameters( this );
		
		pSurface.AddPrimitiveVariable( new CqParameterTypedVarying<CqColor, CqColor>( "Cs", new EqVariableType(type_color), CqColor.class, CqColor.class ) );
		pSurface.AddPrimitiveVariable( new CqParameterTypedVarying<CqColor, CqColor>( "Os", new EqVariableType(type_color), CqColor.class, CqColor.class ) );
		pSurface.Cs().SetSize( 130 );
		pSurface.Os().SetSize( 130 );
		for ( i = 0; i < 13*10; i++ )
		{
			((CqColor)pSurface.Cs().pValue_get( i , 0 )).assignment( m_pAttributes.GetColorAttribute( "System", "Color" ) [ 0 ] );
			((CqColor)pSurface.Os().pValue_get( i , 0 )).assignment( m_pAttributes.GetColorAttribute( "System", "Opacity" ) [ 0 ] );
		}
		
		this.pPatchMeshBicubic[ 0 ] = pSurface;
		
		pSurface = new CqSurfacePatchMeshBicubic( 13, 7, true, true );
//		lUses = pSurface.Uses();
		
		// Fill in default values for all primitive variables not explicitly specified.
		// Fill in primitive variables specified.
		pSurface.AddPrimitiveVariable( new CqParameterTypedVertex<CqVector4D, CqVector3D>( "P", 1, new EqVariableType(type_hpoint), CqVector4D.class, CqVector3D.class ) );
		pSurface.P() .SetSize( 13 * 7 );
		for ( i = 0; i < 13*7; i++ )
			((CqVector4D)pSurface.P().pValue_get( i , 0 )).assignment( Patch02[ i ] );
		pSurface.SetDefaultPrimitiveVariables();
		pSurface.SetSurfaceParameters( this );
		
		pSurface.AddPrimitiveVariable( new CqParameterTypedVarying<CqColor, CqColor>( "Cs", new EqVariableType(type_color), CqColor.class, CqColor.class ) );
		pSurface.AddPrimitiveVariable( new CqParameterTypedVarying<CqColor, CqColor>( "Os", new EqVariableType(type_color), CqColor.class, CqColor.class ) );
		pSurface.Cs() .SetSize( 13 * 7 );
		pSurface.Os() .SetSize( 13 * 7 );
		for ( i = 0; i < 13*7; i++ )
		{
			((CqColor)pSurface.Cs().pValue_get( i , 0 )).assignment( m_pAttributes.GetColorAttribute( "System", "Color" ) [ 0 ] );
			((CqColor)pSurface.Os().pValue_get( i , 0 )).assignment( m_pAttributes.GetColorAttribute( "System", "Opacity" ) [ 0 ] );
		}
		this.pPatchMeshBicubic[ 1 ] = pSurface;
		
		pSurface = new CqSurfacePatchMeshBicubic( 4, 7, true, true );
//		lUses = pSurface.Uses();
		
		// Fill in default values for all primitive variables not explicitly specified.
		// Fill in primitive variables specified.
		pSurface.AddPrimitiveVariable( new CqParameterTypedVertex<CqVector4D, CqVector3D>( "P", 1, new EqVariableType(type_hpoint), CqVector4D.class, CqVector3D.class ) );
		pSurface.P() .SetSize( 4 * 7 );
		for ( i = 0; i < 4*7; i++ )
			((CqVector4D)pSurface.P().pValue_get( i , 0 )).assignment( Patch03[ i ] );
		pSurface.SetDefaultPrimitiveVariables();
		pSurface.SetSurfaceParameters( this );
		
		pSurface.AddPrimitiveVariable( new CqParameterTypedVarying<CqColor, CqColor>( "Cs", new EqVariableType(type_color), CqColor.class, CqColor.class ) );
		pSurface.AddPrimitiveVariable( new CqParameterTypedVarying<CqColor, CqColor>( "Os", new EqVariableType(type_color), CqColor.class, CqColor.class ) );
		pSurface.Cs() .SetSize( 4 * 7 );
		pSurface.Os() .SetSize( 4 * 7 );
		for ( i = 0; i < 4*7; i++ )
		{
			((CqColor)pSurface.Cs().pValue_get( i , 0 )).assignment( m_pAttributes.GetColorAttribute( "System", "Color" ) [ 0 ] );
			((CqColor)pSurface.Os().pValue_get( i , 0 )).assignment( m_pAttributes.GetColorAttribute( "System", "Opacity" ) [ 0 ] );
		}
		this.pPatchMeshBicubic[ 2 ] = pSurface;
		
		pSurface = new CqSurfacePatchMeshBicubic( 4, 7, true, true );
//		lUses = pSurface.Uses();
		
		// Fill in default values for all primitive variables not explicitly specified.
		// Fill in primitive variables specified.
		pSurface.AddPrimitiveVariable( new CqParameterTypedVertex<CqVector4D, CqVector3D>( "P", 1, new EqVariableType(type_hpoint), CqVector4D.class, CqVector3D.class ) );
		pSurface.P() .SetSize( 4 * 7 );
		for ( i = 0; i < 4*7; i++ )
			((CqVector4D)pSurface.P().pValue_get( i , 0 )).assignment( Patch04[ i ] );
		pSurface.SetDefaultPrimitiveVariables();
		pSurface.SetSurfaceParameters( this );
		
		pSurface.AddPrimitiveVariable( new CqParameterTypedVarying<CqColor, CqColor>( "Cs", new EqVariableType(type_color), CqColor.class, CqColor.class ) );
		pSurface.AddPrimitiveVariable( new CqParameterTypedVarying<CqColor, CqColor>( "Os", new EqVariableType(type_color), CqColor.class, CqColor.class ) );
		pSurface.Cs() .SetSize( 4 * 7 );
		pSurface.Os() .SetSize( 4 * 7 );
		for ( i = 0; i < 4*7; i++ )
		{
			((CqColor)pSurface.Cs().pValue_get( i , 0 )).assignment( m_pAttributes.GetColorAttribute( "System", "Color" ) [ 0 ] );
			((CqColor)pSurface.Os().pValue_get( i , 0 )).assignment( m_pAttributes.GetColorAttribute( "System", "Opacity" ) [ 0 ] );
		}
		this.pPatchMeshBicubic[ 3 ] = pSurface;
		
		pSurface = new CqSurfacePatchMeshBicubic( 4, 7, true, true );
//		lUses = pSurface.Uses();
		
		// Fill in default values for all primitive variables not explicitly specified.
		// Fill in primitive variables specified.
		pSurface.AddPrimitiveVariable( new CqParameterTypedVertex<CqVector4D, CqVector3D>( "P", 1, new EqVariableType(type_hpoint), CqVector4D.class, CqVector3D.class ) );
		pSurface.P() .SetSize( 4 * 7 );
		for ( i = 0; i < 4*7; i++ )
			((CqVector4D)pSurface.P().pValue_get( i , 0 )).assignment( Patch05[ i ] );
		pSurface.SetDefaultPrimitiveVariables();
		pSurface.SetSurfaceParameters( this );
		
		pSurface.AddPrimitiveVariable( new CqParameterTypedVarying<CqColor, CqColor>( "Cs", new EqVariableType(type_color), CqColor.class, CqColor.class ) );
		pSurface.AddPrimitiveVariable( new CqParameterTypedVarying<CqColor, CqColor>( "Os", new EqVariableType(type_color), CqColor.class, CqColor.class ) );
		pSurface.Cs() .SetSize( 4 * 7 );
		pSurface.Os() .SetSize( 4 * 7 );
		for ( i = 0; i < 4*7; i++ )
		{
			((CqColor)pSurface.Cs().pValue_get( i , 0 )).assignment( m_pAttributes.GetColorAttribute( "System", "Color" ) [ 0 ] );
			((CqColor)pSurface.Os().pValue_get( i , 0 )).assignment( m_pAttributes.GetColorAttribute( "System", "Opacity" ) [ 0 ] );
		}
		this.pPatchMeshBicubic[ 4 ] = pSurface;
		
		pSurface = new CqSurfacePatchMeshBicubic( 4, 7, true, true );
//		lUses = pSurface.Uses();
		
		// Fill in default values for all primitive variables not explicitly specified.
		// Fill in primitive variables specified.
		pSurface.AddPrimitiveVariable( new CqParameterTypedVertex<CqVector4D, CqVector3D>( "P", 1, new EqVariableType(type_hpoint), CqVector4D.class, CqVector3D.class ) );
		pSurface.P() .SetSize( 4 * 7 );
		for ( i = 0; i < 4*7; i++ )
			((CqVector4D)pSurface.P().pValue_get( i , 0 )).assignment( Patch06[ i ] );
		pSurface.SetDefaultPrimitiveVariables();
		pSurface.SetSurfaceParameters( this );
		
		pSurface.AddPrimitiveVariable( new CqParameterTypedVarying<CqColor, CqColor>( "Cs", new EqVariableType(type_color), CqColor.class, CqColor.class ) );
		pSurface.AddPrimitiveVariable( new CqParameterTypedVarying<CqColor, CqColor>( "Os", new EqVariableType(type_color), CqColor.class, CqColor.class ) );
		pSurface.Cs() .SetSize( 4 * 7 );
		pSurface.Os() .SetSize( 4 * 7 );
		for ( i = 0; i < 4*7; i++ )
		{
			((CqColor)pSurface.Cs().pValue_get( i , 0 )).assignment( m_pAttributes.GetColorAttribute( "System", "Color" ) [ 0 ] );
			((CqColor)pSurface.Os().pValue_get( i , 0 )).assignment( m_pAttributes.GetColorAttribute( "System", "Opacity" ) [ 0 ] );
		}
		this.pPatchMeshBicubic[ 5 ] = pSurface;
		this.cNbrPatchMeshBicubic = 6;
		// bottom
		if ( m_CrowBase )
		{
			pSurface = new CqSurfacePatchMeshBicubic( 13, 4, true, true );
//			lUses = pSurface.Uses();
			
			// Fill in default values for all primitive variables not explicitly specified.
			// Fill in primitive variables specified.
			pSurface.AddPrimitiveVariable( new CqParameterTypedVertex<CqVector4D, CqVector3D>( "P", 1, new EqVariableType(type_hpoint), CqVector4D.class, CqVector3D.class ) );
			pSurface.P() .SetSize( 13 * 4 );
			for ( i = 0; i < 13*4; i++ )
			{
				
				if ( i < 13 )
					((CqVector4D)pSurface.P().pValue_get( i , 0 )).assignment( new CqVector3D( 0.0f, 0.0f, 0.0f ) );
				else if ( i < 39 )
					((CqVector4D)pSurface.P().pValue_get( i , 0 )).assignment( Patch01[ i - 13 ] );
				else
					((CqVector4D)pSurface.P().pValue_get( i , 0 )).assignment( Patch01[ i - 13 ].mul( 0.85f ) );
				
				
			}
			pSurface.SetDefaultPrimitiveVariables();
			pSurface.SetSurfaceParameters( this );
			
			pSurface.AddPrimitiveVariable( new CqParameterTypedVarying<CqColor, CqColor>( "Cs", new EqVariableType(type_color), CqColor.class, CqColor.class ) );
			pSurface.AddPrimitiveVariable( new CqParameterTypedVarying<CqColor, CqColor>( "Os", new EqVariableType(type_color), CqColor.class, CqColor.class ) );
			pSurface.Cs() .SetSize( 13 * 4 );
			pSurface.Os() .SetSize( 13 * 4 );
			for ( i = 0; i < 13*4; i++ )
			{
				((CqColor)pSurface.Cs().pValue_get( i , 0 )).assignment( m_pAttributes.GetColorAttribute( "System", "Color" ) [ 0 ] );
				((CqColor)pSurface.Os().pValue_get( i , 0 )).assignment( m_pAttributes.GetColorAttribute( "System", "Opacity" ) [ 0 ] );
			}
			this.pPatchMeshBicubic[ 6 ] = pSurface;
			this.cNbrPatchMeshBicubic = 7;
		}
		
	}
	
	public CqTeapot( final CqTeapot From )
	{
		this.assignment( From );
	}
	
	public void Transform( final CqMatrix matTx, final CqMatrix matITTx, final CqMatrix matRTx, int iTime )
	{
		m_matTx.assignMul( matTx );
		m_matITTx.assignMul( matITTx );
	}
	
	public final void Transform( final CqMatrix matTx, final CqMatrix matITTx, final CqMatrix matRTx ){
		Transform( matTx, matITTx, matRTx, 0 );
	}
	
	/** Determine whether the passed surface is valid to be used as a
	 *  frame in motion blur for this surface.
	 */
	public boolean	IsMotionBlurMatch( CqBasicSurface pSurf )
	{
		return( false );
	}
	
	public	int	cUniform()
	{
		return ( 1 );
	}
	public	int	cVarying()
	{
		return ( 4 );
	}
	public	int	cVertex()
	{
		return ( 16 );
	}
	public	int	cFaceVarying()
	{
		///TODO Must work out what this value should be.
		return ( 1 );
	}
	
	// Overrides from CqSurface
	public	CqBound Bound()
	{
		CqVector3D vecMin = new CqVector3D( -3.000f, -2.0f, 0.0f );
		CqVector3D vecMax = new CqVector3D( 3.525f, 2.0f, ( m_CrowBase ? 3.15f : 3.15f - 0.15f /* remove bottom */ ) );
		
		CqBound	B = new CqBound( vecMin, vecMax );
		B.Transform( m_matTx );
		return ( AdjustBoundForTransformationMotion( B ) );
	}
	
	public	int Split( STLVector<CqBasicSurface> aSplits )
	{
		return 0;
	}
	
	public	CqTeapot assignment( final CqTeapot From )
	{
		super.assignment( (CqSurface)From );
		m_CrowBase = From.m_CrowBase;
		m_matTx.assignment( From.m_matTx );
		m_matITTx.assignment( From.m_matITTx );
		
		return ( this );
	}
	
	
	private static CqVector3D[] Patch01 = new CqVector3D[]{ //13*10 ] = { /*u=13 v=10 */
		new CqVector3D( 1.5f, 0.0f, 0.0f ),
		new CqVector3D( 1.5f, 0.828427f, 0.0f ),
		new CqVector3D( 0.828427f, 1.5f, 0.0f ),
		new CqVector3D( 0f, 1.5f, 0.0f ),
		new CqVector3D( -0.828427f, 1.5f, 0.0f ),
		new CqVector3D( -1.5f, 0.828427f, 0.0f ),
		new CqVector3D( -1.5f, 0f, 0.0f ),
		new CqVector3D( -1.5f, -0.828427f, 0.0f ),
		new CqVector3D( -0.828427f, -1.5f, 0.0f ),
		new CqVector3D( 0f, -1.5f, 0.0f ),
		new CqVector3D( 0.828427f, -1.5f, 0.0f ),
		new CqVector3D( 1.5f, -0.828427f, 0.0f ),
		new CqVector3D( 1.5f, 0.0f, 0.0f ),
		new CqVector3D( 1.5f, 0.0f, 0.075f ),
		new CqVector3D( 1.5f, 0.828427f, 0.075f ),
		new CqVector3D( 0.828427f, 1.5f, 0.075f ),
		new CqVector3D( 0f, 1.5f, 0.075f ),
		new CqVector3D( -0.828427f, 1.5f, 0.075f ),
		new CqVector3D( -1.5f, 0.828427f, 0.075f ),
		new CqVector3D( -1.5f, 0f, 0.075f ),
		new CqVector3D( -1.5f, -0.828427f, 0.075f ),
		new CqVector3D( -0.828427f, -1.5f, 0.075f ),
		new CqVector3D( 0.0f, -1.5f, 0.075f ),
		new CqVector3D( 0.828427f, -1.5f, 0.075f ),
		new CqVector3D( 1.5f, -0.828427f, 0.075f ),
		new CqVector3D( 1.5f, 0f, 0.075f ),
		new CqVector3D( 2f, 0f, 0.3f ),
		new CqVector3D( 2f, 1.10457f, 0.3f ),
		new CqVector3D( 1.10457f, 2f, 0.3f ),
		new CqVector3D( 0.0f, 2f, 0.3f ),
		new CqVector3D( -1.10457f, 2f, 0.3f ),
		new CqVector3D( -2f, 1.10457f, 0.3f ),
		new CqVector3D( -2f, 0f, 0.3f ),
		new CqVector3D( -2f, -1.10457f, 0.3f ),
		new CqVector3D( -1.10457f, -2f, 0.3f ),
		new CqVector3D( 0f, -2f, 0.3f ),
		new CqVector3D( 1.10457f, -2f, 0.3f ),
		new CqVector3D( 2f, -1.10457f, 0.3f ),
		new CqVector3D( 2f, 0f, 0.3f ),
		new CqVector3D( 2f, 0f, 0.75f ),
		new CqVector3D( 2f, 1.10457f, 0.75f ),
		new CqVector3D( 1.10457f, 2f, 0.75f ),
		new CqVector3D( 0f, 2f, 0.75f ),
		new CqVector3D( -1.10457f, 2f, 0.75f ),
		new CqVector3D( -2f, 1.10457f, 0.75f ),
		new CqVector3D( -2f, 0f, 0.75f ),
		new CqVector3D( -2f, -1.10457f, 0.75f ),
		new CqVector3D( -1.10457f, -2f, 0.75f ),
		new CqVector3D( 0f, -2f, 0.75f ),
		new CqVector3D( 1.10457f, -2f, 0.75f ),
		new CqVector3D( 2f, -1.10457f, 0.75f ),
		new CqVector3D( 2f, 0f, 0.75f ),
		new CqVector3D( 2f, 0f, 1.2f ),
		new CqVector3D( 2f, 1.10457f, 1.2f ),
		new CqVector3D( 1.10457f, 2f, 1.2f ),
		new CqVector3D( 0f, 2f, 1.2f ),
		new CqVector3D( -1.10457f, 2f, 1.2f ),
		new CqVector3D( -2f, 1.10457f, 1.2f ),
		new CqVector3D( -2f, 0f, 1.2f ),
		new CqVector3D( -2f, -1.10457f, 1.2f ),
		new CqVector3D( -1.10457f, -2f, 1.2f ),
		new CqVector3D( 0f, -2f, 1.2f ),
		new CqVector3D( 1.10457f, -2f, 1.2f ),
		new CqVector3D( 2f, -1.10457f, 1.2f ),
		new CqVector3D( 2f, 0f, 1.2f ),
		new CqVector3D( 1.75f, 0f, 1.725f ),
		new CqVector3D( 1.75f, 0.966498f, 1.725f ),
		new CqVector3D( 0.966498f, 1.75f, 1.725f ),
		new CqVector3D( 0f, 1.75f, 1.725f ),
		new CqVector3D( -0.966498f, 1.75f, 1.725f ),
		new CqVector3D( -1.75f, 0.966498f, 1.725f ),
		new CqVector3D( -1.75f, 0f, 1.725f ),
		new CqVector3D( -1.75f, -0.966498f, 1.725f ),
		new CqVector3D( -0.966498f, -1.75f, 1.725f ),
		new CqVector3D( 0f, -1.75f, 1.725f ),
		new CqVector3D( 0.966498f, -1.75f, 1.725f ),
		new CqVector3D( 1.75f, -0.966498f, 1.725f ),
		new CqVector3D( 1.75f, 0f, 1.725f ),
		new CqVector3D( 1.5f, 0f, 2.25f ),
		new CqVector3D( 1.5f, 0.828427f, 2.25f ),
		new CqVector3D( 0.828427f, 1.5f, 2.25f ),
		new CqVector3D( 0f, 1.5f, 2.25f ),
		new CqVector3D( -0.828427f, 1.5f, 2.25f ),
		new CqVector3D( -1.5f, 0.828427f, 2.25f ),
		new CqVector3D( -1.5f, 0f, 2.25f ),
		new CqVector3D( -1.5f, -0.828427f, 2.25f ),
		new CqVector3D( -0.828427f, -1.5f, 2.25f ),
		new CqVector3D( 0f, -1.5f, 2.25f ),
		new CqVector3D( 0.828427f, -1.5f, 2.25f ),
		new CqVector3D( 1.5f, -0.828427f, 2.25f ),
		new CqVector3D( 1.5f, 0f, 2.25f ),
		new CqVector3D( 1.4375f, 0f, 2.38125f ),
		new CqVector3D( 1.4375f, 0.793909f, 2.38125f ),
		new CqVector3D( 0.793909f, 1.4375f, 2.38125f ),
		new CqVector3D( 0f, 1.4375f, 2.38125f ),
		new CqVector3D( -0.793909f, 1.4375f, 2.38125f ),
		new CqVector3D( -1.4375f, 0.793909f, 2.38125f ),
		new CqVector3D( -1.4375f, 0f, 2.38125f ),
		new CqVector3D( -1.4375f, -0.793909f, 2.38125f ),
		new CqVector3D( -0.793909f, -1.4375f, 2.38125f ),
		new CqVector3D( 0f, -1.4375f, 2.38125f ),
		new CqVector3D( 0.793909f, -1.4375f, 2.38125f ),
		new CqVector3D( 1.4375f, -0.793909f, 2.38125f ),
		new CqVector3D( 1.4375f, 0f, 2.38125f ),
		new CqVector3D( 1.3375f, 0f, 2.38125f ),
		new CqVector3D( 1.3375f, 0.738681f, 2.38125f ),
		new CqVector3D( 0.738681f, 1.3375f, 2.38125f ),
		new CqVector3D( 0f, 1.3375f, 2.38125f ),
		new CqVector3D( -0.738681f, 1.3375f, 2.38125f ),
		new CqVector3D( -1.3375f, 0.738681f, 2.38125f ),
		new CqVector3D( -1.3375f, 0f, 2.38125f ),
		new CqVector3D( -1.3375f, -0.738681f, 2.38125f ),
		new CqVector3D( -0.738681f, -1.3375f, 2.38125f ),
		new CqVector3D( 0f, -1.3375f, 2.38125f ),
		new CqVector3D( 0.738681f, -1.3375f, 2.38125f ),
		new CqVector3D( 1.3375f, -0.738681f, 2.38125f ),
		new CqVector3D( 1.3375f, 0f, 2.38125f ),
		new CqVector3D( 1.4f, 0f, 2.25f ),
		new CqVector3D( 1.4f, 0.773198f, 2.25f ),
		new CqVector3D( 0.773198f, 1.4f, 2.25f ),
		new CqVector3D( 0f, 1.4f, 2.25f ),
		new CqVector3D( -0.773198f, 1.4f, 2.25f ),
		new CqVector3D( -1.4f, 0.773198f, 2.25f ),
		new CqVector3D( -1.4f, 0f, 2.25f ),
		new CqVector3D( -1.4f, -0.773198f, 2.25f ),
		new CqVector3D( -0.773198f, -1.4f, 2.25f ),
		new CqVector3D( 0f, -1.4f, 2.25f ),
		new CqVector3D( 0.773198f, -1.4f, 2.25f ),
		new CqVector3D( 1.4f, -0.773198f, 2.25f ),
		new CqVector3D( 1.4f, 0f, 2.25f )
	};
	
	private static CqVector3D[] Patch02 = new CqVector3D[]{ // 13*7 ] = { /*u=13 v=7 */
		new CqVector3D( 1.3f, 0f, 2.25f ),
		new CqVector3D( 1.3f, 0.71797f, 2.25f ),
		new CqVector3D( 0.71797f, 1.3f, 2.25f ),
		new CqVector3D( 0f, 1.3f, 2.25f ),
		new CqVector3D( -0.71797f, 1.3f, 2.25f ),
		new CqVector3D( -1.3f, 0.71797f, 2.25f ),
		new CqVector3D( -1.3f, 0f, 2.25f ),
		new CqVector3D( -1.3f, -0.71797f, 2.25f ),
		new CqVector3D( -0.71797f, -1.3f, 2.25f ),
		new CqVector3D( 0f, -1.3f, 2.25f ),
		new CqVector3D( 0.71797f, -1.3f, 2.25f ),
		new CqVector3D( 1.3f, -0.71797f, 2.25f ),
		new CqVector3D( 1.3f, 0f, 2.25f ),
		new CqVector3D( 1.3f, 0f, 2.4f ),
		new CqVector3D( 1.3f, 0.71797f, 2.4f ),
		new CqVector3D( 0.71797f, 1.3f, 2.4f ),
		new CqVector3D( 0f, 1.3f, 2.4f ),
		new CqVector3D( -0.71797f, 1.3f, 2.4f ),
		new CqVector3D( -1.3f, 0.71797f, 2.4f ),
		new CqVector3D( -1.3f, 0f, 2.4f ),
		new CqVector3D( -1.3f, -0.71797f, 2.4f ),
		new CqVector3D( -0.71797f, -1.3f, 2.4f ),
		new CqVector3D( 0f, -1.3f, 2.4f ),
		new CqVector3D( 0.71797f, -1.3f, 2.4f ),
		new CqVector3D( 1.3f, -0.71797f, 2.4f ),
		new CqVector3D( 1.3f, 0f, 2.4f ),
		new CqVector3D( 0.4f, 0f, 2.4f ),
		new CqVector3D( 0.4f, 0.220914f, 2.4f ),
		new CqVector3D( 0.220914f, 0.4f, 2.4f ),
		new CqVector3D( 0f, 0.4f, 2.4f ),
		new CqVector3D( -0.220914f, 0.4f, 2.4f ),
		new CqVector3D( -0.4f, 0.220914f, 2.4f ),
		new CqVector3D( -0.4f, 0f, 2.4f ),
		new CqVector3D( -0.4f, -0.220914f, 2.4f ),
		new CqVector3D( -0.220914f, -0.4f, 2.4f ),
		new CqVector3D( 0f, -0.4f, 2.4f ),
		new CqVector3D( 0.220914f, -0.4f, 2.4f ),
		new CqVector3D( 0.4f, -0.220914f, 2.4f ),
		new CqVector3D( 0.4f, 0f, 2.4f ),
		new CqVector3D( 0.2f, 0f, 2.55f ),
		new CqVector3D( 0.2f, 0.110457f, 2.55f ),
		new CqVector3D( 0.110457f, 0.2f, 2.55f ),
		new CqVector3D( 0f, 0.2f, 2.55f ),
		new CqVector3D( -0.110457f, 0.2f, 2.55f ),
		new CqVector3D( -0.2f, 0.110457f, 2.55f ),
		new CqVector3D( -0.2f, 0f, 2.55f ),
		new CqVector3D( -0.2f, -0.110457f, 2.55f ),
		new CqVector3D( -0.110457f, -0.2f, 2.55f ),
		new CqVector3D( 0f, -0.2f, 2.55f ),
		new CqVector3D( 0.110457f, -0.2f, 2.55f ),
		new CqVector3D( 0.2f, -0.110457f, 2.55f ),
		new CqVector3D( 0.2f, 0f, 2.55f ),
		new CqVector3D( 0f, 0f, 2.7f ),
		new CqVector3D( 0f, 0f, 2.7f ),
		new CqVector3D( 0f, 0f, 2.7f ),
		new CqVector3D( 0f, 0f, 2.7f ),
		new CqVector3D( 0f, 0f, 2.7f ),
		new CqVector3D( 0f, 0f, 2.7f ),
		new CqVector3D( 0f, 0f, 2.7f ),
		new CqVector3D( 0f, 0f, 2.7f ),
		new CqVector3D( 0f, 0f, 2.7f ),
		new CqVector3D( 0f, 0f, 2.7f ),
		new CqVector3D( 0f, 0f, 2.7f ),
		new CqVector3D( 0f, 0f, 2.7f ),
		new CqVector3D( 0f, 0f, 2.7f ),
		new CqVector3D( 0.8f, 0f, 3f ),
		new CqVector3D( 0.8f, 0.441828f, 3f ),
		new CqVector3D( 0.441828f, 0.8f, 3f ),
		new CqVector3D( 0f, 0.8f, 3f ),
		new CqVector3D( -0.441828f, 0.8f, 3f ),
		new CqVector3D( -0.8f, 0.441828f, 3f ),
		new CqVector3D( -0.8f, 0f, 3f ),
		new CqVector3D( -0.8f, -0.441828f, 3f ),
		new CqVector3D( -0.441828f, -0.8f, 3f ),
		new CqVector3D( 0f, -0.8f, 3f ),
		new CqVector3D( 0.441828f, -0.8f, 3f ),
		new CqVector3D( 0.8f, -0.441828f, 3f ),
		new CqVector3D( 0.8f, 0f, 3f ),
		new CqVector3D( 0f, 0f, 3f ),
		new CqVector3D( 0f, 0f, 3f ),
		new CqVector3D( 0f, 0f, 3f ),
		new CqVector3D( 0f, 0f, 3f ),
		new CqVector3D( 0f, 0f, 3f ),
		new CqVector3D( 0f, 0f, 3f ),
		new CqVector3D( 0f, 0f, 3f ),
		new CqVector3D( 0f, 0f, 3f ),
		new CqVector3D( 0f, 0f, 3f ),
		new CqVector3D( 0f, 0f, 3f ),
		new CqVector3D( 0f, 0f, 3f ),
		new CqVector3D( 0f, 0f, 3f ),
		new CqVector3D( 0f, 0f, 3f )
	};
	
	private static CqVector3D[] Patch03 = new CqVector3D[]{ // 4*7 ] = { /*u=4 v=7 */
		new CqVector3D( -2f, 0f, 0.75f ),
		new CqVector3D( -2f, 0.3f, 0.75f ),
		new CqVector3D( -1.9f, 0.3f, 0.45f ),
		new CqVector3D( -1.9f, 0f, 0.45f ),
		new CqVector3D( -2.5f, 0f, 0.975f ),
		new CqVector3D( -2.5f, 0.3f, 0.975f ),
		new CqVector3D( -2.65f, 0.3f, 0.7875f ),
		new CqVector3D( -2.65f, 0f, 0.7875f ),
		new CqVector3D( -2.7f, 0f, 1.425f ),
		new CqVector3D( -2.7f, 0.3f, 1.425f ),
		new CqVector3D( -3f, 0.3f, 1.2f ),
		new CqVector3D( -3f, 0f, 1.2f ),
		new CqVector3D( -2.7f, 0f, 1.65f ),
		new CqVector3D( -2.7f, 0.3f, 1.65f ),
		new CqVector3D( -3f, 0.3f, 1.65f ),
		new CqVector3D( -3f, 0f, 1.65f ),
		new CqVector3D( -2.7f, 0f, 1.875f ),
		new CqVector3D( -2.7f, 0.3f, 1.875f ),
		new CqVector3D( -3f, 0.3f, 2.1f ),
		new CqVector3D( -3f, 0f, 2.1f ),
		new CqVector3D( -2.3f, 0f, 1.875f ),
		new CqVector3D( -2.3f, 0.3f, 1.875f ),
		new CqVector3D( -2.5f, 0.3f, 2.1f ),
		new CqVector3D( -2.5f, 0f, 2.1f ),
		new CqVector3D( -1.6f, 0f, 1.875f ),
		new CqVector3D( -1.6f, 0.3f, 1.875f ),
		new CqVector3D( -1.5f, 0.3f, 2.1f ),
		new CqVector3D( -1.5f, 0f, 2.1f )
	};
	private static CqVector3D[] Patch04 = new CqVector3D[]{ // 4*7 ] = { /*u=4 v=7 */
		new CqVector3D( 2.8f, 0f, 2.25f ),
		new CqVector3D( 2.8f, 0.15f, 2.25f ),
		new CqVector3D( 3.2f, 0.15f, 2.25f ),
		new CqVector3D( 3.2f, 0f, 2.25f ),
		new CqVector3D( 2.9f, 0f, 2.325f ),
		new CqVector3D( 2.9f, 0.25f, 2.325f ),
		new CqVector3D( 3.45f, 0.15f, 2.3625f ),
		new CqVector3D( 3.45f, 0f, 2.3625f ),
		new CqVector3D( 2.8f, 0f, 2.325f ),
		new CqVector3D( 2.8f, 0.25f, 2.325f ),
		new CqVector3D( 3.525f, 0.25f, 2.34375f ),
		new CqVector3D( 3.525f, 0f, 2.34375f ),
		new CqVector3D( 2.7f, 0f, 2.25f ),
		new CqVector3D( 2.7f, 0.25f, 2.25f ),
		new CqVector3D( 3.3f, 0.25f, 2.25f ),
		new CqVector3D( 3.3f, 0f, 2.25f ),
		new CqVector3D( 2.3f, 0f, 1.95f ),
		new CqVector3D( 2.3f, 0.25f, 1.95f ),
		new CqVector3D( 2.4f, 0.25f, 1.875f ),
		new CqVector3D( 2.4f, 0f, 1.875f ),
		new CqVector3D( 2.6f, 0f, 1.275f ),
		new CqVector3D( 2.6f, 0.66f, 1.275f ),
		new CqVector3D( 3.1f, 0.66f, 0.675f ),
		new CqVector3D( 3.1f, 0f, 0.675f ),
		new CqVector3D( 1.7f, 0f, 1.275f ),
		new CqVector3D( 1.7f, 0.66f, 1.275f ),
		new CqVector3D( 1.7f, 0.66f, 0.45f ),
		new CqVector3D( 1.7f, 0f, 0.45f )
	};
	private static CqVector3D[] Patch05 = new CqVector3D[]{ // 4*7 ] = { /*u=4 v=7 */
		new CqVector3D( -1.9f, 0f, 0.45f ),
		new CqVector3D( -1.9f, -0.3f, 0.45f ),
		new CqVector3D( -2f, -0.3f, 0.75f ),
		new CqVector3D( -2f, 0f, 0.75f ),
		new CqVector3D( -2.65f, 0f, 0.7875f ),
		new CqVector3D( -2.65f, -0.3f, 0.7875f ),
		new CqVector3D( -2.5f, -0.3f, 0.975f ),
		new CqVector3D( -2.5f, 0f, 0.975f ),
		new CqVector3D( -3f, 0f, 1.2f ),
		new CqVector3D( -3f, -0.3f, 1.2f ),
		new CqVector3D( -2.7f, -0.3f, 1.425f ),
		new CqVector3D( -2.7f, 0f, 1.425f ),
		new CqVector3D( -3f, 0f, 1.65f ),
		new CqVector3D( -3f, -0.3f, 1.65f ),
		new CqVector3D( -2.7f, -0.3f, 1.65f ),
		new CqVector3D( -2.7f, 0f, 1.65f ),
		new CqVector3D( -3f, 0f, 2.1f ),
		new CqVector3D( -3f, -0.3f, 2.1f ),
		new CqVector3D( -2.7f, -0.3f, 1.875f ),
		new CqVector3D( -2.7f, 0f, 1.875f ),
		new CqVector3D( -2.5f, 0f, 2.1f ),
		new CqVector3D( -2.5f, -0.3f, 2.1f ),
		new CqVector3D( -2.3f, -0.3f, 1.875f ),
		new CqVector3D( -2.3f, 0f, 1.875f ),
		new CqVector3D( -1.5f, 0f, 2.1f ),
		new CqVector3D( -1.5f, -0.3f, 2.1f ),
		new CqVector3D( -1.6f, -0.3f, 1.875f ),
		new CqVector3D( -1.6f, 0f, 1.875f )
	};
	
	private static CqVector3D[] Patch06 = new CqVector3D[]{ // 4*7 ] = { /*u=4 v=7 */
		new CqVector3D( 3.2f, 0f, 2.25f ),
		new CqVector3D( 3.2f, -0.15f, 2.25f ),
		new CqVector3D( 2.8f, -0.15f, 2.25f ),
		new CqVector3D( 2.8f, 0f, 2.25f ),
		new CqVector3D( 3.45f, 0f, 2.3625f ),
		new CqVector3D( 3.45f, -0.15f, 2.3625f ),
		new CqVector3D( 2.9f, -0.25f, 2.325f ),
		new CqVector3D( 2.9f, 0f, 2.325f ),
		new CqVector3D( 3.525f, 0f, 2.34375f ),
		new CqVector3D( 3.525f, -0.25f, 2.34375f ),
		new CqVector3D( 2.8f, -0.25f, 2.325f ),
		new CqVector3D( 2.8f, 0f, 2.325f ),
		new CqVector3D( 3.3f, 0f, 2.25f ),
		new CqVector3D( 3.3f, -0.25f, 2.25f ),
		new CqVector3D( 2.7f, -0.25f, 2.25f ),
		new CqVector3D( 2.7f, 0f, 2.25f ),
		new CqVector3D( 2.4f, 0f, 1.875f ),
		new CqVector3D( 2.4f, -0.25f, 1.875f ),
		new CqVector3D( 2.3f, -0.25f, 1.95f ),
		new CqVector3D( 2.3f, 0f, 1.95f ),
		new CqVector3D( 3.1f, 0f, 0.675f ),
		new CqVector3D( 3.1f, -0.66f, 0.675f ),
		new CqVector3D( 2.6f, -0.66f, 1.275f ),
		new CqVector3D( 2.6f, 0f, 1.275f ),
		new CqVector3D( 1.7f, 0f, 0.45f ),
		new CqVector3D( 1.7f, -0.66f, 0.45f ),
		new CqVector3D( 1.7f, -0.66f, 1.275f ),
		new CqVector3D( 1.7f, 0f, 1.275f )
	};
	
//	private static CqVector3D[] Patch07 = new CqVector3D[]{ // 13*2 ] = { /*u=13 v=2 */
//		new CqVector3D( 1.5f, 0.0f, 0.0f ),
//		new CqVector3D( 1.5f, 0.828427f, 0.0f ),
//		new CqVector3D( 0.828427f, 1.5f, 0.0f ),
//		new CqVector3D( 0f, 1.5f, 0.0f ),
//		new CqVector3D( -0.828427f, 1.5f, 0.0f ),
//		new CqVector3D( -1.5f, 0.828427f, 0.0f ),
//		new CqVector3D( -1.5f, 0f, 0.0f ),
//		new CqVector3D( -1.5f, -0.828427f, 0.0f ),
//		new CqVector3D( -0.828427f, -1.5f, 0.0f ),
//		new CqVector3D( 0f, -1.5f, 0.0f ),
//		new CqVector3D( 0.828427f, -1.5f, 0.0f ),
//		new CqVector3D( 1.5f, -0.828427f, 0.0f ),
//		new CqVector3D( 1.5f, 0.0f, 0.0f ),
//		new CqVector3D( 1.5f, 0.0f, 0.075f ),
//		new CqVector3D( 1.5f, 0.828427f, 0.075f ),
//		new CqVector3D( 0.828427f, 1.5f, 0.075f ),
//		new CqVector3D( 0f, 1.5f, 0.075f ),
//		new CqVector3D( -0.828427f, 1.5f, 0.075f ),
//		new CqVector3D( -1.5f, 0.828427f, 0.075f ),
//		new CqVector3D( -1.5f, 0f, 0.075f ),
//		new CqVector3D( -1.5f, -0.828427f, 0.075f ),
//		new CqVector3D( -0.828427f, -1.5f, 0.075f ),
//		new CqVector3D( 0.0f, -1.5f, 0.075f ),
//		new CqVector3D( 0.828427f, -1.5f, 0.075f ),
//		new CqVector3D( 1.5f, -0.828427f, 0.075f ),
//		new CqVector3D( 1.5f, 0f, 0.075f )
//	};
}
