// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import java.util.Collections;
import java.util.Comparator;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.types.CqVector4D;

/**
 * 
 * Class for handling KDTree data representing the points primitive.
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqPointsKDTreeData implements IqKDTreeData<Integer> {

	private CqPoints m_pPointsSurface;
	
	
	public CqPointsKDTreeData( CqPoints pPoints )
	{
		m_pPointsSurface = pPoints;
	}
	
	public void SortElements(STLVector<Integer> aLeaves, int dimension)
	{
//		std::sort(aLeaves.begin(), aLeaves.end(), CqPointsKDTreeDataComparator(m_pPointsSurface, dimension) );
		Collections.sort( aLeaves, new CqPointsKDTreeDataComparator(m_pPointsSurface, dimension) );
	}
	
	public int Dimensions(){
		return(3);
	}
	
	public void SetpPoints( CqPoints pPoints )
	{
		m_pPointsSurface = pPoints;
	}
	
	public void FreePoints()
	{
	}
	    
	
	
    /**
     * 
     * \[gp̃NX
     * 
     * @author NTT DATA Corporation
     */
    private class CqPointsKDTreeDataComparator implements Comparator<Integer>
    {
    	private CqPoints	m_pPointsSurface;
    	private int		m_Dim;
    	
    	public CqPointsKDTreeDataComparator( CqPoints pPoints, int dimension )
    	{
    		m_pPointsSurface = pPoints;
    		m_Dim = dimension;
    	}

		public int compare(Integer a, Integer b) {
			
			boolean ret;
//			ret = ( ( m_pPointsSurface.pPoints().P().pValue( a )[0][m_Dim] ) < ( m_pPointsSurface.pPoints().P().pValue( b )[0][m_Dim] ) );
			ret = ( ( ((CqVector4D)m_pPointsSurface.pPoints().P().pValue_get( a ,0 )).valueAt(m_Dim) ) > ( ((CqVector4D)m_pPointsSurface.pPoints().P().pValue_get( b ,0 )).valueAt(m_Dim) ) );
			
//			//nttdata debug
//			float va = ((CqVector4D)m_pPointsSurface.pPoints().P().pValue( a )[0]).valueAt(m_Dim);
//			float vb = ((CqVector4D)m_pPointsSurface.pPoints().P().pValue( b )[0]).valueAt(m_Dim);
//			System.out.println("a="+a + ",b="+b + " : " + va + " > " + vb );
			
			if( ret )
				return 1;
			else
				return -1;
			
		}
    	
    };
    
	
}
