// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import static net.cellcomputing.himawari.library.EqVariableClass.class_varying;
import net.cellcomputing.himawari.accessory.STLArray;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;
import net.cellcomputing.himawari.util.HimawariLogger;


/**
 * l̃^CvƁAid̃^CvŃev[gꂽAωp[^^CvB
 * @author NTT DATA Corporation
 */
public strictfp class CqParameterTypedVarying<T ,SLT> extends CqParameterTyped<T,SLT>{
    //private STLVector<T>	m_aValues;
    private STLArray<T>	m_aValues;
    protected EqVariableType I;			//Generics I \
    
    /**
     *  RXgN^
     *  
     * @param name p^
     * @param count 
     * @param I EqVariableType C++<S,I,STL>I킷
     * @param TClass C++<S,I,STL>T̃NX
     * @param SLTClass Generics STL̃NX
     */
	public CqParameterTypedVarying(final String name,int count,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass){
		super(name,count,TClass,SLTClass);
		this.I = I;
		//m_aValues = new STLVector<T>(TClass);
		m_aValues = new STLArray<T>(TClass);
		m_aValues.setSize(1);
	}
	/**
	 * RXgN^
	 * @param name p^
	 * @param I count
	 * @param TClass Genrics T̃NX
	 * @param SLTClass Generics SLT̃NX
	 */
	public CqParameterTypedVarying(final String name,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass){
		this(name,1,I,TClass,SLTClass);
	}
	
	
	/**
	 * Rs[RXgN^
	 * 
	 * @param From Rs[
	 * @param I EqVariableType C++<S,I,STL>I킷
	 */
	public CqParameterTypedVarying(final CqParameterTypedVarying<T, SLT>From,EqVariableType I){
		super(From);
		this.I = I;
		//m_aValues = new STLVector<T>(TClass);
		m_aValues = new STLArray<T>(TClass);
		m_aValues.setSize(1);

		this.assignment(From);
	}
	
	/**
	 * fXgN^
	 */
	public void destruct(){
		super.destruct();
	}
	
	/**
	 * u=vZq̃I[o[[h
	 * xN^̒lRs[
	 * 
	 * @param From
	 */
	public CqParameterTypedVarying<T,SLT> assignment(final CqParameterTypedVarying<T,SLT> From){

        int size = From.m_aValues.size();

        m_aValues.setSize( size );

        //--l݂̂Rs[
        T t =m_aValues.elementAt(0);
        if(t instanceof CqVector3D){
            for ( int j = 0; j <  size; j++ )
            {
                //m_aValues.setElementAt(From.m_aValues.get( j ), j );ύX 2005/09/07
                ((CqVector3D)m_aValues.elementAt(j)).assignment((CqVector3D)(From.m_aValues.get(j)));
            }
        	
        }else if(t instanceof CqVector4D){
            for ( int j = 0; j <  size; j++ )
            {
                //m_aValues.setElementAt(From.m_aValues.get( j ), j );ύX 2005/09/07
                ((CqVector4D)m_aValues.elementAt(j)).assignment((CqVector4D)(From.m_aValues.get(j)));
            }
        	
        }else if(t instanceof CqColor){
            for ( int j = 0; j <  size; j++ )
            {
                //m_aValues.setElementAt(From.m_aValues.get( j ), j );ύX 2005/09/07
                ((CqColor)m_aValues.elementAt(j)).assignment((CqColor)(From.m_aValues.get(j)));
            }
        	
        }else if(t instanceof CqMatrix){
            for ( int j = 0; j <  size; j++ )
            {
                //m_aValues.setElementAt(From.m_aValues.get( j ), j );ύX 2005/09/07
                ((CqMatrix)m_aValues.elementAt(j)).assignment((CqMatrix)(From.m_aValues.get(j)));
            }
        	
        }else if(t instanceof p_float){
            for ( int j = 0; j <  size; j++ )
            {
                //m_aValues.setElementAt(From.m_aValues.get( j ), j );ύX 2005/09/07
                ((p_float)m_aValues.elementAt(j)).value = ((p_float)(From.m_aValues.get(j))).value;
            }
        	
        }else if(t instanceof p_int){
            for ( int j = 0; j <  size; j++ )
            {
                //m_aValues.setElementAt(From.m_aValues.get( j ), j );ύX 2005/09/07
                ((p_int)m_aValues.elementAt(j)).value = ((p_int)(From.m_aValues.get(j))).value;
            }
        	
        }else if(t instanceof p_String){
            for ( int j = 0; j <  size; j++ )
            {
                ((p_String)m_aValues.elementAt(j)).value = ((p_String)(From.m_aValues.get(j))).value;
            }
        	
        }
        
        return this;

	}
	/**
	 * EqVariableClassԂ
	 *
	 * @param EqVariableClass
	 */
	public EqVariableClass Class() {
		return new EqVariableClass(class_varying);
	}
	/** 
	 * Vector̒gSăNA
	 */
	public void Clear() {
		m_aValues.clear();
	}
	/**
	 * gƓlCX^X𕡐B
	 */
	public CqParameter Clone() {

		return new CqParameterTypedVarying<T,SLT>( this ,I);
	}
	/**
	 * Type̓N[Ԃ
	 * 
	 * @param Name p^
	 * @param Count JEg
	 * @return VCqParameter
	 */
	public CqParameter CloneType(final String Name, int Count) {
		
		return new CqParameterTypedVarying<T, SLT>( Name, Count ,I,TClass,SLTClass);
	}

	/**
	 * uvApReusltzɒl
	 * u*v̒lpResData.size()KȂ΂ȂȂB
	 * łȂꍇ͖{Ƃ̓[NNA\̉\B
	 * 
	 */
	public void Dice(int u, int v, IqShaderData pResult, IqSurface pSurface){
		   T res = null;
		try {
			res = (T)TClass.newInstance();
		} catch (InstantiationException e) {
			HimawariLogger.outputException( e );
			return;
		} catch (IllegalAccessException e) {
			HimawariLogger.outputException( e );
			return;
		}

//		    SLT pResData = null;
//--ύX 
		//nttdata 
//		    STLVector<SLT> pResData = new STLVector<SLT>(SLTClass);
//		    pResult.GetValuePtr( pResData );
		   
			//STLVector<SLT> pResData = new STLVector<SLT>(SLTClass,1);
			STLArray<SLT> pResData = new STLArray<SLT>(SLTClass,1);
		    pResData = pResult.GetValuePtr_2( pResData.elementAt(0) );
		    assert( null != pResData );

// --܂
		    //
		    if(TClass.equals(CqMatrix.class) && SLTClass.equals(CqMatrix.class)){
		    	//-----------------CqMatrix̏ꍇ-----------------------
		    	// Check if a valid 4 point quad, do nothing if not.
		    	if ( m_aValues.size() >= 4 )
		    	{
		    		// Note it is assumed that the variable has been
		    		// initialised to the correct size prior to calling.
		    		Float diu = 1.0f / u;
		    		Float div = 1.0f / v;
		    		int iv;
		    		int index = 0;
		    		for ( iv = 0; iv <= v; iv++ )
		    		{
		    			int iu;
		    			for ( iu = 0; iu <= u; iu++ )
		    			{
		    			
		    				//nttdata 
//		    				((CqMatrix)res).assignment((CqMatrix)RiGlobal.BilinearEvaluate( (T)(pValue( 0 ) [ 0 ]),
//		    						(T)(pValue( 1 ) [ 0 ]),
//		    						(T)(pValue( 2 ) [ 0 ]),
//		    						(T)(pValue( 3 ) [ 0 ]),
//		    						iu * diu, iv * div,TClass ));

		    				((CqMatrix)res).assignment((CqMatrix)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , 0 )),
		    						(T)(pValue_get( 1 , 0 )),
		    						(T)(pValue_get( 2 , 0 )),
		    						(T)(pValue_get( 3 , 0 )),
		    						iu * diu, iv * div,TClass ));
		    				((CqMatrix)pResData.elementAt(index)).assignment((CqMatrix)res);
		    				index++;
		    				//( pResData++ ) = res;
		    			}
		    		}
		    	}
		    	else
		    	{
		    		int iv;
		    		int index = 0;
    				//nttdata 
//		    		((CqMatrix)res).assignment((CqMatrix)(pValue( 0 ) [ 0 ]));
		    		((CqMatrix)res).assignment((CqMatrix)(pValue_get( 0 , 0 )));
		    		for ( iv = 0; iv <= v; iv++ )
		    		{
		    			int iu;
		    			for ( iu = 0; iu <= u; iu++ ){
		    				((CqMatrix)pResData.elementAt(index)).assignment((CqMatrix)res);
		    				index++;
		    				//( pResData++ ) = res;
		    			}
		    		}
		    	}
		    }else if(TClass.equals(CqColor.class) && SLTClass.equals(CqColor.class)){
		    	//-----------------CqColoȑꍇ-----------------------
		    	// Check if a valid 4 point quad, do nothing if not.
		    	if ( m_aValues.size() >= 4 )
		    	{
		    		// Note it is assumed that the variable has been
		    		// initialised to the correct size prior to calling.
		    		Float diu = 1.0f / u;
		    		Float div = 1.0f / v;
		    		int iv;
		    		int index = 0;
		    		for ( iv = 0; iv <= v; iv++ )
		    		{
		    			int iu;
		    			for ( iu = 0; iu <= u; iu++ )
		    			{
//		    				nttdata 
//		    				((CqColor)res).assignment((CqColor)RiGlobal.BilinearEvaluate( (T)(pValue( 0 ) [ 0 ]),
//		    						(T)(pValue( 1 ) [ 0 ]),
//		    						(T)(pValue( 2 ) [ 0 ]),
//		    						(T)(pValue( 3 ) [ 0 ]),
//		    						iu * diu, iv * div,TClass ));
		    				
		    				((CqColor)res).assignment((CqColor)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , 0 )),
		    						(T)(pValue_get( 1 , 0 )),
		    						(T)(pValue_get( 2 , 0 )),
		    						(T)(pValue_get( 3 , 0 )),
		    						iu * diu, iv * div,TClass ));
		    				
		    				((CqColor)pResData.elementAt(index)).assignment((CqColor)res);
		    				index++;
		    				//( pResData++ ) = res;
		    			}
		    		}
		    	}
		    	else
		    	{
		    		//pResdatãTCYl`FbNĂȂExceptionԉ\
		    		int iv;
		    		int index = 0;
//		    		nttdata 
//		    		((CqColor)res).assignment((CqColor)(pValue( 0 ) [ 0 ]));
		    		((CqColor)res).assignment((CqColor)(pValue_get( 0 , 0 )));
		    		for ( iv = 0; iv <= v; iv++ )
		    		{
		    			int iu;
		    			for ( iu = 0; iu <= u; iu++ ){
		    				((CqColor)pResData.elementAt(index)).assignment((CqColor)res);
		    				index++;
		    				//( pResData++ ) = res;
		    			}
		    		}
		    	}
		    }else if(TClass.equals(CqVector3D.class) && SLTClass.equals(CqVector3D.class)){
		    	//-----------------CqVector3D̏ꍇ-----------------------
		    	// Check if a valid 4 point quad, do nothing if not.
		    	if ( m_aValues.size() >= 4 )
		    	{
		    		// Note it is assumed that the variable has been
		    		// initialised to the correct size prior to calling.
		    		Float diu = 1.0f / u;
		    		Float div = 1.0f / v;
		    		int iv;
		    		int index = 0;
		    		for ( iv = 0; iv <= v; iv++ )
		    		{
		    			int iu;
		    			for ( iu = 0; iu <= u; iu++ )
		    			{
		    				//nttdata 
//		    				((CqVector3D)res).assignment((CqVector3D)RiGlobal.BilinearEvaluate( (T)(pValue( 0 ) [ 0 ]),
//		    						(T)(pValue( 1 ) [ 0 ]),
//		    						(T)(pValue( 2 ) [ 0 ]),
//		    						(T)(pValue( 3 ) [ 0 ]),
//		    						iu * diu, iv * div,TClass ));
		    				
		    				((CqVector3D)res).assignment((CqVector3D)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , 0 )),
		    						(T)(pValue_get( 1 , 0 )),
		    						(T)(pValue_get( 2 , 0 )),
		    						(T)(pValue_get( 3 , 0 )),
		    						iu * diu, iv * div,TClass ));
		    				
		    				((CqVector3D)pResData.elementAt(index)).assignment((CqVector3D)res);
		    				index++;
		    				//( pResData++ ) = res;
		    			}
		    		}
		    	}
		    	else
		    	{
		    		//pResdatãTCYl`FbNĂȂExceptionԉ\
		    		int iv;
		    		int index = 0;
//		    		nttdata 
//		    		((CqVector3D)res).assignment((CqVector3D)(pValue( 0 ) [ 0 ]));
		    		((CqVector3D)res).assignment((CqVector3D)(pValue_get( 0 , 0 )));
		    		for ( iv = 0; iv <= v; iv++ )
		    		{
		    			int iu;
		    			for ( iu = 0; iu <= u; iu++ ){
		    				((CqVector3D)pResData.elementAt(index)).assignment((CqVector3D)res);
		    				index++;
		    				//( pResData++ ) = res;
		    			}
		    		}
		    	}
		    }else if(TClass.equals(p_float.class) && SLTClass.equals(p_float.class)){
		    	//-----------------p_float̏ꍇ-----------------------
		    	// Check if a valid 4 point quad, do nothing if not.
		    	if ( m_aValues.size() >= 4 )
		    	{
		    		// Note it is assumed that the variable has been
		    		// initialised to the correct size prior to calling.
		    		Float diu = 1.0f / u;
		    		Float div = 1.0f / v;
		    		int iv;
		    		int index = 0;
		    		for ( iv = 0; iv <= v; iv++ )
		    		{
		    			int iu;
		    			for ( iu = 0; iu <= u; iu++ )
		    			{
		    				//nttdata 
//		    				((p_float)res).value = ((p_float)RiGlobal.BilinearEvaluate( (T)(pValue( 0 ) [ 0 ]),
//		    						(T)(pValue( 1 ) [ 0 ]),
//		    						(T)(pValue( 2 ) [ 0 ]),
//		    						(T)(pValue( 3 ) [ 0 ]),
//		    						iu * diu, iv * div,TClass )).value;
		    				((p_float)res).value = ((p_float)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , 0 )),
		    						(T)(pValue_get( 1 , 0 )),
		    						(T)(pValue_get( 2 , 0 )),
		    						(T)(pValue_get( 3 , 0 )),
		    						iu * diu, iv * div,TClass )).value;
		    				
	    					((p_float)pResData.elementAt(index)).value = ((p_float)res).value;
		    				index++;
		    				//( pResData++ ) = res;
		    			}
		    		}
		    	}
		    	else
		    	{
		    		//pResdatãTCYl`FbNĂȂExceptionԉ\
		    		int iv;
		    		int index = 0;
//		    		nttdata 
//		    		((p_float)res).value = ((p_float)(pValue( 0 ) [ 0 ])).value;
		    		((p_float)res).value = ((p_float)(pValue_get( 0 , 0 ))).value;
		    		for ( iv = 0; iv <= v; iv++ )
		    		{
		    			int iu;
		    			for ( iu = 0; iu <= u; iu++ ){
		    				((p_float)pResData.elementAt(index)).value = ((p_float)res).value;
		    				index++;
		    				//( pResData++ ) = res;
		    			}
		    		}
		    	}
		    }else if(TClass.equals(p_int.class) && SLTClass.equals(p_float.class)){
		    	//-----------------p_int̏ꍇ-----------------------
		    	// Check if a valid 4 point quad, do nothing if not.
		    	if ( m_aValues.size() >= 4 )
		    	{
		    		// Note it is assumed that the variable has been
		    		// initialised to the correct size prior to calling.
		    		Float diu = 1.0f / u;
		    		Float div = 1.0f / v;
		    		int iv;
		    		int index = 0;
		    		for ( iv = 0; iv <= v; iv++ )
		    		{
		    			int iu;
		    			for ( iu = 0; iu <= u; iu++ )
		    			{
		    				//nttdata 
//		    				((p_int)res).value = ((p_int)RiGlobal.BilinearEvaluate( (T)(pValue( 0 ) [ 0 ]),
//		    						(T)(pValue( 1 ) [ 0 ]),
//		    						(T)(pValue( 2 ) [ 0 ]),
//		    						(T)(pValue( 3 ) [ 0 ]),
//		    						iu * diu, iv * div,TClass )).value;
		    				
		    				((p_int)res).value = ((p_int)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 ,0 )),
		    						(T)(pValue_get( 1 , 0 )),
		    						(T)(pValue_get( 2 , 0 )),
		    						(T)(pValue_get( 3 , 0 )),
		    						iu * diu, iv * div,TClass )).value;
		    				
	    					((p_float)pResData.elementAt(index)).value = ((p_int)res).value;
		    				index++;
		    				//( pResData++ ) = res;
		    			}
		    		}
		    	}
		    	else
		    	{
		    		//pResdatãTCYl`FbNĂȂExceptionԉ\
		    		int iv;
		    		int index = 0;
//		    		nttdata 
//		    		((p_int)res).value = ((p_int)(pValue( 0 ) [ 0 ])).value;
		    		((p_int)res).value = ((p_int)(pValue_get( 0 , 0 ))).value;
		    		for ( iv = 0; iv <= v; iv++ )
		    		{
		    			int iu;
		    			for ( iu = 0; iu <= u; iu++ ){
		    				((p_float)pResData.elementAt(index)).value = ((p_int)res).value;
		    				index++;
		    				//( pResData++ ) = res;
		    			}
		    		}
		    	}
		    }else if(TClass.equals(CqVector4D.class) && SLTClass.equals(CqVector3D.class)){
		    	//-----------------CqVector4D̏ꍇ-----------------------
		    	// Check if a valid 4 point quad, do nothing if not.
		    	if ( m_aValues.size() >= 4 )
		    	{
		    		// Note it is assumed that the variable has been
		    		// initialised to the correct size prior to calling.
		    		Float diu = 1.0f / u;
		    		Float div = 1.0f / v;
		    		int iv;
		    		int index = 0;
		    		for ( iv = 0; iv <= v; iv++ )
		    		{
		    			int iu;
		    			for ( iu = 0; iu <= u; iu++ )
		    			{
		    				
		    				//nttdata 
//		    				((CqVector4D)res).assignment((CqVector4D)RiGlobal.BilinearEvaluate( (T)(pValue( 0 ) [ 0 ]),
//		    						(T)(pValue( 1 ) [ 0 ]),
//		    						(T)(pValue( 2 ) [ 0 ]),
//		    						(T)(pValue( 3 ) [ 0 ]),
//		    						iu * diu, iv * div,TClass ));
		    				((CqVector4D)res).assignment((CqVector4D)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , 0 )),
		    						(T)(pValue_get( 1 , 0 )),
		    						(T)(pValue_get( 2 , 0 )),
		    						(T)(pValue_get( 3 , 0 )),
		    						iu * diu, iv * div,TClass ));
		    				
		    				((CqVector3D)pResData.elementAt(index)).assignment((CqVector4D)res);
		    				index++;
		    				//( pResData++ ) = res;
		    			}
		    		}
		    	}
		    	else
		    	{
		    		//pResdatãTCYl`FbNĂȂExceptionԉ\
		    		int iv;
		    		int index = 0;
//		    		nttdata 
//		    		((CqVector4D)res).assignment((CqVector4D)(pValue( 0 ) [ 0 ]));
		    		((CqVector4D)res).assignment((CqVector4D)(pValue_get( 0 , 0 )));
		    		for ( iv = 0; iv <= v; iv++ )
		    		{
		    			int iu;
		    			for ( iu = 0; iu <= u; iu++ ){
		    				((CqVector3D)pResData.elementAt(index)).assignment((CqVector4D)res);
		    				index++;
		    				//( pResData++ ) = res;
		    			}
		    		}
		    	}
		    }else if(TClass.equals(p_String.class) && SLTClass.equals(p_String.class)){
		    	//-----------------p_String̏ꍇ-----------------------
		    	// Check if a valid 4 point quad, do nothing if not.
		    	if ( m_aValues.size() >= 4 )
		    	{
		    		// Note it is assumed that the variable has been
		    		// initialised to the correct size prior to calling.
		    		Float diu = 1.0f / u;
		    		Float div = 1.0f / v;
		    		int iv;
		    		int index = 0;
		    		for ( iv = 0; iv <= v; iv++ )
		    		{
		    			int iu;
		    			for ( iu = 0; iu <= u; iu++ )
		    			{
		    				
		    				//nttdata 
//		    				((p_String)res).value = ((p_String)RiGlobal.BilinearEvaluate( (T)(pValue( 0 ) [ 0 ]),
//		    						(T)(pValue( 1 ) [ 0 ]),
//		    						(T)(pValue( 2 ) [ 0 ]),
//		    						(T)(pValue( 3 ) [ 0 ]),
//		    						iu * diu, iv * div,TClass )).value;
		    				
		    				((p_String)res).value = ((p_String)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , 0 )),
		    						(T)(pValue_get( 1 , 0 )),
		    						(T)(pValue_get( 2 , 0 )),
		    						(T)(pValue_get( 3 , 0 )),
		    						iu * diu, iv * div,TClass )).value;
		    				
	    					((p_String)pResData.elementAt(index)).value = ((p_String)res).value;
		    				index++;
		    				//( pResData++ ) = res;
		    			}
		    		}
		    	}
		    	else
		    	{
		    		//pResdatãTCYl`FbNĂȂExceptionԉ\
		    		int iv;
		    		int index = 0;
//		    		nttdata 
//		    		((p_String)res).value = ((p_String)(pValue( 0 ) [ 0 ])).value;
		    		((p_String)res).value = ((p_String)(pValue_get( 0 , 0 ))).value;
		    		for ( iv = 0; iv <= v; iv++ )
		    		{
		    			int iu;
		    			for ( iu = 0; iu <= u; iu++ ){
		    				((p_String)pResData.elementAt(index)).value = ((p_String)res).value;
		    				index++;
		    				//( pResData++ ) = res;
		    			}
		    		}
		    	}
		    }
	}

	/**
	 * ɃG[Ԃ
	 */
	public void DiceOne(int u, int v, IqShaderData pResult, IqSurface pSurface, int ArrayIndex) {
		assert( false );
	}
	/**
	 * ̎Vector̒lzƂđSĕԂB
	 * 
	 */
	public Object[] pValue() {
		return m_aValues.toArray();
	}
	/**
	 * ̎Vectorɑ΂āAw肳ꂽʒuȍ~̒l
	 * zƂĕԋpB
	 * 
	 * ԋplZbgȂƂVector̎lωB
	 * 
	 * @param Index Vector̒l̊Jnʒu
	 * @exception Vector̃TCY傫lw肷NegativeArraySizeException
	 */
	//nttdata 
//	public Object[] pValue(final int Index) {
//		assert( Index < m_aValues.size()  );
//		Object[] retval = new Object[m_aValues.size()-Index];
//		
//		//retvalɌ݂Vector̒gRs[Ă
//		for(int i=0;i< m_aValues.size() -Index;i++){
//			retval[i] = m_aValues.elementAt(Index + i);
//		}
//		
//		return retval;
//	}
	public Object[] pValue(final int Index) {
		assert( Index < m_aValues.size()  );
			//@STLVecterɂύXĂB
		return m_aValues.toArray(Index);
		}

	public T pValue_get(final int Index ,final int arrayIndex)
	{
		return m_aValues.elementAt(Index+arrayIndex);
	}
//	nttdata  I
	/**
	 * Vector̃TCYw̑傫ɕύX
	 * @param size ύXTCY
	 */
	public void SetSize(int size) {
		m_aValues.setSize( size );
		
	}
	/**
	 * ̎Vector̃TCYԋp	
	 * @return ݂Vector̃TCY
	 */
	public int Size() {
		 return ( m_aValues.size() );
	}

	/**
	 * Ŏw肳ꂽCX^X̍WSubdivide邱Ƃ
	 * ύXB
	 * 3ɂĕ̎dύXłB
	 * 
	 * @param pResult1	SubdividȇΏۂP
	 * @param pResult2	SubdividȇΏۂQ
	 * @param u		ǂ̂悤Subdivide邩̃tO
	 * @param pSurface	Surface
	 */
//	public void Subdivide(CqParameter pResult1, CqParameter pResult2, boolean u, IqSurface pSurface) {
//	       assert( pResult1.Type().getValue() == Type().getValue() && pResult2.Type().getValue() == Type().getValue() &&
//	                pResult1.Class().getValue() == Class().getValue() && pResult2.Class().getValue() == Class().getValue() );
//
//	        CqParameterTypedVarying<T, SLT> pTResult1 = (CqParameterTypedVarying<T, SLT>)( pResult1 );
//	        CqParameterTypedVarying<T, SLT> pTResult2 = (CqParameterTypedVarying<T, SLT>)( pResult2 );
//	        pTResult1.SetSize( 4 );
//	        pTResult2.SetSize( 4 );
//	        // Check if a valid 4 point quad, do nothing if not.
//	        if ( m_aValues.size() == 4 ){
//	            if ( u ){
////	                pTResult2.pValue( 1 ) [ 0 ] = pValue( 1 ) [ 0 ];
////	                pTResult2.pValue( 3 ) [ 0 ] = pValue( 3 ) [ 0 ];
//	                T t = (T)pTResult1.pValue(1)[0];
//	                //^ɂ锻ʂs
//	                //^7
//	                //-------
//	                if(t instanceof p_float){
//		                ((p_float)pTResult2.pValue( 1 ) [ 0 ]).value = ((p_float)pValue( 1 ) [ 0 ]).value;
//		                ((p_float)pTResult2.pValue( 3 ) [ 0 ]).value = ((p_float)pValue( 3 ) [ 0 ]).value;
//
//	                	((p_float)pTResult1.pValue( 1 ) [ 0 ]).value = ((p_float)pTResult2.pValue( 0 ) [ 0 ]).value = (( (p_float)(pValue( 0 ) [ 0 ])).value + ((p_float)(pValue( 1 ) [ 0 ])).value ) * 0.5f;
//	                	((p_float)pTResult1.pValue( 3 ) [ 0 ]).value = ((p_float)pTResult2.pValue( 2 ) [ 0 ]).value = (( (p_float)(pValue( 2 ) [ 0 ])).value + ((p_float)(pValue( 3 ) [ 0 ])).value ) * 0.5f;
//	                }else if(t instanceof p_int){
//		                ((p_int)pTResult2.pValue( 1 ) [ 0 ]).value = ((p_int)pValue( 1 ) [ 0 ]).value;
//		                ((p_int)pTResult2.pValue( 3 ) [ 0 ]).value = ((p_int)pValue( 3 ) [ 0 ]).value;
//	                	((p_int)pTResult1.pValue( 1 ) [ 0 ]).value = ((p_int)pTResult2.pValue( 0 ) [ 0 ]).value = (int)((( (p_int)(pValue( 0 ) [ 0 ])).value + ((p_int)(pValue( 1 ) [ 0 ])).value ) * 0.5f);
//	                	((p_int)pTResult1.pValue( 3 ) [ 0 ]).value = ((p_int)pTResult2.pValue( 2 ) [ 0 ]).value = (int)((( (p_int)(pValue( 2 ) [ 0 ])).value + ((p_int)(pValue( 3 ) [ 0 ])).value ) * 0.5f);
//	                }else if(t instanceof CqMatrix){
//		                ((CqMatrix)pTResult2.pValue( 1 ) [ 0 ]).assignment((CqMatrix)pValue( 1 ) [ 0 ]);
//		                ((CqMatrix)pTResult2.pValue( 3 ) [ 0 ]).assignment((CqMatrix)pValue( 3 ) [ 0 ]);
//	                	((CqMatrix)pTResult1.pValue( 1 ) [ 0 ]).assignment(((CqMatrix)pTResult2.pValue( 0 ) [ 0 ]).assignment((((CqMatrix)(pValue( 0 ) [ 0 ])).add(((CqMatrix)(pValue( 1 ) [ 0 ])) )).multiply(0.5f)));
//	                	((CqMatrix)pTResult1.pValue( 3 ) [ 0 ]).assignment(((CqMatrix)pTResult2.pValue( 2 ) [ 0 ]).assignment((((CqMatrix)(pValue( 2 ) [ 0 ])).add(((CqMatrix)(pValue( 3 ) [ 0 ])) )).multiply(0.5f)));	                		                	
//	                }else if(t instanceof CqColor){
//		                ((CqColor)pTResult2.pValue( 1 ) [ 0 ]).assignment((CqColor)pValue( 1 ) [ 0 ]);
//		                ((CqColor)pTResult2.pValue( 3 ) [ 0 ]).assignment((CqColor)pValue( 3 ) [ 0 ]);
//	                	((CqColor)pTResult1.pValue( 1 ) [ 0 ]).assignment((((CqColor)pTResult2.pValue( 0 ) [ 0 ]).assignment(((((CqColor)(pValue( 0 ) [ 0 ])).add((CqColor)(pValue( 1 ) [ 0 ]))).mul(0.5f)))));
//	                	((CqColor)pTResult1.pValue( 3 ) [ 0 ]).assignment((((CqColor)pTResult2.pValue( 2 ) [ 0 ]).assignment(((((CqColor)(pValue( 2 ) [ 0 ])).add((CqColor)(pValue( 3 ) [ 0 ]))).mul(0.5f)))));	                		                	
//	                }else if(t instanceof CqVector4D){
//		                ((CqVector4D)pTResult2.pValue( 1 ) [ 0 ]).assignment((CqVector4D)pValue( 1 ) [ 0 ]);
//		                ((CqVector4D)pTResult2.pValue( 3 ) [ 0 ]).assignment((CqVector4D)pValue( 3 ) [ 0 ]);
//
//	                	((CqVector4D)pTResult1.pValue( 1 ) [ 0 ]).assignment(((CqVector4D)pTResult2.pValue( 0 ) [ 0 ]).assignment((((CqVector4D)(pValue( 0 ) [ 0 ])).add(((CqVector4D)(pValue( 1 ) [ 0 ])) )).mul(0.5f)));
//	                	((CqVector4D)pTResult1.pValue( 3 ) [ 0 ]).assignment(((CqVector4D)pTResult2.pValue( 2 ) [ 0 ]).assignment((((CqVector4D)(pValue( 2 ) [ 0 ])).add(((CqVector4D)(pValue( 3 ) [ 0 ])) )).mul(0.5f)));	                		                	
//	                }else if(t instanceof CqVector3D){
//		                ((CqVector3D)pTResult2.pValue( 1 ) [ 0 ]).assignment((CqVector3D)pValue( 1 ) [ 0 ]);
//		                ((CqVector3D)pTResult2.pValue( 3 ) [ 0 ]).assignment((CqVector3D)pValue( 3 ) [ 0 ]);
//
//	                	((CqVector3D)pTResult1.pValue( 1 ) [ 0 ]).assignment(((CqVector3D)pTResult2.pValue( 0 ) [ 0 ]).assignment((((CqVector3D)(pValue( 0 ) [ 0 ])).add(((CqVector3D)(pValue( 1 ) [ 0 ])) )).mul(0.5f)));
//	                	((CqVector3D)pTResult1.pValue( 3 ) [ 0 ]).assignment(((CqVector3D)pTResult2.pValue( 2 ) [ 0 ]).assignment((((CqVector3D)(pValue( 2 ) [ 0 ])).add(((CqVector3D)(pValue( 3 ) [ 0 ])) )).mul(0.5f)));	                		                	
//	                }else if(t instanceof p_String){
//		                ((p_String)pTResult2.pValue( 1 ) [ 0 ]).value = ((p_String)pValue( 1 ) [ 0 ]).value;
//		                ((p_String)pTResult2.pValue( 3 ) [ 0 ]).value = ((p_String)pValue( 3 ) [ 0 ]).value;
//	                	((p_String)pTResult1.pValue( 1 ) [ 0 ]).value = ((p_String)pTResult2.pValue( 0 ) [ 0 ]).value = ((( (p_String)(pValue( 0 ) [ 0 ])).value + ((p_String)(pValue( 1 ) [ 0 ])).value ));
//	                	((p_String)pTResult1.pValue( 3 ) [ 0 ]).value = ((p_String)pTResult2.pValue( 2 ) [ 0 ]).value = ((( (p_String)(pValue( 2 ) [ 0 ])).value + ((p_String)(pValue( 3 ) [ 0 ])).value ));
//	                }
//	                //else if(t instanceof String){
//	                	//ZqȂߍ폜
//	                //}
//	                //--ꍇI
//	            }
//	            else{
////	                pTResult2.pValue( 2 ) [ 0 ] = pValue( 2 ) [ 0 ];
////	                pTResult2.pValue( 3 ) [ 0 ] = pValue( 3 ) [ 0 ];
//	                T t = (T)pTResult1.pValue(1)[0];
//	                //^ɂ锻ʂs
//	                //^7
//	                //-------
//	                if(t instanceof p_float){
//		                ((p_float)pTResult2.pValue( 2 ) [ 0 ]).value = ((p_float)pValue( 2 ) [ 0 ]).value;
//		                ((p_float)pTResult2.pValue( 3 ) [ 0 ]).value = ((p_float)pValue( 3 ) [ 0 ]).value;
//	                	((p_float)pTResult1.pValue( 2 ) [ 0 ]).value = ((p_float)pTResult2.pValue( 0 ) [ 0 ]).value = (( (p_float)(pValue( 0 ) [ 0 ])).value + ((p_float)(pValue( 2 ) [ 0 ])).value ) * 0.5f;
//	                	((p_float)pTResult1.pValue( 3 ) [ 0 ]).value = ((p_float)pTResult2.pValue( 1 ) [ 0 ]).value = (( (p_float)(pValue( 1 ) [ 0 ])).value + ((p_float)(pValue( 3 ) [ 0 ])).value ) * 0.5f;
//	                }else if(t instanceof p_int){
//		                ((p_int)pTResult2.pValue( 2 ) [ 0 ]).value = ((p_int)pValue( 2 ) [ 0 ]).value;
//		                ((p_int)pTResult2.pValue( 3 ) [ 0 ]).value = ((p_int)pValue( 3 ) [ 0 ]).value;
//	                	((p_int)pTResult1.pValue( 2 ) [ 0 ]).value = ((p_int)pTResult2.pValue( 0 ) [ 0 ]).value = (int)((( (p_int)(pValue( 0 ) [ 0 ])).value + ((p_int)(pValue( 2 ) [ 0 ])).value ) * 0.5f);
//	                	((p_int)pTResult1.pValue( 3 ) [ 0 ]).value = ((p_int)pTResult2.pValue( 1 ) [ 0 ]).value = (int)((( (p_int)(pValue( 1 ) [ 0 ])).value + ((p_int)(pValue( 3 ) [ 0 ])).value ) * 0.5f);
//	                }else if(t instanceof CqMatrix){
//		                ((CqMatrix)pTResult2.pValue( 2 ) [ 0 ]).assignment((CqMatrix)pValue( 2 ) [ 0 ]);
//		                ((CqMatrix)pTResult2.pValue( 3 ) [ 0 ]).assignment((CqMatrix)pValue( 3 ) [ 0 ]);
//	                	((CqMatrix)pTResult1.pValue( 2 ) [ 0 ]).assignment(((CqMatrix)pTResult2.pValue( 0 ) [ 0 ]).assignment((((CqMatrix)(pValue( 0 ) [ 0 ])).add(((CqMatrix)(pValue( 2 ) [ 0 ])) )).multiply(0.5f)));
//	                	((CqMatrix)pTResult1.pValue( 3 ) [ 0 ]).assignment(((CqMatrix)pTResult2.pValue( 1 ) [ 0 ]).assignment((((CqMatrix)(pValue( 1 ) [ 0 ])).add(((CqMatrix)(pValue( 3 ) [ 0 ])) )).multiply(0.5f)));	                		                	
//	                }else if(t instanceof CqColor){
//		                ((CqColor)pTResult2.pValue( 2 ) [ 0 ]).assignment(((CqColor)pValue( 2 ) [ 0 ]));
//		                ((CqColor)pTResult2.pValue( 3 ) [ 0 ]).assignment(((CqColor)pValue( 3 ) [ 0 ]));
////	                	((CqColor)pTResult1.pValue( 2 ) [ 0 ]).assignment(new CqVector3D(((CqColor)pTResult2.pValue( 0 ) [ 0 ]).assignment(new CqVector3D(( ((CqColor)(pValue( 0 ) [ 0 ])).add((CqColor)(pValue( 2 ) [ 0 ]) ).mul(0.5f))))));
////	                	((CqColor)pTResult1.pValue( 3 ) [ 0 ]).assignment(new CqVector3D(((CqColor)pTResult2.pValue( 1 ) [ 0 ]).assignment(new CqVector3D(( ((CqColor)(pValue( 1 ) [ 0 ])).add((CqColor)(pValue( 3 ) [ 0 ]) ).mul(0.5f))))));
//	                	((CqColor)pTResult1.pValue( 2 ) [ 0 ]).assignment((((CqColor)pTResult2.pValue( 0 ) [ 0 ]).assignment(((((CqColor)(pValue( 0 ) [ 0 ])).add((CqColor)(pValue( 2 ) [ 0 ]))).mul(0.5f)))));
//	                	((CqColor)pTResult1.pValue( 3 ) [ 0 ]).assignment((((CqColor)pTResult2.pValue( 1 ) [ 0 ]).assignment(((((CqColor)(pValue( 1 ) [ 0 ])).add((CqColor)(pValue( 3 ) [ 0 ]))).mul(0.5f)))));	                		                	
//	                }else if(t instanceof CqVector4D){
//		                ((CqVector4D)pTResult2.pValue( 2 ) [ 0 ]).assignment((CqVector4D)pValue( 2 ) [ 0 ]);
//		                ((CqVector4D)pTResult2.pValue( 3 ) [ 0 ]).assignment((CqVector4D)pValue( 3 ) [ 0 ]);
//	                	((CqVector4D)pTResult1.pValue( 2 ) [ 0 ]).assignment(((CqVector4D)pTResult2.pValue( 0 ) [ 0 ]).assignment((((CqVector4D)(pValue( 0 ) [ 0 ])).add(((CqVector4D)(pValue( 2 ) [ 0 ])) )).mul(0.5f)));
//	                	((CqVector4D)pTResult1.pValue( 3 ) [ 0 ]).assignment(((CqVector4D)pTResult2.pValue( 1 ) [ 0 ]).assignment((((CqVector4D)(pValue( 1 ) [ 0 ])).add(((CqVector4D)(pValue( 3 ) [ 0 ])) )).mul(0.5f)));	                		                	
//	                }else if(t instanceof CqVector3D){
//		                ((CqVector3D)pTResult2.pValue( 2 ) [ 0 ]).assignment((CqVector3D)pValue( 2 ) [ 0 ]);
//		                ((CqVector3D)pTResult2.pValue( 3 ) [ 0 ]).assignment((CqVector3D)pValue( 3 ) [ 0 ]);
//	                	((CqVector3D)pTResult1.pValue( 2 ) [ 0 ]).assignment(((CqVector3D)pTResult2.pValue( 0 ) [ 0 ]).assignment((((CqVector3D)(pValue( 0 ) [ 0 ])).add(((CqVector3D)(pValue( 2 ) [ 0 ])) )).mul(0.5f)));
//	                	((CqVector3D)pTResult1.pValue( 3 ) [ 0 ]).assignment(((CqVector3D)pTResult2.pValue( 1 ) [ 0 ]).assignment((((CqVector3D)(pValue( 1 ) [ 0 ])).add(((CqVector3D)(pValue( 3 ) [ 0 ])) )).mul(0.5f)));	                		                	
//	                }else if(t instanceof p_String){
//		                ((p_String)pTResult2.pValue( 2 ) [ 0 ]).value = ((p_String)pValue( 2 ) [ 0 ]).value;
//		                ((p_String)pTResult2.pValue( 3 ) [ 0 ]).value = ((p_String)pValue( 3 ) [ 0 ]).value;
//	                	((p_String)pTResult1.pValue( 2 ) [ 0 ]).value = ((p_String)pTResult2.pValue( 0 ) [ 0 ]).value = ((( (p_String)(pValue( 0 ) [ 0 ])).value + ((p_String)(pValue( 2 ) [ 0 ])).value ));
//	                	((p_String)pTResult1.pValue( 3 ) [ 0 ]).value = ((p_String)pTResult2.pValue( 1 ) [ 0 ]).value = ((( (p_String)(pValue( 1 ) [ 0 ])).value + ((p_String)(pValue( 3 ) [ 0 ])).value ));
//	                }
//	                //else if(t instanceof String){
//	                	//ZqȂߍ폜
//	                //}
//	                //--ꍇI
//	            }
//	        }
//		
//	}
	public void Subdivide(CqParameter pResult1, CqParameter pResult2, boolean u, IqSurface pSurface) {
	       assert( pResult1.Type().getValue() == Type().getValue() && pResult2.Type().getValue() == Type().getValue() &&
	                pResult1.Class().getValue() == Class().getValue() && pResult2.Class().getValue() == Class().getValue() );

	        CqParameterTypedVarying<T, SLT> pTResult1 = (CqParameterTypedVarying<T, SLT>)( pResult1 );
	        CqParameterTypedVarying<T, SLT> pTResult2 = (CqParameterTypedVarying<T, SLT>)( pResult2 );
	        pTResult1.SetSize( 4 );
	        pTResult2.SetSize( 4 );
	        // Check if a valid 4 point quad, do nothing if not.
	        if ( m_aValues.size() == 4 ){
	            if ( u ){
//	                pTResult2.pValue_get( 1 , 0 ] = pValue_get( 1 , 0 ];
//	                pTResult2.pValue_get( 3 , 0 ] = pValue_get( 3 , 0 ];
	                T t = (T)pTResult1.pValue_get(1,0);
	                //^ɂ锻ʂs
	                //^7
	                //-------
	                if(t instanceof p_float){
		                ((p_float)pTResult2.pValue_get( 1 , 0 )).value = ((p_float)pValue_get( 1 , 0 )).value;
		                ((p_float)pTResult2.pValue_get( 3 , 0 )).value = ((p_float)pValue_get( 3 , 0 )).value;

	                	((p_float)pTResult1.pValue_get( 1 , 0 )).value = ((p_float)pTResult2.pValue_get( 0 , 0 )).value = (( (p_float)(pValue_get( 0 , 0 ))).value + ((p_float)(pValue_get( 1 , 0 ))).value ) * 0.5f;
	                	((p_float)pTResult1.pValue_get( 3 , 0 )).value = ((p_float)pTResult2.pValue_get( 2 , 0 )).value = (( (p_float)(pValue_get( 2 , 0 ))).value + ((p_float)(pValue_get( 3 , 0 ))).value ) * 0.5f;
	                }else if(t instanceof p_int){
		                ((p_int)pTResult2.pValue_get( 1 , 0 )).value = ((p_int)pValue_get( 1 , 0 )).value;
		                ((p_int)pTResult2.pValue_get( 3 , 0 )).value = ((p_int)pValue_get( 3 , 0 )).value;
	                	((p_int)pTResult1.pValue_get( 1 , 0 )).value = ((p_int)pTResult2.pValue_get( 0 , 0 )).value = (int)((( (p_int)(pValue_get( 0 , 0 ))).value + ((p_int)(pValue_get( 1 , 0 ))).value ) * 0.5f);
	                	((p_int)pTResult1.pValue_get( 3 , 0 )).value = ((p_int)pTResult2.pValue_get( 2 , 0 )).value = (int)((( (p_int)(pValue_get( 2 , 0 ))).value + ((p_int)(pValue_get( 3 , 0 ))).value ) * 0.5f);
	                }else if(t instanceof CqMatrix){
		                ((CqMatrix)pTResult2.pValue_get( 1 , 0 )).assignment((CqMatrix)pValue_get( 1 , 0 ));
		                ((CqMatrix)pTResult2.pValue_get( 3 , 0 )).assignment((CqMatrix)pValue_get( 3 , 0 ));
	                	((CqMatrix)pTResult1.pValue_get( 1 , 0 )).assignment(((CqMatrix)pTResult2.pValue_get( 0 , 0 )).assignment((((CqMatrix)(pValue_get( 0 , 0 ))).add(((CqMatrix)(pValue_get( 1 , 0 ))) )).multiply(0.5f)));
	                	((CqMatrix)pTResult1.pValue_get( 3 , 0 )).assignment(((CqMatrix)pTResult2.pValue_get( 2 , 0 )).assignment((((CqMatrix)(pValue_get( 2 , 0 ))).add(((CqMatrix)(pValue_get( 3 , 0 ))) )).multiply(0.5f)));	                		                	
	                }else if(t instanceof CqColor){
		                ((CqColor)pTResult2.pValue_get( 1 , 0 )).assignment((CqColor)pValue_get( 1 , 0 ));
		                ((CqColor)pTResult2.pValue_get( 3 , 0 )).assignment((CqColor)pValue_get( 3 , 0 ));
	                	((CqColor)pTResult1.pValue_get( 1 , 0 )).assignment((((CqColor)pTResult2.pValue_get( 0 , 0 )).assignment(((((CqColor)(pValue_get( 0 , 0 ))).add((CqColor)(pValue_get( 1 , 0 )))).mul(0.5f)))));
	                	((CqColor)pTResult1.pValue_get( 3 , 0 )).assignment((((CqColor)pTResult2.pValue_get( 2 , 0 )).assignment(((((CqColor)(pValue_get( 2 , 0 ))).add((CqColor)(pValue_get( 3 , 0 )))).mul(0.5f)))));	                		                	
	                }else if(t instanceof CqVector4D){
		                ((CqVector4D)pTResult2.pValue_get( 1 , 0 )).assignment((CqVector4D)pValue_get( 1 , 0 ));
		                ((CqVector4D)pTResult2.pValue_get( 3 , 0 )).assignment((CqVector4D)pValue_get( 3 , 0 ));

	                	((CqVector4D)pTResult1.pValue_get( 1 , 0 )).assignment(((CqVector4D)pTResult2.pValue_get( 0 , 0 )).assignment((((CqVector4D)(pValue_get( 0 , 0 ))).add(((CqVector4D)(pValue_get( 1 , 0 ))) )).mul(0.5f)));
	                	((CqVector4D)pTResult1.pValue_get( 3 , 0 )).assignment(((CqVector4D)pTResult2.pValue_get( 2 , 0 )).assignment((((CqVector4D)(pValue_get( 2 , 0 ))).add(((CqVector4D)(pValue_get( 3 , 0 ))) )).mul(0.5f)));	                		                	
	                }else if(t instanceof CqVector3D){
		                ((CqVector3D)pTResult2.pValue_get( 1 , 0 )).assignment((CqVector3D)pValue_get( 1 , 0 ));
		                ((CqVector3D)pTResult2.pValue_get( 3 , 0 )).assignment((CqVector3D)pValue_get( 3 , 0 ));

	                	((CqVector3D)pTResult1.pValue_get( 1 , 0 )).assignment(((CqVector3D)pTResult2.pValue_get( 0 , 0 )).assignment((((CqVector3D)(pValue_get( 0 , 0 ))).add(((CqVector3D)(pValue_get( 1 , 0 ))) )).mul(0.5f)));
	                	((CqVector3D)pTResult1.pValue_get( 3 , 0 )).assignment(((CqVector3D)pTResult2.pValue_get( 2 , 0 )).assignment((((CqVector3D)(pValue_get( 2 , 0 ))).add(((CqVector3D)(pValue_get( 3 , 0 ))) )).mul(0.5f)));	                		                	
	                }else if(t instanceof p_String){
		                ((p_String)pTResult2.pValue_get( 1 , 0 )).value = ((p_String)pValue_get( 1 , 0 )).value;
		                ((p_String)pTResult2.pValue_get( 3 , 0 )).value = ((p_String)pValue_get( 3 , 0 )).value;
	                	((p_String)pTResult1.pValue_get( 1 , 0 )).value = ((p_String)pTResult2.pValue_get( 0 , 0 )).value = ((( (p_String)(pValue_get( 0 , 0 ))).value + ((p_String)(pValue_get( 1 , 0 ))).value ));
	                	((p_String)pTResult1.pValue_get( 3 , 0 )).value = ((p_String)pTResult2.pValue_get( 2 , 0 )).value = ((( (p_String)(pValue_get( 2 , 0 ))).value + ((p_String)(pValue_get( 3 , 0 ))).value ));
	                }
	                //else if(t instanceof String){
	                	//ZqȂߍ폜
	                //}
	                //--ꍇI
	            }
	            else{
//	                pTResult2.pValue_get( 2 , 0 ] = pValue_get( 2 , 0 ];
//	                pTResult2.pValue_get( 3 , 0 ] = pValue_get( 3 , 0 ];
	                T t = (T)pTResult1.pValue_get(1,0);
	                //^ɂ锻ʂs
	                //^7
	                //-------
	                if(t instanceof p_float){
		                ((p_float)pTResult2.pValue_get( 2 , 0 )).value = ((p_float)pValue_get( 2 , 0 )).value;
		                ((p_float)pTResult2.pValue_get( 3 , 0 )).value = ((p_float)pValue_get( 3 , 0 )).value;
	                	((p_float)pTResult1.pValue_get( 2 , 0 )).value = ((p_float)pTResult2.pValue_get( 0 , 0 )).value = (( (p_float)(pValue_get( 0 , 0 ))).value + ((p_float)(pValue_get( 2 , 0 ))).value ) * 0.5f;
	                	((p_float)pTResult1.pValue_get( 3 , 0 )).value = ((p_float)pTResult2.pValue_get( 1 , 0 )).value = (( (p_float)(pValue_get( 1 , 0 ))).value + ((p_float)(pValue_get( 3 , 0 ))).value ) * 0.5f;
	                }else if(t instanceof p_int){
		                ((p_int)pTResult2.pValue_get( 2 , 0 )).value = ((p_int)pValue_get( 2 , 0 )).value;
		                ((p_int)pTResult2.pValue_get( 3 , 0 )).value = ((p_int)pValue_get( 3 , 0 )).value;
	                	((p_int)pTResult1.pValue_get( 2 , 0 )).value = ((p_int)pTResult2.pValue_get( 0 , 0 )).value = (int)((( (p_int)(pValue_get( 0 , 0 ))).value + ((p_int)(pValue_get( 2 , 0 ))).value ) * 0.5f);
	                	((p_int)pTResult1.pValue_get( 3 , 0 )).value = ((p_int)pTResult2.pValue_get( 1 , 0 )).value = (int)((( (p_int)(pValue_get( 1 , 0 ))).value + ((p_int)(pValue_get( 3 , 0 ))).value ) * 0.5f);
	                }else if(t instanceof CqMatrix){
		                ((CqMatrix)pTResult2.pValue_get( 2 , 0 )).assignment((CqMatrix)pValue_get( 2 , 0 ));
		                ((CqMatrix)pTResult2.pValue_get( 3 , 0 )).assignment((CqMatrix)pValue_get( 3 , 0 ));
	                	((CqMatrix)pTResult1.pValue_get( 2 , 0 )).assignment(((CqMatrix)pTResult2.pValue_get( 0 , 0 )).assignment((((CqMatrix)(pValue_get( 0 , 0 ))).add(((CqMatrix)(pValue_get( 2 , 0 ))) )).multiply(0.5f)));
	                	((CqMatrix)pTResult1.pValue_get( 3 , 0 )).assignment(((CqMatrix)pTResult2.pValue_get( 1 , 0 )).assignment((((CqMatrix)(pValue_get( 1 , 0 ))).add(((CqMatrix)(pValue_get( 3 , 0 ))) )).multiply(0.5f)));	                		                	
	                }else if(t instanceof CqColor){
		                ((CqColor)pTResult2.pValue_get( 2 , 0 )).assignment(((CqColor)pValue_get( 2 , 0 )));
		                ((CqColor)pTResult2.pValue_get( 3 , 0 )).assignment(((CqColor)pValue_get( 3 , 0 )));
//	                	((CqColor)pTResult1.pValue_get( 2 , 0 )).assignment(new CqVector3D(((CqColor)pTResult2.pValue_get( 0 , 0 )).assignment(new CqVector3D(( ((CqColor)(pValue_get( 0 , 0 ))).add((CqColor)(pValue_get( 2 , 0 )) ).mul(0.5f))))));
//	                	((CqColor)pTResult1.pValue_get( 3 , 0 )).assignment(new CqVector3D(((CqColor)pTResult2.pValue_get( 1 , 0 )).assignment(new CqVector3D(( ((CqColor)(pValue_get( 1 , 0 ))).add((CqColor)(pValue_get( 3 , 0 )) ).mul(0.5f))))));
	                	((CqColor)pTResult1.pValue_get( 2 , 0 )).assignment((((CqColor)pTResult2.pValue_get( 0 , 0 )).assignment(((((CqColor)(pValue_get( 0 , 0 ))).add((CqColor)(pValue_get( 2 , 0 )))).mul(0.5f)))));
	                	((CqColor)pTResult1.pValue_get( 3 , 0 )).assignment((((CqColor)pTResult2.pValue_get( 1 , 0 )).assignment(((((CqColor)(pValue_get( 1 , 0 ))).add((CqColor)(pValue_get( 3 , 0 )))).mul(0.5f)))));	                		                	
	                }else if(t instanceof CqVector4D){
		                ((CqVector4D)pTResult2.pValue_get( 2 , 0 )).assignment((CqVector4D)pValue_get( 2 , 0 ));
		                ((CqVector4D)pTResult2.pValue_get( 3 , 0 )).assignment((CqVector4D)pValue_get( 3 , 0 ));
	                	((CqVector4D)pTResult1.pValue_get( 2 , 0 )).assignment(((CqVector4D)pTResult2.pValue_get( 0 , 0 )).assignment((((CqVector4D)(pValue_get( 0 , 0 ))).add(((CqVector4D)(pValue_get( 2 , 0 ))) )).mul(0.5f)));
	                	((CqVector4D)pTResult1.pValue_get( 3 , 0 )).assignment(((CqVector4D)pTResult2.pValue_get( 1 , 0 )).assignment((((CqVector4D)(pValue_get( 1 , 0 ))).add(((CqVector4D)(pValue_get( 3 , 0 ))) )).mul(0.5f)));	                		                	
	                }else if(t instanceof CqVector3D){
		                ((CqVector3D)pTResult2.pValue_get( 2 , 0 )).assignment((CqVector3D)pValue_get( 2 , 0 ));
		                ((CqVector3D)pTResult2.pValue_get( 3 , 0 )).assignment((CqVector3D)pValue_get( 3 , 0 ));
	                	((CqVector3D)pTResult1.pValue_get( 2 , 0 )).assignment(((CqVector3D)pTResult2.pValue_get( 0 , 0 )).assignment((((CqVector3D)(pValue_get( 0 , 0 ))).add(((CqVector3D)(pValue_get( 2 , 0 ))) )).mul(0.5f)));
	                	((CqVector3D)pTResult1.pValue_get( 3 , 0 )).assignment(((CqVector3D)pTResult2.pValue_get( 1 , 0 )).assignment((((CqVector3D)(pValue_get( 1 , 0 ))).add(((CqVector3D)(pValue_get( 3 , 0 ))) )).mul(0.5f)));	                		                	
	                }else if(t instanceof p_String){
		                ((p_String)pTResult2.pValue_get( 2 , 0 )).value = ((p_String)pValue_get( 2 , 0 )).value;
		                ((p_String)pTResult2.pValue_get( 3 , 0 )).value = ((p_String)pValue_get( 3 , 0 )).value;
	                	((p_String)pTResult1.pValue_get( 2 , 0 )).value = ((p_String)pTResult2.pValue_get( 0 , 0 )).value = ((( (p_String)(pValue_get( 0 , 0 ))).value + ((p_String)(pValue_get( 2 , 0 ))).value ));
	                	((p_String)pTResult1.pValue_get( 3 , 0 )).value = ((p_String)pTResult2.pValue_get( 1 , 0 )).value = ((( (p_String)(pValue_get( 1 , 0 ))).value + ((p_String)(pValue_get( 3 , 0 ))).value ));
	                }
	                //else if(t instanceof String){
	                	//ZqȂߍ폜
	                //}
	                //--ꍇI
	            }
	        }
		
	}
	
	/**
	 * CqParameterTypedŒ`Ă
	 * Ŏw肵CX^XVectorAw肵l
	 * gVector̎w肵ʒuɃRs[s
	 * 
	 * @param pFrom Rs[CX^X
	 * @param idxTarget Rs[̔zԍB
	 * @param idxSource Rs[̔zԍ
	 */
	//nttdata 
//	public void SetValue(CqParameter pFrom, int idxTarget, int idxSource){
//		assert( pFrom.Type().getValue() == Type().getValue() );
//		
//        CqParameterTyped<T, SLT> pFromTyped = (CqParameterTyped<T, SLT>)( pFrom );
//        T tmp = (T)pValue( idxTarget )[0];//|C^Ȃ̂Œlo
//        if(tmp instanceof CqMatrix){
//        	((CqMatrix)tmp).assignment((CqMatrix)(pFromTyped.pValue( idxSource )[0]));
//        }else if(tmp instanceof CqVector3D){
//        	((CqVector3D)tmp).assignment((CqVector3D)(pFromTyped.pValue( idxSource )[0]));
//        }else if(tmp instanceof CqVector4D){
//        	((CqVector4D)tmp).assignment((CqVector4D)(pFromTyped.pValue( idxSource )[0]));
//        }else if(tmp instanceof CqColor){
//        	((CqColor)tmp).assignment((CqColor)(pFromTyped.pValue( idxSource )[0]));
//        }else if(tmp instanceof p_float){
//        	((p_float)tmp).value = ((p_float)(pFromTyped.pValue(idxSource)[0])).value;
//        }else if(tmp instanceof p_int){
//        	((p_int)tmp).value = ((p_int)(pFromTyped.pValue(idxSource)[0])).value;
//        }else if(tmp instanceof p_String){
//        	((p_String)tmp).value = ((p_String)(pFromTyped.pValue(idxSource)[0])).value;
//        }
//	}
	public void SetValue(CqParameter pFrom, int idxTarget, int idxSource){
		assert( pFrom.Type().getValue() == Type().getValue() );
		
        CqParameterTyped<T, SLT> pFromTyped = (CqParameterTyped<T, SLT>)( pFrom );
        T tmp = (T)pValue_get( idxTarget , 0 );//|C^Ȃ̂Œlo
        if(tmp instanceof CqMatrix){
        	((CqMatrix)tmp).assignment((CqMatrix)(pFromTyped.pValue_get( idxSource , 0 )));
        }else if(tmp instanceof CqVector3D){
        	((CqVector3D)tmp).assignment((CqVector3D)(pFromTyped.pValue_get( idxSource , 0)));
        }else if(tmp instanceof CqVector4D){
        	((CqVector4D)tmp).assignment((CqVector4D)(pFromTyped.pValue_get( idxSource , 0)));
        }else if(tmp instanceof CqColor){
        	((CqColor)tmp).assignment((CqColor)(pFromTyped.pValue_get( idxSource , 0)));
        }else if(tmp instanceof p_float){
        	((p_float)tmp).value = ((p_float)(pFromTyped.pValue_get(idxSource ,0))).value;
        }else if(tmp instanceof p_int){
        	((p_int)tmp).value = ((p_int)(pFromTyped.pValue_get(idxSource , 0))).value;
        }else if(tmp instanceof p_String){
        	((p_String)tmp).value = ((p_String)(pFromTyped.pValue_get(idxSource , 0))).value;
        }
	}
	/**
	 * ̂EqVariableTypeԂ
	 * (C++łGenericsŗpĂ)
	 * @return EqVariableType
	 */
	public EqVariableType Type() {
        return ( I );
	}
	
    /* Static constructor, to allow type free parameter construction.
     * \param strName Character pointer to new parameter name.
     * \param Count Integer array size.
     */
     //
	/**
	 * static RXgN^
	 * RXgN^Ɠlɗpł
	 */
     public static	<T,SLT> CqParameter	Create( final String strName, int Count,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass)
    {
        return ( new CqParameterTypedVarying<T,SLT>( strName, Count ,I,TClass,SLTClass) );
    }
 	/**
 	 * static RXgN^
 	 * RXgN^Ɠlɗpł(countȗn)
 	 */
     
     public static	<T,SLT> CqParameter	Create( final String strName,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass)
     {
    	 return CqParameterTypedVarying.<T,SLT>Create(strName,1,I,TClass,SLTClass);
     }
    
}
