// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;
import static net.cellcomputing.himawari.library.EqIntIndex.*;
/**
 * 
 * p^ƒlێ鉼zNX<br>
 * /ł̓xCqStats.intVars[PRM_created]̒lXVB
 * <br>
 * prototypep^[(fUCp^[Q)
 * http://www002.upp.so-net.ne.jp/ys_oota/mdp/Prototype/
 * 
 * Subdivide()ADiceȂǂ̃\bhB
 * 
 * @author NTT DATA Corporation
 */
public abstract strictfp class CqParameter {
	
	    protected String	m_strName;		///< p[^̖O
	    protected int	m_Count;		///< z̒
	    protected long m_hash;			//nbVlH
	    
	   
	    
	    /**
	     * RXgN^
	     * vێCqStatsm_intVars[PRM_created]
	     * ,m_intVars[PRM_current]CNgA
	     * m_intVars[PRM_peak]̒lZbgB
	     * 
	     * @param strName 	p[^
	     * @param Count 	z
	     * @param myClass GenericsŎw肳1S
	     */
	    public CqParameter(final String strName, int Count){
	    	m_strName = strName;
	    	m_Count = Count;
	    	assert( Count >= 1 );
	        
	        CqStats.STATS_INC( PRM_created );
	        CqStats.STATS_INC( PRM_current );
	        int cPRM = CqStats.STATS_GETI( PRM_current );
	        int cPeak = CqStats.STATS_GETI( PRM_peak );

	        CqStats.STATS_SETI( PRM_peak, cPRM > cPeak ? cPRM : cPeak );
	        m_hash = strName.hashCode();
	        
	    }
	    
	    /**
	     * RXgN^
	     * PȗRXgN^
	     * 
	     * @param strName p^
	     * @param myClass GenericsŎw肳1̂r
	     */
	    public CqParameter(final String strName){
	    	this(strName,1);
	    }
	    
	    /**
	     * Rs[RXgN^
	     * vێCqStatsm_intVars[PRM_created]
	     * ,m_intVars[PRM_current]CNgA
	     * m_intVars[PRM_peak]̒lZbgB
	     * 
	     * @param From Rs[IuWFNg
	     */
	    public  CqParameter(final CqParameter From ){
	    	m_strName 	= From.m_strName;
	    	m_Count		= From.m_Count;
	    	m_hash		= From.m_hash;
	        /// \note Had to remove this as paramters are now created as part of the Renderer construction, so the
	        ///		  renderer context isn't ready yet.
	        //	QGetRenderContext() ->Stats().IncParametersAllocated();
	        CqStats.STATS_INC( PRM_created );
	        CqStats.STATS_INC( PRM_current );
	        int cPRM = CqStats.STATS_GETI( PRM_current );
	        int cPeak = CqStats.STATS_GETI( PRM_peak );

	        CqStats.STATS_SETI( PRM_peak, cPRM > cPeak ? cPRM : cPeak );
	    }
	    /**
	     * fXgN^
	     * CqStats.m_intVars[PRM_current]fNgB
	     * 
	     */
	    public	void destruct(){
	        /// \note Had to remove this as paramters are now created as part of the Renderer construction, so the
	        ///		  renderer context isn't ready yet.
	        //	QGetRenderContext() ->Stats().IncParametersAllocated();
	    	CqStats.STATS_DEC( PRM_current );
	    }

	    /** 
	     * gƓTypeŁAf[^ȂParameterԂ
	     * @return ƓTypeCqParameter
	     */
	    public abstract CqParameter CloneType(final String Name, int Count);
	    
	    //VK쐬 2005/08/02
	    /**
	     * CloneType(Name,1)R[B
	     * @param Name
	     */
	    public CqParameter CloneType(final String Name){
	    	return CloneType(Name,1);
	    }
	    /**
	     * OƁAlVParameterԂ֐
	     * @return lCqParameter
	     */
	    public abstract CqParameter Clone();
	    /** 
	     * EqVariableClassԂ֐
	     * @return EqVariableClass
	     */
	    public abstract EqVariableClass	Class();
	    /** 
	     * EqVariableTypeԂ֐
	     */
	    public abstract EqVariableType	Type();
	    /** 
	     * złȂ/_̃TCYZbgB
	     * 
	     */
	    public abstract void SetSize( int size );
	    /** 
	     * złȂ/_̃TCYԂB
	     * @return /_̃TCY
	     */
	    public abstract int Size();
	    /** 
	     * lNAB
	     */
	    public abstract void Clear();

	    /* attention
	     * The subdivide functions perform common splitting and interpolation on primitive variables
	     * they are only of use if the variable is a bilinear quad (the most common kind)
	     * any other type of splitting or interpolation must be performed by the surface which 
	     * instantiates special types (i.e. polygons).
	     * <br><br>
	     * Subdivide@\͋ʂ̕Av~eBu̕⊮sB
	     * v~eBu͑o΂̎lӌ`(łʂȎނ)݂̂̂̂B
	     * ̃^Cv̕⊮ɂ͕Kʂȃ^CvɃCX^XꂽSurfaceɂ
	     * sȂ΂ȂȂB(Polygons)
	     */
	    
	    /** 
	     * u ̒̕lAɕB̒lw̕ϐŕB
	     * Subdivide the value in the u direction, place one half in this and the other in the specified parameter.
	     * @param pResult1 O̕ParameterNXւ̃|C^
	     * @param pResult2 O̕ParameterNXւ̃|C^
	     * @param u uŕ̂vŕ̂ǂwtOBfalseȂvŕ
	     * @param pSurface p^ǂ̏SurfaceB ʂȃp^ꍇAgB
	     */
	    public abstract void	Subdivide( CqParameter pResult1, CqParameter pResult2, boolean u, IqSurface pSurface);
	    //VK쐬 2005/08/02
	    public final void Subdivide(CqParameter pResult1,CqParameter pResult2,boolean u){
	    	Subdivide(pResult1,pResult2,u,null);
	    }
	    /** 
	     * l̃NX̓K؂ȕ⊮păObhɐ؂o(Dice)
	     * 
	     * @param u Ũ_CX̐(dice count)B
	     * @param v Ṽ_CX̐(dice count)B
	     * @param pResult ʂۑ|C^
	     * @param pSurface ݏĂSurface@vertex̕ϐR⊮邽߂ɎgB
	     */
	    public abstract	void	Dice( int u, int v, IqShaderData pResult, IqSurface pSurface);
	    
	    //VK쐬 2005/08/02
	    /**
	     * Dice(u,v,pResult,null)R[B
	     */
	    public final void Dice( int u, int v, IqShaderData pResult){
	    	Dice(u,v,pResult,null);
	    }
	    /** Pure virtual, 
	     * z̒P̗vfl̃NX̓K؂ȕ⊮păObhɐ؂o(Dice)
	     * 
	     * @param u Integer dice count for the u direction.
	     * @param v Integer dice count for the v direction.
	     * @param pResult Pointer to storage for the result.
	     * @param pSurface Pointer to the surface we are processing used for vertex class variables to perform natural interpolation.
	     */
	    public abstract	void	DiceOne(int u, int v, IqShaderData pResult, IqSurface pSurface, int ArrayIndex);
	    //VK쐬 2005/08/02
	    /**
	     * DiceOne\bh̃I[o[[h<br>
	     * DiceOne(u,v,pResult,null,0)R[B
	     * 
	     */
	    public final void DiceOne( int u, int v, IqShaderData pResult){
	    	DiceOne(u,v,pResult,null,0);
	    }
	    //VK쐬 2005/08/12
	    /**
	     * DiceOne\bh̃I[o[[h<br>
	     * DiceOne(u,v,pResult,pSurface,0)R[B
	     * 
	     */
	    public final void DiceOne( int u, int v, IqShaderData pResult,IqSurface pSurface){
	    	DiceOne(u,v,pResult,pSurface,0);
	    }

	    /** Pure virtual, set an indexed value from another parameter (must be the same type).
	     * ̃p^lindexZbgB
	     * KtypełȂ΂ȂȂB
	     * 
	     * @param pFrom |C^
	     * @param idxTarget Zbglindexl
	     * @param idxSource Zbgl
	     */
	    public abstract void	SetValue( CqParameter pFrom, int idxTarget, int idxSource );

	    /** Get a reference to the parameter name.
	     * p^getter
	     */
	    public final String strName()
	    {
	        return ( m_strName );
	    }
	    /**
	     * nbVlԂgetter
	     * @return nbVl
	     */
	    public final long hash()
	    {
	        return m_hash;
	    }

	    /** Get the array size.
	     * arraysizeԂBgetterB
	     */
	    public int Count()
	    {
	        return ( m_Count );
	    }



}
