// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import static net.cellcomputing.himawari.library.EqEnvVars.EnvVars_P;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector3D;

/**
 * 
 * Specialised micropolygon class for points.
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqMicroPolygonPoints extends CqMicroPolygon {

	private float m_radius;
	
	public CqMicroPolygonPoints()
	{
		super();
	}

	public void Initialise( float radius )
	{
		m_radius = radius;
	}
	
	public	CqBound GetTotalBound( )
	{
		CqVector3D Pmin = new CqVector3D();
		CqVector3D Pmax;
		pGrid().pVar(EnvVars_P).GetPoint(Pmin, m_Index);
		Pmax = new CqVector3D( Pmin );
		Pmin.x( Pmin.x - m_radius );
		Pmin.y( Pmin.y - m_radius );
		Pmax.x( Pmax.x + m_radius );
		Pmax.y( Pmax.y + m_radius );
		return( new CqBound( Pmin, Pmax ) );
	}
	
	//yz Aqsis1.01ύX*****************************************************
//	public	boolean Sample( final CqVector2D vecSample, p_float D, float time )
//	{
	public boolean Sample( final SqSampleData sample, p_float D, float time, boolean UsingDof )
	{
		final CqVector2D vecSample = sample.m_Position;
		
		CqVector3D P = new CqVector3D();
		pGrid().pVar(EnvVars_P).GetPoint(P, m_Index);
		if( (new CqVector2D( P.x, P.y ).sub( vecSample )).Magnitude() < m_radius )
		{
			D.value = P.z;
			return( true );
		}
		return( false );
	}
	
	@SuppressWarnings("unused")
	private CqMicroPolygonPoints( final CqMicroPolygonPoints From )
	{}


	    
}
