// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.library.types.CqRefCount;
import net.cellcomputing.himawari.library.types.CqVector3D;

/**
 * Base class from which all MicroPolyGrids are derived.
 * MicroPolyGrids hꂽNXB
 * 
 * @author NTT DATA Corporation
 */
public abstract strictfp class CqMicroPolyGridBase extends CqRefCount {
	
	/**
	 * RXgN^B
	 */
	public CqMicroPolyGridBase()
	{
		m_fCulled = false ;
		m_fTriangular = false;
	}
	
	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.types.CqRefCount#destruct()
	 */
	public void	destruct()
	{}
	
	/** 
	 * Pure virtual function, splits the grid into micropolys.
	 * z֐BObh}CN|SɕB
	 * @param pImage _OĂC[Wobt@ւ̎QƁB
	 * @param xmin	NbsO(؂)lɓꂽꍇ́AŏxfB
	 * @param xmax	NbsO(؂)lɓꂽꍇ́AőxfB
	 * @param ymin	NbsO(؂)lɓꂽꍇ́AŏyfB
	 * @param ymax	NbsO(؂)lɓꂽꍇ́AőyfB
	 */
	abstract public	void	Split( CqImageBuffer pImage, long xmin, long xmax, long ymin, long ymax );
	
	/**
	 * z֐B
	 * ObhVF[fBOB
	 */
	abstract public	void Shade();
	
	abstract public	void	TransferOutputVariables();
	
	/**
	 * Delete all the variables per grid <br>
	 * eObh̎ϐSďB
	 * 
	 * @param all	
	 */
	abstract public void DeleteVariables( boolean all );
	
	
	/**
	 * Pure virtual, get a pointer to the surface this grid belongs.<br>
	 * z֐B
	 * ݂̃ObhAT[tFX̎QƂ擾B
	 * @return@ObhV[fBOԂ́AT[tFXւ̎QƁB<br>Pointer to surface, only valid during grid shading.
	 */
	abstract public CqSurface pSurface();
	
	
	/**
	 * ݂̃ObhAAgr[g̎QƂ擾B
	 * @return	Agr[g̎QƁB
	 */
	abstract public	IqAttributes pAttributes();
	
	
	/**
	 * ݂̃ObhACSGm[h̎QƂ擾B
	 * @return@CSGm[h̎QƁB
	 */
	abstract public	CqCSGTreeNode pCSGNode();
	
	
	/**
	 * m_fCulled̃Qb^B
	 * 
	 * @return	m_fCulled	S̃ObhĂ΂ꂽǂB
	 */
	public boolean vfCulled()
	{
		return m_fCulled;
	}
	
	
	/**
	 * Query whether this grid is being rendered as a triangle.
	 * ݂̃ObhOp`Ƃă_OĂ邩ǂ₤B
	 * 
	 * @return	m_fTriangular@Op`Ƃă_OĂ邩B
	 */
	public boolean fTriangular()
	{
		return ( m_fTriangular );
	}


	/**
	 * Set this grid as being rendered as a triangle or not.
	 * ݂̃ObhOp`Ƃă_O邩ȂZbgB
	 * 
	 * @param fTriangular	Op`Ƃă_O邩ǂB
	 */
	public void SetfTriangular( boolean fTriangular )
	{
		m_fTriangular = fTriangular;
	}
	
	
	abstract public	int	uGridRes();
	abstract public	int	vGridRes();
	abstract public	int	GridSize();
	abstract public IqShaderData pVar(int index);
	
	
	/**
	 * Get the points of the triangle split line if this grid represents a triangle.
	 * ݂̃ObhOp`\ĂȂAOp`𕪊_擾B
	 * 
	 * @param v1	Op`𕪊_1
	 * @param v2	Op`𕪊_2
	 * @param Time	
	 */
	public void	TriangleSplitPoints(CqVector3D v1, CqVector3D v2, float Time )
	{
		// Workout where in the keyframe sequence the requested point is.
		SqTriangleSplitLine sl = m_TriangleSplitLine.GetMotionObjectInterpolated( Time );
		v1.assignment( sl.m_TriangleSplitPoint1 );
		v2.assignment( sl.m_TriangleSplitPoint2 );
	}
	
	
	public class SqTriangleSplitLine
	{	
		CqVector3D	m_TriangleSplitPoint1;
		CqVector3D  m_TriangleSplitPoint2;
		
		/**
		 * ftHgRXgN^
		 */
		public SqTriangleSplitLine() {
			m_TriangleSplitPoint1 = new CqVector3D();
			m_TriangleSplitPoint2 = new CqVector3D();
		}
		
		/**
		 * Rs[RXgN^
		 */
		public SqTriangleSplitLine( SqTriangleSplitLine From ) {
			m_TriangleSplitPoint1 = new CqVector3D( From.m_TriangleSplitPoint1 );
			m_TriangleSplitPoint2 = new CqVector3D( From.m_TriangleSplitPoint2 );
		}
	};
	
	
	/**
	 * CqMicroPolygonGridBaseNXB <br>
	 * CqMotionSpecpB
	 * 
	 * @author NTT DATA Corporation
	 */
	public class CqTriangleSplitLine extends CqMotionSpec<SqTriangleSplitLine>
	{
		
		/**
		 * RXgN^B
		 */
		public CqTriangleSplitLine()
		{
			super( new SqTriangleSplitLine() );
		}
		
		
		/**
		 *@Rs[RXgN^B
		 * @param def
		 */
		public CqTriangleSplitLine( final SqTriangleSplitLine def )
		{
			super( new SqTriangleSplitLine(def) );
		}
		
		
		public	void	ClearMotionObject( SqTriangleSplitLine A )
		{}
		
		public	SqTriangleSplitLine	ConcatMotionObjects( final SqTriangleSplitLine A, final SqTriangleSplitLine B )
		{
			return( A );
		}
		
		public	SqTriangleSplitLine	LinearInterpolateMotionObjects( float Fraction, final SqTriangleSplitLine A, final SqTriangleSplitLine B )
		{
			SqTriangleSplitLine sl = new SqTriangleSplitLine();
			sl.m_TriangleSplitPoint1.assignment( ( A.m_TriangleSplitPoint1.mul(1.0f - Fraction ).add( B.m_TriangleSplitPoint1.mul(Fraction) ) ) );
			sl.m_TriangleSplitPoint2.assignment( ( A.m_TriangleSplitPoint2.mul(1.0f - Fraction ).add( B.m_TriangleSplitPoint2.mul(Fraction) ) ) );
			return( sl );
		}
	};
	
	abstract public	IqShaderData FindStandardVar( final String pname );
	
	
	public boolean m_fCulled; 				///< Boolean indicating the entire grid is culled.
	public CqTriangleSplitLine	m_TriangleSplitLine = new CqTriangleSplitLine();	///< Two endpoints of the line that is used to turn the quad into a triangle at sample time.
	public boolean	m_fTriangular;			///< Flag indicating that this grid should be rendered as a triangular grid with a phantom fourth corner.
	
}
