/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.display;

import static net.cellcomputing.himawari.library.RiGlobal.QGetRenderContext;
import static net.cellcomputing.himawari.library.RiGlobal.QGetRenderContextI;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.util.HimawariLogger;
/**
 * @author NTT DATA Corporation
 *
 */
public strictfp class ZFileRequest extends DisplayRequest {
	/**
	 * SHADOWHEADER̃X^[g
	 */
	public static final String START_SHADOW_HEADER = "START_SHADOW_HEADER";

	/**
	 * SHADER̃wb_̃Gh
	 */
	public static final String END_SHADOW_HEADER = "END_SHADOW_HEADER";
	
	/**
	 * ʃTCY
	 */
	public static final String SHADOW_WIDTH ="SHADOW_WIDTH";
	
	/**
	 * ʂ̍
	 */
	public static final String SHADOW_HEIGHT = "SHADOW_HEIGHT";
	
	/**
	 * J̈ʒu
	 */
	public static final String SHADOW_CAMERA_POINT = "SHADOW_CAMERA_POINT";
	
	/**
	 * XN[̈ʒu
	 */
	public static final String SHADOW_SCREEN_POINT = "SHADOW_SCREEN_POINT";
	/**
	 * 摜f[^̕
	 */
	private int imageWidth;
	/**
	 * 摜f[^̍
	 */
	private int imageHeight;
	
	/**
	 * Screen̈ʒu
	 */
	CqMatrix matWorldToScreen;
	
	/**
	 * Cameräʒu
	 */
	CqMatrix matWorldToCamera;
	
	
	/**
	 * RXgN^
	 * Request
	 * @param name pngt@C̖O
	 * @param type ۑ`
	 * @param mode RGB,RGBAȂǂ̃J[񂪂͂
	 * @param modeID modehash
	 * @param dataOffset 
	 * @param dataSize
	 * @param imageData RequestǗImageData (BufferedImage)
	 */
	public ZFileRequest(String name, final String type,final String mode,
			int modeID, int dataOffset, int dataSize ,ImageData imageData){
		super(name,type,mode,modeID,dataOffset,dataSize,imageData);
	}
	
	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.display.DisplayRequest#openRequest()
	 */
	@Override
	public void openRequest() {
		imageWidth = QGetRenderContext() .optCurrent().GetIntegerOptionIndex( "System", "Resolution" , 0 ).value;		//image̕擾
		imageHeight = QGetRenderContext() .optCurrent().GetIntegerOptionIndex( "System", "Resolution" , 1 ).value;	//image̍擾
		//JȂǂ̈ʒu擾Ă
		matWorldToCamera = QGetRenderContext().matSpaceToSpace( "world", "camera", new CqMatrix(), new CqMatrix(), QGetRenderContextI().Time() );
		matWorldToScreen = QGetRenderContext().matSpaceToSpace( "world", "screen", new CqMatrix(), new CqMatrix(), QGetRenderContextI().Time() );

	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.display.DisplayRequest#display()
	 */
	@Override
	public void display() {

	}

	private void writeHeader(RandomAccessFile file)throws IOException{
		String ret = "\n";
		//wb_̏o
		file.write(START_SHADOW_HEADER.getBytes());
		
		file.write(ret.getBytes());
		
		//摜̕o
		file.write(SHADOW_WIDTH.getBytes());
		file.write((" "  + imageWidth).getBytes());
		file.write(ret.getBytes());

		//摜̍o
		file.write(SHADOW_HEIGHT.getBytes());
		file.write((" "  + imageWidth).getBytes());
		file.write(ret.getBytes());
		
		//J̈ʒuo
		file.write(SHADOW_CAMERA_POINT.getBytes());
		file.write(ret.getBytes());
		writeMatrix(file,matWorldToCamera);
		file.write(ret.getBytes());
		
		//XN[̈ʒuo
		file.write(SHADOW_SCREEN_POINT.getBytes());
		file.write(ret.getBytes());
		writeMatrix(file,matWorldToScreen);
		file.write(ret.getBytes());
		
		file.write(END_SHADOW_HEADER.getBytes());
		file.write(ret.getBytes());
	}
	
	private void writeMatrix (RandomAccessFile file,CqMatrix matrix)throws IOException{
		for(int i=0; i < 4;i++)
			for(int j=0;j<4 ;j++)
				file.writeFloat(matrix.m_aaElement[i][j]);
	}
	
	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.display.DisplayRequest#closeRequest()
	 */
	@Override
	public void closeRequest() {
		RandomAccessFile file = null;
		float[][] bucketList = (float[][])imageData.getImage();
		
		try {
			file = new RandomAccessFile(name,"rw");
			//wb_[
			file.seek(0);
			file.setLength(0);
			writeHeader(file);
			//܂
			for(int y = 0; y < bucketList.length ; y++){
				for(int x = 0; x < bucketList[0].length;x++){
					//F񂪓Ă邩`FbN
//					if(bucketList[y][x])
//						continue;
					
					//[xt@Cɏo
					file.writeFloat(bucketList[y][x]);
				}
			}

		} catch (FileNotFoundException e) {
			HimawariLogger.outputException(e);
			HimawariLogger.getLogger().error( "Cannot open output image file: " + name + "\n");
			
		} catch (IOException e) {
			HimawariLogger.outputException(e);
			HimawariLogger.getLogger().error( "Cannot open output image file: " + name + "\n");
			
		}finally{
			//SĂBucketÎŃt@CB
			try {
				if(file != null)
					file.close();
			} catch (IOException e) {
				HimawariLogger.outputException(e);
			}
		}
		imageData = null;
	}

}
