/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.display;

import static net.cellcomputing.himawari.display.GrobalDDManager.ConstructFloatsParameter;
import static net.cellcomputing.himawari.display.GrobalDDManager.ConstructIntsParameter;
import static net.cellcomputing.himawari.display.GrobalDDManager.ConstructStringsParameter;
import static net.cellcomputing.himawari.library.EqEnvVars.EnvVars_Last;
import static net.cellcomputing.himawari.library.EqVariableClass.class_uniform;
import static net.cellcomputing.himawari.library.EqVariableType.type_color;
import static net.cellcomputing.himawari.library.EqVariableType.type_float;
import static net.cellcomputing.himawari.library.EqVariableType.type_integer;
import static net.cellcomputing.himawari.library.EqVariableType.type_normal;
import static net.cellcomputing.himawari.library.EqVariableType.type_point;
import static net.cellcomputing.himawari.library.EqVariableType.type_string;
import static net.cellcomputing.himawari.library.EqVariableType.type_vector;
import static net.cellcomputing.himawari.library.RiGlobal.QGetRenderContext;
import static net.cellcomputing.himawari.shaderexecenv.GlobalShaderExecEnv.gVariableTokens;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map.Entry;

import javax.imageio.ImageIO;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.exception.DisplayNotFoundException;
import net.cellcomputing.himawari.exception.XqException;
import net.cellcomputing.himawari.library.IqBucket;
import net.cellcomputing.himawari.library.IqDDManager;
import net.cellcomputing.himawari.library.SqParameterDeclaration;
import net.cellcomputing.himawari.library.UserParameter;
import net.cellcomputing.himawari.util.HimawariLogger;

/**
 * @author NTT DATA Corporation
 * DisplayɊւ閽߂ǗNXB
 * DislayRequestImageDataǗB
 * DisplayRequestRI߂ɂǗA
 * ImageDataImage̕`ŝłB
 * 
 * ʏ
 * 1.AddDisplay\bhpRequesto^
 * 2.openDisplays\bhŏs
 * 3.displayBucket\bhCqBucketPʂ̃_Os
 * 4.closeDisplays\bhŁAt@Cւ̏oȂǂ̏IsB
 * ƂŗpB
 */
public strictfp class DisplayManager implements IqDDManager {
	
	/**
	 * TIFF`\萔
	 */
	private static final String DISPLAY_TIFF = "tiff";

	/**
	 * PNG`\萔
	 */
	private static final String DISPLAY_PNG = "png";

	/**
	 * BMP`\萔
	 */
	private static final String DISPLAY_BMP = "bmp";

	/**
	 * JPEG`\萔
	 */
	private static final String DISPLAY_JPG = "jpg";

	/**
	 * JPEG2000`\萔
	 */
	private static final String DISPLAY_JPEG2000 = "jpeg2000";

	/**
	 * RGBA`\萔
	 */
	private static final String DISPLAY_MODE_RGBA = "rgba";

	/**
	 *  RGB`\萔
	 */
	private static final String DISPLAY_MODE_RGB = "rgb";

	/**
	 * Z`\萔
	 */
	private static final String DISPLAY_MODE_Z = "z";
	
	/**
	 * HDR`\萔
	 */
	private static final String DISPLAY_HDR = "hdr";
	
	
	/**
	 * File`\萔
	 */
	private static final String DISPLAY_FILE = "file";
	/**
	 * Framebuffer`\萔(Windowւ̕\)
	 */
	private static final String DISPLAY_FRAMEBUFFER = "framebuffer";
	
	/**
	 * ZFrameBuffer`\萔(Windowւ̕\)
	 */
	private static final String DISPLAY_ZFRAMEBUFFER = "zframebuffer";
	/**
	 * ZFile`\萔
	 */
	private static final String DISPLAY_ZFILE = "zfile";

	/**
	 * ZFile`\萔
	 */
	private static final String DISPLAY_SHADOW_FILE = "shadow";

	private STLVector<DisplayRequest> m_displayRequests = new STLVector<DisplayRequest>(DisplayRequest.class); 
	private STLVector<ImageData> m_ImageData = new STLVector<ImageData>(ImageData.class);
	private LinkedList<String> m_displayList = new LinkedList<String>();
	
	//--CqDDManaerɒ`Ă萔
	private static int rgb	= DISPLAY_MODE_RGB.hashCode();
	private static int rgba	= DISPLAY_MODE_RGBA.hashCode();
	private static int Ci		= "Cs".hashCode();
	private static int Oi		= "Os".hashCode();
	
	
	
	/**
	 * JVMp\ȉ摜`TA
	 * pł摜`HashMapɓo^.
	 */
	public int Initialise() {
		String[] writerNames = ImageIO.getWriterFormatNames();

		for (int i = 0 ; i < writerNames.length ; i++) {
			m_displayList.add(writerNames[i]);
		}
		//ȃfBXvC`Xgɒǉ
		addExtractDisplay();
		
		return 0;
	}

	/**
	 * JVMł͔FȂȃfBXvC^Cv
	 * HashMapɓo^
	 */
	private void addExtractDisplay() {
		m_displayList.add(DISPLAY_FRAMEBUFFER);	//(\p)
		m_displayList.add(DISPLAY_FILE);		//(ftHgwp)
		m_displayList.add(DISPLAY_HDR);			//(HDR`)
		m_displayList.add(DISPLAY_ZFILE);		//(zFile`)
		m_displayList.add(DISPLAY_SHADOW_FILE);		//(shadow`)
		m_displayList.add(DISPLAY_ZFRAMEBUFFER);		//(shadow`)
	}
	
	/**
	 * sȂB
	 */
	public int Shutdown() {
		return 0;
	}
	
	/**
	 * DisplayRequest󂯎A
	 * modeɓKImageDatayсAtypeɓKRequest쐬
	 * Vectorɓo^
	 * 
	 * fBXvC`āAJ[[hΉ̏ꍇA
	 * ɂȂɂsȂ
	 * @param name fBXvC̖O
	 * @param type fBXvČ`
	 * @param mode fBXvC̃J[[h
	 * @param modeID fBXvC̃J[[h̃nbV
	 * @param dataOffset
	 * @param dataSize
	 * @param mapArguments
	 * 
	 * @throws DisplayNotFoundException typeɑΉfBXvC`Ȃꍇthrow
	 * 
	 * @return 0
	 */
	public int AddDisplay(String name, String type, String mode, int modeID,
			int dataOffset, int dataSize, HashMap<String, Object> mapOfArguments) throws DisplayNotFoundException{
		ImageData imageData = null;
		DisplayRequest request = null;
		
		//p\Ȍ`łȂꍇAOthrow
		if(!m_displayList.contains(type)){
			throw new DisplayNotFoundException(type);
		}
		
		
		//--- AOV 2006.11.10 isawa for AOV ---------------

		//o̓f[^̃^Cv擾
		int outType = QGetRenderContext().OutputDataType(mode);

		//GgĂi^Cv擾łj
		if( outType > 0 ) {
			//^Cvɂ킹ImageData쐬
			switch( outType )
			{
//			case type_hpoint:
////				componentNames = "xyz";
////				break;
//
//				//shadowƓɂp^[
//				type = DISPLAY_SHADOW_FILE; 
//				mode = DISPLAY_MODE_Z;
//				break;
				
			case type_float:
			case type_integer:
				//-- AOV float integerǉ 2007/05/16 watanabei
				type = DISPLAY_HDR;
//				mode = DISPLAY_AOV_SINGLE;
				break;
				//--܂
			case type_vector:
			case type_point:
			case type_normal:
			case type_color:
//				componentNames = "rgb";
//				break;
				
				//HDRƓɂp^[
				type = DISPLAY_HDR;
//				mode = DISPLAY_AOV_TRIPLE;
				break;
			}
		}
		
		//------------------------------------------------
		

		//--ImageDatayRequest쐬
		//  CreatepFactory쐬ĂǂƎv
		//  filew肳ꂽꍇATIFFpłtiff`ŁA
		//  płȂꍇ́``ŕۑ
		
		if(mode.equals(DISPLAY_MODE_RGB) && type.equals(DISPLAY_FRAMEBUFFER)){
			imageData = ImageData.getInstance(RGBImageData.class,dataOffset);
			request = new FrameBufferRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
		}else if(mode.equals(DISPLAY_MODE_RGBA) && type.equals(DISPLAY_FRAMEBUFFER)){
			imageData = ImageData.getInstance(RGBAImageData.class,dataOffset);
			request = new FrameBufferRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
		}else if(mode.equals(DISPLAY_MODE_RGBA) && type.equals(DISPLAY_TIFF)){
			imageData = ImageData.getInstance(RGBAImageData.class,dataOffset);
			request = new TiffRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
		}else if(mode.equals(DISPLAY_MODE_RGB) && type.equals(DISPLAY_TIFF)){
			imageData = ImageData.getInstance(RGBImageData.class,dataOffset);
			request = new TiffRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
		}else if(mode.equals(DISPLAY_MODE_RGBA) && type.equals(DISPLAY_PNG)){
			imageData = ImageData.getInstance(RGBAImageData.class,dataOffset);
			request = new PngRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
		}else if(mode.equals(DISPLAY_MODE_RGB) && type.equals(DISPLAY_PNG)){
			imageData = ImageData.getInstance(RGBImageData.class,dataOffset);
			request = new PngRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
		}else if(mode.equals(DISPLAY_MODE_RGBA) && type.equals(DISPLAY_BMP)){
			//RGBA̓T|[gȂWARNINGo͂ARGB[hɕϊs
			HimawariLogger.getLogger().warning("[" + type + "]  \"" + mode + "\" is not supported. Convert \""+ mode +"\" into \"rgb\".\n");

			imageData = ImageData.getInstance(RGBImageData.class,dataOffset);
			request = new BMPRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
		}else if(mode.equals(DISPLAY_MODE_RGB) && type.equals(DISPLAY_BMP)){
			imageData = ImageData.getInstance(RGBImageData.class,dataOffset);
			request = new BMPRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
		}else if(mode.equals(DISPLAY_MODE_RGBA) && type.equals(DISPLAY_JPG)){
			//RGBA̓T|[gȂWARNINGo͂ARGB[hɕϊs
			HimawariLogger.getLogger().warning("[" + type + "]  \"" + mode + "\" is not supported. Convert \""+ mode +"\" into \"rgb\".\n");

			imageData = ImageData.getInstance(RGBImageData.class,dataOffset);
			request = new JPEGRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
		}else if(mode.equals(DISPLAY_MODE_RGB) && type.equals(DISPLAY_JPG)){
			imageData = ImageData.getInstance(RGBImageData.class,dataOffset);
			request = new JPEGRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
		}else if(mode.equals(DISPLAY_MODE_RGBA) && type.equals(DISPLAY_HDR)){
			//RGBA̓T|[gȂWARNINGo͂ARGB[hɕϊs
			HimawariLogger.getLogger().warning("[" + type + "]  \"" + mode + "\" is not supported. Convert \""+ mode +"\" into \"rgb\".\n");

			imageData = ImageData.getInstance(HDRImage.class,dataOffset);
			request = new HDRRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
		}else if(mode.equals(DISPLAY_MODE_RGB) && type.equals(DISPLAY_HDR)){
			imageData = ImageData.getInstance(HDRImage.class,dataOffset);
			request = new HDRRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
		}else if(mode.equals(DISPLAY_MODE_RGBA) && type.equals(DISPLAY_JPEG2000)){
			imageData = ImageData.getInstance(RGBAImageData.class,dataOffset);
			request = new JPEG2000Request(name,type,mode,modeID,dataOffset,dataSize,imageData);
		}else if(mode.equals(DISPLAY_MODE_RGB) && type.equals(DISPLAY_JPEG2000)){
			imageData = ImageData.getInstance(RGBImageData.class,dataOffset);
			request = new JPEG2000Request(name,type,mode,modeID,dataOffset,dataSize,imageData);

		}else if(type.equals(DISPLAY_FILE) && mode.equals(DISPLAY_MODE_RGBA)){
			imageData = ImageData.getInstance(RGBAImageData.class,dataOffset);
			
			if(m_displayList.contains(DISPLAY_TIFF))
				request = new  TiffRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
			else
				request = new PngRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
			
		}else if(type.equals(DISPLAY_FILE) && mode.equals(DISPLAY_MODE_RGB)){
			imageData = ImageData.getInstance(RGBImageData.class,dataOffset);
			
			if(m_displayList.contains(DISPLAY_TIFF))
				request = new  TiffRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
			else
				request = new PngRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
			
		}else if((type.equals(DISPLAY_SHADOW_FILE) || type.equals(DISPLAY_ZFILE)) && mode.equals(DISPLAY_MODE_Z)){
			//shadowMap쐬
			imageData = ImageData.getInstance(ZFileImage.class,dataOffset);
			request = new ZFileRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
		}else if((type.equals(DISPLAY_ZFRAMEBUFFER) ) && mode.equals(DISPLAY_MODE_Z)){
			imageData = ImageData.getInstance(ZFileImage.class,dataOffset);
			request = new ZFrameBufferRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
			
//		}else if(mode.equals(DISPLAY_AOV_SINGLE) && type.equals(DISPLAY_HDR)){
		}else if((outType == type_float || outType ==type_integer) && type.equals(DISPLAY_HDR)){
			imageData = ImageData.getInstance(AOVSingleImageData.class,dataOffset);
			request = new HDRRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
//		}else if(mode.equals(DISPLAY_AOV_TRIPLE) && type.equals(DISPLAY_HDR)){
		}else if((outType == type_point || outType ==type_vector|| outType ==type_normal || outType ==type_color) && type.equals(DISPLAY_HDR)){
			imageData = ImageData.getInstance(AOVTripleImageData.class,dataOffset);
			request = new HDRRequest(name,type,mode,modeID,dataOffset,dataSize,imageData);
		}else{
			//G[bZ[W\
			HimawariLogger.getLogger().error("[" + type + "]  \"" + mode + "\" is not supported.\n");
		}
		
		
		if(request != null)
			m_displayRequests.add(request);
		//--ImageData쐬ς݂łΓo^sȂ
		if(imageData != null && !m_ImageData.contains(imageData)){
			m_ImageData.add(imageData);
		}
		
		//------- 2006.11.13 isawa add for AOV --------------------------------
		
		//ʂȈ̐ݒ
		
		// Create the array of UserParameter structures for all the unrecognised extra parameters,
		// while extracting information for the recognised ones.
		PrepareCustomParameters(mapOfArguments, imageData);
		
		//o̓t@C̓o^
		dispNames.add(name);
		//---------------------------------------------------------------------

		
		return 0;
	}


	/**
	 * o^ĂRequestSč폜
	 */
	public int ClearDisplays() {
		m_displayRequests.clear();
		m_ImageData.clear();
		return 0;
	}
	
	/**
	 * o^ĂRequestɑ΂
	 * openRequest()ĂяoB
	 * ܂o^ĂImageDataɑ΂āAinit()ĂяoB
	 */
	public int OpenDisplays() {
		for(ImageData i : m_ImageData){
			i.init();
		}
		
		
		for(DisplayRequest i : m_displayRequests){
			i.openRequest();
		}
		return 0;
	}
	
	/**
	 * o^ĂRequestSĂɑ΂āA
	 * closeRequest\bhĂяo
	 */
	public int CloseDisplays() {
		for(DisplayRequest i : m_displayRequests){
			i.closeRequest();
		}
		return 0;
	}
	
	/**
	 * o^ĂRequestSĂɑ΂
	 * Display\bhĂяo
	 * ܂Ao^ĂImageDataSĂɑ΂
	 * setBucketĂяo
	 */
	public int DisplayBucket(IqBucket pBucket) {
		
		for(ImageData i : m_ImageData){
			i.setBucket(pBucket);
		}
		
		for(DisplayRequest i : m_displayRequests){
			i.display();
		}
		return 0;
	}
	
	/**
	 * CqDDManager̃\bh
	 */
	public boolean fDisplayNeeds(String var) {
		long htoken = var.hashCode();
		
//		// Scan all registered displays to see if any of them need the variable specified.
		for( DisplayRequest i : m_displayRequests )
		{
			boolean usage = ( ( i.m_modeHash == rgba ) || ( i.m_modeHash == rgb ) );
			if ( ( htoken == Ci ) && usage )
				return ( true );
			else if ( ( htoken == Oi ) && usage )
				return ( true );
			else if ( ( i.m_modeHash == htoken ) )
				return ( true );
		}
		return ( true );
	}
	
	/**
	 * CqDDManager̃\bh
	 */
	public int Uses() {
		int Uses = 0;
		// Scan all registered displays to combine the required variables.
		for( DisplayRequest i : m_displayRequests )
		{
			int ivar;
			for( ivar = 0; ivar < EnvVars_Last; ivar++ )
			{
				if( i.m_modeHash == gVariableTokens[ ivar ] )
					Uses |= 1 << ivar;
			}
		}
		return ( Uses );
	}
	
	
	//------- 2006.08.17 isawa add for BOINC ------------------------------
	/**
	 * ȎQƁB
	 * BOINĆAHimawariLbJ[ÓIgetImage()\bhĂяo߂̂́B
	 */
	private static DisplayManager me;
	
	/**
	 * RXgN^B
	 * ȎQƂZbgB
	 */
	public DisplayManager() {
		me = this;
	}
	
	/**
	 * ݃_OBufferedImageoB
	 * BOINCHimawariLbJ[pB
	 * 
	 * @return	݃_OBufferedImageIuWFNg
	 */
	@SuppressWarnings("unchecked")
	public static BufferedImage getImage() {
		
		BufferedImage image;

		if( me == null ) return null;
		
		for( ImageData id : me.m_ImageData )
		{
			if (id.getImage() instanceof BufferedImage) {
				image = (BufferedImage) id.getImage();
				return image;
			}
			if (id instanceof ZFileImage) {
				ZFileImage zimage = (ZFileImage) id;
				return zimage.getZImage();
			}
		}
		
		return null;
	}
	//---------------------------------------------------------------------
	
	//------- 2006.11.13 isawa add for AOV --------------------------------
	
	/**
	 * ImageDataIuWFNgi摜𐶐IuWFNgj֓Ȉݒ肷B
	 * 
	 * @param mapOfArguments	i[nbVe[uB
	 * @param req				ݒ肷ImageData
	 */
	@SuppressWarnings("unchecked")
	private void PrepareCustomParameters(HashMap<String, Object> mapParams, ImageData req) {

		// Scan the map of extra parameters
//		std::map<std::string, void*>::iterator param;
//	    for ( param = mapParams.begin(); param != mapParams.end(); param++ )
		for( Entry<String, Object> param : mapParams.entrySet() )
	    {
			// First check if it is one of the recognised parameters that the renderer should handle.
			if(param.getKey().equals("quantize"))
			{
				// Extract the quantization information and store it with the display request.
				p_float[] floats = (p_float[])( param.getValue() );
				req.m_QuantizeZeroVal = floats[0].value;
				req.m_QuantizeOneVal = floats[1].value;
				req.m_QuantizeMinVal = floats[2].value;
				req.m_QuantizeMaxVal = floats[3].value;
			}
			else if(param.getKey().equals("dither"))
			{
				// Extract the quantization information and store it with the display request.
				p_float[] floats = (p_float[])( param.getValue() );
				req.m_QuantizeDitherVal = floats[0].value;
			}
			else
			{
				// Otherwise, construct a UserParameter structure and fill in the details.
				SqParameterDeclaration Decl;
				try
				{
					Decl = QGetRenderContext().FindParameterDecl( param.getKey() );
				}
				catch( XqException e )
				{
					HimawariLogger.getLogger().error( e.strReason() + "\n" );
					return;
				}

				// Check the parameter type is uniform, not valid for non-surface requests otherwise.
				if( Decl.m_Class.getValue() != class_uniform )
				{
					assert( false );
					continue;
				}

				UserParameter parameter = new UserParameter();
				parameter.name = null;
				parameter.value = 0;
				parameter.vtype = 0;
				parameter.vcount = 0;
				parameter.nbytes = 0;

				// Store the name
//				char* pname = reinterpret_cast<char*>(malloc(Decl.m_strName.size()+1));
//				strcpy(pname, Decl.m_strName.c_str());
//				parameter.name = pname;
				parameter.name = Decl.m_strName;

				switch ( Decl.m_Type.getValue() )
				{
					case type_string:
					{
						final p_String[] strings = (p_String[])( param.getValue() );
						ConstructStringsParameter(Decl.m_strName, strings, Decl.m_Count, parameter);
					}
					break;

					case type_float:
					{
						final p_float[] floats = (p_float[])( param.getValue() );
						ConstructFloatsParameter(Decl.m_strName, floats, Decl.m_Count, parameter);
					}
					break;

					case type_integer:
					{
						final p_int[] ints = (p_int[])( param.getValue() );
						ConstructIntsParameter(Decl.m_strName, ints, Decl.m_Count, parameter);
					}
					break;
				}
				req.m_customParams.add(parameter);
			}
	    }
	}
	
	
	/**
	 * DisplayɎw肳ꂽo̓t@Ci[ReiB
	 */
	private ArrayList<String>	dispNames = new ArrayList<String>();
	
	/**
	 * DisplayɎw肳ꂽo̓t@Cz擾B
	 * BOINCHimawariLbJ[pB
	 * 
	 * @return	DisplayɎw肳ꂽo̓t@Cz
	 */
	public static ArrayList<String> getDisplayNames() {
		
		if( me == null ) return null;
		
		//ri.pic͏O
		me.dispNames.remove("ri.pic");
		
		//t@CƂĕϊĂ
		File file;
		for( int i=0; i<me.dispNames.size(); i++ ) {
			file = new File( me.dispNames.get(i) );
			me.dispNames.set( i, file.getName() );
		}
		
		return me.dispNames;
	}
	
	
	//---------------------------------------------------------------------
	
	

	
}
