/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.display;

import static net.cellcomputing.himawari.library.RiGlobal.QGetRenderContext;
import net.cellcomputing.himawari.accessory.Valarray;
import net.cellcomputing.himawari.library.CqBucket;
import net.cellcomputing.himawari.library.IqBucket;
import net.cellcomputing.himawari.library.types.CqColor;
/**
 * @author NTT DATA Corporation
 * AOVfloatyint^̉摜f[^ǗNXB
 * CqColor[][]̃f[^B
 * f[^g1`lHDR`ɕۑ邽
 * 3`l̒ɓl͂邱ƂɂȂB
 * 
 */

public strictfp class AOVSingleImageData extends ImageData<CqColor[][]> {

	/**
	 * RXgN^
	 *
	 */
	protected AOVSingleImageData(int offset){
		super(offset);			// 2006/11/10 offsetpύX n
	}
	
	/**
	 * BucketpixelColor擾A
	 * imageDataɊi[B
	 */
	public void setBucket(IqBucket pBucket) {
		if( (pBucket.Width() == 0) || (pBucket.Height() == 0) )
			return;
		int	xmin = pBucket.XOrigin();
		int	ymin = pBucket.YOrigin();
		int	xmaxplus1 = xmin + pBucket.Width();
		int	ymaxplus1 = ymin + pBucket.Height();
		
		// If completely outside the crop rectangle, don't bother sending.
		//ʂ̃G[
		if( xmaxplus1 <= QGetRenderContext().pImage().CropWindowXMin() ||
			ymaxplus1 <= QGetRenderContext().pImage().CropWindowYMin() ||
			xmin > QGetRenderContext().pImage().CropWindowXMax() ||
			ymin > QGetRenderContext().pImage().CropWindowYMax() )
			return;
		//--܂
		
		for ( int y = ymin; y < ymaxplus1; y++ )
		{
			for ( int x = xmin; x < xmaxplus1; x++ )
			{
				//`͈͂ǂ̃`FbNs
				//ʂ̃G[
				if(x < QGetRenderContext().pImage().CropWindowXMin() || y < QGetRenderContext().pImage().CropWindowYMin() ||
					x >= QGetRenderContext().pImage().CropWindowXMax() || y >= QGetRenderContext().pImage().CropWindowYMax())
					continue;
				//--܂
				
				CqColor col;
				//ʏ̏o͎wł΁A
				if( offset==0 ){
					//CqColor擾
					col = ((CqBucket)pBucket).getFColor(x,y);
				}
				//AOVł΁A
				else{
					//ValarrayIuWFNg擾
					Valarray val = ((CqBucket)pBucket).Data(x,y);
					
					//Offset̎wl擾
					float val0 = val.valueAt(offset+0);
					
					
					//ʎqIvVw肳ĂA
					// If special quantization instructions have been given for this display, do it now.
					if( !( m_QuantizeZeroVal == 0.0f &&
							m_QuantizeOneVal  == 0.0f &&
							m_QuantizeMinVal  == 0.0f &&
							m_QuantizeMaxVal  == 0.0f ) )
					{
						val0 = quantize(val0);
					}
					
					//擾lCqColor𐶐ASẴ`lɓl
					col = new CqColor( val0, val0, val0 );
				}

				imageData[y - QGetRenderContext().pImage().CropWindowYMin()][x - QGetRenderContext().pImage().CropWindowXMin()] = new CqColor(col);
			}
		}
	}
	
	/**
	 * HDRp̉摜Ԃ
	 */
	public CqColor[][] getImage() {
		return imageData;
	}
	
	/** 
	 * tB[h̏sB
	 * setBucketsOɕKĂ΂KvB
	 */
	public void init() {
//		width = QGetRenderContext() .optCurrent().GetIntegerOption( "System", "Resolution" ) [ 0 ];		//image̕擾
//		height = QGetRenderContext() .optCurrent().GetIntegerOption( "System", "Resolution" ) [ 1 ];	//image̍擾
		super.init();
		imageData = new CqColor[height][width];
	}

}
