/* Simple argument-parsing class
 * Copyright (C) 2001 Patrick E. Pelletier <ppelleti@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.argparse;

import net.cellcomputing.himawari.accessory.STLVector;

/**
 * IvV̏ڍ׃p[^(String^E)̐ݒsNXB
 * @author NTT DATA Corporation
 */
strictfp public class StringsHandler extends OptionHandler
{	
	/**
	 * IvVɑ镡̏ڍ׃p[^
	 */
	public STLVector<String> value;
	
	/**
	 * RXgN^
	 * @param usage_in	IvV
	 * @param value_in	IvV̏ڍ׃p[^
	 * @param separator_in	IvV͏
	 * @param count_in	ڍׂσp[^̐
	 */
	public StringsHandler(String usage_in, STLVector<String>  value_in,
										int separator_in, int count_in)
	{
		super(usage_in, separator_in, count_in);
		value = value_in;
	}

	/**
	 * ^ꂽIvVɑ΂郁bZ[WԂB
	 * @return ""
	 * @see net.cellcomputing.himawari.argparse.OptionHandler#handlearg(java.lang.String)
	 */
	public String handlearg(String arg)
	{
		value.add(arg);
		count -= (count == -1)? 0 : 1;
	    return "";
	}
}
