/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.accessory;

/**
 * 
 * inti[valarrayNX
 * 
 * @author NTT DATA Corporation
 */
public strictfp class ValarrayInt {

private static final long serialVersionUID = 22387720686191143L;
	
	private int[] array;

	
	
	public ValarrayInt() {
		array = new int[0];
	}
	
	public ValarrayInt( int size ){
		array = new int[size];
	}
	
	public ValarrayInt( int def,int size ){
		array = new int[size];
		for( int i=0; i<size; i++ ){
			array[i] = def;
		}
	}
	
	public int size(){
		return array.length;
	}
	
	public void resize( int size, int def ){
		array = new int[size];
		for( int i=0; i<size; i++ ){
			array[i] = def;
		}
	}
	
	public void resize( int size ){
		array = new int[size];
	}
	
	public int valueAt( int index ){
		assert( index < array.length );
		
		return array[index];
	}
	
	public void setValueAt( int index, int val ){
		assert( index < array.length );
		
		array[index] = val;
	}
	
	
	public void assignment( ValarrayInt val ){
		assert( this.size() == val.size() );
		
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] = val.array[i];
		}
	}
	
	public void assignment( int val ){
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] = val;
		}
	}
	
	public void assignAdd( ValarrayInt val ){
		assert( this.size() == val.size() );
		
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] += val.array[i];
		}
	}
	
	public void assignAdd( int val ){
		
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] += val;
		}
	}
	
	public void assignSub( ValarrayInt val ){
		assert( this.size() == val.size() );
		
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] -= val.array[i];
		}
	}
	
	public void assignSub( int val ){
		
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] -= val;
		}
	}
	
	public void assignMul( ValarrayInt val ){
		assert( this.size() == val.size() );
		
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] *= val.array[i];
		}
	}
	
	public void assignMul( int val ){
		
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] *= val;
		}
	}
	
	public void assignDiv( ValarrayInt val ){
		assert( this.size() == val.size() );
		
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] /= val.array[i];
		}
	}
	
	public void assignDiv( int val ){
		
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] /= val;
		}
	}
	
	public ValarrayInt add( ValarrayInt val ){
		assert( this.size() == val.size() );
		
		int size = array.length;
		
		ValarrayInt ret = new ValarrayInt( size );
		for( int i=0; i<size; i++ ){
			ret.array[i] = this.array[i] + val.array[i];
		}
		
		return ret;
	}
	
	public ValarrayInt add( int val ){
		int size = array.length;
		
		ValarrayInt ret = new ValarrayInt( size );
		for( int i=0; i<size; i++ ){
			ret.array[i] = this.array[i] + val;
		}
		
		return ret;
	}
	
	public ValarrayInt sub( ValarrayInt val ){
		assert( this.size() == val.size() );
		
		int size = array.length;
		
		ValarrayInt ret = new ValarrayInt( size );
		for( int i=0; i<size; i++ ){
			ret.array[i] = this.array[i] - val.array[i];
		}
		
		return ret;
	}
	
	public ValarrayInt sub( int val ){
		int size = array.length;
		
		ValarrayInt ret = new ValarrayInt( size );
		for( int i=0; i<size; i++ ){
			ret.array[i] = this.array[i] - val;
		}
		
		return ret;
	}
	
	public ValarrayInt mul( ValarrayInt val ){
		assert( this.size() == val.size() );
		
		int size = array.length;
		
		ValarrayInt ret = new ValarrayInt( size );
		for( int i=0; i<size; i++ ){
			ret.array[i] = this.array[i] * val.array[i];
		}
		
		return ret;
	}
	
	public ValarrayInt mul( int val ){
		int size = array.length;
		
		ValarrayInt ret = new ValarrayInt( size );
		for( int i=0; i<size; i++ ){
			ret.array[i] = this.array[i] * val;
		}
		
		return ret;
	}
	
	public ValarrayInt div( ValarrayInt val ){
		assert( this.size() == val.size() );
		
		int size = array.length;
		
		ValarrayInt ret = new ValarrayInt( size );
		for( int i=0; i<size; i++ ){
			ret.array[i] = this.array[i] / val.array[i];
		}
		
		return ret;
	}
	
	public ValarrayInt div( int val ){
		int size = array.length;
		
		ValarrayInt ret = new ValarrayInt( size );
		for( int i=0; i<size; i++ ){
			ret.array[i] = this.array[i] / val;
		}
		
		return ret;
	}
	
}
