// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.shadervm;

import static net.cellcomputing.himawari.library.EqIntIndex.SHD_Var_varying_init;
import static net.cellcomputing.himawari.library.EqIntIndex.SHD_var_varying_string;
import net.cellcomputing.himawari.accessory.STLArray;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_boolean;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.IqShaderData;

/**
 * CqShaderVariableVaryingNXStringɓ
 * NX
 * @author NTT DATA Corporation
 */
public strictfp class CqShaderVariableVaryingString extends CqShaderVariableVarying<p_String> {
	
	/**
	 * RXgN^B
	 * Vector̔z1ɃZbgāA
	 * vXVB
	 */
	public CqShaderVariableVaryingString( )
	{
		super(new EqVariableType(EqVariableType.type_string));
		//Ϗ̂
		//m_aValue = new STLVector<p_String>(p_String.class);
		m_aValue = new STLArray<p_String>(p_String.class);
		m_aValue.resize( 1 );
		CqStats.STATS_INC( SHD_var_varying_string );
	}
	
	/**
	 * RXgN^B
	 * Vector̔z1ɃZbgāA
	 * vXVB
	 * 
	 * @param strName
	 * @param fParameter
	 */
	public CqShaderVariableVaryingString(final String strName, boolean fParameter)
	{
		super(strName,fParameter,new EqVariableType(EqVariableType.type_string));
		//Ϗ̂
//		m_aValue = new STLVector<p_String>(p_String.class);
		m_aValue = new STLArray<p_String>(p_String.class);
		m_aValue.resize( 1 );
		CqStats.STATS_INC( SHD_var_varying_string );
	}
	
	/**
	 * RXgN^B
	 * Vector̔z1ɃZbgāA
	 * vXVB
	 * 
	 * @param strName
	 */
	public CqShaderVariableVaryingString(final String strName){
		this(strName,false);
	}
	
	/**
	 * Rs[RXgN^
	 * @param val
	 */
	public CqShaderVariableVaryingString(CqShaderVariableVaryingString val){
		super(val,new EqVariableType(EqVariableType.type_string));
		//qNXŎ
//		m_aValue = new STLVector<p_String>(p_String.class);
		m_aValue = new STLArray<p_String>(p_String.class);
		m_aValue.resize( val.m_aValue.size() );
		//R[hɏC 2005/11/2 nttdata
		for(int i = 0; i < val.m_aValue.size(); i++)
			m_aValue.elementAt(i).value = val.m_aValue.elementAt(i).value;
	}
	
	/**
	 * u=vZq̃I[o[[h
	 *  Vector̒lRs[B
	 * @param From
	 */
	public void assignment(CqShaderVariableVarying From) {
		// use std::vector assignment
//		m_aValue = From.m_aValue;
		m_aValue.resize(From.m_aValue.size());
		for(int i = 0; i < From.m_aValue.size();i++){
			m_aValue.elementAt(i).value = ((p_String)From.m_aValue.elementAt(i)).value;
		}
		
	}
	
	/**
	 * eNXŒ`ꂽ֐
	 * Vector̃TCY1ȏł
	 * w肳ꂽ擪̒lVector𖄂ߐsB
	 * Vector̃TCY0ȉł΁A
	 * lŖߐsB
	 * 
	 * ߐs(uGridRes+1) * (vGridRes)B
	 * 
	 * @param uGridRes
	 * @param vGridRes
	 */
	public void Initialise(int uGridRes, int vGridRes) {
		p_String Def = new p_String();
		
		if ( m_aValue.size() > 0 )
			Def.value = m_aValue.elementAt(0).value;
		
		if( Def.equals("") )
		{
			m_aValue.resize( (( uGridRes + 1 ) * ( vGridRes + 1 )) );
		}
		else
		{
			m_aValue.assign( (( uGridRes + 1 ) * ( vGridRes + 1 )), Def );
		}
		
		//܂
		CqStats.STATS_INC( SHD_Var_varying_init );
		
	}
	/**
	 * w肳ꂽꏊShaderData̒l擾
	 * @param res 擾li[ϐ
	 * @param index 擾ꏊ
	 */
	public	void	GetString( p_String res, int index)
	{
		res.value = m_aValue.elementAt( index ).value;
	}
	
	/**
	 * ShaderData̎AString^̃|C^擾B
	 * 
	 * @param res ʂi[BgύXShaderData̒le󂯂
	 */
	public	void	GetStringPtr( STLVector<p_String> res )
	{
		res.resize(m_aValue.size());
		for(int i=0;i < m_aValue.size();i++){
			res.setElementAt(m_aValue.elementAt(i),i);
		}
	}
	//public	STLVector<p_String>	GetStringPtr_2( )
	public	STLArray<p_String>	GetStringPtr_2( )
	{
		return m_aValue;
	}
	
	/**
	 * ShaderData̎w肳ꂽꏊ̒lύXB
	 * 
	 * @param s ύXl
	 * @param index ύXꏊ
	 */
	public	void	SetString( final String s, int index )
	{
		m_aValue.elementAt( index ).value = s;
	}
	
	/**
	 * ShaderData̒lύXB
	 * Ŏw肳ꂽlVector𖄂ߐs
	 * @param s ύXl
	 */
	public	void	SetString( final String s )
	{
		m_aValue.assign( m_aValue.size(), new p_String(s) );
	}
	
	/** Copy the values from the passed variable into this, taking into account any class differences.
	 * Ŏw肳ꂽϐlARs[B
	 * Rs[̃TCY1ȉ̏ꍇ́A̒l
	 * Vector̒Rs[B
	 *  
	 * Rs[Vector̃TCY1傫
	 * Vector̃TCY菬ꍇErrorƂȂB
	 * @param pVal The variable to copy from.
	 */
	public	void	SetValueFromVariable( final IqShaderData pVal )
	{
		int i;
		if ( pVal.Size() > 1 )
		{
//			STLVector<p_String> pData = new STLVector<p_String>(p_String.class);
//			pVal.GetStringPtr( pData );
			//STLVector<p_String> pData = new STLVector<p_String>(p_String.class);
			STLArray<p_String> pData = new STLArray<p_String>(p_String.class);
			pData = pVal.GetStringPtr_2( );
			
			for ( i = 0; i < Size(); i++ )
				m_aValue.elementAt( i ).value = pData.elementAt( i ).value;
		}
		else
		{
			p_String temp = new p_String();
			pVal.GetString( temp );
			m_aValue.assign( m_aValue.size(), temp );
		}
	}
	
	/**
	 * indexŎw肳ꂽꏊ̒lA""łtrue
	 * ȊOȂfalse1Ɋi[B
	 * 
	 * @param res ʂi[ϐ
	 * @param index zԍ
	 */
	public void	GetBool( p_boolean res, int index)
	{
		res.value = m_aValue.elementAt( index ).value.compareTo( "" ) == 0;
	}
	/** 
	 * Set the all SIMD data ased on a state vector, only indexes whose bit is set are modified.
	 * Ŏw肳ꂽϐVector̎w肳ꂽꏊ̒l
	 * gVector̓ꏊɃRs[B
	 * 
	 * AgA܂̓Rs[̎Vector̒ȏ̏ꏊw肷
	 * G[B
	 * @param pVal Rs[ The stack entry to assign.
	 * @param index Rs[ꏊ Integer SIMD index.
	 */
	public	void	SetValueFromVariable( final IqShaderData pVal, int index )
	{
		pVal.GetString( m_aValue.elementAt( index ), index );
	}
	
	/**
	 * ƓlCX^XԂ
	 * 
	 * @return g̃Rs[
	 */
	public	IqShaderData Clone()
	{
		CqShaderVariableVaryingString newVar = new CqShaderVariableVaryingString( this );
		newVar.SetSize( (int) Size() );
		newVar.SetValueFromVariable( this );
		return ( newVar );
	}
	
}
