// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.shadervm;

import static java.lang.Math.*;
import java.io.IOException;
import java.io.StreamTokenizer; 
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.LinkedList;

import net.cellcomputing.himawari.accessory.STLArray;
import net.cellcomputing.himawari.accessory.STLArrayList;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_boolean;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.accessory.primitive.p_long;
import net.cellcomputing.himawari.library.CqParameter;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.EqShaderType;
import net.cellcomputing.himawari.library.EqVariableClass;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.IqShader;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.IqShaderExecEnv;
import net.cellcomputing.himawari.library.IqSurface;
import net.cellcomputing.himawari.library.types.CqBitVector;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.shaderexecenv.CqShaderExecEnv;
import net.cellcomputing.himawari.util.HimawariLogger;

import static net.cellcomputing.himawari.library.EqVariableType.*;
import static net.cellcomputing.himawari.library.EqVariableClass.*;
import static net.cellcomputing.himawari.library.EqIntIndex.*;
import static net.cellcomputing.himawari.library.RiGlobal.*;
import static net.cellcomputing.himawari.shaderexecenv.GlobalShaderExecEnv.*;
import static net.cellcomputing.himawari.shadervm.EqSegment.*;
import static net.cellcomputing.himawari.shadervm.GlobalShaderVM.*;

/**
 * 
 * 
 * 
 * @author NTT DATA Corporation
 */
@SuppressWarnings("unused")
//public class CqShaderVM extends CqDSORepository implements IqShader, CqShaderStack
public strictfp class CqShaderVM implements IqShader, CqShaderStack
{
	
	private HimawariLogger logger = HimawariLogger.getLogger();
	
	public CqShaderVM()
	{
		CqShaderStack();
		m_Uses = 0xFFFFFFFF;
		m_LocalIndex =  0 ;
		m_PC = new STLVector<UsProgramElement>(UsProgramElement.class);
//		m_PC = new STLArrayList<UsProgramElement>(UsProgramElement.class);
		m_PCindex = 0;
		
		m_fAmbient =  true;
	}
	public     CqShaderVM( final CqShaderVM From )
	{
		CqShaderStack();
		m_LocalIndex =  0 ;
		m_PC = new STLVector<UsProgramElement>(UsProgramElement.class);
//		m_PC = new STLArrayList<UsProgramElement>(UsProgramElement.class);
		m_PCindex = 0;
		
		m_fAmbient = true ;
	    this.assignment( From );
	}
	public  void destruct()
    {
		CqShaderStackdestract();
        // Delete the local variables.
//        for ( std::vector<IqShaderData*>::iterator i = m_LocalVars.begin(); i != m_LocalVars.end(); i++ )
		m_LocalVars.clear();
//		for ( IqShaderData i :  m_LocalVars )  
//			if ( ( i ) != null )  i = null;
    }


	    // Overidden from IqShader
    public	CqMatrix matCurrent()
    {
        return ( m_matCurrent );
    }
    public	void	SetstrName( final String strName )
    {
        m_strName = strName;
    }
    
    public	final String strName()
    {
        return ( m_strName );
    }
    
    public void SetArgument( final String strName, EqVariableType type, final String strSpace, Object pval )
    {
    	//   	 Find the relevant variable.
        int i = FindLocalVarIndex( strName );
        if ( i >= 0 )
        {
            int index = 0, count = 1, arrayindex = 0;
            IqShaderData pArray = null;

            if ( m_LocalVars.get( i ).ArrayLength() > 0 )
            {
                pArray = m_LocalVars.get( i );
                count = pArray.ArrayLength();
            }

            // Ensure that the type passed matches what the variable expects.
            if( m_LocalVars.get( i ).Type().getValue() == type.getValue() )
            {
                while ( count-- > 0 )
                {
                    IqShaderData pVMVal = CreateTemporaryStorage(type, new EqVariableClass(class_uniform) );
                    switch ( m_LocalVars.get( i ).Type().getValue() )
                    {
                    case	type_float:
                        {
                            pVMVal.SetFloat( ((p_float[])( pval ))[ index++ ].value );
                        }
                        break;

                    case	type_point:
                        {
                            p_float[] pvecval = (p_float[])( pval );
                            pVMVal.SetPoint( new CqVector3D( pvecval[ index + 0 ].value, pvecval[ index + 1 ].value, pvecval[ index + 2 ].value ) );
                            index += 3;
                        }
                        break;

                    case	type_normal:
                        {
                            p_float[] pvecval = (p_float[])( pval );
                            pVMVal.SetNormal( new CqVector3D( pvecval[ index + 0 ].value, pvecval[ index + 1 ].value, pvecval[ index + 2 ].value ) );
                            index += 3;
                        }
                        break;

                    case	type_vector:
                        {
                            p_float[] pvecval = (p_float[])( pval );
                            pVMVal.SetVector( new CqVector3D( pvecval[ index + 0 ].value, pvecval[ index + 1 ].value, pvecval[ index + 2 ].value ) );
                            index += 3;
                        }
                        break;

                    case	type_color:
                        {
                            p_float[] pvecval = (p_float[])( pval );
                            pVMVal.SetColor( new CqColor( pvecval[ index + 0 ].value, pvecval[ index + 1 ].value, pvecval[ index + 2 ].value ) );
                            index += 3;
                        }
                        break;

                    case	type_matrix:
                        {
                    		p_float[] pvecval = (p_float[])( pval );
                            pVMVal.SetMatrix( new CqMatrix( pvecval[ index + 0 ].value, pvecval[ index + 1 ].value, pvecval[ index + 2 ].value, pvecval[ index + 3 ].value,
                                                         pvecval[ index + 4 ].value, pvecval[ index + 5 ].value, pvecval[ index + 6 ].value, pvecval[ index + 7 ].value,
                                                         pvecval[ index + 8 ].value, pvecval[ index + 9 ].value, pvecval[ index + 10 ].value, pvecval[ index + 11 ].value,
                                                         pvecval[ index + 12 ].value, pvecval[ index + 13 ].value, pvecval[ index + 14 ].value, pvecval[ index + 15 ].value ) );
                            index += 16;
                        }
                        break;

                    case	type_string:
                        {
                            pVMVal.SetString( ( (p_String[])( pval ) )[ index++ ].value );
                        }
                        break;

                    default: // Clear up warnings
                        break;
                    }

                    CqMatrix matObjectToWorld = matCurrent();
                    if( m_pEnv != null )
                    	matObjectToWorld.assignment( m_pEnv.pTransform().matObjectToWorld(m_pEnv.pTransform().Time(0)) );
                    
                    // If it is a color or a point, ensure it is the correct 'space'
                    if ( m_LocalVars.get( i ).Type().getValue() == type_point || m_LocalVars.get( i ).Type().getValue() == type_hpoint )
                    {
                        String _strSpace =  "shader" ;
                        if ( strSpace.compareTo( "" ) != 0 )
                            _strSpace = strSpace;
                        CqVector3D p = new CqVector3D();
                        pVMVal.GetPoint( p, 0 );
                        pVMVal.SetPoint( QGetRenderContextI().matSpaceToSpace( _strSpace, "camera", matCurrent(), matObjectToWorld, QGetRenderContextI().Time() ).multiply( p ) );
                    }
                    else if ( m_LocalVars.get( i ).Type().getValue() == type_normal )
                    {
                    	String _strSpace =  "shader" ;
                        if ( strSpace.compareTo( "" ) != 0 )
                            _strSpace = strSpace;
                        CqVector3D p = new CqVector3D();
                        pVMVal.GetNormal( p, 0 );
                        pVMVal.SetNormal( QGetRenderContextI().matNSpaceToSpace( _strSpace, "camera", matCurrent(), matObjectToWorld, QGetRenderContextI().Time() ).multiply( p ) );
                    }
                    else if ( m_LocalVars.get( i ).Type().getValue() == type_vector )
                    {
                    	String _strSpace =  "shader" ;
                        if ( strSpace.compareTo( "" ) != 0 )
                            _strSpace = strSpace;
                        CqVector3D p = new CqVector3D();
                        pVMVal.GetVector( p, 0 );
                        pVMVal.SetVector( QGetRenderContextI().matVSpaceToSpace( _strSpace, "camera", matCurrent(), matObjectToWorld, QGetRenderContextI().Time() ).multiply( p ) );
                    }
                    else if ( m_LocalVars.get( i ).Type().getValue() == type_matrix )
                    {
                    	String _strSpace =  "shader" ;
                        if ( strSpace.compareTo( "" ) != 0 )
                            _strSpace = strSpace;
                        CqMatrix m = new CqMatrix();
                        pVMVal.GetMatrix( m, 0 );
                        pVMVal.SetMatrix( QGetRenderContextI().matVSpaceToSpace( _strSpace, "camera", matCurrent(), matObjectToWorld, QGetRenderContextI().Time() ).multiply( m ) );
                    }

                    if ( pArray != null )
                        pArray.ArrayEntry( arrayindex++ ).SetValueFromVariable( pVMVal );
                    else
                        m_LocalVars.get( i ).SetValueFromVariable( pVMVal );

                    DeleteTemporaryStorage(pVMVal);
                }
            }
            else
            {
            	logger.warning("Type mismatch in shader \"" + m_strName + "\" \n");
            }
        }
        else
        {
        	logger.warning("Unknown parameter \"" + strName + "\" in shader \"" + m_strName + "\" \n");
        }
    }
	    
    public	void	SetArgument( CqParameter pParam, IqSurface pSurface )
    {
        // Find the relevant variable.
        int i = FindLocalVarIndex( pParam.strName() );
        if ( i >= 0 )
        {
            /// \todo: Find out how to handle arrays.
            IqShaderData pVar = m_LocalVars.get( i );
            pParam.Dice(m_uGridRes,m_vGridRes,pVar,pSurface);
        }
    }
    
    public	IqShaderData	FindArgument( final String name )
    {
        // Find the relevant variable.
        int i = FindLocalVarIndex( name );
        if ( i >= 0 )
            return( m_LocalVars.get( i ) );
        else
            return( null );
    }

    public	boolean	GetValue( final String name, IqShaderData res )
    {
        // Find the relevant variable.
        int i = FindLocalVarIndex( name );
        if ( i >= 0 )
        {
            res.SetValueFromVariable( m_LocalVars.get( i ) );
            return ( true );
        }
        return ( false );
    }
    
    public	void	Evaluate( final IqShaderExecEnv pEnv )
    {
        Execute( pEnv );
    }
    public	void	PrepareDefArgs()
    {
        ExecuteInit();
    }
//  ---------------------------------------------------------------------
    /**	Ready the shader for execution.
    */
    public void	Initialise( final int uGridRes, final int vGridRes, final IqShaderExecEnv pEnv )
    {
        m_pEnv = pEnv;
        // Initialise local variables.
        int i;
        for ( i = m_LocalVars.size() - 1; i >= 0; i-- )
            m_LocalVars.get( i ).Initialise( uGridRes, vGridRes );

        m_uGridRes = uGridRes;
        m_vGridRes = vGridRes;

        // Reset the program counter.
        m_PC = new STLVector<UsProgramElement>(UsProgramElement.class);
//        m_PC = new STLArrayList<UsProgramElement>(UsProgramElement.class);
        m_PCindex = 0;
        //m_PC.reset();
    }
    public	boolean	fAmbient()
    {
        return ( m_fAmbient );
    }
    public	IqShader Clone()
    {
        CqShaderVM pShader = new CqShaderVM( this );
        pShader.ExecuteInit();
        return ( pShader );
    }
    
    public boolean	Uses( int Var )
    {
    	// 炩ɖ[vȂ̂Ŋ댯Ȃ̂ŏĂ܂B
//        assert( Var >= 0 && Var < EnvVars_Last );
//        return ( Uses( new EqEnvVars(Var).getValue() ) );
    	return false;
//        return ( Uses( static_cast<EqEnvVars>( Var ) ) );
    }
    public int	Uses()
    {
        return ( m_Uses );
    }
    
    final public IqShaderData CreateVariable( EqVariableType Type, EqVariableClass Class, final String name )
    {
    	return CreateVariable(Type, Class, name ,false,false);
    }
	final public IqShaderData CreateVariable( EqVariableType Type, EqVariableClass Class, final String name, boolean fArgument )
	{
		return CreateVariable(Type, Class, name ,false,false);
	}
	
    public IqShaderData CreateVariable( EqVariableType Type, EqVariableClass Class, final String name, boolean fParameter, boolean fOutput )
    {
        // Create a VM specific shader variable, which implements the IqShaderData interface,
        // based on the type and class specified.
        switch ( Type.getValue() )
        {
        case type_bool:    /* abviously they are missing here */
        case type_integer:
        case type_float:
            {
                switch ( Class.getValue() )
                {
                case class_varying:
                    return ( new CqShaderVariableVaryingFloat( name, fParameter ) );
                case class_uniform:
                    return ( new CqShaderVariableUniformFloat( name, fParameter ) );
                default: // Clear up compiler warnings
                    break;
                }
                assert( false );	// If we get here, something is wrong with the request.
                return ( null );
            }

        case type_point:
            {
                switch ( Class.getValue() )
                {
                case class_varying:
                    return ( new CqShaderVariableVaryingPoint( name, fParameter ) );
                case class_uniform:
                    return ( new CqShaderVariableUniformPoint( name, fParameter ) );
                default: // Clear up compiler warnings
                    break;
                }
                assert( false );	// If we get here, something is wrong with the request.
                return ( null );
            }

        case type_normal:
            {
                switch ( Class.getValue() )
                {
                case class_varying:
                    return ( new CqShaderVariableVaryingNormal( name, fParameter ) );
                case class_uniform:
                    return ( new CqShaderVariableUniformNormal( name, fParameter ) );
                default: // Clear up compiler warnings
                    break;
                }
                assert( false );	// If we get here, something is wrong with the request.
                return ( null );
            }

        case type_vector:
            {
                switch ( Class.getValue() )
                {
                case class_varying:
                    return ( new CqShaderVariableVaryingVector( name, fParameter ) );
                case class_uniform:
                    return ( new CqShaderVariableUniformVector( name, fParameter ) );
                default: // Clear up compiler warnings
                    break;
                }
                assert( false );	// If we get here, something is wrong with the request.
                return ( null );
            }

        case type_string:
            {
                switch ( Class.getValue() )
                {
                case class_varying:
                    return ( new CqShaderVariableVaryingString( name, fParameter ) );
                case class_uniform:
                    return ( new CqShaderVariableUniformString( name, fParameter ) );
                default: // Clear up compiler warnings
                    break;
                }
                assert( false );	// If we get here, something is wrong with the request.
                return ( null );
            }

        case type_color:
            {
                switch ( Class.getValue() )
                {
                case class_varying:
                    return ( new CqShaderVariableVaryingColor( name, fParameter ) );
                case class_uniform:
                    return ( new CqShaderVariableUniformColor( name, fParameter ) );
                default: // Clear up compiler warnings
                    break;
                }
                assert( false );	// If we get here, something is wrong with the request.
                return ( null );
            }

        case type_triple:
        case type_hpoint:
        case type_void:
            assert( false );	// We don't support triples in the engine as variables.
            return ( null );

        case type_matrix:
            {
                switch ( Class.getValue() )
                {
                case class_varying:
                    return ( new CqShaderVariableVaryingMatrix( name, fParameter ) );
                case class_uniform:
                    return ( new CqShaderVariableUniformMatrix( name, fParameter ) );
                default: // Clear up compiler warnings
                    break;
                }
                assert( false );	// If we get here, something is wrong with the request.
                return ( null );
            }
        default: // Clear up compiler warnings
            break;
        }
        assert( false );	// If we get here, something is wrong with the request.
        return ( null );
    }

//  ---------------------------------------------------------------------
    /**
     *  Function to create a local variable array for a specific shader
     */

    final public IqShaderData CreateVariableArray( EqVariableType Type, EqVariableClass Class, final String name, int Count )
    {
    	return CreateVariableArray( Type,  Class, name, Count ,false);
    }
    final public IqShaderData CreateVariableArray( EqVariableType Type, EqVariableClass Class, final String name, int Count, boolean fArgument )
	{
		return CreateVariableArray( Type,  Class, name, Count ,false,false);
	}
    public IqShaderData CreateVariableArray( EqVariableType VarType, EqVariableClass VarClass, final String name, int Count, boolean fParameter, boolean fOutput )
    {
        IqShaderData pVar = null;
        switch ( VarType.getValue() )
        {
        case type_float:
            if ( VarClass.getValue() == class_varying )
                pVar = new CqShaderVariableVaryingFloat( name, fParameter );
            else
                pVar = new CqShaderVariableUniformFloat( name, fParameter );
            break;

        case type_point:
            if ( VarClass.getValue() == class_varying )
                pVar = new CqShaderVariableVaryingPoint( name, fParameter );
            else
                pVar = new CqShaderVariableUniformPoint( name, fParameter );
            break;

        case type_normal:
            if ( VarClass.getValue() == class_varying )
                pVar = new CqShaderVariableVaryingNormal( name, fParameter );
            else
                pVar = new CqShaderVariableUniformNormal( name, fParameter );
            break;

        case type_vector:
            if ( VarClass.getValue() == class_varying )
                pVar = new CqShaderVariableVaryingVector( name, fParameter );
            else
                pVar = new CqShaderVariableUniformVector( name, fParameter );
            break;

        case type_color:
            if ( VarClass.getValue() == class_varying )
                pVar = new CqShaderVariableVaryingColor( name, fParameter );
            else
                pVar = new CqShaderVariableUniformColor( name, fParameter );
            break;

        case type_string:
            if ( VarClass.getValue() == class_varying )
                pVar = new CqShaderVariableVaryingString( name, fParameter );
            else
                pVar = new CqShaderVariableUniformString( name, fParameter );
            break;

        case type_matrix:
            if ( VarClass.getValue() == class_varying )
                pVar = new CqShaderVariableVaryingMatrix( name, fParameter );
            else
                pVar = new CqShaderVariableUniformMatrix( name, fParameter );
            break;
        default: // Clear up the warnings
            break;
        }
        CqShaderVariableArray pArray = new CqShaderVariableArray( name, Count, fParameter );
        //łƕs@ƎQƓn邩mFĂBԂ
        pArray.aVariables().set( 0 , pVar );
        int i;
        for ( i = 1; i < Count; i++ )
            pArray.aVariables().set( i , pVar.Clone() );

        return ( pArray );
    }
    
//  ---------------------------------------------------------------------
    /**
     *  Function to create a very temporary variable array for a specific shader
     */

    public IqShaderData CreateTemporaryStorage( EqVariableType type, EqVariableClass _class )
    {
        String strName =  "__temporary__" ;
        return ( CreateVariable( type, _class, strName ) );
    }
    
//  ---------------------------------------------------------------------
    /**
     *  Function to Delete the very temporary variable array for a specific shader
     */

    public void DeleteTemporaryStorage( IqShaderData pData )
    {
//        delete( pData );
    	pData.destruct();
    }
    
    public void DefaultSurface()
    {
        String	pDefSurfaceShader = " " +
        		"surface " +
        		"segment Data " +
        		"USES 460803 " +
        		"param uniform  float Kd " +
        		"param uniform  float Ka " +
        		"varying  float d " +
        		"segment Init " +
        		"pushif 0.8 " +
        		"pop Kd " +
        		"pushif 0.2 " +
        		"pop Ka " +
        		"segment Code " +
        		"pushv N " +
        		"normalize " +
        		"pushv I " +
        		"normalize " +
        		"dotpp " +
        		"pop d " +
        		"pushv d " +
        		"pushv d " +
        		"pushv Kd " +
        		"mulff " +
        		"mulff " +
        		"pushv Ka " +
        		"addff " +
        		"setfc " +
        		"pushv Cs " +
        		"mulcc " +
        		"pop Ci " +
        		"pushv Os " +
        		"pop Oi " +
        		"pushv Oi " +
        		"pushv Ci " +
        		"mulcc " +
        		"pop Ci "
        		;
        
        StreamTokenizer defStream = new StreamTokenizer( new StringReader(pDefSurfaceShader) );

        LoadProgram(defStream);
    }

//  ---------------------------------------------------------------------
    /**
     *  Shutdown the engine, releasing any static data it may hold on to during it's lifetime..
     */

    public static void ShutdownShaderEngine()
    {
        // Free any temporary variables in the buckets.
        if( !m_UFPool.isEmpty() )
        {
            m_UFPool.clear();
        }
        if( !m_VFPool.isEmpty() )
        {
            m_VFPool.clear();
        }

        if( !m_UPPool.isEmpty() )
        {
            m_UPPool.clear();
        }
        if( !m_VPPool.isEmpty() )
        {
            m_VPPool.clear();
        }

        if( !m_USPool.isEmpty() )
        {
            m_USPool.clear();
        }
        if( !m_VSPool.isEmpty() )
        {
            m_VSPool.clear();
        }

        if( !m_UCPool.isEmpty() )
        {
            m_UCPool.clear();
        }
        if( !m_VCPool.isEmpty() )
        {
            m_VCPool.clear();
        }

        if( !m_UNPool.isEmpty() )
        {
            m_UNPool.clear();
        }
        if( !m_VNPool.isEmpty() )
        {
            m_VNPool.clear();
        }

        if( !m_UVPool.isEmpty() )
        {
            m_UVPool.clear();
        }
        if( !m_VVPool.isEmpty() )
        {
            m_VVPool.clear();
        }

        if( !m_UMPool.isEmpty() )
        {
            m_UMPool.clear();
        }
        if( !m_VMPool.isEmpty() )
        {
            m_VMPool.clear();
        }
    }


    /** Load a program from a compiled slx file.
     *  RpCꂽslxt@CvO֓ǂݍށB
     */
    static int tmp = 0;
    public void LoadProgram( StreamTokenizer pFile )
    {
    	pFile.wordChars( '_', '_' );
    	pFile.wordChars( ':', ':' );
    	pFile.wordChars( '$', '$' );

    	p_String token = new p_String();
        EqSegment Segment = new EqSegment( EqSegment.Seg_Data );
        STLVector<UsProgramElement>	pProgramArea = null;
        STLVector<p_int>	aLabels = new STLVector<p_int>(p_int.class);
//        STLArrayList<UsProgramElement>	pProgramArea = null;
//        STLArrayList<p_int>	aLabels = new STLArrayList<p_int>(p_int.class);
        
        CqShaderExecEnv StdEnv = new CqShaderExecEnv();
        int	array_count = 0;
        long  htoken, j;
    	/*
    	 * Private hash key for the data types supported by the shaders
    	 */
    	STLVector<p_long> itypes = new STLVector<p_long>( p_long.class );
//    	STLArrayList<p_long> itypes = new STLArrayList<p_long>( p_long.class );
    	
        // Initialise the private hash keys.
        

    	for(j = 0; j < gcVariableTypeNames; j++)
    		itypes.add( new p_long(gVariableTypeNames[(int) j].hashCode()) );


        boolean fShaderSpec = false;
        //while ( pFile.nval != StreamTokenizer.TT_EOF )
        while ( GetToken( token, pFile ) != StreamTokenizer.TT_EOF )
        {
        	//GetToken( token, pFile );
          
            htoken = token.value.hashCode();

            // Check for type and version information.
            if ( !fShaderSpec )
            {
                int i;
                // static int tmp = 0;ɏĂB
                
                i = tmp;
                for ( ; i < gcShaderTypeNames; i++ )//tmpT[`܂
                {
                    if ( gShaderTypeNames[i].hash == 0 )
                    {
                        gShaderTypeNames[i].hash = gShaderTypeNames[i].name.hashCode();
                    }
                    if ( gShaderTypeNames[i].hash == htoken )
                    {
                        m_Type = gShaderTypeNames[i].type;
                        fShaderSpec = true;
                        tmp = i;
                        break;
                    }
                }
                if (fShaderSpec == false)//ڂŌȂ΍ŏT[`܂
                {
                   for (i = 0 ; i < tmp; i++ )
	                {
	                    if (gShaderTypeNames[i].hash == 0)
	                    {
	                    	//̕ɓ邱ƂȂ񂶂Ȃ̂ȁHԂ
	                           gShaderTypeNames[i].hash = gShaderTypeNames[i].name.hashCode();
	                    }
	                    if ( gShaderTypeNames[i].hash == htoken )
	                    {
	                        m_Type = gShaderTypeNames[i].type;
	                        fShaderSpec = true;
	                           tmp = i;
	                        break;
	                    }
	                }
                }
                if ( fShaderSpec ) continue;
            }

            if ( token.value.compareTo( "AQSIS_V" ) == 0 )
            {
            	try
            	{
	            	//GetToken( token, pFile );
	            	pFile.nextToken();
	            	float majer = (float) pFile.nval;
	            	
	            	pFile.nextToken();
	            	int miner = (int) pFile.nval;
	            	// Get the version information.
	                String strVersion = "" + majer + "." + miner;
            	}catch(Exception e)
            	{
            		HimawariLogger.outputException( e );
            	}
            	
                //TqInt vMaj, vMin, build;
                //GET_VERSION_FROM_STRING(vMaj,vMin,build);
                //if(CHECK_NEWER_VERSION(vMaj,vMin,build))
                //{
    			//	CqBasicError(0,Severity_Fatal,"SLX built by more recent version of Aqsis");
    			//	return;
                //}

                continue;
            }

            if ( ushash == htoken ) // == "USES"
            {
            	try {
					pFile.nextToken();
				} catch (IOException e) {
					HimawariLogger.outputException( e );
				}
                m_Uses = (int) pFile.nval ;
                continue;
            }

            if ( sehash == htoken ) // == "segment"
            {
                GetToken( token, pFile );
                htoken = token.value.hashCode();

                if ( dhash == htoken ) // == "Data"
                    Segment = new EqSegment( Seg_Data );
                else if ( ihash == htoken) // == "Init"
                {
                    Segment = new EqSegment( Seg_Init );
                    pProgramArea = m_ProgramInit;
                    aLabels.clear();
                }
                else if (cohash == htoken ) // == "Code"
                {
                    Segment = new EqSegment( Seg_Code );
                    pProgramArea = m_Program;
                    aLabels.clear();
                }
            }
            else
            {
                EqVariableType VarType = new EqVariableType( type_invalid );
                EqVariableClass VarClass = new EqVariableClass( class_varying );
                boolean			fVarArray = false;
                boolean			fParameter = false;
                boolean			fOutput = false;
                switch ( Segment.getValue() )
                {
                case Seg_Data:
                    VarType = new EqVariableType( type_invalid );
                    VarClass = new EqVariableClass( class_invalid );
                    while ( VarType.getValue() == type_invalid )
                    {
                        if ( ouhash == htoken) // == "output"
                            fOutput = true;
                        else if ( phash == htoken) // == "param"
                            fParameter = true;
                        else if ( vhash == htoken) // == "varying"
                            VarClass = new EqVariableClass( class_varying );
                        else if ( uhash == htoken) // == "uniform"
                            VarClass = new EqVariableClass( class_uniform );
                        else
                        {
                            int itype = 0;
                            for(itype = 0; itype<gcVariableTypeNames; itype++)
                                if ( htoken == itypes.get(itype).value ) // == gVariableTypeNames[itype]
                                {
                                    VarType = new EqVariableType(itype);
                                    break;
                                }
                        }
                        GetToken( token, pFile );
                        htoken = token.value.hashCode();
                    }
                    // C̎dg݂Ƃ܂Ȃ̂ŕύX@u`
                    try {
	                    if( pFile.nextToken() != 91)//"["ȊO̎̓vbVobN
	                    {
	                    	pFile.pushBack();
	                    }
	                    else//"["͔̎zƂď
	                    {
								pFile.nextToken();
								array_count = (int)pFile.nval;
								fVarArray = true;
								pFile.nextToken();//"["ǂݔ΂B
	                    }
                    } catch (IOException e) {
                    	logger.critical("Invalid variable specification in slx file");
                        return ;
					}
                    // Check for array type variable.
                    /*if ( token.value.charAt( token.value.length() - 1 ) == ']' )
                    {
                        int i = 0;
                        while ( i < token.value.length() && token.value.charAt( i ) != '[' ) i++;
                        if ( i == token.value.length() )
                        {
                            //CqBasicError( 0, Severity_Fatal, "Invalid variable specification in slx file" );
                            logger.critical("Invalid variable specification in slx file");
                            return ;
                        }
                        //token.charAt( token.length() - 1 ) = '\0';
                        //token.charAt( i ) = '\0';
                        
                        array_count = Integer.valueOf( token.value.charAt( i ) );
                        fVarArray = true;
                        token.value = token.value.substring(0,i);
                        i++;
                    }*/
                    // Check if there is a valid variable specifier
                    if ( VarType.getValue() == type_invalid ||
                            VarClass.getValue() == class_invalid )
                        continue;

                    if ( fVarArray )
                        AddLocalVariable( CreateVariableArray( VarType, VarClass, token.value, array_count, fParameter, fOutput ) );
                    else
                        AddLocalVariable( CreateVariable( VarType, VarClass, token.value, fParameter, fOutput ) );
                    break;

                case Seg_Init:
                case Seg_Code:
                    // Check if it is a label
                    if ( token.value.charAt(0) == ':' )// == 0 )
                    {
							float f;
							f = Float.valueOf( token.value.substring(1) );
							if ( aLabels.size() < ( f + 1 ) )
                            aLabels.resize( (int)( f ) + 1 );
                        	aLabels.get( (int)( f ) ).value = pProgramArea.size();
							try {
								AddCommand( this.getClass().getDeclaredMethod("SO_nop"), pProgramArea );
							} catch (SecurityException e) {
								HimawariLogger.outputException( e );
							} catch (NoSuchMethodException e) {
								HimawariLogger.outputException( e );
							}
                        
							break;
                    }
                    // Find the opcode in the translation table.
                    int i;
                    for ( i = 0; i < m_cTransSize; i++ )
                    {
                        if ( m_TransTable[ i ].m_hash == 0)
                        {
                            m_TransTable[ i ].m_hash = m_TransTable[ i ].m_strName.hashCode();
                        }

                        if ( ehash == htoken )
                        {
//                            String strFunc, strRetType, strArgTypes ;
//                            EqVariableType RetType;
//                            STLVector<EqVariableType> ArgTypes = new STLVector<EqVariableType>(EqVariableType.class);
//                            boolean error = false; // Error in DSO resolution
//
//                            strFunc = pFile.sval;
//                            strFunc = strFunc.substring(1,strFunc.length() - 2);
//                            STLVector<SqDSOExternalCall> candidates = null;
//                            m_itActiveDSOMap = m_ActiveDSOMap.find( strFunc );
//                            if( m_itActiveDSOMap != m_ActiveDSOMap.end() )
//                            {
//                                candidates = ( m_itActiveDSOMap ).second;
//                            }
//                            else
//                            {
//                                candidates = getShadeOpMethods(strFunc);
//                                if( candidates == null )
//                                {
//                                	logger.critical( "\"" + strName() + "\": No DSO found for external shadeop: \"" + strFunc + "\" \n" );
//                                    exit(1);
//                                }
//                                m_ActiveDSOMap[strFunc]=candidates;
//                            };
//
//                            // pick out the return type
//                            strRetType = pFile.sval;
//                            m_itTypeIdMap = m_TypeIdMap.find( strRetType[1] );
//                            if (m_itTypeIdMap != m_TypeIdMap.end())
//                            {
//                                RetType = (m_itTypeIdMap).second;
//                            }
//                            else
//                            {
//                                //error, we dont know this return type
//                            	logger.critical( "\"" + strName() + "\": Invalid return type in call to external shadeop: \"" + strFunc + "\" : \"" + strRetType + "\" \n" );
//                                exit(1);
//                            };
//
//                            strArgTypes = pFile.sval;
//                            for ( int x=1; x < strArgTypes.length()-1; x++ )
//                            {
//                                m_itTypeIdMap = m_TypeIdMap.find( strArgTypes[x] );
//                                if ( m_itTypeIdMap != m_TypeIdMap.end() )
//                                {
//                                    ArgTypes.push_back( ( m_itTypeIdMap ).second );
//                                }
//                                else
//                                {
//                                    // Error, unknown arg type
//                                	logger.critical( "\"" + strName() + "\": Invalid argument type in call to external shadeop: \"" + strFunc + "\" : \"" + strArgTypes[x] + "\" \n" );
//                                    exit(1);
//                                };
//
//                            };
//
//                            //Now we need to find a good candidate.
////                            std::list<SqDSOExternalCall*>::iterator candidate;
////                            candidate = candidates.begin();
//                            while (candidate !=candidates.end())
//                            {
//                                // Do we have a match
//                                if ((candidate).return_type == RetType &&
//                                                        (candidate).arg_types == ArgTypes) break;
//                                candidate++;
//                            };
//
//                            // If we are looking for a void return type but have not
//                            // found an exact match, we will take the first match with
//                            // suitable arguments and force the return value to be
//                            // discarded.
//                            boolean forcedrop = false;
//                            if(candidate == candidates.end() && RetType == type_void)
//                            {
//                                candidate = candidates.begin();
//                                while (candidate !=candidates.end())
//                                {
//                                    // Do we have a match
//                                    if ( (candidate).arg_types == ArgTypes)
//                                    {
//                                        String strProto = strPrototype(strFunc, (candidate));
//                                        logger.info( "\"" + strName() + "\": Using non-void DSO shadeop:  \"" + strProto + "\"" +
//                                        "\"" + strName() + "\": In place of requested void shadeop: \"" + strFunc + "\"" +
//                                        "\"" + strName() + "\": If this is not the operation you intended you should force the correct shadeop in your shader source.\n" );
//                                        forcedrop = true;
//                                        break;
//                                    };
//                                    candidate++;
//                                };
//                            }
//
//                            if(candidate == candidates.end())
//                            {
//                            	logger.critical( "\"" + strName() + "\": No candidate found for call to external shadeop: \"" + strFunc +
//                                "\"" + strName() + "\": Perhaps you need some casts?" +
//                                "\"" + strName() + "\": The following candidates are in you current DSO path: \n");
//                                candidate = candidates.begin();
//                                while (candidate !=candidates.end())
//                                {
//                                    CqString strProto = strPrototype(strFunc, (candidate));
//                                    logger.info( "\"" + strName + "\": \t" + strProto + "\n");
//                                    candidate++;
//                                };
//                                exit(1);
//                            };
//
//                            if(!(candidate).initialised )
//                            {
//                                // We have an initialiser we have not run yet
//                                if((candidate).init){
//                                    (candidate).initData =
//                                        ((candidate).init)((int)((Object)this),null);
//                                };
//                                (candidate).initialised = true;
//                            };
//
//                            AddCommand( SO_external, pProgramArea );
//                            AddDSOExternalCall( (candidate),pProgramArea );
//
//                            if( forcedrop )
//                                AddCommand( SO_drop, pProgramArea );
//
                            break;
                        }

                        if ( m_TransTable[ i ].m_hash == htoken)
                        {
                            // If the opcodes command pointer is 0, just ignore this opcode.
                            if ( m_TransTable[ i ].m_pCommand == null )//javaƃGNZvVԂ͂Ȃ̂ł肦ȂBیłB
                                break;

                            // If this is an 'illuminate' or 'solar' statement, then we can safely say this
                            // is not an ambient light.
                            if( "SO_illuminate".compareTo( m_TransTable[ i ].m_pCommand.getName() ) == 0 ||
                                "SO_illuminate2".compareTo( m_TransTable[ i ].m_pCommand.getName() ) == 0 ||
                                "SO_solar".compareTo( m_TransTable[ i ].m_pCommand.getName() ) == 0 ||
                                "SO_solar2".compareTo( m_TransTable[ i ].m_pCommand.getName() ) == 0 )
                                m_fAmbient = false;

                            // Add this opcode to the program segment.
                            AddCommand( m_TransTable[ i ].m_pCommand, pProgramArea );

                            // Process this opcodes parameters.
                            int p;
                            for ( p = 0; p < m_TransTable[ i ].m_cParams; p++ )
                            {
                                if ( m_TransTable[ i ].m_aParamTypes[ p ] == type_invalid )
                                {
                                    GetToken( token, pFile );
                                    int iVar;
                                    if ( ( iVar = FindLocalVarIndex( token.value ) ) >= 0 )// VF[_Ő錾ꂽϐɒlꍇ
                                        AddVariable( iVar, pProgramArea );
                                    else if ( ( iVar = StdEnv.FindStandardVarIndex( token.value ) ) >= 0 )// O[oƂĐ錾ꂽϐɒlꍇ
                                        AddVariable( iVar | 0x8000, pProgramArea );
                                    else//̑
                                        // TODO: Report error.
                                        AddVariable( 0, pProgramArea );
                                }
                                else
                                {
                                	try 
                                	{
	                                    switch ( m_TransTable[ i ].m_aParamTypes[ p ] )
	                                    {
	                                    case type_float:
											pFile.nextToken();
											float f;
	                                        //( pFile ) >> f;
	                                    	f = (float) pFile.nval ;
	                                    	
	                                    	//1e-006ǂݍނ߂ ǉ@
								            int nextToken = pFile.nextToken();
								            if (nextToken == StreamTokenizer.TT_WORD
								                && (pFile.sval.charAt(0) == 'e' || pFile.sval.charAt(0) == 'E')
								                && (Character.isDigit(pFile.sval.charAt(1)) || pFile.sval.charAt(1) == '-')) {
								                double exp = Double.parseDouble(pFile.sval.substring(1));
								                f = (float) (f * Math.pow(10.0, exp));
								            } else
								            	pFile.pushBack();
								    		//1e-006ǂݍނ߂ ǉ@܂
								    		
	                                        AddFloat( f, pProgramArea );
	                                        break;
	
	                                    case type_string:
											pFile.nextToken();
	                                    	char c;
	                                        String s = pFile.sval;
	                                        AddString( s, pProgramArea );
	                                        break;
	                                    }
	                                } catch (IOException e) {
	                                	HimawariLogger.outputException( e );
									}
                                }
                            }
                            break;
                        }
                    }
                    // If we have not found the opcode, throw an error.
                    if ( i == m_cTransSize )
                    {
                        String strErr =  "Invalid opcode found : " ;
                        strErr += token;
                        logger.critical( strErr + "\n");
                        return ;
                    }
                    break;
                }
            }
        }
        // Now we need to complete any label jump statements.
        int i = 0;
        while ( i < m_Program.size() )
        {
            UsProgramElement E = m_Program.get( i++ );
            if ( E.m_Command.getName().compareTo( "SO_jnz" ) == 0 ||
                 E.m_Command.getName().compareTo( "SO_jmp" ) == 0 ||
                 E.m_Command.getName().compareTo( "SO_jz" ) == 0 ||
                 E.m_Command.getName().compareTo( "SO_RS_JZ" ) == 0 ||
                 E.m_Command.getName().compareTo( "SO_RS_JNZ" ) == 0||
                 E.m_Command.getName().compareTo( "SO_S_JZ" ) == 0 ||
                 E.m_Command.getName().compareTo( "SO_S_JNZ" ) == 0 )
            {
                SqLabel lab = new SqLabel();
                lab.m_Offset = aLabels.get( (int)( m_Program.get( i ).m_FloatVal ) ).value;
                lab.m_pAddress = m_Program.get( lab.m_Offset );
                m_Program.get( i ).m_Label = lab;
                i++;
            }
            else
            {
                // Find the command so that we can skip the parameters
                int j1;
                for ( j1 = 0; j1 < m_cTransSize; j1++ )
                {
                    if ( m_TransTable[ j1 ].m_pCommand == E.m_Command )
                    {
                        i += m_TransTable[ j1 ].m_cParams;
                        break;
                    }
                }
            }
        }

    }
    
    
//  ---------------------------------------------------------------------
    /**	Execute a series of shader language bytecodes.
    */

    public void Execute( final IqShaderExecEnv pEnv )
    {
        // Check if there is anything to execute.
        if ( m_Program.size() <= 0 )
            return ;

        m_pEnv = pEnv;

        pEnv.InvalidateIlluminanceCache();

        // Execute the main program.
        m_PC = m_Program;
        m_PCindex = 0;
        m_PO = 0;
        m_PE = m_Program.size();
        UsProgramElement pE;

        while ( !fDone() )
        {
            pE = ReadNext( );
            try {
				pE.m_Command.invoke(this);
			} catch (Exception e) {
				HimawariLogger.outputException( e );
			}
        }
        // Check that the stack is empty.
        assert( m_iTop == 0 );
        m_Stack.clear();
    }
    
//  ---------------------------------------------------------------------
    /**	Execute the program segment which initialises the default values of instance variables.
    */

    public void ExecuteInit()
    {
        // Check if there is anything to execute.
        if ( m_ProgramInit.size() <= 0 )
            return ;

        // Fake an environment
        IqShaderExecEnv pOldEnv = m_pEnv;

        IqShaderExecEnv Env = new CqShaderExecEnv();
        Env.Initialise( 1, 1, null, null, this, m_Uses );
        Initialise( 1, 1, Env );

        // Execute the init program.
        m_PC = m_ProgramInit;
        m_PCindex = 0;
        m_PO = 0;
        m_PE = m_ProgramInit.size();
        UsProgramElement pE;

        while ( !fDone() )
        {
            pE = ReadNext( );
            try {
				pE.m_Command.invoke(this);
			} catch (Exception e) {
				HimawariLogger.outputException( e );
			}
        }
        // Check that the stack is empty.
        assert( m_iTop == 0 );
        m_Stack.clear();

        m_pEnv = pOldEnv;
    }
    
    
//  ---------------------------------------------------------------------
    /**
     * Begin changes to add accessors for libslxargs 
     */

    public int GetShaderVarCount()
    {
        return m_LocalVars.size();
    }
    
//  ---------------------------------------------------------------------
    /**
     *
     */

    public IqShaderData GetShaderVarAt(int varIndex)
    {
        IqShaderData result;
        result = null;
        if (varIndex >= 0)
        {
            if ((int) varIndex < m_LocalVars.size())
            {
                result = m_LocalVars.get( varIndex );
            }
        }
        return result;
    }
    
    public EqShaderType	Type()
    {
        return ( m_Type );
    }	// for libslxargs


    /** Assignment operator.
     */
    public CqShaderVM assignment( final CqShaderVM From )
    {
    	m_Uses = From.m_Uses;
        m_matCurrent.assignment( From.m_matCurrent );
        m_strName = From.m_strName;
        m_fAmbient = From.m_fAmbient;

        // Copy the local variables...
//        std::vector<IqShaderData*>::const_iterator i;
        for ( IqShaderData i : From.m_LocalVars )
            m_LocalVars.add( ( i ).Clone() );

        // Copy the intialisation program.
//        std::vector<UsProgramElement>::const_iterator p;
        for ( UsProgramElement p : From.m_ProgramInit )
        	m_ProgramInit.add( p );

        // Copy the main program.
        for ( UsProgramElement p : From.m_Program )
        	m_Program.add( p );

        return ( this );
    }


    private int	m_Uses;			///< Bit vector representing the system variables used by this shader.
    private CqMatrix	m_matCurrent = new CqMatrix();	///< Transformation matrix to world coordinates in effect at the time this shader was instantiated.
    private String	m_strName = new String();		///< The name of this shader.

    private EqShaderType m_Type = new EqShaderType(0);							///< Shader type for libslxargs
    private long	m_LocalIndex;                   ///<  Local Index to speed up
    private IqShaderExecEnv	m_pEnv;							///< Pointer to the current excution environment.
    private STLVector<IqShaderData>	m_LocalVars = new STLVector<IqShaderData>(IqShaderData.class);		///< Array of local variables.
    private STLVector<UsProgramElement>	m_ProgramInit = new STLVector<UsProgramElement>(UsProgramElement.class);		///< Bytecodes of the intialisation program.
    private STLVector<UsProgramElement>	m_Program = new STLVector<UsProgramElement>(UsProgramElement.class);			///< Bytecodes of the main program.
//    private STLArrayList<IqShaderData>	m_LocalVars = new STLArrayList<IqShaderData>(IqShaderData.class);		///< Array of local variables.
//    private STLArrayList<UsProgramElement>	m_ProgramInit = new STLArrayList<UsProgramElement>(UsProgramElement.class);		///< Bytecodes of the intialisation program.
//    private STLArrayList<UsProgramElement>	m_Program = new STLArrayList<UsProgramElement>(UsProgramElement.class);			///< Bytecodes of the main program.
   
    private int	m_uGridRes;
    private int	m_vGridRes;
//    private UsProgramElement	m_PC ;							///< Current program pointer.
    private STLVector<UsProgramElement>	m_PC ;	///< Current program pointer.
    private int m_PCindex;
    private int	m_PO;							///< Current program offset.
    private int	m_PE;							///< Offset of the end of the program.
    private boolean	m_fAmbient;						///< Flag indicating if this is an ambient light source ( if it is indeed a light source ).

    /** Determine whether the program execution has finished.
     */
    private boolean	fDone()
    {
        return ( m_PO >= m_PE );
    }
    /** Get the next program element from storage.
     * @return Reference to the next program element.
     */
    private UsProgramElement ReadNext()
    {
        m_PO++; return ( m_PC.get(m_PCindex++) );
    }
    /** Get a shader variable by index.
     * @param Index Integer index, top bit indicates system variable.
     * @return Pointer to a IqShaderData derived class.
     */
    private IqShaderData	GetVar( int Index )
    {
        if ( ( Index & 0x8000 ) != 0)
            return ( m_pEnv.pVar( Index & 0x7FFF ) );
        else
            return ( m_LocalVars.get( Index ) );
    }
    /** Add a variable to the list of local ones.
     * @param pVar Pointer to a IqShaderData derived class.
     */
    private void	AddLocalVariable( IqShaderData pVar )
    {
        m_LocalVars.add( pVar );
    }
    /** Find the index of a named shader variable.
     * @param strName Character pointer to the name.
     * @return Index of local variable or -1.
     */
    private int	FindLocalVarIndex( final String strName )
    {
        long tmp = m_LocalIndex;
        long hash = strName.hashCode();

        for ( ; m_LocalIndex < m_LocalVars.size(); m_LocalIndex++ )
            if ( m_LocalVars.get( (int)m_LocalIndex ).strName().hashCode()  == hash ) return ( (int)m_LocalIndex );

        for ( m_LocalIndex = 0; m_LocalIndex < tmp; m_LocalIndex++ )
            if ( m_LocalVars.get( (int)m_LocalIndex ).strName().hashCode() == hash ) return ((int) m_LocalIndex );
        return ( -1 );
    }


//  ---------------------------------------------------------------------
    /** Load a token from a compiled slx file.
     * dlύXÃg[NƂĂ邾Ȃ̂JavałStreamTokenizergpĂ܂B
     * 
     */
//    void CqShaderVM::GetToken( char* token, TqInt l, std::istream* pFile )
    public int GetToken( p_String token, StreamTokenizer pFile )
    {
    	int STtype = -1;
    	try 
    	{
    		STtype = pFile.nextToken();
    	
	    	if( STtype == StreamTokenizer.TT_WORD)
	    	{
	    		token.value = pFile.sval;
	    	}
	    	else
	    	{
	    		token.value = String.valueOf( pFile.nval );
	    	}
    	
    	} catch (IOException e) {
    		HimawariLogger.outputException( e );
    	}
    	return STtype;
//        char c;
//        int i = 0;
//        ( *pFile ) >> std::ws;
//        c = pFile.get();
//        if ( c == ':' && i == 0 )
//        {
//            token[ 0 ] = c;
//            token[ 1 ] = '\0';
//            return ;	// Special case for labels.
//        }
//        while ( notspace( c ) && i < l - 1 )
//        {
//            token[ i++ ] = c;
//            token[ i ] = '\0';
//            c = pFile.get();
//        }
    }
    
    /** Add a command to the program data area.
     * @param pCommand Pointer to the opcode function.
     * @param pProgramArea Pointer to the program area, either init, or main code areas.
     */
    private void	AddCommand( Method pCommand, STLVector<UsProgramElement> pProgramArea )
//    private void	AddCommand( Method pCommand, STLArrayList<UsProgramElement> pProgramArea )
    {
        UsProgramElement E = new UsProgramElement();
        E.m_Command = pCommand;
        pProgramArea.add( E );
    }
    /** Add an absolute float value to the program data area.
     * @param f Float value to add.
     * @param pProgramArea Pointer to the program area, either init, or main code areas.
     */
    private void	AddFloat( float f, STLVector<UsProgramElement> pProgramArea )
//    private void	AddFloat( float f, STLArrayList<UsProgramElement> pProgramArea )
    {
        UsProgramElement E = new UsProgramElement();
        E.m_FloatVal = f;
        pProgramArea.add( E );
    }
    /** Add an absolute string value to the program data area.
     * @param s Character pointer value to add.
     * @param pProgramArea Pointer to the program area, either init, or main code areas.
     */
    private void	AddString( final String s, STLVector<UsProgramElement> pProgramArea )
//    private void	AddString( final String s, STLArrayList<UsProgramElement> pProgramArea )
    {
        String ps = s ;	// MGC: MEMLEAK , cleanup missing
        UsProgramElement E = new UsProgramElement();
        E.m_pString = ps;
        pProgramArea.add( E );
    }
    /** Add an variable index value to the program area.
     * @param iVar Integer variable index to add, top bit indicates system variable.
     * @param pProgramArea Pointer to the program area, either init, or main code areas.
     */
    private void	AddVariable( int iVar, STLVector<UsProgramElement> pProgramArea )
//    private void	AddVariable( int iVar, STLArrayList<UsProgramElement> pProgramArea )
    {
        UsProgramElement E = new UsProgramElement();
        E.m_iVariable = iVar;
        pProgramArea.add( E );
    }
    /** Add an an external call descriptor to the program area
     * @param pExtCall Pointer to the external call descriptor.
     * @param pProgramArea Pointer to the program area, either init, or main code areas.
     */
    private void	AddDSOExternalCall( SqDSOExternalCall pExtCall, STLVector<UsProgramElement> pProgramArea )
//    private void	AddDSOExternalCall( SqDSOExternalCall pExtCall, STLArrayList<UsProgramElement> pProgramArea )
    {
        UsProgramElement E = new UsProgramElement();
        E.m_pExtCall = pExtCall;
        pProgramArea.add( E );
    }

    private void	SO_nop()
    {}
    
    private void	SO_dup()
    {
    	Dup();
    }
    
	private void	SO_drop()
    {
    	Drop();
    }
    
    private void	SO_debug_break()
    {}
    
    private void	SO_pushif()
    {
    	p_boolean __fVarying = new p_boolean(false);;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	pResult.SetFloat( ReadNext().m_FloatVal );
    	Push( pResult );
    }
    
    private void	SO_puship()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	float f = ReadNext().m_FloatVal;
    	float f2 = ReadNext().m_FloatVal;
    	float f3 = ReadNext().m_FloatVal;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	CqVector3D v = new CqVector3D(f,f2,f3);
    	pResult.SetValue(v);
    	Push( pResult );
    }

    private void	SO_pushis()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_string),new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	String ps = ReadNext().m_pString;
    	pResult.SetValue( ps );
    	Push( pResult );
    }

    private void	SO_pushv()
    {
        PushV( GetVar( ReadNext().m_iVariable ) );
    }

    private void	SO_ipushv()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	IqShaderData pVar = GetVar( ReadNext().m_iVariable );

    	if ( pVar.ArrayLength() == 0 )
    	{
//    		std::cerr << critical << "Attempt to index a non array variable" << std::endl;
    		HimawariLogger logger = HimawariLogger.getLogger();
    		logger.critical( "Attempt to index a non array variable\n" );
    		return ;
    	}
    	
    	IqShaderData pResult=GetNextTemp(pVar.Type(),(pVar.Size()>1 || A.Size()>1)?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	int ext = m_pEnv.GridSize();
    	boolean fVarying = ext > 1;
    	int i;
    	CqBitVector RS = m_pEnv.RunningState();
    	for ( i = 0; i < ext; i++ )
    	{
    		if(!fVarying || RS.Value( i ))
    		{
    			p_float _aq_A = new p_float();;
    			A.GetFloat( _aq_A, i );
    			pResult.SetValueFromVariable( pVar.ArrayEntry( (int)( _aq_A.value ) ), i );
    		}
    	}
    	Push( pResult );
    	Release( _se_A );
    }
    
    private void	SO_pop()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	IqShaderData pV = GetVar( ReadNext().m_iVariable );
    	SqStackEntry _se_Val=Pop(__fVarying);
    	IqShaderData Val = _se_Val.m_Data;
    	long ext = max( m_pEnv.GridSize(), pV.Size() );
    	boolean fVarying = ext > 1;
    	int i;
    	CqBitVector RS = m_pEnv.RunningState();
    	for ( i = 0; i < ext; i++ )
    	{
    		if(!fVarying || RS.Value( i ))
    			pV.SetValueFromVariable( Val, i );
    	}
    }
    
    private void	SO_ipop()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	UsProgramElement el = ReadNext();
    	IqShaderData pV = GetVar( el.m_iVariable );
    	CqShaderVariableArray pVA = (CqShaderVariableArray)( pV );
    	if ( pV.ArrayLength() == 0 )
    	{
//    		std::cerr << critical << "Attempt to index a non array variable" << std::endl;
    		HimawariLogger logger = HimawariLogger.getLogger();
    		logger.critical( "Attempt to index a non array variable\n" );
    		return ;
    	}
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_Val=Pop(__fVarying);
    	IqShaderData Val = _se_Val.m_Data;
    	
    	long ext = max( m_pEnv.GridSize(), pV.Size() );
    	boolean fVarying = ext > 1;
    	int i;
    	CqBitVector RS = m_pEnv.RunningState();
    	for ( i = 0; i < ext; i++ )
    	{
    		if ( !fVarying || RS.Value( i ) )
    		{
    			p_float fIndex = new p_float();
    			A.GetFloat( fIndex, i );
    			int index = (int)( fIndex.value );
    			( pVA ).valueAt( index ) .SetValueFromVariable( Val, i );
    		}
    	}
    	Release( _se_Val );
    	Release( _se_A );
    }

    private void	SO_mergef()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_F=Pop(__fVarying);
    	IqShaderData F = _se_F.m_Data;
    	SqStackEntry _se_T=Pop(__fVarying);
    	IqShaderData T = _se_T.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),new EqVariableClass(class_varying));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	int i;
    	int ext = m_pEnv.GridSize();
    	for ( i = 0; i < ext; i++ )
    	{
    		p_boolean _aq_A = new p_boolean();
    		p_float _aq_T = new p_float(), _aq_F = new p_float();
    		A.GetBool( _aq_A, i );
    		T.GetFloat( _aq_T, i );
    		F.GetFloat( _aq_F, i );
    		if ( _aq_A.value ) pResult.SetValue( _aq_T.value, i );
    		else pResult.SetValue( _aq_F.value, i );
    	}
    	Push( pResult );
    	Release( _se_T );
    	Release( _se_F );
    	Release( _se_A );
    }

    private void SO_merges()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_F=Pop(__fVarying);
    	IqShaderData F = _se_F.m_Data;
    	SqStackEntry _se_T=Pop(__fVarying);
    	IqShaderData T = _se_T.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_string),new EqVariableClass(class_varying));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	int i;
    	int ext = m_pEnv.GridSize();
    	for ( i = 0; i < ext; i++ )
    	{
    		p_boolean _aq_A = new p_boolean();
    		p_String _aq_T = new p_String(), _aq_F = new p_String();
    		A.GetBool( _aq_A, i );
    		T.GetString( _aq_T, i );
    		F.GetString( _aq_F, i );
    		if ( _aq_A.value ) pResult.SetValue( _aq_T.value, i );
    		else pResult.SetValue( _aq_F.value, i );
    	}
    	Push( pResult );
    	Release( _se_T );
    	Release( _se_F );
    	Release( _se_A );
    }
    
    private void SO_mergep()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_F=Pop(__fVarying);
    	IqShaderData F = _se_F.m_Data;
    	SqStackEntry _se_T=Pop(__fVarying);
    	IqShaderData T = _se_T.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),new EqVariableClass(class_varying));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	int i;
    	int ext = m_pEnv.GridSize();
    	for ( i = 0; i < ext; i++ )
    	{
    		p_boolean _aq_A = new p_boolean();
    		CqVector3D _aq_T = new CqVector3D(), _aq_F = new CqVector3D();
    		A.GetBool( _aq_A, i );
    		T.GetPoint( _aq_T, i );
    		F.GetPoint( _aq_F, i );
    		if ( _aq_A.value ) pResult.SetValue( _aq_T, i );
    		else pResult.SetValue( _aq_F, i );
    	}
    	Push( pResult );
    	Release( _se_T );
    	Release( _se_F );
    	Release( _se_A );
    }

    private void SO_mergec()
    {

    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_F=Pop(__fVarying);
    	IqShaderData F = _se_F.m_Data;
    	SqStackEntry _se_T=Pop(__fVarying);
    	IqShaderData T = _se_T.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),new EqVariableClass(class_varying));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	int i;
    	int ext = m_pEnv.GridSize();
    	for ( i = 0; i < ext; i++ )
    	{
    		p_boolean _aq_A = new p_boolean();
    		CqColor _aq_T = new CqColor(), _aq_F = new CqColor();
    		A.GetBool( _aq_A, i );
    		T.GetColor( _aq_T, i );
    		F.GetColor( _aq_F, i );
    		if ( _aq_A.value ) pResult.SetValue( _aq_T, i );
    		else pResult.SetValue( _aq_F, i );
    	}
    	Push( pResult );
    	Release( _se_T );
    	Release( _se_F );
    	Release( _se_A );
    }

    private void SO_setfc()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpCAST_FC( A, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_A );
    }

    private void SO_setfp()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpCAST_FP( A, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_A );
    }
    
    private void SO_setfm()
    {
        p_boolean __fVarying = new p_boolean(false);
        SqStackEntry _se_A=Pop(__fVarying);
        IqShaderData A = _se_A.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_matrix),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        OpCAST_FM( A, pResult, m_pEnv.RunningState() );
        Push( pResult );
        Release( _se_A );
    }

    private void SO_settc()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	SqStackEntry _se_C=Pop(__fVarying);
    	IqShaderData C = _se_C.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpTRIPLE_C( pResult, A, B, C, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_C );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_settp()
    {
        p_boolean __fVarying = new p_boolean(false);
        SqStackEntry _se_A=Pop(__fVarying);
        IqShaderData A = _se_A.m_Data;
        SqStackEntry _se_B=Pop(__fVarying);
        IqShaderData B = _se_B.m_Data;
        SqStackEntry _se_C=Pop(__fVarying);
        IqShaderData C = _se_C.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        OpTRIPLE_P( pResult, A, B, C, m_pEnv.RunningState() );
        Push( pResult );
        Release( _se_C );
        Release( _se_B );
        Release( _se_A );
    }
    
    private void SO_setpc()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpCAST_PC( A, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_A );
    }
    
    private void SO_setcp()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpCAST_CP( A, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_A );
    }
    
    private void SO_setwm()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	SqStackEntry _se_C=Pop(__fVarying);
    	IqShaderData C = _se_C.m_Data;
    	SqStackEntry _se_D=Pop(__fVarying);
    	IqShaderData D = _se_D.m_Data;
    	SqStackEntry _se_E=Pop(__fVarying);
    	IqShaderData E = _se_E.m_Data;
    	SqStackEntry _se_F=Pop(__fVarying);
    	IqShaderData F = _se_F.m_Data;
    	SqStackEntry _se_G=Pop(__fVarying);
    	IqShaderData G = _se_G.m_Data;
    	SqStackEntry _se_H=Pop(__fVarying);
    	IqShaderData H = _se_H.m_Data;
    	SqStackEntry _se_I=Pop(__fVarying);
    	IqShaderData I = _se_I.m_Data;
    	SqStackEntry _se_J=Pop(__fVarying);
    	IqShaderData J = _se_J.m_Data;
    	SqStackEntry _se_K=Pop(__fVarying);
    	IqShaderData K = _se_K.m_Data;
    	SqStackEntry _se_L=Pop(__fVarying);
    	IqShaderData L = _se_L.m_Data;
    	SqStackEntry _se_M=Pop(__fVarying);
    	IqShaderData M = _se_M.m_Data;
    	SqStackEntry _se_N=Pop(__fVarying);
    	IqShaderData N = _se_N.m_Data;
    	SqStackEntry _se_O=Pop(__fVarying);
    	IqShaderData O = _se_O.m_Data;
    	SqStackEntry _se_P=Pop(__fVarying);
    	IqShaderData P = _se_P.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_matrix),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpHEXTUPLE_M( pResult, P, O, N, M, L, K, J, I, H, G, F, E, D, C, B, A, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_P );
    	Release( _se_O );
    	Release( _se_N );
    	Release( _se_M );
    	Release( _se_L );
    	Release( _se_K );
    	Release( _se_J );
    	Release( _se_I );
    	Release( _se_H );
    	Release( _se_G );
    	Release( _se_F );
    	Release( _se_E );
    	Release( _se_D );
    	Release( _se_C );
    	Release( _se_B );
    	Release( _se_A );
    }

    private void SO_RS_PUSH()
    {
        m_pEnv.PushState();
    }
    
    private void SO_RS_POP()
    {
        m_pEnv.PopState();
    }
    
    private void SO_RS_GET()
    {
        m_pEnv.GetCurrentState();
    }

    private void SO_RS_INVERSE()
    {
        m_pEnv.InvertRunningState();
    }
    
    private void SO_S_CLEAR()
    {
        m_pEnv.ClearCurrentState();
    }
    
    private void SO_S_GET()
    {
        p_boolean __fVarying = new p_boolean(false);
        SqStackEntry _se_A=Pop(__fVarying);
        IqShaderData A = _se_A.m_Data;
        int i;
        CqBitVector RS = m_pEnv.RunningState();
        int ext = m_pEnv.GridSize();
        for ( i = 0; i < ext; i++ )
        {
            if ( RS.Value( i ) )
            {
                p_boolean _aq_A = new p_boolean();
                A.GetBool( _aq_A, i );
                m_pEnv.CurrentState().SetValue( i, _aq_A.value );
            }
        }
        Release( _se_A );
    }
    
    private void	SO_RS_JZ()
    {
    	SqLabel lab = ReadNext().m_Label;
        if ( m_pEnv.RunningState().Count() == 0 )
        {
            m_PO = lab.m_Offset;
            m_PCindex = m_PO;
            //m_PC = lab.m_pAddress;
            m_PC.get( m_PCindex ).assignment( lab.m_pAddress );
        }
    };
    
    private void	SO_RS_JNZ()
    {
    	 SqLabel lab = ReadNext().m_Label;
	    if ( m_pEnv.RunningState().Count() == m_pEnv.RunningState().Size() )
	    {
	        m_PO = lab.m_Offset;
	        m_PCindex = m_PO;
	        //m_PC = lab.m_pAddress;
	        m_PC.get( m_PCindex ).assignment( lab.m_pAddress );
	    }
    };
    
    private void	SO_S_JZ()
    {
        SqLabel lab = ReadNext().m_Label;
        if ( m_pEnv.CurrentState().Count() == 0 )
        {
            m_PO = lab.m_Offset;
            m_PCindex = m_PO;
            //m_PC = lab.m_pAddress;
            m_PC.get( m_PCindex ).assignment( lab.m_pAddress );
        }
    };
    
    private void	SO_S_JNZ()
    {
    	SqLabel lab = ReadNext().m_Label;
    	if ( m_pEnv.CurrentState().Count() == m_pEnv.RunningState().Size() )
    	{
    		m_PO = lab.m_Offset;
    		m_PCindex = m_PO;
    		//m_PC = lab.m_pAddress;
    		m_PC.get( m_PCindex ).assignment( lab.m_pAddress );
    	}
    };
    
    private void	SO_jnz()
    {
//    	SqLabel lab = ReadNext().m_Label;
//    	if ( m_pEnv.CurrentState().Count() == m_pEnv.RunningState().Size() )
//    	{
//    		m_PO = lab.m_Offset;
//    		m_PCindex = m_PO;
//    		//m_PC = lab.m_pAddress;
//    		m_PC.get( m_PCindex ).assignment( lab.m_pAddress );
//    	}
    	SqLabel lab = ReadNext().m_Label;
    	p_boolean __fVarying = new p_boolean(false);
        IqShaderData f = Pop(__fVarying).m_Data;
        int __iGrid = 0;
        do
        {
            if ( !__fVarying.value || m_pEnv.RunningState().Value( __iGrid ) )
            {
            	p_boolean _f = new p_boolean(false);
                f.GetBool( _f, __iGrid );
                if ( !_f.value ) return ;
            }
        }
        while ( ++__iGrid < m_pEnv.GridSize() );
        m_PO = lab.m_Offset;
        m_PCindex = m_PO;
        //m_PC = lab.m_pAddress;
        m_PC.get( m_PCindex ).assignment( lab.m_pAddress );
    	
    };
        
    private void	SO_jz()
    {
    	SqLabel lab = ReadNext().m_Label;
    	p_boolean __fVarying = new p_boolean(false);
    	IqShaderData f = Pop(__fVarying).m_Data;
    	int __iGrid = 0;
    	do
    	{
    		if ( !__fVarying.value || m_pEnv.RunningState().Value( __iGrid ) )
    		{
    			p_boolean _f = new p_boolean();
    			f.GetBool( _f, __iGrid );
    			if ( _f.value ) return ;
    		}
    	}
    	while ( ++__iGrid < m_pEnv.GridSize() );
    	m_PO = lab.m_Offset;
    	m_PCindex = m_PO;
    	//m_PC = lab.m_pAddress;
    	m_PC.get( m_PCindex ).assignment( lab.m_pAddress );
    }
    
    private void	SO_jmp()
    {
    	SqLabel lab = ReadNext().m_Label;
    	m_PO = lab.m_Offset;
    	m_PCindex = m_PO;
    	//m_PC = lab.m_pAddress;
    	m_PC.get( m_PCindex ).assignment( lab.m_pAddress );
    };
    
    private void SO_lsff()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpLSS_FF( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_lspp()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpLSS_PP( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_lscc()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpLSS_CC( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_gtff()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpGRT_FF( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
        Release( _se_A );
    }
    
    private void SO_gtpp()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpGRT_PP( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_gtcc()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpGRT_CC( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_geff()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpGE_FF( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_gepp()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpGE_PP( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_gecc()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpGE_CC( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_leff()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpLE_FF( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_lepp()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpLE_PP( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_lecc()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpLE_CC( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }

    private void SO_eqff()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpEQ_FF( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_eqpp()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpEQ_PP( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_eqcc()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpEQ_CC( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }

    private void SO_eqss()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpEQ_SS( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
        Release( _se_A );
    }

    private void	SO_eqmm(){};
    
    private void SO_neff()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpNE_FF( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_nepp()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpNE_PP( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_necc()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpNE_CC( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_ness()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpNE_SS( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void	SO_nemm(){};
    
    private void SO_mulff()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpMUL_FF( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_divff()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpDIV_FF( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_addff()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpADD_FF( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_subff()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpSUB_FF( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_negf()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpNEG_F( A, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_A );
    }
    
    private void SO_mulpp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpMULV( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
        Release( _se_A );
    }
    
    private void SO_divpp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpDIV_PP( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }

    private void SO_addpp()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_A=Pop(__fVarying);
        IqShaderData A = _se_A.m_Data;
        SqStackEntry _se_B=Pop(__fVarying);
        IqShaderData B = _se_B.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        OpADD_PP( A, B, pResult, m_pEnv.RunningState() );
        Push( pResult );
        Release( _se_B );
        Release( _se_A );
    }

    private void SO_subpp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpSUB_PP( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }

    private void SO_crspp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpCRS_PP( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
        Release( _se_A );
    }
    
    private void SO_dotpp()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpDOT_PP( A, B, pResult, m_pEnv.RunningState() );;
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_negp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpNEG_P( A, pResult, m_pEnv.RunningState() );
    	Push( pResult );
        Release( _se_A );
    }
    
    private void SO_mulcc()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpMUL_CC( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_divcc()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpDIV_CC( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
        Release( _se_A );
    }

    private void SO_addcc()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_A=Pop(__fVarying);
        IqShaderData A = _se_A.m_Data;
        SqStackEntry _se_B=Pop(__fVarying);
        IqShaderData B = _se_B.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        OpADD_CC( A, B, pResult, m_pEnv.RunningState() );
        Push( pResult );
        Release( _se_B );
        Release( _se_A );
    }
    
    private void SO_subcc()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpSUB_CC( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
        Release( _se_A );
    }

    private void SO_crscc()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpCRS_CC( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
        Release( _se_A );
    }
    
    private void SO_dotcc()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpDOT_CC( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }

    private void SO_negc()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpNEG_C( A, pResult, m_pEnv.RunningState() );
    	Push( pResult );
        Release( _se_A );
    }

    private void SO_mulfp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpMUL_FP( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
        Release( _se_B );
        Release( _se_A );
    }

    private void SO_divfp()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_A=Pop(__fVarying);
        IqShaderData A = _se_A.m_Data;
        SqStackEntry _se_B=Pop(__fVarying);
        IqShaderData B = _se_B.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        OpDIV_FP( A, B, pResult, m_pEnv.RunningState() );
        Push( pResult );
        Release( _se_B );
        Release( _se_A );
    }

    private void SO_addfp()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_A=Pop(__fVarying);
        IqShaderData A = _se_A.m_Data;
        SqStackEntry _se_B=Pop(__fVarying);
        IqShaderData B = _se_B.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        OpADD_FP( A, B, pResult, m_pEnv.RunningState() );
        Push( pResult );
        Release( _se_B );
        Release( _se_A );
    }

    private void SO_subfp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpSUB_FP( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
        Release( _se_A );
    }

    private void SO_mulfc()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_A=Pop(__fVarying);
        IqShaderData A = _se_A.m_Data;
        SqStackEntry _se_B=Pop(__fVarying);
        IqShaderData B = _se_B.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        OpMUL_FC( A, B, pResult, m_pEnv.RunningState() );
        Push( pResult );
        Release( _se_B );
        Release( _se_A );
    }

    private void SO_divfc()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpDIV_FC( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }

    private void SO_addfc()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpADD_FC( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }

    private void SO_subfc()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpSUB_FC( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }

    private void SO_mulmm()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	pResult.SetFloat( 0.0f );
    	Push( pResult );	/* TODO: Implement matrices in the VM*/
    }

    private void SO_divmm()
    {
        p_boolean __fVarying= new p_boolean(false);
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        pResult.SetFloat( 0.0f );
        Push( pResult );	/* TODO: Implement matrices in the VM*/
    }

    private void SO_land()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_A=Pop(__fVarying);
        IqShaderData A = _se_A.m_Data;
        SqStackEntry _se_B=Pop(__fVarying);
        IqShaderData B = _se_B.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        OpLAND_B( A, B, pResult, m_pEnv.RunningState() );
        Push( pResult );
        Release( _se_B );
        Release( _se_A );
    }

    private void SO_lor()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_A=Pop(__fVarying);
        IqShaderData A = _se_A.m_Data;
        SqStackEntry _se_B=Pop(__fVarying);
        IqShaderData B = _se_B.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        OpLOR_B( A, B, pResult, m_pEnv.RunningState() );
        Push( pResult );
        Release( _se_B );
        Release( _se_A );
    }

    private void SO_radians()
    {
    	p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_ValA=Pop(__fVarying);
        IqShaderData ValA = _se_ValA.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_radians(ValA,pResult,this);
        Push(pResult);
        Release( _se_ValA );
    }

    private void SO_degrees()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_degrees(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_sin()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_sin(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_asin()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_asin(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_cos()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_cos(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_acos()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_acos(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_tan()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_tan(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_atan()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_atan(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_atan2()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_atan(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_pow()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_ValA=Pop(__fVarying);
        IqShaderData ValA = _se_ValA.m_Data;
        SqStackEntry _se_ValB=Pop(__fVarying);
        IqShaderData ValB = _se_ValB.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_pow(ValA,ValB,pResult,this);
        Push(pResult);
        Release( _se_ValA );
        Release( _se_ValB );
    }

    private void SO_exp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_exp(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_sqrt()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_sqrt(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_log()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_log(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_log2()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_log(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_mod()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_mod(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_abs()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_abs(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_sign()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_sign(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_min()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_a=Pop(__fVarying);
    	IqShaderData a = _se_a.m_Data;
    	SqStackEntry _se_b=Pop(__fVarying);
    	IqShaderData b = _se_b.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_min(a,b,pResult,this, cParams, aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_a );
    	Release( _se_b );
    }

    private void SO_max()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_a=Pop(__fVarying);
    	IqShaderData a = _se_a.m_Data;
    	SqStackEntry _se_b=Pop(__fVarying);
    	IqShaderData b = _se_b.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_max(a,b,pResult,this, cParams, aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_a );
    	Release( _se_b );
    }

    private void SO_pmin()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_count=Pop(__fVarying);
        IqShaderData count = _se_count.m_Data;
        SqStackEntry _se_a=Pop(__fVarying);
        IqShaderData a = _se_a.m_Data;
        SqStackEntry _se_b=Pop(__fVarying);
        IqShaderData b = _se_b.m_Data;
        p_float fc = new p_float();
        count.GetFloat( fc );
        int cParams=(int)( fc.value );
        IqShaderData[] aParams=new IqShaderData[cParams];
        int iP=0;
        while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_pmin(a,b,pResult,this, cParams, aParams);
        Push(pResult);
        Release( _se_count );
        Release( _se_a );
        Release( _se_b );
    }

    private void SO_pmax()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_a=Pop(__fVarying);
    	IqShaderData a = _se_a.m_Data;
    	SqStackEntry _se_b=Pop(__fVarying);
    	IqShaderData b = _se_b.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_pmax(a,b,pResult,this, cParams, aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_a );
    	Release( _se_b );
    }

    private void SO_vmin()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_count=Pop(__fVarying);
        IqShaderData count = _se_count.m_Data;
        SqStackEntry _se_a=Pop(__fVarying);
        IqShaderData a = _se_a.m_Data;
        SqStackEntry _se_b=Pop(__fVarying);
        IqShaderData b = _se_b.m_Data;
        p_float fc = new p_float();
        count.GetFloat( fc );
        int cParams=(int)( fc.value );
        IqShaderData[] aParams=new IqShaderData[cParams];
        int iP=0;
        while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_pmin(a,b,pResult,this, cParams, aParams);
        Push(pResult);
        Release( _se_count );
        Release( _se_a );
        Release( _se_b );
    }

    private void SO_vmax()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_count=Pop(__fVarying);
        IqShaderData count = _se_count.m_Data;
        SqStackEntry _se_a=Pop(__fVarying);
        IqShaderData a = _se_a.m_Data;
        SqStackEntry _se_b=Pop(__fVarying);
        IqShaderData b = _se_b.m_Data;
        p_float fc = new p_float();
        count.GetFloat( fc );
        int cParams=(int)( fc.value );
        IqShaderData[] aParams=new IqShaderData[cParams];
        int iP=0;
        while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_pmax(a,b,pResult,this, cParams, aParams);
        Push(pResult);
        Release( _se_count );
        Release( _se_a );
        Release( _se_b );
    }

    private void SO_nmin()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_count=Pop(__fVarying);
        IqShaderData count = _se_count.m_Data;
        SqStackEntry _se_a=Pop(__fVarying);
        IqShaderData a = _se_a.m_Data;
        SqStackEntry _se_b=Pop(__fVarying);
        IqShaderData b = _se_b.m_Data;
        p_float fc = new p_float();
        count.GetFloat( fc );
        int cParams=(int)( fc.value );
        IqShaderData[] aParams=new IqShaderData[cParams];
        int iP=0;
        while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_pmin(a,b,pResult,this, cParams, aParams);
        Push(pResult);
        Release( _se_count );
        Release( _se_a );
        Release( _se_b );
    }

    private void SO_nmax()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_a=Pop(__fVarying);
    	IqShaderData a = _se_a.m_Data;
    	SqStackEntry _se_b=Pop(__fVarying);
    	IqShaderData b = _se_b.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_pmax(a,b,pResult,this, cParams, aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_a );
    	Release( _se_b );
    }

    private void SO_cmin()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_a=Pop(__fVarying);
    	IqShaderData a = _se_a.m_Data;
    	SqStackEntry _se_b=Pop(__fVarying);
    	IqShaderData b = _se_b.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_cmin(a,b,pResult,this, cParams, aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_a );
    	Release( _se_b );
    }

    private void SO_cmax()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_a=Pop(__fVarying);
    	IqShaderData a = _se_a.m_Data;
    	SqStackEntry _se_b=Pop(__fVarying);
    	IqShaderData b = _se_b.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_cmax(a,b,pResult,this, cParams, aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_a );
    	Release( _se_b );
    }

    private void SO_clamp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_clamp(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }

    private void SO_pclamp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_pclamp(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }

    private void SO_cclamp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_cclamp(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }

    private void SO_floor()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_floor(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_ceil()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ceil(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_round()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_round(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_step()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_step(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_smoothstep()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_smoothstep(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }

    private void SO_fspline()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_count=Pop(__fVarying);
        IqShaderData count = _se_count.m_Data;
        SqStackEntry _se_value=Pop(__fVarying);
        IqShaderData value = _se_value.m_Data;
        SqStackEntry _se_vala=Pop(__fVarying);
        IqShaderData vala = _se_vala.m_Data;
        SqStackEntry _se_valb=Pop(__fVarying);
        IqShaderData valb = _se_valb.m_Data;
        SqStackEntry _se_valc=Pop(__fVarying);
        IqShaderData valc = _se_valc.m_Data;
        SqStackEntry _se_vald=Pop(__fVarying);
        IqShaderData vald = _se_vald.m_Data;
        p_float fc = new p_float();
        count.GetFloat( fc );
        int cParams=(int)( fc.value ) + 4;
        IqShaderData[] apSplinePoints=new IqShaderData[cParams];
        apSplinePoints[0]=vala;
        apSplinePoints[1]=valb;
        apSplinePoints[2]=valc;
        apSplinePoints[3]=vald;
        int iSP;
        for(iSP=4; iSP<cParams; iSP++) apSplinePoints[iSP]=Pop(__fVarying).m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_fspline(value,pResult,this,cParams,apSplinePoints);
        Push(pResult);
        Release( _se_count );
        Release( _se_value );
        Release( _se_vala );
        Release( _se_valb );
        Release( _se_valc );
        Release( _se_vald );
    }

    private void SO_cspline()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_count=Pop(__fVarying);
        IqShaderData count = _se_count.m_Data;
        SqStackEntry _se_value=Pop(__fVarying);
        IqShaderData value = _se_value.m_Data;
        SqStackEntry _se_vala=Pop(__fVarying);
        IqShaderData vala = _se_vala.m_Data;
        SqStackEntry _se_valb=Pop(__fVarying);
        IqShaderData valb = _se_valb.m_Data;
        SqStackEntry _se_valc=Pop(__fVarying);
        IqShaderData valc = _se_valc.m_Data;
        SqStackEntry _se_vald=Pop(__fVarying);
        IqShaderData vald = _se_vald.m_Data;
        p_float fc = new p_float();
        count.GetFloat( fc );
        int cParams=(int)( fc.value ) + 4;
        IqShaderData[] apSplinePoints=new IqShaderData[cParams];
        apSplinePoints[0]=vala;
        apSplinePoints[1]=valb;
        apSplinePoints[2]=valc;
        apSplinePoints[3]=vald;
        int iSP;
        for(iSP=4; iSP<cParams; iSP++) apSplinePoints[iSP]=Pop(__fVarying).m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_cspline(value,pResult,this,cParams,apSplinePoints);
        Push(pResult);
        Release( _se_count );
        Release( _se_value );
        Release( _se_vala );
        Release( _se_valb );
        Release( _se_valc );
        Release( _se_vald );
    }

    private void SO_pspline()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_count=Pop(__fVarying);
        IqShaderData count = _se_count.m_Data;
        SqStackEntry _se_value=Pop(__fVarying);
        IqShaderData value = _se_value.m_Data;
        SqStackEntry _se_vala=Pop(__fVarying);
        IqShaderData vala = _se_vala.m_Data;
        SqStackEntry _se_valb=Pop(__fVarying);
        IqShaderData valb = _se_valb.m_Data;
        SqStackEntry _se_valc=Pop(__fVarying);
        IqShaderData valc = _se_valc.m_Data;
        SqStackEntry _se_vald=Pop(__fVarying);
        IqShaderData vald = _se_vald.m_Data;
        p_float fc = new p_float();
        count.GetFloat( fc );
        int cParams=(int)( fc.value ) + 4;
        IqShaderData[] apSplinePoints=new IqShaderData[cParams];
        apSplinePoints[0]=vala;
        apSplinePoints[1]=valb;
        apSplinePoints[2]=valc;
        apSplinePoints[3]=vald;
        int iSP;
        for(iSP=4; iSP<cParams; iSP++) apSplinePoints[iSP]=Pop(__fVarying).m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_pspline(value,pResult,this,cParams,apSplinePoints);
        Push(pResult);
        Release( _se_count );
        Release( _se_value );
        Release( _se_vala );
        Release( _se_valb );
        Release( _se_valc );
        Release( _se_vald );
    }

    private void SO_sfspline()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_basis=Pop(__fVarying);
    	IqShaderData basis = _se_basis.m_Data;
    	SqStackEntry _se_value=Pop(__fVarying);
    	IqShaderData value = _se_value.m_Data;
    	SqStackEntry _se_vala=Pop(__fVarying);
    	IqShaderData vala = _se_vala.m_Data;
    	SqStackEntry _se_valb=Pop(__fVarying);
    	IqShaderData valb = _se_valb.m_Data;
    	SqStackEntry _se_valc=Pop(__fVarying);
    	IqShaderData valc = _se_valc.m_Data;
    	SqStackEntry _se_vald=Pop(__fVarying);
    	IqShaderData vald = _se_vald.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value ) + 4;
    	IqShaderData[] apSplinePoints=new IqShaderData[cParams];
    	apSplinePoints[0]=vala;
    	apSplinePoints[1]=valb;
    	apSplinePoints[2]=valc;
    	apSplinePoints[3]=vald;
    	int iSP;
    	for(iSP=4; iSP<cParams; iSP++) apSplinePoints[iSP]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_sfspline(basis,value,pResult,this,cParams,apSplinePoints);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_basis );
    	Release( _se_value );
    	Release( _se_vala );
    	Release( _se_valb );
    	Release( _se_valc );
    	Release( _se_vald );
    }

    private void SO_scspline()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_basis=Pop(__fVarying);
    	IqShaderData basis = _se_basis.m_Data;
    	SqStackEntry _se_value=Pop(__fVarying);
    	IqShaderData value = _se_value.m_Data;
    	SqStackEntry _se_vala=Pop(__fVarying);
    	IqShaderData vala = _se_vala.m_Data;
    	SqStackEntry _se_valb=Pop(__fVarying);
    	IqShaderData valb = _se_valb.m_Data;
    	SqStackEntry _se_valc=Pop(__fVarying);
    	IqShaderData valc = _se_valc.m_Data;
    	SqStackEntry _se_vald=Pop(__fVarying);
    	IqShaderData vald = _se_vald.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value ) + 4;
    	IqShaderData[] apSplinePoints=new IqShaderData[cParams];
    	apSplinePoints[0]=vala;
    	apSplinePoints[1]=valb;
    	apSplinePoints[2]=valc;
    	apSplinePoints[3]=vald;
    	int iSP;
    	for(iSP=4; iSP<cParams; iSP++) apSplinePoints[iSP]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_scspline(basis,value,pResult,this,cParams,apSplinePoints);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_basis );
    	Release( _se_value );
    	Release( _se_vala );
    	Release( _se_valb );
    	Release( _se_valc );
    	Release( _se_vald );
    }

    private void SO_spspline()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_count=Pop(__fVarying);
        IqShaderData count = _se_count.m_Data;
        SqStackEntry _se_basis=Pop(__fVarying);
        IqShaderData basis = _se_basis.m_Data;
        SqStackEntry _se_value=Pop(__fVarying);
        IqShaderData value = _se_value.m_Data;
        SqStackEntry _se_vala=Pop(__fVarying);
        IqShaderData vala = _se_vala.m_Data;
        SqStackEntry _se_valb=Pop(__fVarying);
        IqShaderData valb = _se_valb.m_Data;
        SqStackEntry _se_valc=Pop(__fVarying);
        IqShaderData valc = _se_valc.m_Data;
        SqStackEntry _se_vald=Pop(__fVarying);
        IqShaderData vald = _se_vald.m_Data;
        p_float fc = new p_float();
        count.GetFloat( fc );
        int cParams=(int)( fc.value ) + 4;
        IqShaderData[] apSplinePoints=new IqShaderData[cParams];
        apSplinePoints[0]=vala;
        apSplinePoints[1]=valb;
        apSplinePoints[2]=valc;
        apSplinePoints[3]=vald;
        int iSP;
        for(iSP=4; iSP<cParams; iSP++) apSplinePoints[iSP]=Pop(__fVarying).m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_spspline(basis,value,pResult,this,cParams,apSplinePoints);
        Push(pResult);
        Release( _se_count );
        Release( _se_basis );
        Release( _se_value );
        Release( _se_vala );
        Release( _se_valb );
        Release( _se_valc );
        Release( _se_vald );
    }

    private void SO_fDu()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_fDu(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_fDv()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_ValA=Pop(__fVarying);
        IqShaderData ValA = _se_ValA.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_fDv(ValA,pResult,this);
        Push(pResult);
        Release( _se_ValA );
    }

    private void SO_fDeriv()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_fDeriv(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_cDu()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_cDu(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_cDv()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_cDv(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_cDeriv()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_cDeriv(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_pDu()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_pDu(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }
    
    private void SO_pDv()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_pDv(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }
    
    private void SO_pDeriv()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_pDeriv(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_frandom()
    {
    	boolean __fVarying=true;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_frandom(pResult,this);
    	Push(pResult);
    }
    
    private void SO_crandom()
    {
    	boolean __fVarying=true;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_crandom(pResult,this);
    	Push(pResult);
    }
    
    private void SO_prandom()
    {
    	boolean __fVarying=true;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_prandom(pResult,this);
    	Push(pResult);
    }

    private void SO_noise1()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_fnoise1(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_noise2()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_fnoise2(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_noise3()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_fnoise3(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }
    
    private void SO_noise4()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_fnoise4(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_cnoise1()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_cnoise1(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }
    
    private void SO_cnoise2()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_cnoise2(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_cnoise3()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_cnoise3(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }
    
    private void SO_cnoise4()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_cnoise4(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_pnoise1()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_pnoise1(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }
    
    private void SO_pnoise2()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_pnoise2(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_pnoise3()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_pnoise3(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }
    
    private void SO_pnoise4()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_pnoise4(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_xcomp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpCOMP_P( A, 0, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_A );
    }
    
    private void SO_ycomp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpCOMP_P( A, 1, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_A );
    }
    
    private void SO_zcomp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpCOMP_P( A, 2, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_A );
    }

    private void SO_setxcomp()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_ValA=Pop(__fVarying);
        IqShaderData ValA = _se_ValA.m_Data;
        SqStackEntry _se_ValB=Pop(__fVarying);
        IqShaderData ValB = _se_ValB.m_Data;
        m_pEnv.SO_setxcomp(ValA,ValB,this);
        Release( _se_ValA );
        Release( _se_ValB );
    }
    
    private void SO_setycomp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	m_pEnv.SO_setycomp(ValA,ValB,this);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_setzcomp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	m_pEnv.SO_setzcomp(ValA,ValB,this);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_length()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_length(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }
    
    private void SO_distance()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_distance(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_area()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_area(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }
    
    private void SO_normalize()
    {
    	p_boolean __fVarying = new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_vector),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_normalize(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }
    
    private void SO_faceforward()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_vector),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_faceforward(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_faceforward2()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_vector),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_faceforward2(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }

    private void SO_reflect()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_vector),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_reflect(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_refract()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_vector),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_refract(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }

    private void SO_fresnel()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	SqStackEntry _se_ValD=Pop(__fVarying);
    	IqShaderData ValD = _se_ValD.m_Data;
    	SqStackEntry _se_ValE=Pop(__fVarying);
    	IqShaderData ValE = _se_ValE.m_Data;
    	m_pEnv.SO_fresnel(ValA,ValB,ValC,ValD,ValE,this);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    	Release( _se_ValD );
    	Release( _se_ValE );
    }
    
    private void SO_fresnel2()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	SqStackEntry _se_ValD=Pop(__fVarying);
    	IqShaderData ValD = _se_ValD.m_Data;
    	SqStackEntry _se_ValE=Pop(__fVarying);
    	IqShaderData ValE = _se_ValE.m_Data;
    	SqStackEntry _se_ValF=Pop(__fVarying);
    	IqShaderData ValF = _se_ValF.m_Data;
    	SqStackEntry _se_ValG=Pop(__fVarying);
    	IqShaderData ValG = _se_ValG.m_Data;
    	m_pEnv.SO_fresnel(ValA,ValB,ValC,ValD,ValE,ValF,ValG,this);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    	Release( _se_ValD );
    	Release( _se_ValE );
    	Release( _se_ValF );
    	Release( _se_ValG );
    }

    private void SO_transform2()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_transform(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }
    
    private void SO_transform()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_transform(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_transformm()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_transformm(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_vtransform2()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_ValA=Pop(__fVarying);
        IqShaderData ValA = _se_ValA.m_Data;
        SqStackEntry _se_ValB=Pop(__fVarying);
        IqShaderData ValB = _se_ValB.m_Data;
        SqStackEntry _se_ValC=Pop(__fVarying);
        IqShaderData ValC = _se_ValC.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_vector),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_vtransform(ValA,ValB,ValC,pResult,this);
        Push(pResult);
        Release( _se_ValA );
        Release( _se_ValB );
        Release( _se_ValC );
    }
    
    private void SO_vtransform()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_vector),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_vtransform(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_vtransformm()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_vector),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_vtransformm(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_ntransform2()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_ValA=Pop(__fVarying);
        IqShaderData ValA = _se_ValA.m_Data;
        SqStackEntry _se_ValB=Pop(__fVarying);
        IqShaderData ValB = _se_ValB.m_Data;
        SqStackEntry _se_ValC=Pop(__fVarying);
        IqShaderData ValC = _se_ValC.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_normal),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_ntransform(ValA,ValB,ValC,pResult,this);
        Push(pResult);
        Release( _se_ValA );
        Release( _se_ValB );
        Release( _se_ValC );
    }
    
    private void SO_ntransform()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_normal),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ntransform(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_ntransformm()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_normal),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ntransformm(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_depth()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_depth(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_calculatenormal()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_normal),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_calculatenormal(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_comp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	OpCOMP_C( A, B, pResult, m_pEnv.RunningState() );
    	Push( pResult );
    	Release( _se_B );
    	Release( _se_A );
    }
    
    private void SO_setcomp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	m_pEnv.SO_setcomp(ValA,ValB,ValC,this);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }
    
    private void SO_cmix()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_cmix(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }
    
    private void SO_fmix()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_fmix(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }
    
    private void SO_pmix()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_pmix(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }
    
    private void SO_vmix()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_vector),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_vmix(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }
    
    private void SO_nmix()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_normal),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_nmix(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }

    private void SO_ambient()
    {
    	boolean __fVarying=true;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ambient(pResult,this);
    	Push(pResult);
    }

    private void SO_diffuse()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_diffuse(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }
    
    private void SO_specular()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_specular(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }
    
    private void SO_phong()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_phong(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }

    private void SO_trace()
    {
    	p_boolean __fVarying=new p_boolean(true);
        SqStackEntry _se_ValA=Pop(__fVarying);
        IqShaderData ValA = _se_ValA.m_Data;
        SqStackEntry _se_ValB=Pop(__fVarying);
        IqShaderData ValB = _se_ValB.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_trace(ValA,ValB,pResult,this);
        Push(pResult);
        Release( _se_ValA );
        Release( _se_ValB );
    }

    private void SO_shadow()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_name=Pop(__fVarying);
    	IqShaderData name = _se_name.m_Data;
    	SqStackEntry _se_channel=Pop(__fVarying);
    	IqShaderData channel = _se_channel.m_Data;
    	SqStackEntry _se_R=Pop(__fVarying);
    	IqShaderData R = _se_R.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_shadow(name,channel,R,pResult,this, cParams, aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_name );
    	Release( _se_channel );
    	Release( _se_R );
    }
    
    private void SO_shadow1()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_name=Pop(__fVarying);
    	IqShaderData name = _se_name.m_Data;
    	SqStackEntry _se_channel=Pop(__fVarying);
    	IqShaderData channel = _se_channel.m_Data;
    	SqStackEntry _se_R1=Pop(__fVarying);
    	IqShaderData R1 = _se_R1.m_Data;
    	SqStackEntry _se_R2=Pop(__fVarying);
    	IqShaderData R2 = _se_R2.m_Data;
    	SqStackEntry _se_R3=Pop(__fVarying);
    	IqShaderData R3 = _se_R3.m_Data;
    	SqStackEntry _se_R4=Pop(__fVarying);
    	IqShaderData R4 = _se_R4.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_shadow1(name,channel,R1,R2,R3,R4,pResult,this,cParams,aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_name );
    	Release( _se_channel );
    	Release( _se_R1 );
    	Release( _se_R2 );
    	Release( _se_R3 );
    	Release( _se_R4 );
    }

    private void SO_ftexture1()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_name=Pop(__fVarying);
    	IqShaderData name = _se_name.m_Data;
    	SqStackEntry _se_channel=Pop(__fVarying);
    	IqShaderData channel = _se_channel.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ftexture1(name,channel,pResult,this,cParams,aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_name );
    	Release( _se_channel );
    }

    private void SO_ftexture2()
    {
    	p_boolean __fVarying=new p_boolean(true);
        SqStackEntry _se_count=Pop(__fVarying);
        IqShaderData count = _se_count.m_Data;
        SqStackEntry _se_name=Pop(__fVarying);
        IqShaderData name = _se_name.m_Data;
        SqStackEntry _se_channel=Pop(__fVarying);
        IqShaderData channel = _se_channel.m_Data;
        SqStackEntry _se_s1=Pop(__fVarying);
        IqShaderData s1 = _se_s1.m_Data;
        SqStackEntry _se_t1=Pop(__fVarying);
        IqShaderData t1 = _se_t1.m_Data;
        p_float fc = new p_float();
        count.GetFloat( fc );
        int cParams=(int)( fc.value );
        IqShaderData[] aParams=new IqShaderData[cParams];
        int iP=0;
        while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_ftexture2(name,channel,s1,t1,pResult,this, cParams, aParams);
        Push(pResult);
        Release( _se_count );
        Release( _se_name );
        Release( _se_channel );
        Release( _se_s1 );
        Release( _se_t1 );
    }

    private void SO_ftexture3()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_name=Pop(__fVarying);
    	IqShaderData name = _se_name.m_Data;
    	SqStackEntry _se_channel=Pop(__fVarying);
    	IqShaderData channel = _se_channel.m_Data;
    	SqStackEntry _se_s1=Pop(__fVarying);
    	IqShaderData s1 = _se_s1.m_Data;
    	SqStackEntry _se_t1=Pop(__fVarying);
    	IqShaderData t1 = _se_t1.m_Data;
    	SqStackEntry _se_s2=Pop(__fVarying);
    	IqShaderData s2 = _se_s2.m_Data;
    	SqStackEntry _se_t2=Pop(__fVarying);
    	IqShaderData t2 = _se_t2.m_Data;
    	SqStackEntry _se_s3=Pop(__fVarying);
    	IqShaderData s3 = _se_s3.m_Data;
    	SqStackEntry _se_t3=Pop(__fVarying);
    	IqShaderData t3 = _se_t3.m_Data;
    	SqStackEntry _se_s4=Pop(__fVarying);
    	IqShaderData s4 = _se_s4.m_Data;
    	SqStackEntry _se_t4=Pop(__fVarying);
    	IqShaderData t4 = _se_t4.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ftexture3(name,channel,s1,t1,s2,t2,s3,t3,s4,t4,pResult,this,cParams,aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_name );
    	Release( _se_channel );
    	Release( _se_s1 );
    	Release( _se_t1 );
    	Release( _se_s2 );
    	Release( _se_t2 );
    	Release( _se_s3 );
    	Release( _se_t3 );
    	Release( _se_s4 );
    	Release( _se_t4 );
    }
    
    private void SO_textureinfo()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	IqShaderData pV = GetVar( ReadNext().m_iVariable );
    	SqStackEntry _se_Val=Pop(__fVarying);
    	IqShaderData Val = _se_Val.m_Data;
    	SqStackEntry _se_DataInfo=Pop(__fVarying);
    	IqShaderData DataInfo = _se_DataInfo.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_textureinfo( Val, DataInfo, pV, pResult );
    	Push( pResult );
    	Release( _se_Val );
    }
    
    private void SO_ctexture1()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_name=Pop(__fVarying);
    	IqShaderData name = _se_name.m_Data;
    	SqStackEntry _se_channel=Pop(__fVarying);
    	IqShaderData channel = _se_channel.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ctexture1(name,channel,pResult,this,cParams,aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_name );
    	Release( _se_channel );
    }
    
    private void SO_ctexture2()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_name=Pop(__fVarying);
    	IqShaderData name = _se_name.m_Data;
    	SqStackEntry _se_channel=Pop(__fVarying);
    	IqShaderData channel = _se_channel.m_Data;
    	SqStackEntry _se_s1=Pop(__fVarying);
    	IqShaderData s1 = _se_s1.m_Data;
    	SqStackEntry _se_t1=Pop(__fVarying);
    	IqShaderData t1 = _se_t1.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ctexture2(name,channel,s1,t1,pResult,this, cParams, aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_name );
    	Release( _se_channel );
    	Release( _se_s1 );
    	Release( _se_t1 );
    }
    
    private void SO_ctexture3()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_name=Pop(__fVarying);
    	IqShaderData name = _se_name.m_Data;
    	SqStackEntry _se_channel=Pop(__fVarying);
    	IqShaderData channel = _se_channel.m_Data;
    	SqStackEntry _se_s1=Pop(__fVarying);
    	IqShaderData s1 = _se_s1.m_Data;
    	SqStackEntry _se_t1=Pop(__fVarying);
    	IqShaderData t1 = _se_t1.m_Data;
    	SqStackEntry _se_s2=Pop(__fVarying);
    	IqShaderData s2 = _se_s2.m_Data;
    	SqStackEntry _se_t2=Pop(__fVarying);
    	IqShaderData t2 = _se_t2.m_Data;
    	SqStackEntry _se_s3=Pop(__fVarying);
    	IqShaderData s3 = _se_s3.m_Data;
    	SqStackEntry _se_t3=Pop(__fVarying);
    	IqShaderData t3 = _se_t3.m_Data;
    	SqStackEntry _se_s4=Pop(__fVarying);
    	IqShaderData s4 = _se_s4.m_Data;
    	SqStackEntry _se_t4=Pop(__fVarying);
    	IqShaderData t4 = _se_t4.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ctexture3(name,channel,s1,t1,s2,t2,s3,t3,s4,t4,pResult,this,cParams,aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_name );
    	Release( _se_channel );
    	Release( _se_s1 );
    	Release( _se_t1 );
    	Release( _se_s2 );
    	Release( _se_t2 );
    	Release( _se_s3 );
    	Release( _se_t3 );
    	Release( _se_s4 );
    	Release( _se_t4 );
    }
    
    private void SO_fenvironment2()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_name=Pop(__fVarying);
    	IqShaderData name = _se_name.m_Data;
    	SqStackEntry _se_channel=Pop(__fVarying);
    	IqShaderData channel = _se_channel.m_Data;
    	SqStackEntry _se_R=Pop(__fVarying);
    	IqShaderData R = _se_R.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_fenvironment2(name,channel,R,pResult,this, cParams, aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_name );
    	Release( _se_channel );
    	Release( _se_R );
    }
    
    private void SO_fenvironment3()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_name=Pop(__fVarying);
    	IqShaderData name = _se_name.m_Data;
    	SqStackEntry _se_channel=Pop(__fVarying);
    	IqShaderData channel = _se_channel.m_Data;
    	SqStackEntry _se_R1=Pop(__fVarying);
    	IqShaderData R1 = _se_R1.m_Data;
    	SqStackEntry _se_R2=Pop(__fVarying);
    	IqShaderData R2 = _se_R2.m_Data;
    	SqStackEntry _se_R3=Pop(__fVarying);
    	IqShaderData R3 = _se_R3.m_Data;
    	SqStackEntry _se_R4=Pop(__fVarying);
    	IqShaderData R4 = _se_R4.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_fenvironment3(name,channel,R1,R2,R3,R4,pResult,this,cParams,aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_name );
    	Release( _se_channel );
    	Release( _se_R1 );
    	Release( _se_R2 );
    	Release( _se_R3 );
    	Release( _se_R4 );
    }
    
    private void SO_cenvironment2()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_name=Pop(__fVarying);
    	IqShaderData name = _se_name.m_Data;
    	SqStackEntry _se_channel=Pop(__fVarying);
    	IqShaderData channel = _se_channel.m_Data;
    	SqStackEntry _se_R=Pop(__fVarying);
    	IqShaderData R = _se_R.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_cenvironment2(name,channel,R,pResult,this, cParams, aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_name );
    	Release( _se_channel );
    	Release( _se_R );
    }
    
    private void SO_cenvironment3()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_name=Pop(__fVarying);
    	IqShaderData name = _se_name.m_Data;
    	SqStackEntry _se_channel=Pop(__fVarying);
    	IqShaderData channel = _se_channel.m_Data;
    	SqStackEntry _se_R1=Pop(__fVarying);
    	IqShaderData R1 = _se_R1.m_Data;
    	SqStackEntry _se_R2=Pop(__fVarying);
    	IqShaderData R2 = _se_R2.m_Data;
    	SqStackEntry _se_R3=Pop(__fVarying);
    	IqShaderData R3 = _se_R3.m_Data;
    	SqStackEntry _se_R4=Pop(__fVarying);
    	IqShaderData R4 = _se_R4.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_cenvironment3(name,channel,R1,R2,R3,R4,pResult,this,cParams,aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_name );
    	Release( _se_channel );
    	Release( _se_R1 );
    	Release( _se_R2 );
    	Release( _se_R3 );
    	Release( _se_R4 );
    }

    private void SO_bump1()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_name=Pop(__fVarying);
    	IqShaderData name = _se_name.m_Data;
    	SqStackEntry _se_channel=Pop(__fVarying);
    	IqShaderData channel = _se_channel.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_bump1(name,channel,pResult,this,cParams,aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_name );
    	Release( _se_channel );
    }

    private void SO_bump2()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_name=Pop(__fVarying);
    	IqShaderData name = _se_name.m_Data;
    	SqStackEntry _se_channel=Pop(__fVarying);
    	IqShaderData channel = _se_channel.m_Data;
    	SqStackEntry _se_s1=Pop(__fVarying);
    	IqShaderData s1 = _se_s1.m_Data;
    	SqStackEntry _se_t1=Pop(__fVarying);
    	IqShaderData t1 = _se_t1.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_bump2(name,channel,s1,t1,pResult,this, cParams, aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_name );
    	Release( _se_channel );
    	Release( _se_s1 );
    	Release( _se_t1 );
    }

    private void SO_bump3()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_name=Pop(__fVarying);
    	IqShaderData name = _se_name.m_Data;
    	SqStackEntry _se_channel=Pop(__fVarying);
    	IqShaderData channel = _se_channel.m_Data;
    	SqStackEntry _se_s1=Pop(__fVarying);
    	IqShaderData s1 = _se_s1.m_Data;
    	SqStackEntry _se_t1=Pop(__fVarying);
    	IqShaderData t1 = _se_t1.m_Data;
    	SqStackEntry _se_s2=Pop(__fVarying);
    	IqShaderData s2 = _se_s2.m_Data;
    	SqStackEntry _se_t2=Pop(__fVarying);
    	IqShaderData t2 = _se_t2.m_Data;
    	SqStackEntry _se_s3=Pop(__fVarying);
    	IqShaderData s3 = _se_s3.m_Data;
    	SqStackEntry _se_t3=Pop(__fVarying);
    	IqShaderData t3 = _se_t3.m_Data;
    	SqStackEntry _se_s4=Pop(__fVarying);
    	IqShaderData s4 = _se_s4.m_Data;
    	SqStackEntry _se_t4=Pop(__fVarying);
    	IqShaderData t4 = _se_t4.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_bump3(name,channel,s1,t1,s2,t2,s3,t3,s4,t4,pResult,this,cParams,aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_name );
    	Release( _se_channel );
    	Release( _se_s1 );
    	Release( _se_t1 );
    	Release( _se_s2 );
    	Release( _se_t2 );
    	Release( _se_s3 );
    	Release( _se_t3 );
    	Release( _se_s4 );
    	Release( _se_t4 );
    }

    private void SO_illuminate()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	m_pEnv.SO_illuminate(ValA,this);
    	Release( _se_ValA );
    }
    
    private void SO_illuminate2()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	m_pEnv.SO_illuminate(ValA,ValB,ValC,this);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }

    private void SO_init_illuminance()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	m_pEnv.InvalidateIlluminanceCache();
    	m_pEnv.ValidateIlluminanceCache( A, null, this );
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),new EqVariableClass(class_varying));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	pResult.SetFloat( m_pEnv.SO_init_illuminance()?1:0 );
    	Push( pResult );
    	Release( _se_A );
    }
    
    private void SO_init_illuminance2()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_A=Pop(__fVarying);
    	IqShaderData A = _se_A.m_Data;
    	SqStackEntry _se_B=Pop(__fVarying);
    	IqShaderData B = _se_B.m_Data;
    	m_pEnv.InvalidateIlluminanceCache();
    	m_pEnv.ValidateIlluminanceCache( A, B, this );
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),new EqVariableClass(class_varying));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	pResult.SetFloat( m_pEnv.SO_init_illuminance()?1:0 );
    	Push( pResult );
    	Release( _se_A );
    }

    private void SO_advance_illuminance()
    {
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),new EqVariableClass(class_varying));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	pResult.SetFloat( m_pEnv.SO_advance_illuminance()?1:0 );
    	Push( pResult );
    }
    
    private void SO_illuminance()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	m_pEnv.SO_illuminance(ValA,ValB,this);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_illuminance2()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	SqStackEntry _se_ValD=Pop(__fVarying);
    	IqShaderData ValD = _se_ValD.m_Data;
    	m_pEnv.SO_illuminance(ValA,ValB,ValC,ValD,this);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    	Release( _se_ValD );
    }
   
    private void SO_solar()
    {
    	p_boolean __fVarying=new p_boolean(true);
        m_pEnv.SO_solar(this);
    }

    private void SO_solar2()
    {
    	p_boolean __fVarying=new p_boolean(true);
        SqStackEntry _se_ValA=Pop(__fVarying);
        IqShaderData ValA = _se_ValA.m_Data;
        SqStackEntry _se_ValB=Pop(__fVarying);
        IqShaderData ValB = _se_ValB.m_Data;
        m_pEnv.SO_solar(ValA,ValB,this);
        Release( _se_ValA );
        Release( _se_ValB );
    }
    
    private void SO_printf()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_a=Pop(__fVarying);
    	IqShaderData a = _se_a.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	m_pEnv.SO_printf(a,this, cParams, aParams);
    	Release( _se_count );
    	Release( _se_a );
    }

    private void SO_atmosphere()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	IqShaderData pV = GetVar( ReadNext().m_iVariable );
    	SqStackEntry _se_Val=Pop(__fVarying);
    	IqShaderData Val = _se_Val.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_atmosphere( Val, pV, pResult );
    	Push( pResult );
    	Release( _se_Val );
    }
    
    private void SO_displacement()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	IqShaderData pV = GetVar( ReadNext().m_iVariable );
    	SqStackEntry _se_Val=Pop(__fVarying);
    	IqShaderData Val = _se_Val.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_displacement( Val, pV, pResult );
    	Push( pResult );
    	Release( _se_Val );
    }

    private void SO_lightsource()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	IqShaderData pV = GetVar( ReadNext().m_iVariable );
    	SqStackEntry _se_Val=Pop(__fVarying);
    	IqShaderData Val = _se_Val.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_lightsource( Val, pV, pResult );
    	Push( pResult );
    	Release( _se_Val );
    }

    private void SO_surface()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	IqShaderData pV = GetVar( ReadNext().m_iVariable );
    	SqStackEntry _se_Val=Pop(__fVarying);
    	IqShaderData Val = _se_Val.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_surface( Val, pV, pResult );
    	Push( pResult );
    	Release( _se_Val );
    }
    
    private void SO_attribute()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	IqShaderData pV = GetVar( ReadNext().m_iVariable );
    	SqStackEntry _se_Val=Pop(__fVarying);
    	IqShaderData Val = _se_Val.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_attribute( Val, pV, pResult );
    	Push( pResult );
    	Release( _se_Val );
    }
    
    private void SO_option()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	IqShaderData pV = GetVar( ReadNext().m_iVariable );
    	SqStackEntry _se_Val=Pop(__fVarying);
    	IqShaderData Val = _se_Val.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_option( Val, pV, pResult );
    	Push( pResult );
    	Release( _se_Val );
    }

    private void SO_rendererinfo()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	IqShaderData pV = GetVar( ReadNext().m_iVariable );
    	SqStackEntry _se_Val=Pop(__fVarying);
    	IqShaderData Val = _se_Val.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_rendererinfo( Val, pV, pResult );
    	Push( pResult );
    	Release( _se_Val );
    }

    private void SO_incident()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	IqShaderData pV = GetVar( ReadNext().m_iVariable );
    	SqStackEntry _se_Val=Pop(__fVarying);
    	IqShaderData Val = _se_Val.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_incident( Val, pV, pResult );
    	Push( pResult );
    	Release( _se_Val );
    }
    
    private void SO_opposite()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	IqShaderData pV = GetVar( ReadNext().m_iVariable );
    	SqStackEntry _se_Val=Pop(__fVarying);
    	IqShaderData Val = _se_Val.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_opposite( Val, pV, pResult );
    	Push( pResult );
    	Release( _se_Val );
    }

    private void SO_fcellnoise1()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_fcellnoise1(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }
    
    private void SO_fcellnoise2()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_fcellnoise2(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_fcellnoise3()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_fcellnoise3(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }
    
    private void SO_fcellnoise4()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_fcellnoise4(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_ccellnoise1()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ccellnoise1(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }
    
    private void SO_ccellnoise2()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ccellnoise2(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_ccellnoise3()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ccellnoise3(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }
    
    private void SO_ccellnoise4()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ccellnoise4(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_pcellnoise1()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_pcellnoise1(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }
    
    private void SO_pcellnoise2()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_pcellnoise2(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_pcellnoise3()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_pcellnoise3(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }
    
    private void SO_pcellnoise4()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_pcellnoise4(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_fpnoise1()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_fpnoise1(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_fpnoise2()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	SqStackEntry _se_ValD=Pop(__fVarying);
    	IqShaderData ValD = _se_ValD.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_fpnoise2(ValA,ValB,ValC,ValD,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    	Release( _se_ValD );
    }
    
    private void SO_fpnoise3()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_fpnoise3(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_fpnoise4()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	SqStackEntry _se_ValD=Pop(__fVarying);
    	IqShaderData ValD = _se_ValD.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_fpnoise4(ValA,ValB,ValC,ValD,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    	Release( _se_ValD );
    }

    private void SO_cpnoise1()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_cpnoise1(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_cpnoise2()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	SqStackEntry _se_ValD=Pop(__fVarying);
    	IqShaderData ValD = _se_ValD.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_cpnoise2(ValA,ValB,ValC,ValD,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    	Release( _se_ValD );
    }
    
    private void SO_cpnoise3()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_cpnoise3(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_cpnoise4()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	SqStackEntry _se_ValD=Pop(__fVarying);
    	IqShaderData ValD = _se_ValD.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_cpnoise4(ValA,ValB,ValC,ValD,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    	Release( _se_ValD );
    }

    private void SO_ppnoise1()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ppnoise1(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_ppnoise2()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	SqStackEntry _se_ValD=Pop(__fVarying);
    	IqShaderData ValD = _se_ValD.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ppnoise2(ValA,ValB,ValC,ValD,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    	Release( _se_ValD );
    }
    
    private void SO_ppnoise3()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ppnoise3(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_ppnoise4()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	SqStackEntry _se_ValD=Pop(__fVarying);
    	IqShaderData ValD = _se_ValD.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ppnoise4(ValA,ValB,ValC,ValD,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    	Release( _se_ValD );
    }

    private void SO_ctransform2()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ctransform(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }
    
    private void SO_ctransform()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_ctransform(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_ptlined()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_ValA=Pop(__fVarying);
        IqShaderData ValA = _se_ValA.m_Data;
        SqStackEntry _se_ValB=Pop(__fVarying);
        IqShaderData ValB = _se_ValB.m_Data;
        SqStackEntry _se_ValC=Pop(__fVarying);
        IqShaderData ValC = _se_ValC.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_ptlined(ValA,ValB,ValC,pResult,this);
        Push(pResult);
        Release( _se_ValA );
        Release( _se_ValB );
        Release( _se_ValC );
    }

    private void SO_inversesqrt()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_inversesqrt(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_concat()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_a=Pop(__fVarying);
    	IqShaderData a = _se_a.m_Data;
    	SqStackEntry _se_b=Pop(__fVarying);
    	IqShaderData b = _se_b.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_string),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_concat(a,b,pResult,this, cParams, aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_a );
    	Release( _se_b );
    }
    
    private void SO_format()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_count=Pop(__fVarying);
        IqShaderData count = _se_count.m_Data;
        SqStackEntry _se_a=Pop(__fVarying);
        IqShaderData a = _se_a.m_Data;
        p_float fc = new p_float();
        count.GetFloat( fc );
        int cParams=(int)( fc.value );
        IqShaderData[] aParams=new IqShaderData[cParams];
        int iP=0;
        while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_string),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_format(a,pResult,this, cParams, aParams);
        Push(pResult);
        Release( _se_count );
        Release( _se_a );
    }
    
    private void SO_match()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_match(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_rotate()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	SqStackEntry _se_ValD=Pop(__fVarying);
    	IqShaderData ValD = _se_ValD.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_rotate(ValA,ValB,ValC,ValD,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    	Release( _se_ValD );
    }

    private void SO_filterstep()
    {
        p_boolean __fVarying= new p_boolean(false);;
        SqStackEntry _se_count=Pop(__fVarying);
        IqShaderData count = _se_count.m_Data;
        SqStackEntry _se_a=Pop(__fVarying);
        IqShaderData a = _se_a.m_Data;
        SqStackEntry _se_b=Pop(__fVarying);
        IqShaderData b = _se_b.m_Data;
        p_float fc = new p_float();
        count.GetFloat( fc );
        int cParams=(int)( fc.value );
        IqShaderData[] aParams=new IqShaderData[cParams];
        int iP=0;
        while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_filterstep(a,b,pResult,this, cParams, aParams);
        Push(pResult);
        Release( _se_count );
        Release( _se_a );
        Release( _se_b );
    }

    private void SO_filterstep2()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_count=Pop(__fVarying);
    	IqShaderData count = _se_count.m_Data;
    	SqStackEntry _se_a=Pop(__fVarying);
    	IqShaderData a = _se_a.m_Data;
    	SqStackEntry _se_b=Pop(__fVarying);
    	IqShaderData b = _se_b.m_Data;
    	SqStackEntry _se_c=Pop(__fVarying);
    	IqShaderData c = _se_c.m_Data;
    	p_float fc = new p_float();
    	count.GetFloat( fc );
    	int cParams=(int)( fc.value );
    	IqShaderData[] aParams=new IqShaderData[cParams];
    	int iP=0;
    	while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_filterstep2(a,b,c,pResult,this, cParams, aParams);
    	Push(pResult);
    	Release( _se_count );
    	Release( _se_a );
    	Release( _se_b );
    	Release( _se_c );
    }

    private void SO_specularbrdf()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_ValA=Pop(__fVarying);
        IqShaderData ValA = _se_ValA.m_Data;
        SqStackEntry _se_ValB=Pop(__fVarying);
        IqShaderData ValB = _se_ValB.m_Data;
        SqStackEntry _se_ValC=Pop(__fVarying);
        IqShaderData ValC = _se_ValC.m_Data;
        SqStackEntry _se_ValD=Pop(__fVarying);
        IqShaderData ValD = _se_ValD.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_specularbrdf(ValA,ValB,ValC,ValD,pResult,this);
        Push(pResult);
        Release( _se_ValA );
        Release( _se_ValB );
        Release( _se_ValC );
        Release( _se_ValD );
    }

    private void SO_mcomp()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_A=Pop(__fVarying);
        IqShaderData A = _se_A.m_Data;
        SqStackEntry _se_B=Pop(__fVarying);
        IqShaderData B = _se_B.m_Data;
        SqStackEntry _se_C=Pop(__fVarying);
        IqShaderData C = _se_C.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        OpCOMPM( A, B, C, pResult, m_pEnv.RunningState() );
        Push( pResult );
        Release( _se_C );
        Release( _se_B );
        Release( _se_A );
    }

    private void SO_setmcomp()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	SqStackEntry _se_ValD=Pop(__fVarying);
    	IqShaderData ValD = _se_ValD.m_Data;
    	m_pEnv.SO_setmcomp(ValA,ValB,ValC,ValD,this);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    	Release( _se_ValD );
    }

    private void SO_determinant()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_determinant(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_mtranslate()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqStackEntry _se_ValA=Pop(__fVarying);
        IqShaderData ValA = _se_ValA.m_Data;
        SqStackEntry _se_ValB=Pop(__fVarying);
        IqShaderData ValB = _se_ValB.m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_matrix),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_mtranslate(ValA,ValB,pResult,this);
        Push(pResult);
        Release( _se_ValA );
        Release( _se_ValB );
    }
    
    private void SO_mrotate()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_matrix),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_mrotate(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }
    
    private void SO_mscale()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_matrix),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_mscale(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_fsplinea()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_fsplinea(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_csplinea()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_csplinea(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }
    
    private void SO_psplinea()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_psplinea(ValA,ValB,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    }

    private void SO_sfsplinea()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_sfsplinea(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }
    
    private void SO_scsplinea()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_color),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_scsplinea(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }
    
    private void SO_spsplinea()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_point),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_spsplinea(ValA,ValB,ValC,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    }

    private void SO_shadername()
    {
        p_boolean __fVarying= new p_boolean(false);
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_string),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_shadername(pResult,this);
        Push(pResult);
    }
    
    private void SO_shadername2()
    {
    	p_boolean __fVarying= new p_boolean(false);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	IqShaderData pResult=GetNextTemp(new EqVariableType(type_string),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
    	pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
    	m_pEnv.SO_shadername2(ValA,pResult,this);
    	Push(pResult);
    	Release( _se_ValA );
    }

    private void SO_bake_f()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	SqStackEntry _se_ValD=Pop(__fVarying);
    	IqShaderData ValD = _se_ValD.m_Data;
    	m_pEnv.SO_bake_f(ValA,ValB,ValC,ValD,this);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    	Release( _se_ValD );
    }
    private void SO_bake_3c()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	SqStackEntry _se_ValD=Pop(__fVarying);
    	IqShaderData ValD = _se_ValD.m_Data;
    	m_pEnv.SO_bake_3c(ValA,ValB,ValC,ValD,this);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    	Release( _se_ValD );
    }
    private void SO_bake_3p()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	SqStackEntry _se_ValD=Pop(__fVarying);
    	IqShaderData ValD = _se_ValD.m_Data;
    	m_pEnv.SO_bake_3p(ValA,ValB,ValC,ValD,this);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    	Release( _se_ValD );
    }
    private void SO_bake_3v()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	SqStackEntry _se_ValD=Pop(__fVarying);
    	IqShaderData ValD = _se_ValD.m_Data;
    	m_pEnv.SO_bake_3v(ValA,ValB,ValC,ValD,this);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    	Release( _se_ValD );
    }
    private void SO_bake_3n()
    {
    	p_boolean __fVarying=new p_boolean(true);
    	SqStackEntry _se_ValA=Pop(__fVarying);
    	IqShaderData ValA = _se_ValA.m_Data;
    	SqStackEntry _se_ValB=Pop(__fVarying);
    	IqShaderData ValB = _se_ValB.m_Data;
    	SqStackEntry _se_ValC=Pop(__fVarying);
    	IqShaderData ValC = _se_ValC.m_Data;
    	SqStackEntry _se_ValD=Pop(__fVarying);
    	IqShaderData ValD = _se_ValD.m_Data;
    	m_pEnv.SO_bake_3n(ValA,ValB,ValC,ValD,this);
    	Release( _se_ValA );
    	Release( _se_ValB );
    	Release( _se_ValC );
    	Release( _se_ValD );
    }

    private void	SO_external()
    {
        p_boolean __fVarying= new p_boolean(false);
        SqDSOExternalCall pCall = ReadNext().m_pExtCall;
        // This is a little ugly, but it means we can still use RESULT with Voids.
        IqShaderData pResult=GetNextTemp((pCall.return_type.getValue() != type_void ? pCall.return_type : new EqVariableType(type_float)),new EqVariableClass(class_varying));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));


        SqStackEntry[] stackitems = new SqStackEntry[pCall.arg_types.size()];
        IqShaderData[] arg_data = new IqShaderData[pCall.arg_types.size()];
        int x = 0;
        for ( x = 0 ; x < pCall.arg_types.size();x++){
            stackitems[x] = Pop(__fVarying);
            arg_data[x] = stackitems[x].m_Data;
        };

        m_pEnv.SO_external(pCall.method, pCall.initData, pResult, this, pCall.arg_types.size(),arg_data);

        for ( x = 0 ; x < pCall.arg_types.size();x++){
            Release( stackitems[x] );
        };

        //delete[]( stackitems );
        //delete[](arg_data);

        if( pCall.return_type.getValue() != type_void )
        {
            Push( pResult );
        } else {
            DeleteTemporaryStorage( pResult );
        };
    }
    
    private void SO_occlusion()
    {
    	p_boolean __fVarying=new p_boolean(true);
        SqStackEntry _se_count=Pop(__fVarying);
        IqShaderData count = _se_count.m_Data;
        SqStackEntry _se_name=Pop(__fVarying);
        IqShaderData name = _se_name.m_Data;
        SqStackEntry _se_channel=Pop(__fVarying);
        IqShaderData channel = _se_channel.m_Data;
        SqStackEntry _se_P=Pop(__fVarying);
        IqShaderData P = _se_P.m_Data;
        SqStackEntry _se_N=Pop(__fVarying);
        IqShaderData N = _se_N.m_Data;
        SqStackEntry _se_samples=Pop(__fVarying);
        IqShaderData samples = _se_samples.m_Data;
        p_float fc = new p_float();
        count.GetFloat( fc );
        int cParams=(int)( fc.value );
        IqShaderData[] aParams=new IqShaderData[cParams];
        int iP=0;
        while(iP!=cParams) aParams[iP++]=Pop(__fVarying).m_Data;
        IqShaderData pResult=GetNextTemp(new EqVariableType(type_float),__fVarying.value?new EqVariableClass(class_varying):new EqVariableClass(class_uniform));
        pResult.SetSize(( m_uGridRes + 1 ) * ( m_vGridRes + 1 ));
        m_pEnv.SO_occlusion(name,channel,P,N,samples,pResult,this, cParams, aParams);
        Push(pResult);
        Release( _se_count );
        Release( _se_name );
        Release( _se_channel );
        Release( _se_P );
        Release( _se_N );
        Release( _se_samples );
    }


   
    private static	SqOpCodeTrans	m_TransTable[] = new SqOpCodeTrans[325];		///< Static opcode translation table.

    {
		try {
			m_TransTable[0] = new SqOpCodeTrans("RS_PUSH", 		0, this.getClass().getDeclaredMethod( "SO_RS_PUSH"), 0, new int[]{0} );
			m_TransTable[1] = new SqOpCodeTrans("RS_POP", 		0, this.getClass().getDeclaredMethod( "SO_RS_POP" ), 0, new int[]{0} );
			m_TransTable[2] = new SqOpCodeTrans("RS_GET", 		0, this.getClass().getDeclaredMethod( "SO_RS_GET" ), 0, new int[]{0} );
			m_TransTable[3] = new SqOpCodeTrans("RS_INVERSE", 	0, this.getClass().getDeclaredMethod( "SO_RS_INVERSE" ), 0, new int[]{0} );
			m_TransTable[4] = new SqOpCodeTrans("RS_JZ", 		0, this.getClass().getDeclaredMethod( "SO_RS_JZ" ), 1, new int[]{type_float});
			m_TransTable[5] = new SqOpCodeTrans("RS_JNZ", 		0, this.getClass().getDeclaredMethod( "SO_RS_JNZ" ), 1, new int[]{type_float});
			m_TransTable[6] = new SqOpCodeTrans("S_JZ", 		0, this.getClass().getDeclaredMethod( "SO_S_JZ" ), 1, new int[]{type_float});
			m_TransTable[7] = new SqOpCodeTrans("S_JNZ", 		0, this.getClass().getDeclaredMethod( "SO_S_JNZ" ), 1, new int[]{type_float});
			m_TransTable[8] = new SqOpCodeTrans("S_GET", 		0, this.getClass().getDeclaredMethod( "SO_S_GET" ), 0, new int[]{0});
			m_TransTable[9] = new SqOpCodeTrans("S_CLEAR", 		0, this.getClass().getDeclaredMethod( "SO_S_CLEAR" ), 0, new int[]{0});

			m_TransTable[10] = new SqOpCodeTrans("nop", 		0, this.getClass().getDeclaredMethod( "SO_nop" ), 0, new int[]{0});
			m_TransTable[11] = new SqOpCodeTrans("dup", 		0, this.getClass().getDeclaredMethod( "SO_dup" ), 0, new int[]{0});
			m_TransTable[12] = new SqOpCodeTrans("debug_break", 0, this.getClass().getDeclaredMethod( "SO_debug_break" ), 0, new int[]{0});
			m_TransTable[13] = new SqOpCodeTrans("drop", 		0, this.getClass().getDeclaredMethod( "SO_drop" ), 0, new int[]{0});

			m_TransTable[14] = new SqOpCodeTrans("mergef", 		0, this.getClass().getDeclaredMethod( "SO_mergef" ), 0, new int[]{0});
			m_TransTable[15] = new SqOpCodeTrans("merges", 		0, this.getClass().getDeclaredMethod( "SO_merges" ), 0, new int[]{0});
			m_TransTable[16] = new SqOpCodeTrans("mergep", 		0, this.getClass().getDeclaredMethod( "SO_mergep" ), 0, new int[]{0});
			m_TransTable[17] = new SqOpCodeTrans("mergen", 		0, this.getClass().getDeclaredMethod( "SO_mergep" ), 0, new int[]{0});
			m_TransTable[18] = new SqOpCodeTrans("mergev", 		0, this.getClass().getDeclaredMethod( "SO_mergep" ), 0, new int[]{0});
			m_TransTable[19] = new SqOpCodeTrans("mergec", 		0, this.getClass().getDeclaredMethod( "SO_mergec" ), 0, new int[]{0});

			m_TransTable[20] = new SqOpCodeTrans("pushif", 		0, this.getClass().getDeclaredMethod( "SO_pushif" ), 1, new int[]{type_float});
			m_TransTable[21] = new SqOpCodeTrans("puship", 		0, this.getClass().getDeclaredMethod( "SO_puship" ), 3, new int[]{type_float, type_float, type_float});
			m_TransTable[22] = new SqOpCodeTrans("pushis", 		0, this.getClass().getDeclaredMethod( "SO_pushis" ), 1, new int[]{type_string});
			m_TransTable[23] = new SqOpCodeTrans("pushv", 		0, this.getClass().getDeclaredMethod( "SO_pushv" ), 1, new int[]{type_invalid});
			m_TransTable[24] = new SqOpCodeTrans("ipushv", 		0, this.getClass().getDeclaredMethod( "SO_ipushv" ), 1, new int[]{type_invalid});

			m_TransTable[25] = new SqOpCodeTrans("pop", 		0, this.getClass().getDeclaredMethod( "SO_pop" ), 1, new int[]{type_invalid});
			m_TransTable[26] = new SqOpCodeTrans("ipop", 		0, this.getClass().getDeclaredMethod( "SO_ipop" ), 1, new int[]{type_invalid});

			m_TransTable[27] = new SqOpCodeTrans("setfc", 		0, this.getClass().getDeclaredMethod( "SO_setfc" ), 0, new int[]{0});
			m_TransTable[28] = new SqOpCodeTrans("setfp", 		0, this.getClass().getDeclaredMethod( "SO_setfp" ), 0, new int[]{0});
			m_TransTable[29] = new SqOpCodeTrans("setfn", 		0, this.getClass().getDeclaredMethod( "SO_setfp" ), 0, new int[]{0});
			m_TransTable[30] = new SqOpCodeTrans("setfv", 		0, this.getClass().getDeclaredMethod( "SO_setfp" ), 0, new int[]{0});
			m_TransTable[31] = new SqOpCodeTrans("setfm",		0, this.getClass().getDeclaredMethod( "SO_setfm" ), 0, new int[]{0});

			m_TransTable[32] = new SqOpCodeTrans("settc", 		0, this.getClass().getDeclaredMethod( "SO_settc" ), 0, new int[]{0});
			m_TransTable[33] = new SqOpCodeTrans("settp", 		0, this.getClass().getDeclaredMethod( "SO_settp" ), 0, new int[]{0});
			m_TransTable[34] = new SqOpCodeTrans("settn", 		0, this.getClass().getDeclaredMethod( "SO_settp" ), 0, new int[]{0});
			m_TransTable[35] = new SqOpCodeTrans("settv", 		0, this.getClass().getDeclaredMethod( "SO_settp" ), 0, new int[]{0});

			m_TransTable[36] = new SqOpCodeTrans("setpc", 		0, this.getClass().getDeclaredMethod( "SO_setpc" ), 0, new int[]{0});
			m_TransTable[37] = new SqOpCodeTrans("setvc", 		0, this.getClass().getDeclaredMethod( "SO_setpc" ), 0, new int[]{0});
			m_TransTable[38] = new SqOpCodeTrans("setnc", 		0, this.getClass().getDeclaredMethod( "SO_setpc" ), 0, new int[]{0});

			m_TransTable[39] = new SqOpCodeTrans("setcp", 		0, this.getClass().getDeclaredMethod( "SO_setcp" ), 0, new int[]{0});
			m_TransTable[40] = new SqOpCodeTrans("setcn", 		0, this.getClass().getDeclaredMethod( "SO_setcp" ), 0, new int[]{0});
			m_TransTable[41] = new SqOpCodeTrans("setcv", 		0, this.getClass().getDeclaredMethod( "SO_setcp" ), 0, new int[]{0});

			m_TransTable[42] = new SqOpCodeTrans("setwm", 		0, this.getClass().getDeclaredMethod( "SO_setwm" ), 0, new int[]{0});

			m_TransTable[43] = new SqOpCodeTrans("jnz", 		0, this.getClass().getDeclaredMethod( "SO_jnz" ), 1, new int[]{type_float});
			m_TransTable[44] = new SqOpCodeTrans("jz", 			0, this.getClass().getDeclaredMethod( "SO_jz" ), 1, new int[]{type_float});
			m_TransTable[45] = new SqOpCodeTrans("jmp", 		0, this.getClass().getDeclaredMethod( "SO_jmp" ), 1, new int[]{type_float});

			m_TransTable[46] = new SqOpCodeTrans("lsff", 		0, this.getClass().getDeclaredMethod( "SO_lsff" ), 0, new int[]{0});
			m_TransTable[47] = new SqOpCodeTrans("lspp", 		0, this.getClass().getDeclaredMethod( "SO_lspp" ), 0, new int[]{0});
			m_TransTable[48] = new SqOpCodeTrans("lshh", 		0, this.getClass().getDeclaredMethod( "SO_lspp" ), 0, new int[]{0});
			m_TransTable[49] = new SqOpCodeTrans("lscc", 		0, this.getClass().getDeclaredMethod( "SO_lscc" ), 0, new int[]{0});
			m_TransTable[50] = new SqOpCodeTrans("lsnn", 		0, this.getClass().getDeclaredMethod( "SO_lspp" ), 0, new int[]{0});
			m_TransTable[51] = new SqOpCodeTrans("lsvv", 		0, this.getClass().getDeclaredMethod( "SO_lspp" ), 0, new int[]{0});

			m_TransTable[52] = new SqOpCodeTrans("gtff", 		0, this.getClass().getDeclaredMethod( "SO_gtff" ), 0, new int[]{0});
			m_TransTable[53] = new SqOpCodeTrans("gtpp", 		0, this.getClass().getDeclaredMethod( "SO_gtpp" ), 0, new int[]{0});
			m_TransTable[54] = new SqOpCodeTrans("gthh", 		0, this.getClass().getDeclaredMethod( "SO_gtpp" ), 0, new int[]{0});
			m_TransTable[55] = new SqOpCodeTrans("gtcc", 		0, this.getClass().getDeclaredMethod( "SO_gtcc" ), 0, new int[]{0});
			m_TransTable[56] = new SqOpCodeTrans("gtnn", 		0, this.getClass().getDeclaredMethod( "SO_gtpp" ), 0, new int[]{0});
			m_TransTable[57] = new SqOpCodeTrans("gtvv", 		0, this.getClass().getDeclaredMethod( "SO_gtpp" ), 0, new int[]{0});

			m_TransTable[58] = new SqOpCodeTrans("geff", 		0, this.getClass().getDeclaredMethod( "SO_geff" ), 0, new int[]{0});
			m_TransTable[59] = new SqOpCodeTrans("gepp", 		0, this.getClass().getDeclaredMethod( "SO_gepp" ), 0, new int[]{0});
			m_TransTable[60] = new SqOpCodeTrans("gehh", 		0, this.getClass().getDeclaredMethod( "SO_gepp" ), 0, new int[]{0});
			m_TransTable[61] = new SqOpCodeTrans("gecc", 		0, this.getClass().getDeclaredMethod( "SO_gecc" ), 0, new int[]{0});
			m_TransTable[62] = new SqOpCodeTrans("genn", 		0, this.getClass().getDeclaredMethod( "SO_gepp" ), 0, new int[]{0});
			m_TransTable[63] = new SqOpCodeTrans("gevv", 		0, this.getClass().getDeclaredMethod( "SO_gepp" ), 0, new int[]{0});

			m_TransTable[64] = new SqOpCodeTrans("leff", 		0, this.getClass().getDeclaredMethod( "SO_leff" ), 0, new int[]{0});
			m_TransTable[65] = new SqOpCodeTrans("lepp", 		0, this.getClass().getDeclaredMethod( "SO_lepp" ), 0, new int[]{0});
			m_TransTable[66] = new SqOpCodeTrans("lehh", 		0, this.getClass().getDeclaredMethod( "SO_lepp" ), 0, new int[]{0});
			m_TransTable[67] = new SqOpCodeTrans("lecc", 		0, this.getClass().getDeclaredMethod( "SO_lecc" ), 0, new int[]{0});
			m_TransTable[68] = new SqOpCodeTrans("lenn", 		0, this.getClass().getDeclaredMethod( "SO_lepp" ), 0, new int[]{0});
			m_TransTable[69] = new SqOpCodeTrans("levv", 		0, this.getClass().getDeclaredMethod( "SO_lepp" ), 0, new int[]{0});

			m_TransTable[70] = new SqOpCodeTrans("eqff", 		0, this.getClass().getDeclaredMethod( "SO_eqff" ), 0, new int[]{0});
			m_TransTable[71] = new SqOpCodeTrans("eqpp", 		0, this.getClass().getDeclaredMethod( "SO_eqpp" ), 0, new int[]{0});
			m_TransTable[72] = new SqOpCodeTrans("eqhh", 		0, this.getClass().getDeclaredMethod( "SO_eqpp" ), 0, new int[]{0});
			m_TransTable[73] = new SqOpCodeTrans("eqcc", 		0, this.getClass().getDeclaredMethod( "SO_eqcc" ), 0, new int[]{0});
			m_TransTable[74] = new SqOpCodeTrans("eqss", 		0, this.getClass().getDeclaredMethod( "SO_eqss" ), 0, new int[]{0});
			m_TransTable[75] = new SqOpCodeTrans("eqnn", 		0, this.getClass().getDeclaredMethod( "SO_eqpp" ), 0, new int[]{0});
			m_TransTable[76] = new SqOpCodeTrans("eqvv", 		0, this.getClass().getDeclaredMethod( "SO_eqpp" ), 0, new int[]{0});

			m_TransTable[77] = new SqOpCodeTrans("neff", 		0, this.getClass().getDeclaredMethod( "SO_neff" ), 0, new int[]{0});
			m_TransTable[78] = new SqOpCodeTrans("nepp", 		0, this.getClass().getDeclaredMethod( "SO_nepp" ), 0, new int[]{0});
			m_TransTable[79] = new SqOpCodeTrans("nehh", 		0, this.getClass().getDeclaredMethod( "SO_nepp" ), 0, new int[]{0});
			m_TransTable[80] = new SqOpCodeTrans("necc", 		0, this.getClass().getDeclaredMethod( "SO_necc" ), 0, new int[]{0});
			m_TransTable[81] = new SqOpCodeTrans("ness", 		0, this.getClass().getDeclaredMethod( "SO_ness" ), 0, new int[]{0});
			m_TransTable[82] = new SqOpCodeTrans("nenn", 		0, this.getClass().getDeclaredMethod( "SO_nepp" ), 0, new int[]{0});
			m_TransTable[83] = new SqOpCodeTrans("nevv", 		0, this.getClass().getDeclaredMethod( "SO_nepp" ), 0, new int[]{0});

			m_TransTable[84] = new SqOpCodeTrans("mulff", 		0, this.getClass().getDeclaredMethod( "SO_mulff" ), 0, new int[]{0});
			m_TransTable[85] = new SqOpCodeTrans("divff", 		0, this.getClass().getDeclaredMethod( "SO_divff" ), 0, new int[]{0});
			m_TransTable[86] = new SqOpCodeTrans("addff", 		0, this.getClass().getDeclaredMethod( "SO_addff" ), 0, new int[]{0});
			m_TransTable[87] = new SqOpCodeTrans("subff", 		0, this.getClass().getDeclaredMethod( "SO_subff" ), 0, new int[]{0});
			m_TransTable[88] = new SqOpCodeTrans("negf", 		0, this.getClass().getDeclaredMethod( "SO_negf" ), 0, new int[]{0});

			m_TransTable[89] = new SqOpCodeTrans("mulpp", 		0, this.getClass().getDeclaredMethod( "SO_mulpp" ), 0, new int[]{0});
	        m_TransTable[90] = new SqOpCodeTrans("divpp", 		0, this.getClass().getDeclaredMethod( "SO_divpp" ), 0, new int[]{0});
	        m_TransTable[91] = new SqOpCodeTrans("addpp", 		0, this.getClass().getDeclaredMethod( "SO_addpp" ), 0, new int[]{0});
	        m_TransTable[92] = new SqOpCodeTrans("subpp", 		0, this.getClass().getDeclaredMethod( "SO_subpp" ), 0, new int[]{0});
	        m_TransTable[93] = new SqOpCodeTrans("crspp", 		0, this.getClass().getDeclaredMethod( "SO_crspp" ), 0, new int[]{0});
	        m_TransTable[94] = new SqOpCodeTrans("dotpp", 		0, this.getClass().getDeclaredMethod( "SO_dotpp" ), 0, new int[]{0});
	        m_TransTable[95] = new SqOpCodeTrans("negp", 		0, this.getClass().getDeclaredMethod( "SO_negp" ), 0, new int[]{0});

	        m_TransTable[96] = new SqOpCodeTrans("mulcc", 		0, this.getClass().getDeclaredMethod( "SO_mulcc" ), 0, new int[]{0});
	        m_TransTable[97] = new SqOpCodeTrans("divcc",		0, this.getClass().getDeclaredMethod( "SO_divcc" ), 0, new int[]{0});
	        m_TransTable[98] = new SqOpCodeTrans("addcc", 		0, this.getClass().getDeclaredMethod( "SO_addcc" ), 0, new int[]{0});
	        m_TransTable[99] = new SqOpCodeTrans("subcc", 		0, this.getClass().getDeclaredMethod( "SO_subcc" ), 0, new int[]{0});
	        m_TransTable[100] = new SqOpCodeTrans("crscc", 		0, this.getClass().getDeclaredMethod( "SO_crscc" ), 0, new int[]{0});
	        m_TransTable[101] = new SqOpCodeTrans("dotcc", 		0, this.getClass().getDeclaredMethod( "SO_dotcc" ), 0, new int[]{0});
	        m_TransTable[102] = new SqOpCodeTrans("negc", 		0, this.getClass().getDeclaredMethod( "SO_negc" ), 0, new int[]{0});

	        m_TransTable[103] = new SqOpCodeTrans("mulfp", 		0, this.getClass().getDeclaredMethod( "SO_mulfp" ), 0, new int[]{0});
	        m_TransTable[104] = new SqOpCodeTrans("divfp", 		0, this.getClass().getDeclaredMethod( "SO_divfp" ), 0, new int[]{0});
	        m_TransTable[105] = new SqOpCodeTrans("addfp", 		0, this.getClass().getDeclaredMethod( "SO_addfp" ), 0, new int[]{0});
	        m_TransTable[106] = new SqOpCodeTrans("subfp", 		0, this.getClass().getDeclaredMethod( "SO_subfp" ), 0, new int[]{0});

	        m_TransTable[107] = new SqOpCodeTrans("mulfc", 		0, this.getClass().getDeclaredMethod( "SO_mulfc" ), 0, new int[]{0});
	        m_TransTable[108] = new SqOpCodeTrans("divfc", 		0, this.getClass().getDeclaredMethod( "SO_divfc" ), 0, new int[]{0});
	        m_TransTable[109] = new SqOpCodeTrans("addfc", 		0, this.getClass().getDeclaredMethod( "SO_addfc" ), 0, new int[]{0});
	        m_TransTable[110] = new SqOpCodeTrans("subfc", 		0, this.getClass().getDeclaredMethod( "SO_subfc" ), 0, new int[]{0});

	        m_TransTable[111] = new SqOpCodeTrans("mulmm", 		0, this.getClass().getDeclaredMethod( "SO_mulmm" ), 0, new int[]{0});
	        m_TransTable[112] = new SqOpCodeTrans("divmm", 		0, this.getClass().getDeclaredMethod( "SO_divmm" ), 0, new int[]{0});

	        m_TransTable[113] = new SqOpCodeTrans("land", 		0, this.getClass().getDeclaredMethod( "SO_land" ), 0, new int[]{0});
	        m_TransTable[114] = new SqOpCodeTrans("lor", 		0, this.getClass().getDeclaredMethod( "SO_lor" ), 0, new int[]{0});

	        m_TransTable[115] = new SqOpCodeTrans("radians", 	0, this.getClass().getDeclaredMethod( "SO_radians" ), 0, new int[]{0});
	        m_TransTable[116] = new SqOpCodeTrans("degrees", 	0, this.getClass().getDeclaredMethod( "SO_degrees" ), 0, new int[]{0});
	        m_TransTable[117] = new SqOpCodeTrans("sin", 		0, this.getClass().getDeclaredMethod( "SO_sin" ), 0, new int[]{0});
	        m_TransTable[118] = new SqOpCodeTrans("asin", 		0, this.getClass().getDeclaredMethod( "SO_asin" ), 0, new int[]{0});
	        m_TransTable[119] = new SqOpCodeTrans("cos", 		0, this.getClass().getDeclaredMethod( "SO_cos" ), 0, new int[]{0});
	        m_TransTable[120] = new SqOpCodeTrans("acos", 		0, this.getClass().getDeclaredMethod( "SO_acos" ), 0, new int[]{0});
	        m_TransTable[121] = new SqOpCodeTrans("tan", 		0, this.getClass().getDeclaredMethod( "SO_tan" ), 0, new int[]{0});
	        m_TransTable[122] = new SqOpCodeTrans("atan", 		0, this.getClass().getDeclaredMethod( "SO_atan" ), 0, new int[]{0});
	        m_TransTable[123] = new SqOpCodeTrans("atan2", 		0, this.getClass().getDeclaredMethod( "SO_atan2" ), 0, new int[]{0});
	        m_TransTable[124] = new SqOpCodeTrans("pow", 		0, this.getClass().getDeclaredMethod( "SO_pow" ), 0, new int[]{0});
	        m_TransTable[125] = new SqOpCodeTrans("exp", 		0, this.getClass().getDeclaredMethod( "SO_exp" ), 0, new int[]{0});
	        m_TransTable[126] = new SqOpCodeTrans("sqrt", 		0, this.getClass().getDeclaredMethod( "SO_sqrt" ), 0, new int[]{0});
	        m_TransTable[127] = new SqOpCodeTrans("log", 		0, this.getClass().getDeclaredMethod( "SO_log" ), 0, new int[]{0});
	        m_TransTable[128] = new SqOpCodeTrans("log2", 		0, this.getClass().getDeclaredMethod( "SO_log2" ), 0, new int[]{0});
	        m_TransTable[129] = new SqOpCodeTrans("mod", 		0, this.getClass().getDeclaredMethod( "SO_mod" ), 0, new int[]{0});
	        m_TransTable[130] = new SqOpCodeTrans("abs", 		0, this.getClass().getDeclaredMethod( "SO_abs" ), 0, new int[]{0});
	        m_TransTable[131] = new SqOpCodeTrans("sign", 		0, this.getClass().getDeclaredMethod( "SO_sign" ), 0, new int[]{0});
	        m_TransTable[132] = new SqOpCodeTrans("min", 		0, this.getClass().getDeclaredMethod( "SO_min" ), 0, new int[]{0});
	        m_TransTable[133] = new SqOpCodeTrans("max", 		0, this.getClass().getDeclaredMethod( "SO_max" ), 0, new int[]{0});
	        m_TransTable[134] = new SqOpCodeTrans("pmin", 		0, this.getClass().getDeclaredMethod( "SO_pmin" ), 0, new int[]{0});
	        m_TransTable[135] = new SqOpCodeTrans("pmax", 		0, this.getClass().getDeclaredMethod( "SO_pmax" ), 0, new int[]{0});
	        m_TransTable[136] = new SqOpCodeTrans("vmin", 		0, this.getClass().getDeclaredMethod( "SO_vmin" ), 0, new int[]{0});
	        m_TransTable[137] = new SqOpCodeTrans("vmax", 		0, this.getClass().getDeclaredMethod( "SO_vmax" ), 0, new int[]{0});
	        m_TransTable[138] = new SqOpCodeTrans("nmin", 		0, this.getClass().getDeclaredMethod( "SO_nmin" ), 0, new int[]{0});
	        m_TransTable[139] = new SqOpCodeTrans("nmax", 		0, this.getClass().getDeclaredMethod( "SO_nmax" ), 0, new int[]{0});
	        m_TransTable[140] = new SqOpCodeTrans("cmin", 		0, this.getClass().getDeclaredMethod( "SO_cmin" ), 0, new int[]{0});
	        m_TransTable[141] = new SqOpCodeTrans("cmax", 		0, this.getClass().getDeclaredMethod( "SO_cmax" ), 0, new int[]{0});
	        m_TransTable[142] = new SqOpCodeTrans("clamp", 		0, this.getClass().getDeclaredMethod( "SO_clamp" ), 0, new int[]{0});
	        m_TransTable[143] = new SqOpCodeTrans("pclamp", 	0, this.getClass().getDeclaredMethod( "SO_pclamp" ), 0, new int[]{0});
	        m_TransTable[144] = new SqOpCodeTrans("vclamp", 	0, this.getClass().getDeclaredMethod( "SO_pclamp" ), 0, new int[]{0});
	        m_TransTable[145] = new SqOpCodeTrans("nclamp", 	0, this.getClass().getDeclaredMethod( "SO_pclamp" ), 0, new int[]{0});
	        m_TransTable[146] = new SqOpCodeTrans("cclamp", 	0, this.getClass().getDeclaredMethod( "SO_cclamp" ), 0, new int[]{0});
	        m_TransTable[147] = new SqOpCodeTrans("floor", 		0, this.getClass().getDeclaredMethod( "SO_floor" ), 0, new int[]{0});
	        m_TransTable[148] = new SqOpCodeTrans("ceil", 		0, this.getClass().getDeclaredMethod( "SO_ceil" ), 0, new int[]{0});
	        m_TransTable[149] = new SqOpCodeTrans("round", 		0, this.getClass().getDeclaredMethod( "SO_round" ), 0, new int[]{0});
	        m_TransTable[150] = new SqOpCodeTrans("step", 		0, this.getClass().getDeclaredMethod( "SO_step" ), 0, new int[]{0});
	        m_TransTable[151] = new SqOpCodeTrans("smoothstep", 0, this.getClass().getDeclaredMethod( "SO_smoothstep" ), 0, new int[]{0});
	        m_TransTable[152] = new SqOpCodeTrans("fspline", 	0, this.getClass().getDeclaredMethod( "SO_fspline" ), 0, new int[]{0});
	        m_TransTable[153] = new SqOpCodeTrans("cspline", 	0, this.getClass().getDeclaredMethod( "SO_cspline" ), 0, new int[]{0});
	        m_TransTable[154] = new SqOpCodeTrans("pspline", 	0, this.getClass().getDeclaredMethod( "SO_pspline" ), 0, new int[]{0});
	        m_TransTable[155] = new SqOpCodeTrans("vspline", 	0, this.getClass().getDeclaredMethod( "SO_pspline" ), 0, new int[]{0});
	        m_TransTable[156] = new SqOpCodeTrans("sfspline", 	0, this.getClass().getDeclaredMethod( "SO_sfspline" ), 0, new int[]{0});
	        m_TransTable[157] = new SqOpCodeTrans("scspline", 	0, this.getClass().getDeclaredMethod( "SO_scspline" ), 0, new int[]{0});
	        m_TransTable[158] = new SqOpCodeTrans("spspline", 	0, this.getClass().getDeclaredMethod( "SO_spspline" ), 0, new int[]{0});
	        m_TransTable[159] = new SqOpCodeTrans("svspline", 	0, this.getClass().getDeclaredMethod( "SO_spspline" ), 0, new int[]{0});
	        m_TransTable[160] = new SqOpCodeTrans("fDu", 		0, this.getClass().getDeclaredMethod( "SO_fDu" ), 0, new int[]{0});
	        m_TransTable[161] = new SqOpCodeTrans("fDv", 		0, this.getClass().getDeclaredMethod( "SO_fDv" ), 0, new int[]{0});
	        m_TransTable[162] = new SqOpCodeTrans("fDeriv", 	0, this.getClass().getDeclaredMethod( "SO_fDeriv" ), 0, new int[]{0});
	        m_TransTable[163] = new SqOpCodeTrans("cDu", 		0, this.getClass().getDeclaredMethod( "SO_cDu" ), 0, new int[]{0});
	        m_TransTable[164] = new SqOpCodeTrans("cDv", 		0, this.getClass().getDeclaredMethod( "SO_cDv" ), 0, new int[]{0});
	        m_TransTable[165] = new SqOpCodeTrans("cDeriv", 	0, this.getClass().getDeclaredMethod( "SO_cDeriv" ), 0, new int[]{0});
	        m_TransTable[166] = new SqOpCodeTrans("pDu", 		0, this.getClass().getDeclaredMethod( "SO_pDu" ), 0, new int[]{0});
	        m_TransTable[167] = new SqOpCodeTrans("pDv", 		0, this.getClass().getDeclaredMethod( "SO_pDv" ), 0, new int[]{0});
	        m_TransTable[168] = new SqOpCodeTrans("pDeriv", 	0, this.getClass().getDeclaredMethod( "SO_pDeriv" ), 0, new int[]{0});
	        m_TransTable[169] = new SqOpCodeTrans("hDu", 		0, this.getClass().getDeclaredMethod( "SO_pDu" ), 0, new int[]{0});
	        m_TransTable[170] = new SqOpCodeTrans("hDv", 		0, this.getClass().getDeclaredMethod( "SO_pDv" ), 0, new int[]{0});
	        m_TransTable[171] = new SqOpCodeTrans("hDeriv", 	0, this.getClass().getDeclaredMethod( "SO_pDeriv" ), 0, new int[]{0});
	        m_TransTable[172] = new SqOpCodeTrans("nDu", 		0, this.getClass().getDeclaredMethod( "SO_pDu" ), 0, new int[]{0});
	        m_TransTable[173] = new SqOpCodeTrans("nDv", 		0, this.getClass().getDeclaredMethod( "SO_pDv" ), 0, new int[]{0});
	        m_TransTable[174] = new SqOpCodeTrans("nDeriv", 	0, this.getClass().getDeclaredMethod( "SO_pDeriv" ), 0, new int[]{0});
	        m_TransTable[175] = new SqOpCodeTrans("vDu",		0, this.getClass().getDeclaredMethod( "SO_pDu" ), 0, new int[]{0});
	        m_TransTable[176] = new SqOpCodeTrans("vDv", 		0, this.getClass().getDeclaredMethod( "SO_pDv" ), 0, new int[]{0});
	        m_TransTable[177] = new SqOpCodeTrans("vDeriv", 	0, this.getClass().getDeclaredMethod( "SO_pDeriv" ), 0, new int[]{0});
	        m_TransTable[178] = new SqOpCodeTrans("frandom", 	0, this.getClass().getDeclaredMethod( "SO_frandom" ), 0, new int[]{0});
	        m_TransTable[179] = new SqOpCodeTrans("crandom", 	0, this.getClass().getDeclaredMethod( "SO_crandom" ), 0, new int[]{0});
	        m_TransTable[180] = new SqOpCodeTrans("prandom", 	0, this.getClass().getDeclaredMethod( "SO_prandom" ), 0, new int[]{0});
	        m_TransTable[181] = new SqOpCodeTrans("noise1", 	0, this.getClass().getDeclaredMethod( "SO_noise1" ), 0, new int[]{0});
	        m_TransTable[182] = new SqOpCodeTrans("noise2", 	0, this.getClass().getDeclaredMethod( "SO_noise2" ), 0, new int[]{0});
	        m_TransTable[183] = new SqOpCodeTrans("noise3", 	0, this.getClass().getDeclaredMethod( "SO_noise3" ), 0, new int[]{0});
	        m_TransTable[184] = new SqOpCodeTrans("noise4", 	0, this.getClass().getDeclaredMethod( "SO_noise4" ), 0, new int[]{0});
	        m_TransTable[185] = new SqOpCodeTrans("cnoise1", 	0, this.getClass().getDeclaredMethod( "SO_cnoise1" ), 0, new int[]{0});
	        m_TransTable[186] = new SqOpCodeTrans("cnoise2", 	0, this.getClass().getDeclaredMethod( "SO_cnoise2" ), 0, new int[]{0});
	        m_TransTable[187] = new SqOpCodeTrans("cnoise3", 	0, this.getClass().getDeclaredMethod( "SO_cnoise3" ), 0, new int[]{0});
	        m_TransTable[188] = new SqOpCodeTrans("cnoise4", 	0, this.getClass().getDeclaredMethod( "SO_cnoise4" ), 0, new int[]{0});
	        m_TransTable[189] = new SqOpCodeTrans("pnoise1", 	0, this.getClass().getDeclaredMethod( "SO_pnoise1" ), 0, new int[]{0});
	        m_TransTable[190] = new SqOpCodeTrans("pnoise2", 	0, this.getClass().getDeclaredMethod( "SO_pnoise2" ), 0, new int[]{0});
	        m_TransTable[191] = new SqOpCodeTrans("pnoise3", 	0, this.getClass().getDeclaredMethod( "SO_pnoise3" ), 0, new int[]{0});
	        m_TransTable[192] = new SqOpCodeTrans("pnoise4", 	0, this.getClass().getDeclaredMethod( "SO_pnoise4" ), 0, new int[]{0});
	        m_TransTable[193] = new SqOpCodeTrans("xcomp", 		0, this.getClass().getDeclaredMethod( "SO_xcomp" ), 0, new int[]{0});
	        m_TransTable[194] = new SqOpCodeTrans("ycomp", 		0, this.getClass().getDeclaredMethod( "SO_ycomp" ), 0, new int[]{0});
	        m_TransTable[195] = new SqOpCodeTrans("zcomp", 		0, this.getClass().getDeclaredMethod( "SO_zcomp" ), 0, new int[]{0});
	        m_TransTable[196] = new SqOpCodeTrans("setxcomp", 	0, this.getClass().getDeclaredMethod( "SO_setxcomp" ), 0, new int[]{0});
	        m_TransTable[197] = new SqOpCodeTrans("setycomp", 	0, this.getClass().getDeclaredMethod( "SO_setycomp" ), 0, new int[]{0});
	        m_TransTable[198] = new SqOpCodeTrans("setzcomp", 	0, this.getClass().getDeclaredMethod( "SO_setzcomp" ), 0, new int[]{0});
	        m_TransTable[199] = new SqOpCodeTrans("length", 	0, this.getClass().getDeclaredMethod( "SO_length" ), 0, new int[]{0});
	        m_TransTable[200] = new SqOpCodeTrans("distance", 	0, this.getClass().getDeclaredMethod( "SO_distance" ), 0, new int[]{0});
	        m_TransTable[201] = new SqOpCodeTrans("area", 		0, this.getClass().getDeclaredMethod( "SO_area" ), 0, new int[]{0});
	        m_TransTable[202] = new SqOpCodeTrans("normalize", 	0, this.getClass().getDeclaredMethod( "SO_normalize" ), 0, new int[]{0});
	        m_TransTable[203] = new SqOpCodeTrans("faceforward",0, this.getClass().getDeclaredMethod( "SO_faceforward" ), 0, new int[]{0});
	        m_TransTable[204] = new SqOpCodeTrans("faceforward2",0, this.getClass().getDeclaredMethod( "SO_faceforward2" ), 0, new int[]{0});
	        m_TransTable[205] = new SqOpCodeTrans("reflect", 	0, this.getClass().getDeclaredMethod( "SO_reflect" ), 0, new int[]{0});
	        m_TransTable[206] = new SqOpCodeTrans("refract", 	0, this.getClass().getDeclaredMethod( "SO_refract" ), 0, new int[]{0});
	        m_TransTable[207] = new SqOpCodeTrans("fresnel", 	0, this.getClass().getDeclaredMethod( "SO_fresnel" ), 0, new int[]{0});
	        m_TransTable[208] = new SqOpCodeTrans("fresnel2", 	0, this.getClass().getDeclaredMethod( "SO_fresnel2" ), 0, new int[]{0});
	        m_TransTable[209] = new SqOpCodeTrans("transform2", 0, this.getClass().getDeclaredMethod( "SO_transform2" ), 0, new int[]{0});
	        m_TransTable[210] = new SqOpCodeTrans("transformm", 0, this.getClass().getDeclaredMethod( "SO_transformm" ), 0, new int[]{0});
	        m_TransTable[211] = new SqOpCodeTrans("transform", 	0, this.getClass().getDeclaredMethod( "SO_transform" ), 0, new int[]{0});
	        m_TransTable[212] = new SqOpCodeTrans("vtransform2",0, this.getClass().getDeclaredMethod( "SO_vtransform2" ), 0, new int[]{0});
	        m_TransTable[213] = new SqOpCodeTrans("vtransformm",0, this.getClass().getDeclaredMethod( "SO_vtransformm" ), 0, new int[]{0});
	        m_TransTable[214] = new SqOpCodeTrans("vtransform", 0, this.getClass().getDeclaredMethod( "SO_vtransform" ), 0, new int[]{0});
	        m_TransTable[215] = new SqOpCodeTrans("ntransform2",0, this.getClass().getDeclaredMethod( "SO_ntransform2" ), 0, new int[]{0});
	        m_TransTable[216] = new SqOpCodeTrans("ntransformm",0, this.getClass().getDeclaredMethod( "SO_ntransformm" ), 0, new int[]{0});
	        m_TransTable[217] = new SqOpCodeTrans("ntransform", 0, this.getClass().getDeclaredMethod( "SO_ntransform" ), 0, new int[]{0});
	        m_TransTable[218] = new SqOpCodeTrans("depth", 		0, this.getClass().getDeclaredMethod( "SO_depth" ), 0, new int[]{0});
	        m_TransTable[219] = new SqOpCodeTrans("calculatenormal", 0, this.getClass().getDeclaredMethod( "SO_calculatenormal" ), 0, new int[]{0});
	        m_TransTable[220] = new SqOpCodeTrans("cmix", 		0, this.getClass().getDeclaredMethod( "SO_cmix" ), 0, new int[]{0});
	        m_TransTable[221] = new SqOpCodeTrans("fmix", 		0, this.getClass().getDeclaredMethod( "SO_fmix" ), 0, new int[]{0});
	        m_TransTable[222] = new SqOpCodeTrans("pmix", 		0, this.getClass().getDeclaredMethod( "SO_pmix" ), 0, new int[]{0});
	        m_TransTable[223] = new SqOpCodeTrans("vmix", 		0, this.getClass().getDeclaredMethod( "SO_vmix" ), 0, new int[]{0});
	        m_TransTable[224] = new SqOpCodeTrans("nmix", 		0, this.getClass().getDeclaredMethod( "SO_nmix" ), 0, new int[]{0});
	        m_TransTable[225] = new SqOpCodeTrans("comp", 		0, this.getClass().getDeclaredMethod( "SO_comp" ), 0, new int[]{0});
	        m_TransTable[226] = new SqOpCodeTrans("setcomp", 	0, this.getClass().getDeclaredMethod( "SO_setcomp" ), 0, new int[]{0});
	        m_TransTable[227] = new SqOpCodeTrans("ambient", 	0, this.getClass().getDeclaredMethod( "SO_ambient" ), 0, new int[]{0});
	        m_TransTable[228] = new SqOpCodeTrans("diffuse", 	0, this.getClass().getDeclaredMethod( "SO_diffuse" ), 0, new int[]{0});
	        m_TransTable[229] = new SqOpCodeTrans("specular", 	0, this.getClass().getDeclaredMethod( "SO_specular" ), 0, new int[]{0});
	        m_TransTable[230] = new SqOpCodeTrans("phong", 		0, this.getClass().getDeclaredMethod( "SO_phong" ), 0, new int[]{0});
	        m_TransTable[231] = new SqOpCodeTrans("trace", 		0, this.getClass().getDeclaredMethod( "SO_trace" ), 0, new int[]{0});
	        m_TransTable[232] = new SqOpCodeTrans("ftexture1", 	0, this.getClass().getDeclaredMethod( "SO_ftexture1" ), 0, new int[]{0});
	        m_TransTable[233] = new SqOpCodeTrans("ftexture2", 	0, this.getClass().getDeclaredMethod( "SO_ftexture2" ), 0, new int[]{0});
	        m_TransTable[234] = new SqOpCodeTrans("ftexture3", 	0, this.getClass().getDeclaredMethod( "SO_ftexture3" ), 0, new int[]{0});
	        m_TransTable[235] = new SqOpCodeTrans("ctexture1", 	0, this.getClass().getDeclaredMethod( "SO_ctexture1" ), 0, new int[]{0});
	        m_TransTable[236] = new SqOpCodeTrans("ctexture2", 	0, this.getClass().getDeclaredMethod( "SO_ctexture2" ), 0, new int[]{0});
	        m_TransTable[237] = new SqOpCodeTrans("ctexture3", 	0, this.getClass().getDeclaredMethod( "SO_ctexture3" ), 0, new int[]{0});
	        m_TransTable[238] = new SqOpCodeTrans("textureinfo",0, this.getClass().getDeclaredMethod( "SO_textureinfo" ), 1, new int[]{type_invalid});
	        m_TransTable[239] = new SqOpCodeTrans("fenvironment2",0, this.getClass().getDeclaredMethod( "SO_fenvironment2" ), 0, new int[]{0});
	        m_TransTable[240] = new SqOpCodeTrans("fenvironment3",0, this.getClass().getDeclaredMethod( "SO_fenvironment3" ), 0, new int[]{0});
	        m_TransTable[241] = new SqOpCodeTrans("cenvironment2",0, this.getClass().getDeclaredMethod( "SO_cenvironment2" ), 0, new int[]{0});
	        m_TransTable[242] = new SqOpCodeTrans("cenvironment3",0, this.getClass().getDeclaredMethod( "SO_cenvironment3" ), 0, new int[]{0});
	        m_TransTable[243] = new SqOpCodeTrans("bump1", 		0, this.getClass().getDeclaredMethod( "SO_bump1" ), 0, new int[]{0});
	        m_TransTable[244] = new SqOpCodeTrans("bump2", 		0, this.getClass().getDeclaredMethod( "SO_bump2" ), 0, new int[]{0});
	        m_TransTable[245] = new SqOpCodeTrans("bump3", 		0, this.getClass().getDeclaredMethod( "SO_bump3" ), 0, new int[]{0});
	        m_TransTable[246] = new SqOpCodeTrans("shadow2", 	0, this.getClass().getDeclaredMethod( "SO_shadow1" ), 0, new int[]{0});
	        m_TransTable[247] = new SqOpCodeTrans("shadow", 	0, this.getClass().getDeclaredMethod( "SO_shadow" ), 0, new int[]{0});
	        m_TransTable[248] = new SqOpCodeTrans("illuminate2", 0, this.getClass().getDeclaredMethod( "SO_illuminate2" ), 0, new int[]{0});
	        m_TransTable[249] = new SqOpCodeTrans("illuminate", 0, this.getClass().getDeclaredMethod( "SO_illuminate" ), 0, new int[]{0});
	        m_TransTable[250] = new SqOpCodeTrans("illuminance2", 0, this.getClass().getDeclaredMethod( "SO_illuminance2" ), 0, new int[]{0});
	        m_TransTable[251] = new SqOpCodeTrans("illuminance", 0, this.getClass().getDeclaredMethod( "SO_illuminance" ), 0, new int[]{0});
	        m_TransTable[252] = new SqOpCodeTrans("init_illuminance2", 0, this.getClass().getDeclaredMethod( "SO_init_illuminance2" ), 0, new int[]{0});
	        m_TransTable[253] = new SqOpCodeTrans("init_illuminance", 0, this.getClass().getDeclaredMethod( "SO_init_illuminance" ), 0, new int[]{0});
	        m_TransTable[254] = new SqOpCodeTrans("advance_illuminance", 0, this.getClass().getDeclaredMethod( "SO_advance_illuminance" ), 0, new int[]{0});
	        m_TransTable[255] = new SqOpCodeTrans("solar2", 			0, this.getClass().getDeclaredMethod( "SO_solar2" ), 0, new int[]{0});
	        m_TransTable[256] = new SqOpCodeTrans("solar", 				0, this.getClass().getDeclaredMethod( "SO_solar" ), 0, new int[]{0});
	        m_TransTable[257] = new SqOpCodeTrans("printf", 			0, this.getClass().getDeclaredMethod( "SO_printf" ), 0, new int[]{0});

	        m_TransTable[258] = new SqOpCodeTrans("fcellnoise1", 0, this.getClass().getDeclaredMethod( "SO_fcellnoise1" ), 0, new int[]{0});
	        m_TransTable[259] = new SqOpCodeTrans("fcellnoise2", 0, this.getClass().getDeclaredMethod( "SO_fcellnoise2" ), 0, new int[]{0});
	        m_TransTable[260] = new SqOpCodeTrans("fcellnoise3", 0, this.getClass().getDeclaredMethod( "SO_fcellnoise3" ), 0, new int[]{0});
	        m_TransTable[261] = new SqOpCodeTrans("fcellnoise4", 0, this.getClass().getDeclaredMethod( "SO_fcellnoise4" ), 0, new int[]{0});
	        m_TransTable[262] = new SqOpCodeTrans("ccellnoise1", 0, this.getClass().getDeclaredMethod( "SO_ccellnoise1" ), 0, new int[]{0});
	        m_TransTable[263] = new SqOpCodeTrans("ccellnoise2", 0, this.getClass().getDeclaredMethod( "SO_ccellnoise2" ), 0, new int[]{0});
	        m_TransTable[264] = new SqOpCodeTrans("ccellnoise3", 0, this.getClass().getDeclaredMethod( "SO_ccellnoise3" ), 0, new int[]{0});
	        m_TransTable[265] = new SqOpCodeTrans("ccellnoise4", 0, this.getClass().getDeclaredMethod( "SO_ccellnoise4" ), 0, new int[]{0});
	        m_TransTable[266] = new SqOpCodeTrans("pcellnoise1", 0, this.getClass().getDeclaredMethod( "SO_pcellnoise1" ), 0, new int[]{0});
	        m_TransTable[267] = new SqOpCodeTrans("pcellnoise2", 0, this.getClass().getDeclaredMethod( "SO_pcellnoise2" ), 0, new int[]{0});
	        m_TransTable[268] = new SqOpCodeTrans("pcellnoise3", 0, this.getClass().getDeclaredMethod( "SO_pcellnoise3" ), 0, new int[]{0});
	        m_TransTable[269] = new SqOpCodeTrans("pcellnoise4", 0, this.getClass().getDeclaredMethod( "SO_pcellnoise4" ), 0, new int[]{0});

	        m_TransTable[270] = new SqOpCodeTrans("fpnoise1", 0, this.getClass().getDeclaredMethod( "SO_fpnoise1" ), 0, new int[]{0});
	        m_TransTable[271] = new SqOpCodeTrans("fpnoise2", 0, this.getClass().getDeclaredMethod( "SO_fpnoise2" ), 0, new int[]{0});
	        m_TransTable[272] = new SqOpCodeTrans("fpnoise3", 0, this.getClass().getDeclaredMethod( "SO_fpnoise3" ), 0, new int[]{0});
	        m_TransTable[273] = new SqOpCodeTrans("fpnoise4", 0, this.getClass().getDeclaredMethod( "SO_fpnoise4" ), 0, new int[]{0});
	        m_TransTable[274] = new SqOpCodeTrans("cpnoise1", 0, this.getClass().getDeclaredMethod( "SO_cpnoise1" ), 0, new int[]{0});
	        m_TransTable[275] = new SqOpCodeTrans("cpnoise2", 0, this.getClass().getDeclaredMethod( "SO_cpnoise2" ), 0, new int[]{0});
	        m_TransTable[276] = new SqOpCodeTrans("cpnoise3", 0, this.getClass().getDeclaredMethod( "SO_cpnoise3" ), 0, new int[]{0});
	        m_TransTable[277] = new SqOpCodeTrans("cpnoise4", 0, this.getClass().getDeclaredMethod( "SO_cpnoise4" ), 0, new int[]{0});
	        m_TransTable[278] = new SqOpCodeTrans("ppnoise1", 0, this.getClass().getDeclaredMethod( "SO_ppnoise1" ), 0, new int[]{0});
	        m_TransTable[279] = new SqOpCodeTrans("pnoise2", 0, this.getClass().getDeclaredMethod( "SO_ppnoise2" ), 0, new int[]{0});
	        m_TransTable[280] = new SqOpCodeTrans("ppnoise3", 0, this.getClass().getDeclaredMethod( "SO_ppnoise3" ), 0, new int[]{0});
	        m_TransTable[281] = new SqOpCodeTrans("ppnoise4", 0, this.getClass().getDeclaredMethod( "SO_ppnoise4" ), 0, new int[]{0});

	        m_TransTable[282] = new SqOpCodeTrans("atmosphere", 0, this.getClass().getDeclaredMethod( "SO_atmosphere" ), 1, new int[]{type_invalid});
	        m_TransTable[283] = new SqOpCodeTrans("displacement", 0, this.getClass().getDeclaredMethod( "SO_displacement" ), 1, new int[]{type_invalid});
	        m_TransTable[284] = new SqOpCodeTrans("lightsource", 0, this.getClass().getDeclaredMethod( "SO_lightsource" ), 1, new int[]{type_invalid});
	        m_TransTable[285] = new SqOpCodeTrans("surface", 0, this.getClass().getDeclaredMethod( "SO_surface" ), 1, new int[]{type_invalid});

	        m_TransTable[286] = new SqOpCodeTrans("attribute", 0, this.getClass().getDeclaredMethod( "SO_attribute" ), 1, new int[]{type_invalid});
	        m_TransTable[287] = new SqOpCodeTrans("option", 0, this.getClass().getDeclaredMethod( "SO_option" ), 1, new int[]{type_invalid});
	        m_TransTable[288] = new SqOpCodeTrans("rendererinfo", 0, this.getClass().getDeclaredMethod( "SO_rendererinfo" ), 1, new int[]{type_invalid});
	        m_TransTable[289] = new SqOpCodeTrans("incident", 0, this.getClass().getDeclaredMethod( "SO_incident" ), 1, new int[]{type_invalid});
	        m_TransTable[290] = new SqOpCodeTrans("opposite", 0, this.getClass().getDeclaredMethod( "SO_opposite" ), 1, new int[]{type_invalid});

	        m_TransTable[291] = new SqOpCodeTrans("ctransform", 0, this.getClass().getDeclaredMethod( "SO_ctransform" ), 0, new int[]{0});
	        m_TransTable[292] = new SqOpCodeTrans("ctransform2", 0, this.getClass().getDeclaredMethod( "SO_ctransform2" ), 0, new int[]{0});

	        m_TransTable[293] = new SqOpCodeTrans("ptlined", 0, this.getClass().getDeclaredMethod( "SO_ptlined" ), 0, new int[]{0});
	        m_TransTable[294] = new SqOpCodeTrans("inversesqrt", 0, this.getClass().getDeclaredMethod( "SO_inversesqrt" ), 0, new int[]{0});
	        m_TransTable[295] = new SqOpCodeTrans("concat", 0, this.getClass().getDeclaredMethod( "SO_concat" ), 0, new int[]{0});
	        m_TransTable[296] = new SqOpCodeTrans("format", 0, this.getClass().getDeclaredMethod( "SO_format" ), 0, new int[]{0});
	        m_TransTable[297] = new SqOpCodeTrans("match", 0, this.getClass().getDeclaredMethod( "SO_match" ), 0, new int[]{0});
	        m_TransTable[298] = new SqOpCodeTrans("rotate", 0, this.getClass().getDeclaredMethod( "SO_rotate" ), 0, new int[]{0});
	        m_TransTable[299] = new SqOpCodeTrans("filterstep", 0, this.getClass().getDeclaredMethod( "SO_filterstep" ), 0, new int[]{0});
	        m_TransTable[300] = new SqOpCodeTrans("filterstep2", 0, this.getClass().getDeclaredMethod( "SO_filterstep2" ), 0, new int[]{0});
	        m_TransTable[301] = new SqOpCodeTrans("specularbrdf", 0, this.getClass().getDeclaredMethod( "SO_specularbrdf" ), 0, new int[]{0});

	        m_TransTable[302] = new SqOpCodeTrans("mcomp", 0, this.getClass().getDeclaredMethod( "SO_mcomp" ), 0, new int[]{0});
	        m_TransTable[303] = new SqOpCodeTrans("setmcomp", 0, this.getClass().getDeclaredMethod( "SO_setmcomp" ), 0, new int[]{0});
	        m_TransTable[304] = new SqOpCodeTrans("determinant", 0, this.getClass().getDeclaredMethod( "SO_determinant" ), 0, new int[]{0});
	        m_TransTable[305] = new SqOpCodeTrans("mtranslate", 0, this.getClass().getDeclaredMethod( "SO_mtranslate" ), 0, new int[]{0});
	        m_TransTable[306] = new SqOpCodeTrans("mrotate", 0, this.getClass().getDeclaredMethod( "SO_mrotate" ), 0, new int[]{0});
	        m_TransTable[307] = new SqOpCodeTrans("mscale", 0, this.getClass().getDeclaredMethod( "SO_mscale" ), 0, new int[]{0});

	        m_TransTable[308] = new SqOpCodeTrans("fsplinea", 0, this.getClass().getDeclaredMethod( "SO_fsplinea" ), 0, new int[]{0});
	        m_TransTable[309] = new SqOpCodeTrans("csplinea", 0, this.getClass().getDeclaredMethod( "SO_csplinea" ), 0, new int[]{0});
	        m_TransTable[310] = new SqOpCodeTrans("psplinea", 0, this.getClass().getDeclaredMethod( "SO_psplinea" ), 0, new int[]{0});
	        m_TransTable[311] = new SqOpCodeTrans("vsplinea", 0, this.getClass().getDeclaredMethod( "SO_psplinea" ), 0, new int[]{0});
	        m_TransTable[312] = new SqOpCodeTrans("sfsplinea", 0, this.getClass().getDeclaredMethod( "SO_sfsplinea" ), 0, new int[]{0});
	        m_TransTable[313] = new SqOpCodeTrans("scsplinea", 0, this.getClass().getDeclaredMethod( "SO_scsplinea" ), 0, new int[]{0});
	        m_TransTable[314] = new SqOpCodeTrans("spsplinea", 0, this.getClass().getDeclaredMethod( "SO_spsplinea" ), 0, new int[]{0});
	        m_TransTable[315] = new SqOpCodeTrans("svsplinea", 0, this.getClass().getDeclaredMethod( "SO_spsplinea" ), 0, new int[]{0});

	        m_TransTable[316] = new SqOpCodeTrans("shadername2", 0, this.getClass().getDeclaredMethod( "SO_shadername2" ), 0, new int[]{0});
	        m_TransTable[317] = new SqOpCodeTrans("shadername", 0, this.getClass().getDeclaredMethod( "SO_shadername" ), 0, new int[]{0});
	        m_TransTable[318] = new SqOpCodeTrans("bake_f", 0, this.getClass().getDeclaredMethod( "SO_bake_f" ), 0, new int[]{0});
	        m_TransTable[319] = new SqOpCodeTrans("bake_3c", 0, this.getClass().getDeclaredMethod( "SO_bake_3c" ), 0, new int[]{0});
	        m_TransTable[320] = new SqOpCodeTrans("bake_3n", 0, this.getClass().getDeclaredMethod( "SO_bake_3n" ), 0, new int[]{0});
	        m_TransTable[321] = new SqOpCodeTrans("bake_3v", 0, this.getClass().getDeclaredMethod( "SO_bake_3v" ), 0, new int[]{0});
	        m_TransTable[322] = new SqOpCodeTrans("bake_3p", 0, this.getClass().getDeclaredMethod( "SO_bake_3p" ), 0, new int[]{0});

	        m_TransTable[323] = new SqOpCodeTrans("external", 0, this.getClass().getDeclaredMethod( "SO_external" ), 1, new int[]{type_invalid});

	        m_TransTable[324] = new SqOpCodeTrans("occlusion", 			0, this.getClass().getDeclaredMethod( "SO_occlusion" ), 0, new int[]{0});
		
		} catch (SecurityException e) {
			HimawariLogger.outputException( e );
		} catch (NoSuchMethodException e) {
			HimawariLogger.outputException( e );
		}
	    };
    
	    /*
		 * Its size
		 */
		private static int m_cTransSize = m_TransTable.length;
		
		
//*********************** CqShaderStack  ********************************//
    
    	public void CqShaderStack() 
        {
    		m_iTop = 0 ;
            int n = Math.max(m_maxsamples, m_samples);
            m_Stack.resize( n );
        }
    	
    	public void CqShaderStackdestract()
        {
            m_Stack.clear();
            Statistics();
        }


    	public IqShaderData GetNextTemp( EqVariableType type, EqVariableClass _class )
    	{
    	    switch ( type.getValue() )
    	    {
    	    case type_float:
    	        {
    	            if ( _class.getValue() == class_uniform )
    	            {
    	                if( m_UFPool.isEmpty() )
    	                    return( new CqShaderVariableUniformFloat() );
    	                else
    	                {
//    	                    IqShaderData ret = m_UFPool.front();
//    	                    m_UFPool.pop_front();
    	                	IqShaderData ret = m_UFPool.removeFirst();
    	                	
    	                    return( ret );
    	                }
    	            }
    	            else
    	            {
    	                if( m_VFPool.isEmpty() )
    	                    return( new CqShaderVariableVaryingFloat() );
    	                else
    	                {
//    	                    IqShaderData ret = m_VFPool.front();
//    	                    m_VFPool.pop_front();
    	                	IqShaderData ret = m_VFPool.removeFirst();
    	                    return( ret );
    	                }
    	            }
    	        }

    	    case type_point:
    	        {
    	            if ( _class.getValue() == class_uniform )
    	            {
    	                if( m_UPPool.isEmpty() )
    	                    return( new CqShaderVariableUniformPoint() );
    	                else
    	                {
//    	                    IqShaderData ret = m_UPPool.front();
//    	                    m_UPPool.pop_front();
    	                	IqShaderData ret = m_UPPool.removeFirst();
    	                    return( ret );
    	                }
    	            }
    	            else
    	            {
    	                if( m_VPPool.isEmpty() )
    	                    return( new CqShaderVariableVaryingPoint() );
    	                else
    	                {
//    	                    IqShaderData ret = m_VPPool.front();
//    	                    m_VPPool.pop_front();
    	                	IqShaderData ret = m_VPPool.removeFirst();
    	                    return( ret );
    	                }
    	            }
    	        }

    	    case type_string:
    	        {
    	            if ( _class.getValue() == class_uniform )
    	            {
    	                if( m_USPool.isEmpty() )
    	                    return( new CqShaderVariableUniformString() );
    	                else
    	                {
//    	                    IqShaderData ret = m_USPool.front();
//    	                    m_USPool.pop_front();
    	                	IqShaderData ret = m_USPool.removeFirst();
    	                    return( ret );
    	                }
    	            }
    	            else
    	            {
    	                if( m_VSPool.isEmpty() )
    	                    return( new CqShaderVariableVaryingString() );
    	                else
    	                {
//    	                    IqShaderData ret = m_VSPool.front();
//    	                    m_VSPool.pop_front();
    	                	IqShaderData ret = m_VSPool.removeFirst();
    	                    return( ret );
    	                }
    	            }
    	        }

    	    case type_color:
    	        {
    	            if ( _class.getValue() == class_uniform )
    	            {
    	                if( m_UCPool.isEmpty() )
    	                    return( new CqShaderVariableUniformColor() );
    	                else
    	                {
//    	                    IqShaderData ret = m_UCPool.front();
//    	                    m_UCPool.pop_front();
    	                	IqShaderData ret = m_UCPool.removeFirst();
    	                    return( ret );
    	                }
    	            }
    	            else
    	            {
    	                if( m_VCPool.isEmpty() )
    	                    return( new CqShaderVariableVaryingColor() );
    	                else
    	                {
//    	                    IqShaderData ret = m_VCPool.front();
//    	                    m_VCPool.pop_front();
    	                	IqShaderData ret = m_VCPool.removeFirst();
    	                    return( ret );
    	                }
    	            }
    	        }

    	    case type_normal:
    	        {
    	            if ( _class.getValue() == class_uniform )
    	            {
    	                if( m_UNPool.isEmpty() )
    	                    return( new CqShaderVariableUniformNormal() );
    	                else
    	                {
//    	                    IqShaderData ret = m_UNPool.front();
//    	                    m_UNPool.pop_front();
    	                	IqShaderData ret = m_UNPool.removeFirst();
    	                    return( ret );
    	                }
    	            }
    	            else
    	            {
    	                if( m_VNPool.isEmpty() )
    	                    return( new CqShaderVariableVaryingNormal() );
    	                else
    	                {
//    	                    IqShaderData ret = m_VNPool.front();
//    	                    m_VNPool.pop_front();
    	                	IqShaderData ret = m_VNPool.removeFirst();
    	                    return( ret );
    	                }
    	            }
    	        }

    	    case type_vector:
    	        {
    	            if ( _class.getValue() == class_uniform )
    	            {
    	                if( m_UVPool.isEmpty() )
    	                    return( new CqShaderVariableUniformVector() );
    	                else
    	                {
//    	                    IqShaderData ret = m_UVPool.front();
//    	                    m_UVPool.pop_front();
    	                	IqShaderData ret = m_UVPool.removeFirst();
    	                    return( ret );
    	                }
    	            }
    	            else
    	            {
    	                if( m_VVPool.isEmpty() )
    	                    return( new CqShaderVariableVaryingVector() );
    	                else
    	                {
//    	                    IqShaderData ret = m_VVPool.front();
//    	                    m_VVPool.pop_front();
    	                	IqShaderData ret = m_VVPool.removeFirst();
    	                    return( ret );
    	                }
    	            }
    	        }

    	    case type_matrix:
    	        {
    	            if ( _class.getValue() == class_uniform )
    	            {
    	                if( m_UMPool.isEmpty() )
    	                    return( new CqShaderVariableUniformMatrix() );
    	                else
    	                {
//    	                    IqShaderData ret = m_UMPool.front();
//    	                    m_UMPool.pop_front();
    	                	IqShaderData ret = m_UMPool.removeFirst();
    	                    return( ret );
    	                }
    	            }
    	            else
    	            {
    	                if( m_VMPool.isEmpty() )
    	                    return( new CqShaderVariableVaryingMatrix() );
    	                else
    	                {
//    	                    IqShaderData ret = m_VMPool.front();
//    	                    m_VMPool.pop_front();
    	                	IqShaderData ret = m_VMPool.removeFirst();
    	                    return( ret );
    	                }
    	            }
    	        }
    	    }
    	    assert( false );
    	    return( null );
    	}

        //----------------------------------------------------------------------
        /** Push a new shader variable reference onto the stack.
         */
    	public void	Push( IqShaderData pv )
        {
            while ( m_iTop >= m_Stack.size() )
            {
                int n = m_Stack.size() + 1;
                m_Stack.resize( n );
//              m_Stack.reserve( n );
            }

            m_Stack.get( m_iTop ).m_Data = pv;
            m_Stack.get( m_iTop ).m_IsTemp = true;
            m_iTop ++;
            CqStats.STATS_INC( SHD_stk_push );
            CqStats.STATS_SETI( SHD_stk_peak, Math.max( CqStats.STATS_GETI( SHD_stk_peak ), (int)( m_iTop )) );
        }

        //----------------------------------------------------------------------
        /** Push a new shader variable reference onto the stack.
         */
    	public void	PushV( IqShaderData pv )
        {
            assert( null != pv );
            while ( m_iTop >= m_Stack.size() )
            {
                int n = m_Stack.size() + 1;
                m_Stack.resize( n );
//                m_Stack.reserve( n );
            }

            m_Stack.get( m_iTop ).m_Data = pv;
            m_Stack.get( m_iTop ).m_IsTemp = false;
            m_iTop ++;
            CqStats.STATS_INC( SHD_stk_pushv );
            CqStats.STATS_SETI( SHD_stk_peak, Math.max( CqStats.STATS_GETI( SHD_stk_peak ), (int)( m_iTop )) );
        }

        //----------------------------------------------------------------------
        /** Pop the top stack entry.
         * \param f Boolean value to update if this is varying. If not varying, leaves f unaltered.
         * \return Reference to the top stack entry.
         */
    	public SqStackEntry Pop( p_boolean f )
        {
            if ( m_iTop != 0) m_iTop--;

            SqStackEntry Val = new SqStackEntry( m_Stack.get( m_iTop ) );
            f.value = Val.m_Data.Size() > 1 || f.value;

            CqStats.STATS_INC( SHD_stk_pop );

            return ( Val );
        }

    	public void Release( SqStackEntry s )
    	{
    	    if( s.m_IsTemp )
    	    {
    	        switch( s.m_Data.Type().getValue() )
    	        {
    	        case type_float:
    	            {
    	                if ( s.m_Data.Class().getValue() == class_uniform )
    	                    m_UFPool.addLast( (CqShaderVariableUniformFloat)(s.m_Data) );
    	                else
    	                    m_VFPool.addLast( (CqShaderVariableVaryingFloat)(s.m_Data) );
    	                break;
    	            }

    	        case type_point:
    	            {
    	                if ( s.m_Data.Class().getValue() == class_uniform )
    	                    m_UPPool.addLast( (CqShaderVariableUniformPoint)(s.m_Data) );
    	                else
    	                    m_VPPool.addLast( (CqShaderVariableVaryingPoint)(s.m_Data) );
    	                break;
    	            }

    	        case type_string:
    	            {
    	                if ( s.m_Data.Class().getValue() == class_uniform )
    	                    m_USPool.addLast( (CqShaderVariableUniformString)(s.m_Data) );
    	                else
    	                    m_VSPool.addLast( (CqShaderVariableVaryingString)(s.m_Data) );
    	                break;
    	            }

    	        case type_color:
    	            {
    	                if ( s.m_Data.Class().getValue() == class_uniform )
    	                    m_UCPool.addLast( (CqShaderVariableUniformColor)(s.m_Data) );
    	                else
    	                    m_VCPool.addLast( (CqShaderVariableVaryingColor)(s.m_Data) );
    	                break;
    	            }

    	        case type_normal:
    	            {
    	                if ( s.m_Data.Class().getValue() == class_uniform )
    	                    m_UNPool.addLast( (CqShaderVariableUniformNormal)(s.m_Data) );
    	                else
    	                    m_VNPool.addLast( (CqShaderVariableVaryingNormal)(s.m_Data) );
    	                break;
    	            }

    	        case type_vector:
    	            {
    	                if ( s.m_Data.Class().getValue() == class_uniform )
    	                    m_UVPool.addLast( (CqShaderVariableUniformVector)(s.m_Data) );
    	                else
    	                    m_VVPool.addLast( (CqShaderVariableVaryingVector)(s.m_Data) );
    	                break;
    	            }

    	        case type_matrix:
    	            {
    	                if ( s.m_Data.Class().getValue() == class_uniform )
    	                    m_UMPool.addLast( (CqShaderVariableUniformMatrix)(s.m_Data) );
    	                else
    	                    m_VMPool.addLast( (CqShaderVariableVaryingMatrix)(s.m_Data) );
    	                break;
    	            }
    	        }
    	    }
    	    CqStats.STATS_INC( SHD_stk_release );
    	}

        //----------------------------------------------------------------------
        /** Duplicate the top stack entry.
         */
    	public void	Dup()
        {
    		int iTop = 0;
            if(m_iTop > 1)iTop = m_iTop-1;

            IqShaderData s = GetNextTemp( m_Stack.get( iTop ).m_Data.Type(), m_Stack.get( iTop ).m_Data.Class() );
            s.SetValueFromVariable( m_Stack.get( iTop ).m_Data );
            Push( s );

            CqStats.STATS_INC( SHD_stk_dup );
        }

        /** Drop the top stack entry.
         */
    	public void	Drop()
        {
            p_boolean f = new p_boolean(false);
            Pop( f );

            CqStats.STATS_INC( SHD_stk_drop );
        }

        /**
         * Print the max number of depth if compiled for it.
         */
    	static int done = 0;
    	public static void Statistics()
    	{
    		HimawariLogger log = HimawariLogger.getLogger();
    		
    		    if (done != 0 )
    		    {
    		        log.error( "The shaderstack's max. depth was " + m_maxsamples  );
    		        done = 1;
    		    }
    	}


        /** set the more efficient number of samples per type of variable at run-time.
         */
    	public static void	SetSamples(int n)
        {
            m_samples = n;
        }



    	//protected STLVector<SqStackEntry>	m_Stack = new STLVector<SqStackEntry>(SqStackEntry.class);
    	protected STLArray<SqStackEntry>	m_Stack = new STLArray<SqStackEntry>(SqStackEntry.class);
    	protected int	m_iTop;										///< Index of the top entry.

    	protected static LinkedList<CqShaderVariableUniformFloat>			m_UFPool = new LinkedList<CqShaderVariableUniformFloat>();
        // Integer
    	protected static LinkedList<CqShaderVariableUniformPoint>			m_UPPool = new LinkedList<CqShaderVariableUniformPoint>();
    	protected static LinkedList<CqShaderVariableUniformString>			m_USPool = new LinkedList<CqShaderVariableUniformString>();
    	protected static LinkedList<CqShaderVariableUniformColor>			m_UCPool = new LinkedList<CqShaderVariableUniformColor>();
        // Triple
        // hPoint
    	protected static LinkedList<CqShaderVariableUniformNormal>			m_UNPool = new LinkedList<CqShaderVariableUniformNormal>();
    	protected static LinkedList<CqShaderVariableUniformVector>			m_UVPool = new LinkedList<CqShaderVariableUniformVector>();
        // Void
    	protected static LinkedList<CqShaderVariableUniformMatrix>			m_UMPool = new LinkedList<CqShaderVariableUniformMatrix>();
        // SixteenTuple

    	protected static LinkedList<CqShaderVariableVaryingFloat>			m_VFPool = new LinkedList<CqShaderVariableVaryingFloat>();
        // Integer
    	protected static LinkedList<CqShaderVariableVaryingPoint>			m_VPPool = new LinkedList<CqShaderVariableVaryingPoint>();
    	protected static LinkedList<CqShaderVariableVaryingString>			m_VSPool = new LinkedList<CqShaderVariableVaryingString>();
    	protected static LinkedList<CqShaderVariableVaryingColor>			m_VCPool = new LinkedList<CqShaderVariableVaryingColor>();
        // Triple
        // hPoint
    	protected static LinkedList<CqShaderVariableVaryingNormal>			m_VNPool = new LinkedList<CqShaderVariableVaryingNormal>();
    	protected static LinkedList<CqShaderVariableVaryingVector>			m_VVPool = new LinkedList<CqShaderVariableVaryingVector>();
        // Void
    	protected static LinkedList<CqShaderVariableVaryingMatrix>			m_VMPool = new LinkedList<CqShaderVariableVaryingMatrix>();
        // SixteenTuple

    	protected static int    m_samples = 18; // by default == 18 see shaderstack.cpp
    	protected static int    m_maxsamples = 0;
}
