/*
 KeywordBasis.java
 Copyright (C) 2003 Gerardo Horvilleur Martinez

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.parser.keywords;


import net.cellcomputing.himawari.library.RendermanInterface;
import net.cellcomputing.himawari.parser.Tokenizer;

public strictfp class KeywordBasis extends AbstractKeywordParser {

    public void parse(Tokenizer st) throws Exception {
    	
        // Expect u basis
        float[][] uBasis = readBasis(st);
        if( uBasis == null)
        	logger.error( "Invalid uBasis : \"" + st.sval + "\"\n");
        
        // Expect u step
        match( st, TK_NUMBER );
        int uStep = (int) st.nval;
    
        // Expect v basis
        float[][] vBasis = readBasis(st);
        if( vBasis == null )
        	logger.error( "Invalid vBasis : \"" + st.sval + "\"\n");
        
        // Expect u step
        match( st, TK_NUMBER );
        int vStep = (int) st.nval;

        if( uBasis != null && vBasis != null )
        	RendermanInterface.RiBasis( uBasis, uStep, vBasis, vStep );
        
    }
    
    private float[][] readBasis(Tokenizer st) throws Exception {
    	
    	float[][] result;
    	int token = st.nextToken();
    	st.pushBack();
    	
    	// Is a basis name or an array?
    	if ( token == TK_LBRACE ) {
    		// Expect matrix
    		result = readMatrix( st );
    	}
    	else{
    		// Expect basis name
    		match( st, TK_STRING );
    		String name = st.sval;
    		
    		result = new float[ 4 ][ 4 ];
    		boolean basis = RendermanInterface.BasisFromName( result, name );
    		
    		if( !basis )
    			return null;
    	}
    	return result;
    }
}
