// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.types;

import static java.lang.Math.min;
import static java.lang.Math.max;

/**
 * 
 * ̃pbP[WŗpO[o֐
 * 
 * @author NTT DATA Corporation
 */
public strictfp class PublicFunctions {
	
	
	/**
	 * Q_Ԃ` t:1-t ɓ_߂. <br>
	 * Linearly interpolate between the two given values to the point t, 0<=t<=1.
	 * 
	 * @param t	䗦i0<=t<=1j
	 * @param x0	_P
	 * @param x1	_Q
	 * @return	Q_Ԃ`ɓ_
	 */
	public static final float LERP( float t, float x0, float x1 ){
		return ( (x0) + (t)*((x1)-(x0)) );
	}
	
	/**
	 * ^ꂽlAw肵͈͂Ɏ܂悤ɂB<br>
	 * Clamp the given value a, to be with the extents of the given range.
	 * 
	 * @param a	͈͂Ɏ߂l
	 * @param min	͈͂̉
	 * @param max	͈͂̏
	 * @return	w肵͈͂𒴂Ȃl
	 */
	public static final float CLAMP( float a, float min, float max ){
		return ( a<min? min : ( a>max? max:a ) ); 
	}
	
	/**
	 * CqColorIuWFNgɑ΂minZB<br>
	 * evfƂɏ̒l̗pꂽAVCqColorIuWFNgԂB<br>
	 * Determine the minimum of the two colors given.
	 * 
	 * @param a	CqColorIuWFNgP
	 * @param b	CqColorIuWFNgQ
	 * @return	evfƂɏ̒l̗pꂽVCqColorIuWFNg
	 */
	public static final CqColor CMIN( CqColor a, CqColor b ){
		return new CqColor( min(a.fRed(), b.fRed()), min(a.fGreen(), b.fGreen()), min(a.fBlue(), b.fBlue()) );
	}
	
	/**
	 * CqColorIuWFNgɑ΂maxZB<br>
	 * evfƂɑ傫̒l̗pꂽAVCqColorIuWFNgԂB<br>
	 * Determine the maximum of the two colors given.
	 * 
	 * @param a	CqColorIuWFNgP
	 * @param b	CqColorIuWFNgQ
	 * @return	evfƂɑ傫̒l̗pꂽVCqColorIuWFNg
	 */
	public static final CqColor CMAX( CqColor a, CqColor b ){
		return new CqColor( max(a.fRed(), b.fRed()), max(a.fGreen(), b.fGreen()), max(a.fBlue(), b.fBlue()) );
	}
	
	/**
	 * CqColorIuWFNgɑ΂clampZB<br>
	 * evfƂɎw͈͂𒴂Ȃ悤Ȓl̗pꂽAVCqColorIuWFNgԂB<br>
	 * Clamp the given color a, to be with the extents of the given range.
	 * 
	 * @param a	w͈͂Ɏ߂CqColor
	 * @param min	͈͂̉
	 * @param max	͈͂̏
	 * @return	evfƂɎw͈͂𒴂Ȃ悤Ȓl̗pꂽVCqColorIuWFNg
	 */
	public static final CqColor CCLAMP( CqColor a, CqColor min, CqColor max ){
		return new CqColor( CLAMP(a.fRed(), min.fRed(), max.fRed()), CLAMP(a.fGreen(), min.fGreen(), max.fGreen()), CLAMP(a.fBlue(), min.fBlue(), max.fBlue()) );
	}
	
	/**
	 * CqVector3DIuWFNgɑ΂minZB<br>
	 * evfƂɏ̒l̗pꂽAVCqVector3DIuWFNgԂB<br>
	 * Determine the minimum of the two vectors given.
	 * 
	 * @param a	CqVector3DIuWFNgP
	 * @param b	CqVector3DIuWFNgQ
	 * @return	evfƂɏ̒l̗pꂽVCqVector3DIuWFNg
	 */
	public static final CqVector3D VMIN( CqVector3D a, CqVector3D b ){
		return new CqVector3D( min(a.x, b.x), min(a.y, b.y), min(a.z, b.z) );
	}
	
	/**
	 * CqVector3DIuWFNgɑ΂maxZB<br>
	 * evfƂɑ傫̒l̗pꂽAVCqVector3DIuWFNgԂB<br>
	 * Determine the maximum of the two vectors given.
	 * 
	 * @param a	CqVector3DIuWFNgP
	 * @param b	CqVector3DIuWFNgQ
	 * @return	evfƂɑ傫̒l̗pꂽVCqVector3DIuWFNg
	 */
	public static final CqVector3D VMAX( CqVector3D a, CqVector3D b ){
		return new CqVector3D( max(a.x, b.x), max(a.y, b.y), max(a.z, b.z) );
	}
	
	/// Clamp the given vector a, to be with the extents of the given range.
	/**
	 * CqVector3DIuWFNgɑ΂clampZB<br>
	 * evfƂɎw͈͂𒴂Ȃ悤Ȓl̗pꂽAVCqVector3DIuWFNgԂB<br>
	 * Clamp the given vector a, to be with the extents of the given range.
	 * 
	 * @param a	w͈͂Ɏ߂CqVector3D
	 * @param min	͈͂̉
	 * @param max	͈͂̏
	 * @return	evfƂɎw͈͂𒴂Ȃ悤Ȓl̗pꂽVCqVector3DIuWFNg
	 */
	public static final CqVector3D VCLAMP( CqVector3D a, CqVector3D min, CqVector3D max ){
		return new CqVector3D( CLAMP( a.x, min.x, max.x ), CLAMP( a.y, min.y, max.y ), CLAMP( a.z, min.z, max.z ) );
	}
	
	/**
	 * rbgƂAԉE[̂P̈ʒu߂iŒrbǧvZj.<br>
	 * Determine the lowest set bit in an unsigned value.
	 * 
	 * @param x	Cӂ̐l
	 * @return	ԉẼrbg\킷intli2~nj
	 */
	public static final long LOWEST_BIT( long x )
	{
		return ( x & ( ( ~x ) + 1 ) );
	}
	
	/**
	 * Qׂ̂悩ǂB<br>
	 * Determine if the given value is a power of two.
	 * 
	 * @param x	Cӂ̐l
	 * @return	true: ׂ@false: ׂłȂ
	 */
	public static final boolean IS_POW2( long x )
	{
		return ( x != 0 && x == LOWEST_BIT( x ) );
	}
	
	/**
	 * ̍ōrbgȉ̃rbgׂėĂBAnڂōrbgł΁A2^n-1vZi2^n-1̐Eł̐؂グj.<br>
	 * Calculate the next highest power of two minus 1 from the given value.
	 * 
	 * @param x	Cӂ̐l
	 * @return	2^n-1̐Eł̐؂グl
	 */
	public static final long CEIL_POW2_MINUS1( long x )
	{
		for ( long i = 1; i!=0; i <<= 1 ){
			x |= x >> i;
		}
		return ( x );
	}
	
	/**
	 * ̍ōrbĝP̃rbglZoBAnڂōrbgł΁A2^nvZiQׂ̂̐Eł̐؂グj.<br>
	 * A2^n̂Ƃ͂̂܂2^nԂi悤j<br>
	 * Calculate the next highest power of two from the given value.
	 * 
	 * @param x	Cӂ̐l
	 * @return	Qׂ̂̐Eł̐؂グl
	 */
	public static final long CEIL_POW2( long x )
	{
		return ( CEIL_POW2_MINUS1( x - 1 ) + 1 );
	}
	
	public static final float RAD(float a)
	{
		return (float) ((a)/(180.0f/Math.PI)) ;
	}
//	/ Convert the given radians value to degrees.
	public static final float DEG(float a)
	{
		return (float) ((a)/(Math.PI/180.0f));
	}
}
