// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.types;


/**
 * 
 * 2xNg<br>
 * 3/4xNg̕ϊAPʃxNg郁\bhB
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqVector2D  {

	private static final long serialVersionUID = -3755250159902223025L;
	
	public float x;
	public float y;
	//************************************************************************//
	//*** RXgN^̒`
	//************************************************************************//
	
	/**
	 * ftHgRXgN^͉Ȃ
	 */
	public CqVector2D() {}
	
	/**
	 * floaẗlƂ2xNg쐬B
	 * @param x	s̑Pvf
	 * @param y	s̑Qvf
	 */
	public CqVector2D( float x, float y ){
		this.x = x;
		this.y = y;
	}
	
	/**
	 * QxNg̗vfpĐVQxNg쐬B
	 * @param From	QxNg
	 */
	public CqVector2D( CqVector2D From ){
		this.x = From.x;
		this.y = From.y;
	}
	
	/**
	 * RxNg̑PEQvfpĂQxNg쐬B
	 * @param From	RxNg
	 */
	public CqVector2D( CqVector3D From ){
		this.x = From.x;
		this.y = From.y;
	}
	
	/**
	 * SxNg̑PEQvfASvfŊlłQxNg쐬B
	 * @param From	SxNg
	 */
	public CqVector2D( CqVector4D From ){
		this.x = From.x / From.w;
		this.y = From.y / From.w;
	}
	
	//************************************************************************//
	//*** \bh̒`
	//************************************************************************//
	
	/**
	 * Pvf̃Zb^
	 * @param x	Pvf
	 */
	public void x( float x ){
		this.x = x;
	}
	
	/**
	 * Qvf̃Zb^
	 * @param y	Qvf
	 */
	public void y( float y ){
		this.y = y;
	}
	
	/**
	 * xNg̑傫Ԃ
	 * @return	xNg̑傫
	 */
	public float Magnitude(){
		return (float)(Math.sqrt( ( x * x ) + ( y * y )));
	}
	
	/**
	 * xNg̑傫̕ijԂ
	 * @return	xNg̑傫̕
	 */
	public float Magnitude2(){
//		return this.lengthSquared();
        return ( ( x * x ) + ( y * y ) );

	}
	
	/**
	 * ̃xNg𐳋K
	 */
	public void Unit(){
//		this.normalize();
        float Mag = Magnitude();

        x /= Mag;
        y /= Mag;
	}
	
	
	//************************************************************************//
	//*** Zq̃I[o[[h
	//************************************************************************//
	
	/**
	 * ZqB@
	 * 
	 * @param From	CqVector2DIuWFNg
	 * @return	this
	 */
	public CqVector2D assignment( CqVector2D From ){
		this.x = From.x;
		this.y = From.y;
		return this;
	}
	
	/**
	 * ZqB@
	 * RxNg̑Rvf𖳎ăRs[B
	 * @param From	CqVector3DIuWFNg
	 * @return	this
	 */
	public CqVector2D assignment( CqVector3D From ){
		this.x = From.x;
		this.y = From.y;
		return this;
	}
	
	/**
	 * ZqB@
	 * SxNg̑Rvf𖳎APEQvfSvfŊăRs[B
	 * @param From	CqVector4DIuWFNg
	 * @return	this
	 */
	public CqVector2D assignment( CqVector4D From ){
	    if( From.w != 1.0f ){
	    	this.x = From.x / From.w;
	    	this.y = From.y / From.w;
	    }
	    else{
			this.x = From.x;
			this.y = From.y;
	    }
	    
	    return this;
	}
	
	/**
	 * ZZqB@
	 * QxNg̊evff𑫂
	 * @param f	Zl
	 * @return	evff𑫂lŏꂽCqVector2DIuWFNg
	 */
	public CqVector2D add( float f ){
		return new CqVector2D( this.x + f, this.y + f );
	}
	
	/**
	 * ZZqB
	 * evfꂼZB
	 * 
	 * @param b	ZCqVector2D
	 * @return	vZ
	 */
	public CqVector2D add( final CqVector2D b ){
		CqVector2D r = new CqVector2D( x,y );
		return r.assignAdd(b);
	}

	/**
	 * ZZqB@
	 * QxNg̊evff iv-fj
	 * @param f	Zl
	 * @return	evfflŏꂽCqVector2DIuWFNg
	 */
	public CqVector2D sub( float f ){
		return new CqVector2D( x-f, y-f );
	}
	
	/**
	 * ZZqB
	 * evfꂼZB
	 * 
	 * @param b	ZCqVector2D
	 * @return	vZ
	 */
	public CqVector2D sub( final CqVector2D b ){
		CqVector2D r = new CqVector2D( x,y );
		return r.assignSub(b);
	}
	
	/**
	 * tZZqB@
	 * Z̋t if-vj Avec.sub(f).negate()ƓӁB
	 * @param f	Zl
	 * @return	evflŏꂽCqVector2DIuWFNg
	 */
	public CqVector2D subInv( float f ){
		return new CqVector2D( f-x, f-y ); 
	}
	
	/**
	 * ZZqB@
	 * QxNg̐{s
	 * @param f	{
	 * @return	evf𐮐{lŏꂽCqVector2DIuWFNg
	 */
	public CqVector2D mul( float f ){
//		CqVector2D v = new CqVector2D( this );
//		v.scale(f);
//		return v;
		return new CqVector2D(this.x * f , this.y * f);
	}
	
	/**
	 * ZZqB
	 * ςԂB
	 * @param v	Ώۂ2xNg
	 * @return	
	 */
	public float mul( CqVector2D v ){
//		return this.dot(v);
		return (v.x * this.x  + v.y * this.y);
	}
	
	/**
	 * ZZqB@
	 * QxNg̊evfŊ iv/fj
	 * @param f	l
	 * @return	evfŊlŏꂽCqVector2DIuWFNg
	 */
	public CqVector2D div( float f ){
		return new CqVector2D( x/f, y/f );
	}
	
	/**
	 * tZZqB@
	 * Z̋tif/vj
	 * @param f	l
	 * @return	evfłlŏꂽCqVector2DIuWFNg
	 */
	public CqVector2D divInv( float f ){
		return new CqVector2D( f/x, f/y );
	}
	
	/**
	 * ZZqB@
	 * QxNgm̏ZBevfmZB
	 * @param v	QxNg
	 * @return	ZʂŏꂽCqVector2DIuWFNg
	 */
	public CqVector2D div( CqVector2D v ){
		return new CqVector2D( x/v.x, y/v.y );
	}
	
	/**
	 * rZqB@
	 * evfmrB
	 * @param Cmp	rΏۂCqVector2DIuWFNg
	 * @return	true:v	false:sv
	 */
	public boolean equals(CqVector2D Cmp) {
		return ( ( x == Cmp.x ) && ( y == Cmp.y )  );
	}
	
	/**
	 * ZB@
	 * evfɂZlŎgXVB
	 * @param f	l
	 * @return	vZʂCqVector2DIuWFNgBg̃Rs[B
	 */
	public CqVector2D assignAdd( float f ) {
		this.x += f;
		this.y += f;
		return this;
	}
	//nttdata 
	public CqVector2D assignAdd( float x ,float y) {
		this.x += x;
		this.y += y;
		return this;
	}
	/**
	 * ZB@
	 * evfmZlŎgXVB
	 * @param v	CqVector2D
	 * @return	vZʂCqVector2DIuWFNgBg̃Rs[B
	 */
	public CqVector2D assignAdd( CqVector2D v ) {
		this.x += v.x;
		this.y += v.y;
		return this;
	}

	/**
	 * ZB@
	 * evf炆ZlŎgXVB
	 * @param f	l
	 * @return	vZʂCqVector2DIuWFNgBg̃Rs[B
	 */
	public CqVector2D assignSub( float f ) {
		this.x -= f;
		this.y -= f;
		return this;
	}
	
	/**
	 * ZB@
	 * evfmZlŎgXVB
	 * @param v	CqVector2D
	 * @return	vZʂCqVector2DIuWFNgBg̃Rs[B
	 */
	public CqVector2D assignSub( CqVector2D v ) {
		this.x -= v.x;
		this.y -= v.y;
		return this;
	}

	/**
	 * ZB@
	 * evfɂZlŎgXVB
	 * @param f	{
	 * @return	vZʂCqVector2DIuWFNgBg̃Rs[B
	 */
	public CqVector2D assignMul( float f ) {
//		this.scale(f);
		this.x = this.x * f;
		this.y = this.y *f;
		return this;
	}
	
	/**
	 * ZB@
	 * evfmZlŎgXVB
	 * @param v	|CqVector2D
	 * @return	vZʂCqVector2DIuWFNgBg̃Rs[B
	 */
	public CqVector2D assignMul( CqVector2D v ) {
		this.x *= v.x;
		this.y *= v.y;
		return this;
	}

	/**
	 * ZB@
	 * evf炆ZlŎgXVB
	 * @param f	l
	 * @return	vZʂCqVector2DIuWFNgBg̃Rs[B
	 */
	public CqVector2D assignDiv( float f ) {
		this.x /= f;
		this.y /= f;
		return this;
	}
	
	/**
	 * ZB@
	 * evfmŏZlŎgXVB
	 * @param v	CqVector2D
	 * @return	vZʂCqVector2DIuWFNgBg̃Rs[B
	 */
	public CqVector2D assignDiv( CqVector2D v ) {
		this.x /= v.x;
		this.y /= v.y;
		return this;
	}

//	/**
//	 * zQƁB@
//	 * QxNg̑ivf擾B
//	 * @param i	vfԍ
//	 * @return	QxNg̑ivf
//	 */
//	public float valueAt( int i ){
//		switch ( i )
//		{
//		case 0:		return ( x );
//		case 1:		return ( y );
//		default:	return ( y );
//		}
//	}
}
