// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.cache;

import net.cellcomputing.himawari.library.RendermanInterface;

/**
 * 
 * RiTransformPoints̃LbV
 * 
 * @author NTT DATA Corporation
 */
public strictfp class RiTransformPointsCache extends RiCacheBase {
	
	public RiTransformPointsCache(String fromspace, String tospace, int npoints, float[][] points)
	{
//		int __fromspace_length = strlen(fromspace);
//		m_fromspace = new char[ __fromspace_length + 1 ];
//		strcpy(m_fromspace, fromspace);
		m_fromspace = new String( fromspace );
//		int __tospace_length = strlen(tospace);
//		m_tospace = new char[ __tospace_length + 1 ];
//		strcpy(m_tospace, tospace);
		m_tospace = new String( tospace );
		m_npoints = npoints;
		int __points_length = npoints;
		m_points = new float[3][__points_length];
		int __points_index;
		for(__points_index = 0; __points_index<__points_length; __points_index++)
		{
			m_points[__points_index][0] = points[__points_index][0];
			m_points[__points_index][1] = points[__points_index][1];
			m_points[__points_index][2] = points[__points_index][2];
		}
	}
	
	@Override
	public void destruct()
	{
		super.destruct();
//		delete[](m_fromspace);
//		delete[](m_tospace);
//		delete[](m_points);
	}
	
	@Override
	public void ReCall()
	{
		RendermanInterface.RiTransformPoints(m_fromspace, m_tospace, m_npoints, m_points);
	}
	
	private String m_fromspace;
	private String m_tospace;
	private int m_npoints;
	private float[][] m_points;
	
}
