// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.cache;

import static net.cellcomputing.himawari.library.RiGlobal.QGetRenderContext;
import net.cellcomputing.himawari.library.RendermanInterface;

/**
 * 
 * RiPatchMeshṼLbV
 * 
 * @author NTT DATA Corporation
 */
public strictfp class RiPatchMeshCache extends RiCacheBase {
	
	public RiPatchMeshCache(String type, int nu, String uwrap, int nv, String vwrap, int count, String[] tokens, Object[] values)
	{
//		int __type_length = strlen(type);
//		m_type = new char[ __type_length + 1 ];
//		strcpy(m_type, type);
		m_type = new String( type );
		m_nu = nu;
//		int __uwrap_length = strlen(uwrap);
//		m_uwrap = new char[ __uwrap_length + 1 ];
//		strcpy(m_uwrap, uwrap);
		m_uwrap = new String( uwrap );
		m_nv = nv;
//		int __vwrap_length = strlen(vwrap);
//		m_vwrap = new char[ __vwrap_length + 1 ];
//		strcpy(m_vwrap, vwrap);
		m_vwrap = new String( vwrap );
		// Copy the plist here.
		int constant_size = 1;
		int uniform_size = 1;
		int varying_size = 1;
		int vertex_size = 1;
		int facevarying_size = 1;
		
		if( type.compareTo("bilinear")==0 )
		{
			if( uwrap.compareTo("periodic")==0 )
				uniform_size = nu;
			else
				uniform_size = nu-1;
			if( vwrap.compareTo("periodic")==0 )
				uniform_size *= nv;
			else
				uniform_size *= nv-1;
		}
		else
		{
			int ustep = QGetRenderContext().pattrCurrent().GetIntegerAttribute( "System", "BasisStep" ) [ 0 ];
			int vstep = QGetRenderContext().pattrCurrent().GetIntegerAttribute( "System", "BasisStep" ) [ 1 ];
			if( uwrap.compareTo("periodic")==0 )
				uniform_size = nu/ustep;
			else
				uniform_size = (nu-4)/ustep;
			if( vwrap.compareTo("periodic")==0 )
				uniform_size *= nv/vstep;
			else
				uniform_size *= (nv-4)/vstep;
		}
		
		if( type.compareTo("bilinear")==0 )
			varying_size = nu*nv;
		else
		{
			int ustep = QGetRenderContext().pattrCurrent().GetIntegerAttribute( "System", "BasisStep" ) [ 0 ];
			int vstep = QGetRenderContext().pattrCurrent().GetIntegerAttribute( "System", "BasisStep" ) [ 1 ];
			varying_size = (nu/ustep)*(nv/vstep);
		}
		vertex_size=nu*nv;
		CachePlist(count, tokens, values, constant_size, uniform_size, varying_size, vertex_size, facevarying_size);
	}
	
	@Override
	public void destruct()
	{
		super.destruct();
//		delete[](m_type);
//		delete[](m_uwrap);
//		delete[](m_vwrap);
		// plist gets destroyed by the base class.
	}
	
	@Override
	public void ReCall()
	{
		RendermanInterface.RiPatchMeshV(m_type, m_nu, m_uwrap, m_nv, m_vwrap, m_count, m_tokens, m_values);
	}
	
	private String m_type;
	private int m_nu;
	private String m_uwrap;
	private int m_nv;
	private String m_vwrap;
	// plist information is stored in the base class.
	
}
