// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.cache;

import java.lang.reflect.Method;

import net.cellcomputing.himawari.library.RendermanInterface;

/**
 * 
 * RiMakeTextureṼLbV
 * 
 * @author NTT DATA Corporation
 */
public strictfp class RiMakeTextureCache extends RiCacheBase {
	
	public RiMakeTextureCache(String imagefile, String texturefile, String swrap, String twrap, Method filterfunc, float swidth, float twidth, int count, String[] tokens, Object[] values)
	{
//		int __imagefile_length = strlen(imagefile);
//		m_imagefile = new char[ __imagefile_length + 1 ];
//		strcpy(m_imagefile, imagefile);
		m_imagefile = new String( imagefile );
//		int __texturefile_length = strlen(texturefile);
//		m_texturefile = new char[ __texturefile_length + 1 ];
//		strcpy(m_texturefile, texturefile);
		m_texturefile = new String( texturefile );
//		int __swrap_length = strlen(swrap);
//		m_swrap = new char[ __swrap_length + 1 ];
//		strcpy(m_swrap, swrap);
		m_swrap = new String( swrap );
//		int __twrap_length = strlen(twrap);
//		m_twrap = new char[ __twrap_length + 1 ];
//		strcpy(m_twrap, twrap);
		m_twrap = new String( twrap );
		m_filterfunc = filterfunc;
		m_swidth = swidth;
		m_twidth = twidth;
		// Copy the plist here.
		int constant_size = 1;
		int uniform_size = 1;
		int varying_size = 1;
		int vertex_size = 1;
		int facevarying_size = 1;
		CachePlist(count, tokens, values, constant_size, uniform_size, varying_size, vertex_size, facevarying_size);
	}
	
	@Override
	public void destruct()
	{
		super.destruct();
//		delete[](m_imagefile);
//		delete[](m_texturefile);
//		delete[](m_swrap);
//		delete[](m_twrap);
		// plist gets destroyed by the base class.
	}
	
	@Override
	public void ReCall()
	{
		RendermanInterface.RiMakeTextureV(m_imagefile, m_texturefile, m_swrap, m_twrap, m_filterfunc, m_swidth, m_twidth, m_count, m_tokens, m_values);
	}
	
	private String m_imagefile;
	private String m_texturefile;
	private String m_swrap;
	private String m_twrap;
	private Method m_filterfunc;
	private float m_swidth;
	private float m_twidth;
	// plist information is stored in the base class.
	
}
