// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.cache;

import net.cellcomputing.himawari.library.RendermanInterface;

/**
 * 
 * RiBlobbyṼLbV
 * 
 * @author NTT DATA Corporation
 */
public strictfp class RiBlobbyCache extends RiCacheBase {

	public RiBlobbyCache(int nleaf, int ncode, int[] code, int nflt, float[] flt, int nstr, String[] str, int count, String[] tokens, Object[] values)
	{
		m_nleaf = nleaf;
		m_ncode = ncode;
		int __code_length = ncode;
		m_code = new int[__code_length];
		int __code_index;
		for(__code_index = 0; __code_index<__code_length; __code_index++)
		{
			m_code[__code_index] = code[__code_index];
		}
		m_nflt = nflt;
		int __flt_length = nflt;
		m_flt = new float[__flt_length];
		int __flt_index;
		for(__flt_index = 0; __flt_index<__flt_length; __flt_index++)
		{
			m_flt[__flt_index] = flt[__flt_index];
		}
		m_nstr = nstr;
		int __str_length = nstr;
		m_str = new String[__str_length];
		int __str_index;
		for(__str_index = 0; __str_index<__str_length; __str_index++)
		{
//			int __str_slength = strlen(str[__str_index]);
//			m_str[__str_index] = new char[ __str_slength + 1 ];
//			strcpy(m_str[__str_index], str[__str_index]);
			m_str[__str_index] = new String( str[__str_index] );
		}
		// Copy the plist here.
		int constant_size = 1;
		int uniform_size = 1;
		int varying_size = 1;
		int vertex_size = 1;
		int facevarying_size = 1;
		CachePlist(count, tokens, values, constant_size, uniform_size, varying_size, vertex_size, facevarying_size);
	}

	@Override
	public void destruct()
	{
		super.destruct();
//		delete[](m_code);
//		delete[](m_flt);
//		int __str_length = 1;
//		int __str_index;
//		for(__str_index = 0; __str_index<__str_length; __str_index++)
//		{
//			delete[](m_str[__str_index]);
//		}
//		delete[](m_str);
		// plist gets destroyed by the base class.
	}
	
	@Override
	public void ReCall()
	{
		RendermanInterface.RiBlobbyV(m_nleaf, m_ncode, m_code, m_nflt, m_flt, m_nstr, m_str, m_count, m_tokens, m_values);
	}

	private int		m_nleaf;
	private int		m_ncode;
	private int[]		m_code;
	private int		m_nflt;
	private float[]	m_flt;
	private int		m_nstr;
	private String[]	m_str;
	// plist information is stored in the base class.
	
}
