// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import static net.cellcomputing.himawari.library.EqModeBlock.*;
import static net.cellcomputing.himawari.library.EqCSGNodeType.*;
import net.cellcomputing.himawari.util.HimawariLogger;

/**
 * 
 * Define the context that exists between calls to RiSolidBegin/RiSolidEnd.<br>
 * RiSolidBegin/RiSolidEndĂяoĂԂɑ݂AReLXg`B
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqSolidModeBlock extends CqModeBlock
{

	/**
	 * RXgN^B@lݒB
	 * @param type	CSGm[h̖́B
	 * @param pconParent	ÕReLXgB
	 */
	public CqSolidModeBlock( String type, final CqModeBlock pconParent )
	{
		super(pconParent, Solid);
//		m_strType = type;
		
	    // Create new Attributes as they must be pushed/popped by the state change.
	    m_pattrCurrent = new CqAttributes( pconParent.m_pattrCurrent );
	    m_pattrCurrent.AddRef();
		m_ptransCurrent = new CqTransform(pconParent.m_ptransCurrent );

	    // Create a new CSG tree node of the appropriate type.
	    m_pCSGNode = CqCSGTreeNode.CreateNode( type );

	    if ( (pconParent != null) && pconParent.isSolid() )
	    {
	    	//CqSolidModeBlock擾B
	    	CqModeBlock pContext = pconParent();
	    	while( !(( pContext.getClass() ).equals( CqSolidModeBlock.class )) )
	    		pContext = pContext.pconParent();
	    	
	        CqSolidModeBlock pParentSolid = ( CqSolidModeBlock )( pContext );
	        
	        // Check if we are linking under a Primitive node, if so warn, and link at the top.
	        if ( pParentSolid.pCSGNode().NodeType().getValue() == CSGNodeType_Primitive )
	        {
	            String objname = "unnamed" ;
	            final String[] pattrName = m_pattrCurrent.GetStringAttribute( "identifier", "name" );
	            
	            if ( pattrName != null ){ 
	            	objname = pattrName[ 0 ];
	            }
	            // OG[óB@v~eBum[h͎qƂ͂ȂB
	            logger.warning( "Cannot add solid block under 'Primitive' \"" + objname + "\" solid block \n" );
	        }
	        else{	
	        	//@m[h̒ǉ
	            pParentSolid.pCSGNode().AddChild( m_pCSGNode );
	        }
	    }
	}
		
	
	/**	
	 * fXgN^B <br>
	 * QƂ̏B@(QƃJE^fNg)
	 * @see net.cellcomputing.himawari.library.CqModeBlock#destruct()
	 */
	@Override
	public void destruct()
	{
		m_pattrCurrent.Release();
	}


    /** 
     * Create a main context.<br>
     * 	C̃ReLXg쐬B
     * 
     * @warning  \bhReLXg̒ŁÃ\bhĂ΂ꂽꍇG[ƂȂB
     */
	@Override
    public CqModeBlock	BeginMainModeBlock()
    {
        return  null;	// Error
    }	
    
	
    /** 
     * Create a frame context.<br>
     * 	t[̃ReLXg쐬B
     * 
     * @warning \bhReLXg̒ŁÃ\bhĂ΂ꂽꍇG[ƂȂB
     */
	@Override
    public CqModeBlock	BeginFrameModeBlock()
    {
        return	null;	// Error
    }	
    
	
    /** 
     * Create a world context.<br>
     * 	[h̃ReLXg쐬B
     * 
     * @warning \bhReLXg̒ŁÃ\bhĂ΂ꂽꍇG[ƂȂB
     */
	@Override
    public	CqModeBlock	BeginWorldModeBlock()
    {
        return	null;	// Error
    }	

	
    /** 
     * Delete the solid context.<br>
     * 	\bh̃ReLXgB
     * 
     * @attention ̃\bĥ݁A[h̃ReLXg邱ƂłB
     */
	@Override
    public void	EndSolidModeBlock()
    {
		destruct();
    }

    /** 
     * Get a reference to the options at the parent context, <br>
     * 	as solid context doesn't store options.<br>
     * 	IvṼQb^B<br>
     * 	\bhReLXg̓IvVۑȂ߁AẽReLXgIvVQƂB
     * 
     * @return 	IvV
     */
	@Override
    public  CqOptions optCurrent()
    {
        return ( pconParent().optCurrent() );
    }

	
	/** 
	 * \bhubN̒łtrueԂB
	 * 
	 * @see net.cellcomputing.himawari.library.CqModeBlock#isSolid()
	 */
	@Override
    public	boolean	isSolid()
    {
        return ( true );
    }
	
	
	/**
	 * ݂CSGtreeԂB
	 * 
	 *  @return	m_pCSGNode	CSGc[m[h
	 * 	@see net.cellcomputing.himawari.library.CqModeBlock#pCSGNode()
	 */
	@Override
    public CqCSGTreeNode	pCSGNode()
    {
        return ( m_pCSGNode );
    }

    private  CqCSGTreeNode	m_pCSGNode;			///< CSGc[m[h̎QƁB	<< Pointer to the node in the CSG tree for this level in the solid definition.
//	private	 String 		m_strType;								///< CSGc[m[hi[B
	private	 HimawariLogger logger = HimawariLogger.getLogger(); 	///<@Ox̎擾B
}