// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import static net.cellcomputing.himawari.library.RiGlobal.QGetRenderContext;
import static net.cellcomputing.himawari.library.RiGlobal.QGetRenderContextI;
import net.cellcomputing.himawari.util.HimawariLogger;

/**
 * @author NTT DATA Corporation
 *
 */
public strictfp class CqShadowMapBuffer extends CqTextureMapBuffer {
	public CqShadowMapBuffer()
	    {
			super();
			dataClass = Float.class;
	    }
	    public void destruct()
	    {
	    	super.destruct();
	    }

	    public float	GetValue(int x, int y, int sample)
	    {
	        int iv = (int)(y * ( m_Width * m_Samples ));
	        int iu = x * m_Samples;
//	        return ( (Float)m_pBufferData.get( iv + iu + sample) );
	        return ( (Float)m_pBufferData[ iv + iu + sample] );
	    }
	    public void	SetValue(int x, int y, int sample, float value)
	    {
	        int iv = (int)(y * ( m_Width * m_Samples ));
	        int iu = (int)(x * m_Samples);
//	        m_pBufferData.set( iv + iu + sample , value);
	        m_pBufferData[iv+iu+sample] = value;
	    }
	    public int	ElemSize()
	    {
	        return( m_Samples );//* sizeof(float) );
	    }
	    /** Get the type of the data in the buffer
	     */
	    public EqBufferType BufferType()
	    {
	        return( new EqBufferType(EqBufferType.BufferType_Float) );
	    }
	    //
		public Object[] AllocSegment( long width, long height, int samples, boolean fProt ){
			int demand =(int)( width * height * ElemSize());
			
			//limitvZ
			if(limit == -1){
				final int[] poptMem = QGetRenderContextI().GetIntegerOption("limits","texturememory");
				limit = RiGlobal.MEG1;
				if(poptMem != null)
					limit = poptMem[ 0 ] * 1024;
			}
			
			//Texture̗\zʂvZ
			int more = QGetRenderContext().Stats().GetTextureMemory() + demand;
			
			//limit𒴂ꍇ̏s
			if((more > limit) && !fProt){
				//eʂ𒴂悤ƂĂ
				//LbVNAق悢
				//KvƂ郁mۂ邽߂ɂ̓LbVZAPKv
				//烆[UɁANGXg镪̃g債Ȃ
				//ȂȂƌx悤B
				
				if(report != 0){
					HimawariLogger.getLogger().warning("Exceeding allocated texture memory by "+
							(more - limit) + "\n");
				}
				report = 0;
				RiGlobal.m_critical = true;	

			}
			 
		    QGetRenderContext().Stats().IncTextureMemory( demand );
//	return new ArrayList<Byte>(demand);
		    return new Float[demand];
		}
}
