// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;
import net.cellcomputing.himawari.util.HimawariLogger;

/**
 * l̃^CvƁAid̃^CvŃev[gꂽAωz̃p[^^Cv
 * @author NTT DATA Corporation
 */
public strictfp class CqParameterTypedVaryingArray<T,SLT> extends CqParameterTyped<T,SLT> {
	STLVector<STLVector<T> >	m_aValues;
	 protected EqVariableType 	I;			//C++łGenericsƂĎw肳Ăl
	 
	 /**
	  * RXgN^
	  * m_aValues̃TCY1ƂāA
	  * m_aValues[0]Ɋi[ĂSTLVectoȑTCYcountɐݒ肷B
	  * count͍m_aValuesɒlSTLVectorǉ鎞̂VectoȑTCY
	  * Ƃėp
	  * 
	  * @param str p^
	  * @param count oϐm_aValues̗vf[0]̏TCY
	  * @param I Generics I
	  * @param TClass Generics TClass
	  * @param SLTClass Generics SLTClass
	  */
	 public CqParameterTypedVaryingArray(final String str,int count,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass){
		 super(str,count,TClass,SLTClass);
		 
		 m_aValues = new STLVector<STLVector<T>>(2,TClass);
		 resizeSTLVector(1,count);
		 this.I = I;
	 }
	 
	 /**
	  * fXgN^
	  */
	 public void destruct(){
		 super.destruct();
	 }
	 
	 /**
	  * Rs[RXgN^
	  * @param From Rs[
	  * @param I Generics I
	  */
	 public CqParameterTypedVaryingArray(CqParameterTypedVaryingArray<T,SLT> From,EqVariableType I){
		 super(From);
		 this.I = I;
		 m_aValues = new STLVector<STLVector<T>>(2,TClass);
		 this.assignment(From);
	 }
	 
	 /**
	  * RXgN^
	  * CountȗĂ
	  * 
	  * @param name O
	  * @param I Genrics I
	  * @param TClass Generics SClass
	  */
	 public CqParameterTypedVaryingArray(final String name,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass){
		 this(name,1,I,TClass,SLTClass);
	 }
	 
		/**
		 * ̎STLVector<STLVector<T>>̐擪STLVector̒l
		 * zƂĕԂB
		 * 
		 */
	public Object[] pValue() {
        assert( 0 < m_aValues.size() );
        assert( 0 < m_aValues.elementAt(0).size() );
        return ( m_aValues.elementAt(0).toArray() );
	}

	/**
	 * ̎STLVector<STLVector<T>>ɑ΂āA
	 * w肳ꂽʒuSTLVector̒lzƂĕԋpB
	 * 
	 * ԋplZbgȂƂVector̎lωB
	 * 
	 * @param Index 擾STLVector̈ʒu
	 * @exception Vector̃TCY傫lw肷NegativeArraySizeException
	 */
	public Object[] pValue(int Index) {
        assert( Index <  m_aValues.size()  );
        assert( 0 < m_aValues.elementAt(0).size() );
        
        //indexŎw肳ꂽVector̒gԂ
        return ( m_aValues.elementAt(Index).toArray());
	}

	//
	public T pValue_get(final int Index ,final int arrayIndex)
	{
		return m_aValues.elementAt(Index).elementAt(arrayIndex);
	}
	/**
	 * EqVariableType̓CX^XԂ
	 * 
	 * @param Name p^
	 * @param Count JEg
	 * @return VCqParameter
	 */
	public CqParameter CloneType(String Name, int Count) {
        return ( new CqParameterTypedVaryingArray<T,SLT>( Name, Count,I,TClass,SLTClass ) );
	}
	/**
	 * gƓlCX^X𕡐B
	 */
	public CqParameter Clone() {
        return ( new CqParameterTypedVaryingArray<T,SLT>( this ,I ) );
	}

	/**
	 * EqVariableClassԂ
	 *
	 * @param EqVariableClass
	 */
	public EqVariableClass Class() {
        return (new EqVariableClass( EqVariableClass.class_varying ));
	}

	/**
	 * ̂EqVariableTypeԂ
	 * (C++łGenericsŗpĂ)
	 * @return EqVariableType
	 */
	public EqVariableType Type() {
        return ( I );
	}


	/**
	 * m_aValuesw肳ꂽlɃTCYB
	 * TCYہÃ݂TCY傫ꍇ
	 * count̑傫STLVectorǉB
	 * 
	 * @param size TCYl
	 */
	public void SetSize(int size) {
        //m_aValues.resize( size, std::vector< T >(m_Count) );
		resizeSTLVector(size,m_Count);
	}

	/**
	 * m_aValuesɊi[ĂSLTVector̃TCYύX
	 * m_aValues̒w肳ꂽTCY傫ꍇɂ
	 * w肳ꂽinitialSizeSTLVector
	 * size𖞂܂ŒǉB
	 * 
	 * m_aValues̒w肳ꂽTCYꍇ
	 * resize\bhR[A]Ȓl폜B
	 * 
	 * @param size ύXTCY
	 * @param initialSize VKɒǉSTLVectorinitialSize
	 */
	private void resizeSTLVector(int size,int initialSize){
        if(m_aValues.size() < size){
        	for(int i = m_aValues.size(); i < size;i++)
        		m_aValues.add(new STLVector<T>(TClass,initialSize));
        }else{
        	m_aValues.resize(size);
        }		
	}
	/**
	 * ̎STLVector<STLVector<T>> m_aValues̃TCYԋp	
	 * @return ݂Vector̃TCY
	 */
	public int Size() {
        return ( m_aValues.size() );
	}

	/**
	 * ̎STLVector<STLVector<T>> m_aValues
	 * ̒lNAȀԂɂ	
	 * 
	 */
	public void Clear() {
		m_aValues.clear();

	}

	/**
	 * Ŏw肳ꂽCX^X̍WSubdivide邱Ƃ
	 * ύXB
	 * 3ɂĕ̎dύXłB
	 * 
	 * @param pResult1	SubdividȇΏۂP
	 * @param pResult2	SubdividȇΏۂQ
	 * @param u		ǂ̂悤Subdivide邩̃tO
	 * @param pSurface	Surface gpȂ
	 */
	public void Subdivide(CqParameter pResult1, CqParameter pResult2, boolean u,
			IqSurface pSurface) {
	       assert( pResult1.Type().getValue() == Type().getValue() && pResult2.Type().getValue() == Type().getValue() &&
	                pResult1.Class().getValue() == Class().getValue() && pResult2.Class().getValue() == Class().getValue() );

	        CqParameterTypedVaryingArray<T, SLT> pTResult1 = (CqParameterTypedVaryingArray<T, SLT>)( pResult1 );
	        CqParameterTypedVaryingArray<T, SLT> pTResult2 = (CqParameterTypedVaryingArray<T, SLT>)( pResult2 );
	        pTResult1.SetSize( 4 );
	        pTResult2.SetSize( 4 );
	        // Check if a valid 4 point quad, do nothing if not.
	        if ( m_aValues.size() == 4 ){
	            if ( u ){

	                T t = (T)pTResult1.pValue_get(1,0);
	                //^ɂ锻ʂs
	                //^7
	                //-------
	                int index;
	                if(t instanceof p_float){
	               
	                	for( index = this.Count()-1; index >= 0; index-- )
	                	{
	                		((p_float)pTResult2.pValue_get( 1 , index )).value = ((p_float)pValue_get( 1 , index )).value;
	                		((p_float)pTResult2.pValue_get( 3 , index )).value = ((p_float)pValue_get( 3 , index )).value;
	                		
	                		((p_float)pTResult1.pValue_get( 1 , index )).value = ((p_float)pTResult2.pValue_get( 0 , index )).value = (( (p_float)(pValue_get( 0 , index ))).value + ((p_float)(pValue_get( 1 , index ))).value ) * 0.5f;
	                		((p_float)pTResult1.pValue_get( 3 , index )).value = ((p_float)pTResult2.pValue_get( 2 , index )).value = (( (p_float)(pValue_get( 2 , index ))).value + ((p_float)(pValue_get( 3 , index ))).value ) * 0.5f;
	                	}
	                }else if(t instanceof p_int){
	                	for( index = this.Count()-1; index >= 0; index-- )
	                	{
	                		((p_int)pTResult2.pValue_get( 1 , index )).value = ((p_int)pValue_get( 1 , index )).value;
	                		((p_int)pTResult2.pValue_get( 3 , index )).value = ((p_int)pValue_get( 3 , index )).value;
	                		((p_int)pTResult1.pValue_get( 1 , index )).value = ((p_int)pTResult2.pValue_get( 0 , index )).value = (int)((( (p_int)(pValue_get( 0 , index ))).value + ((p_int)(pValue_get( 1 , index ))).value ) * 0.5f);
	                		((p_int)pTResult1.pValue_get( 3 , index )).value = ((p_int)pTResult2.pValue_get( 2 , index )).value = (int)((( (p_int)(pValue_get( 2 , index ))).value + ((p_int)(pValue_get( 3 , index ))).value ) * 0.5f);
	                	}
	                }else if(t instanceof CqMatrix){
	                	for( index = this.Count()-1; index >= 0; index-- )
	                	{
	                		((CqMatrix)pTResult2.pValue_get( 1 , index )).assignment((CqMatrix)pValue_get( 1 , index ));
	                		((CqMatrix)pTResult2.pValue_get( 3 , index )).assignment((CqMatrix)pValue_get( 3 , index ));
	                		((CqMatrix)pTResult1.pValue_get( 1 , index )).assignment(((CqMatrix)pTResult2.pValue_get( 0 , index )).assignment((((CqMatrix)(pValue_get( 0 , index ))).add(((CqMatrix)(pValue_get( 1 , index ))) )).multiply(0.5f)));
	                		((CqMatrix)pTResult1.pValue_get( 3 , index )).assignment(((CqMatrix)pTResult2.pValue_get( 2 , index )).assignment((((CqMatrix)(pValue_get( 2 , index ))).add(((CqMatrix)(pValue_get( 3 , index ))) )).multiply(0.5f)));
	                	}
	                }else if(t instanceof CqColor){
	                	for( index = this.Count()-1; index >= 0; index-- )
	                	{
	                		((CqColor)pTResult2.pValue_get( 1 , index )).assignment(((CqColor)pValue_get( 1 , index )));
	                		((CqColor)pTResult2.pValue_get( 3 , index )).assignment(((CqColor)pValue_get( 3 , index )));
	                		((CqColor)pTResult1.pValue_get( 1 , index )).assignment((((CqColor)pTResult2.pValue_get( 0 , index )).assignment(((((CqColor)(pValue_get( 0 , index ))).add((CqColor)(pValue_get( 1 , index )))).mul(0.5f)))));
	                		((CqColor)pTResult1.pValue_get( 3 , index )).assignment((((CqColor)pTResult2.pValue_get( 2 , index )).assignment(((((CqColor)(pValue_get( 2 , index ))).add((CqColor)(pValue_get( 3 , index )))).mul(0.5f)))));	                		                	
	                	}
	                }else if(t instanceof CqVector4D){
	                	for( index = this.Count()-1; index >= 0; index-- )
	                	{
	                		((CqVector4D)pTResult2.pValue_get( 1 , index )).assignment((CqVector4D)pValue_get( 1 , index ));
	                		((CqVector4D)pTResult2.pValue_get( 3 , index )).assignment((CqVector4D)pValue_get( 3 , index ));
	                		
	                		((CqVector4D)pTResult1.pValue_get( 1 , index )).assignment(((CqVector4D)pTResult2.pValue_get( 0 , index )).assignment((((CqVector4D)(pValue_get( 0 , index ))).add(((CqVector4D)(pValue_get( 1 , index ))) )).mul(0.5f)));
	                		((CqVector4D)pTResult1.pValue_get( 3 , index )).assignment(((CqVector4D)pTResult2.pValue_get( 2 , index )).assignment((((CqVector4D)(pValue_get( 2 , index ))).add(((CqVector4D)(pValue_get( 3 , index ))) )).mul(0.5f)));
	                	}
	                }else if(t instanceof CqVector3D){
	                	for( index = this.Count()-1; index >= 0; index-- )
	                	{
	                		((CqVector3D)pTResult2.pValue_get( 1 , index )).assignment((CqVector3D)pValue_get( 1 , index ));
	                		((CqVector3D)pTResult2.pValue_get( 3 , index )).assignment((CqVector3D)pValue_get( 3 , index ));
	                		
	                		((CqVector3D)pTResult1.pValue_get( 1 , index )).assignment(((CqVector3D)pTResult2.pValue_get( 0 , index )).assignment((((CqVector3D)(pValue_get( 0 , index ))).add(((CqVector3D)(pValue_get( 1 , index ))) )).mul(0.5f)));
	                		((CqVector3D)pTResult1.pValue_get( 3 , index )).assignment(((CqVector3D)pTResult2.pValue_get( 2 , index )).assignment((((CqVector3D)(pValue_get( 2 , index ))).add(((CqVector3D)(pValue_get( 3 , index ))) )).mul(0.5f)));
	                	}
	                }
	                else if(t instanceof p_String){
	                	for( index = this.Count()-1; index >= 0; index-- )
	                	{
	                		((p_String)pTResult2.pValue_get( 1 , index )).value = ((p_String)pValue_get( 1 , index )).value;
	                		((p_String)pTResult2.pValue_get( 3 , index )).value = ((p_String)pValue_get( 3 , index )).value;
	                		((p_String)pTResult1.pValue_get( 1 , index )).value = ((p_String)pTResult2.pValue_get( 0 , index )).value = ((( (p_String)(pValue_get( 0 , index ))).value + ((p_String)(pValue_get( 1 , index ))).value ));
	                		((p_String)pTResult1.pValue_get( 3 , index )).value = ((p_String)pTResult2.pValue_get( 2 , index )).value = ((( (p_String)(pValue_get( 2 , index ))).value + ((p_String)(pValue_get( 3 , index ))).value ));
	                	}
	                }
	                //else if(t instanceof String){
	                	//ZqȂߍ폜
	                //}
	                //--ꍇI
	            }
	            else{
//	                pTResult2.pValue_get( 2 , index ) = pValue_get( 2 , index );
//	                pTResult2.pValue_get( 3 , index ) = pValue_get( 3 , index );
	                T t = (T)pTResult1.pValue_get(1,0);
	                //^ɂ锻ʂs
	                //^7
	                //-------
	                int index;
	                if(t instanceof p_float){
	                	for( index = this.Count()-1; index >= 0; index-- )
	                	{
	                		((p_float)pTResult2.pValue_get( 2 , index )).value = ((p_float)pValue_get( 2 , index )).value;
	                		((p_float)pTResult2.pValue_get( 3 , index )).value = ((p_float)pValue_get( 3 , index )).value;
	                		((p_float)pTResult1.pValue_get( 2 , index )).value = ((p_float)pTResult2.pValue_get( 0 , index )).value = (( (p_float)(pValue_get( 0 , index ))).value + ((p_float)(pValue_get( 2 , index ))).value ) * 0.5f;
	                		((p_float)pTResult1.pValue_get( 3 , index )).value = ((p_float)pTResult2.pValue_get( 1 , index )).value = (( (p_float)(pValue_get( 1 , index ))).value + ((p_float)(pValue_get( 3 , index ))).value ) * 0.5f;
	                	}
	                }else if(t instanceof p_int){
	                	for( index = this.Count()-1; index >= 0; index-- )
	                	{
	                		((p_int)pTResult2.pValue_get( 2 , index )).value = ((p_int)pValue_get( 2 , index )).value;
	                		((p_int)pTResult2.pValue_get( 3 , index )).value = ((p_int)pValue_get( 3 , index )).value;
	                		((p_int)pTResult1.pValue_get( 2 , index )).value = ((p_int)pTResult2.pValue_get( 0 , index )).value = (int)((( (p_int)(pValue_get( 0 , index ))).value + ((p_int)(pValue_get( 2 , index ))).value ) * 0.5f);
	                		((p_int)pTResult1.pValue_get( 3 , index )).value = ((p_int)pTResult2.pValue_get( 1 , index )).value = (int)((( (p_int)(pValue_get( 1 , index ))).value + ((p_int)(pValue_get( 3 , index ))).value ) * 0.5f);
	                	}
	                }else if(t instanceof CqMatrix){
	                	for( index = this.Count()-1; index >= 0; index-- )
	                	{
	                		((CqMatrix)pTResult2.pValue_get( 2 , index )).assignment((CqMatrix)pValue_get( 2 , index ));
	                		((CqMatrix)pTResult2.pValue_get( 3 , index )).assignment((CqMatrix)pValue_get( 3 , index ));
	                		((CqMatrix)pTResult1.pValue_get( 2 , index )).assignment(((CqMatrix)pTResult2.pValue_get( 0 , index )).assignment((((CqMatrix)(pValue_get( 0 , index ))).add(((CqMatrix)(pValue_get( 2 , index ))) )).multiply(0.5f)));
	                		((CqMatrix)pTResult1.pValue_get( 3 , index )).assignment(((CqMatrix)pTResult2.pValue_get( 1 , index )).assignment((((CqMatrix)(pValue_get( 1 , index ))).add(((CqMatrix)(pValue_get( 3 , index ))) )).multiply(0.5f)));
	                	}
	                }else if(t instanceof CqColor){
	                	for( index = this.Count()-1; index >= 0; index-- )
	                	{
	                		((CqColor)pTResult2.pValue_get( 2 , index )).assignment(((CqColor)pValue_get( 2 , index )));
	                		((CqColor)pTResult2.pValue_get( 3 , index )).assignment(((CqColor)pValue_get( 3 , index )));
//	                		((CqColor)pTResult1.pValue_get( 2 , index )).assignment(new CqVector3D(((CqColor)pTResult2.pValue_get( 0 , index )).assignment(new CqVector3D(( ((CqColor)(pValue_get( 0 , index ))).add((CqColor)(pValue_get( 2 , index )) ).mul(0.5f))))));
//	                		((CqColor)pTResult1.pValue_get( 3 , index )).assignment(new CqVector3D(((CqColor)pTResult2.pValue_get( 1 , index )).assignment(new CqVector3D(( ((CqColor)(pValue_get( 1 , index ))).add((CqColor)(pValue_get( 3 , index )) ).mul(0.5f))))));
	                		((CqColor)pTResult1.pValue_get( 2 , index )).assignment((((CqColor)pTResult2.pValue_get( 0 , index )).assignment(((((CqColor)(pValue_get( 0 , index ))).add((CqColor)(pValue_get( 2 , index )))).mul(0.5f)))));
	                		((CqColor)pTResult1.pValue_get( 3 , index )).assignment((((CqColor)pTResult2.pValue_get( 1 , index )).assignment(((((CqColor)(pValue_get( 1 , index ))).add((CqColor)(pValue_get( 3 , index )))).mul(0.5f)))));
	                	}
	                }else if(t instanceof CqVector4D){
	                	for( index = this.Count()-1; index >= 0; index-- )
	                	{
	                		((CqVector4D)pTResult2.pValue_get( 2 , index )).assignment((CqVector4D)pValue_get( 2 , index ));
	                		((CqVector4D)pTResult2.pValue_get( 3 , index )).assignment((CqVector4D)pValue_get( 3 , index ));
	                		((CqVector4D)pTResult1.pValue_get( 2 , index )).assignment(((CqVector4D)pTResult2.pValue_get( 0 , index )).assignment((((CqVector4D)(pValue_get( 0 , index ))).add(((CqVector4D)(pValue_get( 2 , index ))) )).mul(0.5f)));
	                		((CqVector4D)pTResult1.pValue_get( 3 , index )).assignment(((CqVector4D)pTResult2.pValue_get( 1 , index )).assignment((((CqVector4D)(pValue_get( 1 , index ))).add(((CqVector4D)(pValue_get( 3 , index ))) )).mul(0.5f)));
	                	}
	                }else if(t instanceof CqVector3D){
	                	for( index = this.Count()-1; index >= 0; index-- )
	                	{
	                		((CqVector3D)pTResult2.pValue_get( 2 , index )).assignment((CqVector3D)pValue_get( 2 , index ));
	                		((CqVector3D)pTResult2.pValue_get( 3 , index )).assignment((CqVector3D)pValue_get( 3 , index ));
	                		((CqVector3D)pTResult1.pValue_get( 2 , index )).assignment(((CqVector3D)pTResult2.pValue_get( 0 , index )).assignment((((CqVector3D)(pValue_get( 0 , index ))).add(((CqVector3D)(pValue_get( 2 , index ))) )).mul(0.5f)));
	                		((CqVector3D)pTResult1.pValue_get( 3 , index )).assignment(((CqVector3D)pTResult2.pValue_get( 1 , index )).assignment((((CqVector3D)(pValue_get( 1 , index ))).add(((CqVector3D)(pValue_get( 3 , index ))) )).mul(0.5f)));
	                	}
	                }else if(t instanceof p_String){
	                	for( index = this.Count()-1; index >= 0; index-- )
	                	{
	                		((p_String)pTResult2.pValue_get( 2 , index )).value = ((p_String)pValue_get( 2 , index )).value;
	                		((p_String)pTResult2.pValue_get( 3 , index )).value = ((p_String)pValue_get( 3 , index )).value;
	                		((p_String)pTResult1.pValue_get( 2 , index )).value = ((p_String)pTResult2.pValue_get( 0 , index )).value = ((( (p_String)(pValue_get( 0 , index ))).value + ((p_String)(pValue_get( 2 , index ))).value ));
	                		((p_String)pTResult1.pValue_get( 3 , index )).value = ((p_String)pTResult2.pValue_get( 1 , index )).value = ((( (p_String)(pValue_get( 1 , index ))).value + ((p_String)(pValue_get( 3 , index ))).value ));
	                	}
	                }
	                //else if(t instanceof String){
	                	//ZqȂߍ폜
	                //}
	                //--ꍇI
	            }
	        }
		

	}

	/**
	 * uvApReusltzɒl
	 * ɗpl
	 * PDm_aValues̃TCY4̎ m_aValues[0][0]`m_aValues[3][0]
	 * QD̑m_aValues[0][0]
	 * łB
	 * 
	 * u*v̒lpResData.size()KȂ΂ȂȂB
	 * łȂꍇ͖{Ƃ̓[NNA\̉\B
	 * @param u uɉ邩p
	 * @param v vɉ邩p
	 * @param pResult l
	 * @param pSurface gpȂ
	 */
	public void Dice(int u, int v, IqShaderData pResult, IqSurface pSurface) {
		T res = null;
		try {
			res = (T)TClass.newInstance();
		} catch (InstantiationException e) {
			HimawariLogger.outputException( e );
			return;
		} catch (IllegalAccessException e) {
			HimawariLogger.outputException( e );
			return;
		}
		
		assert( (pResult.Type()).getValue() == Type().getValue() );
		assert( pResult.Class().getValue() == EqVariableClass.class_varying );
		STLVector<SLT> pResData = new STLVector<SLT>(SLTClass);
		pResult.GetValuePtr( pResData );
		assert( null != pResData );
		
//		--܂
		//
		if(TClass.equals(CqMatrix.class) && SLTClass.equals(CqMatrix.class)){
			//-----------------CqMatrix̏ꍇ-----------------------
			// Check if a valid 4 point quad, do nothing if not.
			if ( m_aValues.size() >= 4 )
			{
				// Note it is assumed that the variable has been
				// initialised to the correct size prior to calling.
				Float diu = 1.0f / u;
				Float div = 1.0f / v;
				int iv;
				int index = 0;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ )
					{
						
						((CqMatrix)res).assignment((CqMatrix)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , 0 )),
								(T)(pValue_get( 1 , 0 )),
								(T)(pValue_get( 2 , 0 )),
								(T)(pValue_get( 3 , 0 )),
								iu * diu, iv * div,TClass ));
						((CqMatrix)pResData.elementAt(index)).assignment((CqMatrix)res);
						index++;
						//( pResData++ ) = res;
					}
				}
			}
			else
			{
				int iv;
				int index = 0;
				((CqMatrix)res).assignment((CqMatrix)(pValue_get( 0 , 0 )));
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ ){
						((CqMatrix)pResData.elementAt(index)).assignment((CqMatrix)res);
						index++;
						//( pResData++ ) = res;
					}
				}
			}
		}else if(TClass.equals(CqColor.class) && SLTClass.equals(CqColor.class)){
			//-----------------CqColoȑꍇ-----------------------
			// Check if a valid 4 point quad, do nothing if not.
			if ( m_aValues.size() >= 4 )
			{
				// Note it is assumed that the variable has been
				// initialised to the correct size prior to calling.
				Float diu = 1.0f / u;
				Float div = 1.0f / v;
				int iv;
				int index = 0;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ )
					{
						
						((CqColor)res).assignment(((CqColor)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , 0 )),
								(T)(pValue_get( 1 , 0 )),
								(T)(pValue_get( 2 , 0 )),
								(T)(pValue_get( 3 , 0 )),
								iu * diu, iv * div,TClass )));
						((CqColor)pResData.elementAt(index)).assignment(((CqColor)res));
						index++;
						//( pResData++ ) = res;
					}
				}
			}
			else
			{
				//pResdatãTCYl`FbNĂȂExceptionԉ\
				int iv;
				int index = 0;
				((CqColor)res).assignment((CqColor)(pValue_get( 0 , 0 )));
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ ){
						((CqColor)pResData.elementAt(index)).assignment((CqColor)res);
						index++;
						//( pResData++ ) = res;
					}
				}
			}
		}else if(TClass.equals(CqVector3D.class) && SLTClass.equals(CqVector3D.class)){
			//-----------------CqVector3D̏ꍇ-----------------------
			// Check if a valid 4 point quad, do nothing if not.
			if ( m_aValues.size() >= 4 )
			{
				// Note it is assumed that the variable has been
				// initialised to the correct size prior to calling.
				Float diu = 1.0f / u;
				Float div = 1.0f / v;
				int iv;
				int index = 0;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ )
					{
						
						((CqVector3D)res).assignment((CqVector3D)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , 0 )),
								(T)(pValue_get( 1 , 0 )),
								(T)(pValue_get( 2 , 0 )),
								(T)(pValue_get( 3 , 0 )),
								iu * diu, iv * div,TClass ));
						((CqVector3D)pResData.elementAt(index)).assignment((CqVector3D)res);
						index++;
						//( pResData++ ) = res;
					}
				}
			}
			else
			{
				//pResdatãTCYl`FbNĂȂExceptionԉ\
				int iv;
				int index = 0;
				((CqVector3D)res).assignment((CqVector3D)(pValue_get( 0 , 0 )));
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ ){
						((CqVector3D)pResData.elementAt(index)).assignment((CqVector3D)res);
						index++;
						//( pResData++ ) = res;
					}
				}
			}
		}else if(TClass.equals(p_float.class) && SLTClass.equals(p_float.class)){
			//-----------------p_float̏ꍇ-----------------------
			// Check if a valid 4 point quad, do nothing if not.
			if ( m_aValues.size() >= 4 )
			{
				// Note it is assumed that the variable has been
				// initialised to the correct size prior to calling.
				Float diu = 1.0f / u;
				Float div = 1.0f / v;
				int iv;
				int index = 0;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ )
					{
						
						((p_float)res).value = ((p_float)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , 0 )),
								(T)(pValue_get( 1 , 0 )),
								(T)(pValue_get( 2 , 0 )),
								(T)(pValue_get( 3 , 0 )),
								iu * diu, iv * div,TClass )).value;
						
						((p_float)pResData.elementAt(index)).value = ((p_float)res).value;
						index++;
						//( pResData++ ) = res;
					}
				}
			}
			else
			{
				//pResdatãTCYl`FbNĂȂExceptionԉ\
				int iv;
				int index = 0;
				((p_float)res).value = ((p_float)(pValue_get( 0 , 0 ))).value;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ ){
						((p_float)pResData.elementAt(index)).value = ((p_float)res).value;
						index++;
						//( pResData++ ) = res;
					}
				}
			}
		}else if(TClass.equals(p_int.class) && SLTClass.equals(p_float.class)){
			//-----------------p_int̏ꍇ-----------------------
			// Check if a valid 4 point quad, do nothing if not.
			if ( m_aValues.size() >= 4 )
			{
				// Note it is assumed that the variable has been
				// initialised to the correct size prior to calling.
				Float diu = 1.0f / u;
				Float div = 1.0f / v;
				int iv;
				int index = 0;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ )
					{
						
						((p_int)res).value = ((p_int)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , 0 )),
								(T)(pValue_get( 1 , 0 )),
								(T)(pValue_get( 2 , 0 )),
								(T)(pValue_get( 3 , 0 )),
								iu * diu, iv * div,TClass )).value;
						((p_float)pResData.elementAt(index)).value = ((p_int)res).value;
						index++;
						//( pResData++ ) = res;
					}
				}
			}
			else
			{
				//pResdatãTCYl`FbNĂȂExceptionԉ\
				int iv;
				int index = 0;
				((p_int)res).value = ((p_int)(pValue_get( 0 , 0 ))).value;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ ){
						((p_float)pResData.elementAt(index)).value = ((p_int)res).value;
						index++;
						//( pResData++ ) = res;
					}
				}
			}
		}else if(TClass.equals(CqVector4D.class) && SLTClass.equals(CqVector3D.class)){
			//-----------------CqVector4D̏ꍇ-----------------------
			// Check if a valid 4 point quad, do nothing if not.
			if ( m_aValues.size() >= 4 )
			{
				// Note it is assumed that the variable has been
				// initialised to the correct size prior to calling.
				Float diu = 1.0f / u;
				Float div = 1.0f / v;
				int iv;
				int index = 0;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ )
					{
						
						((CqVector4D)res).assignment((CqVector4D)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , 0 )),
								(T)(pValue_get( 1 , 0 )),
								(T)(pValue_get( 2 , 0 )),
								(T)(pValue_get( 3 , 0 )),
								iu * diu, iv * div,TClass ));
						((CqVector3D)pResData.elementAt(index)).assignment((CqVector4D)res);
						index++;
						//( pResData++ ) = res;
					}
				}
			}
			else
			{
				//pResdatãTCYl`FbNĂȂExceptionԉ\
				int iv;
				int index = 0;
				((CqVector4D)res).assignment((CqVector4D)(pValue_get( 0 , 0 )));
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ ){
						((CqVector3D)pResData.elementAt(index)).assignment((CqVector4D)res);
						index++;
						//( pResData++ ) = res;
					}
				}
			}
		}else if(TClass.equals(p_String.class) && SLTClass.equals(p_String.class)){
			//-----------------p_String̏ꍇ-----------------------
			// Check if a valid 4 point quad, do nothing if not.
			if ( m_aValues.size() >= 4 )
			{
				// Note it is assumed that the variable has been
				// initialised to the correct size prior to calling.
				Float diu = 1.0f / u;
				Float div = 1.0f / v;
				int iv;
				int index = 0;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ )
					{
						
						((p_String)res).value = ((p_String)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , 0 )),
								(T)(pValue_get( 1 , 0 )),
								(T)(pValue_get( 2 , 0 )),
								(T)(pValue_get( 3 , 0 )),
								iu * diu, iv * div,TClass )).value;
						
						((p_String)pResData.elementAt(index)).value = ((p_String)res).value;
						index++;
						//( pResData++ ) = res;
					}
				}
			}
			else
			{
				//pResdatãTCYl`FbNĂȂExceptionԉ\
				int iv;
				int index = 0;
				((p_String)res).value = ((p_String)(pValue_get( 0 , 0 ))).value;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ ){
						((p_String)pResData.elementAt(index)).value = ((p_String)res).value;
						index++;
						//( pResData++ ) = res;
					}
				}
			}
		}
		
	}
	/**
	 * uvApReusltzɒl
	 * ɗpl
	 * PDm_aValues̃TCY4̎ m_aValues[0)[ArrayIndex)`m_aValues[3)[ArrayIndex)
	 * QD̑m_aValues[0)[ArrayIndex)
	 * łB
	 * 
	 * u*v̒lpResData.size()KȂ΂ȂȂB
	 * łȂꍇ͖{Ƃ̓[NNA\̉\B
	 * ArrayIndex̃TCYm_Count傫ꍇ̓G[ƂȂB
	 * 
	 * @param u uɉ邩p
	 * @param v vɉ邩p
	 * @param pResult l
	 * @param pSurface gpȂ
	 * @param ArrayIndex Vector̂ǂ̒lvZɗp邩w肷
	 */
	public void DiceOne(int u, int v, IqShaderData pResult, IqSurface pSurface,
			int ArrayIndex) {
	    assert( pResult.Type().getValue() == Type().getValue() );
	    assert( pResult.Class().getValue() == EqVariableClass.class_varying );
	    assert( Count() > ArrayIndex );
		T res = null;
		try {
			res = (T)TClass.newInstance();
		} catch (InstantiationException e) {
			HimawariLogger.outputException( e );
			return;
		} catch (IllegalAccessException e) {
			HimawariLogger.outputException( e );
			return;
		}
		
		STLVector<SLT> pResData = new STLVector<SLT>(SLTClass);
		pResult.GetValuePtr( pResData );
		assert( null != pResData );
		
//		--܂
		//
		if(TClass.equals(CqMatrix.class) && SLTClass.equals(CqMatrix.class)){
			//-----------------CqMatrix̏ꍇ-----------------------
			// Check if a valid 4 point quad, do nothing if not.
			if ( m_aValues.size() == 4 )
			{
				// Note it is assumed that the variable has been
				// initialised to the correct size prior to calling.
				Float diu = 1.0f / u;
				Float div = 1.0f / v;
				int iv;
				int index = 0;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ )
					{
						
						((CqMatrix)res).assignment((CqMatrix)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , ArrayIndex )),
								(T)(pValue_get( 1 , ArrayIndex )),
								(T)(pValue_get( 2 , ArrayIndex )),
								(T)(pValue_get( 3 , ArrayIndex )),
								iu * diu, iv * div,TClass ));
						((CqMatrix)pResData.elementAt(index)).assignment((CqMatrix)res);
						index++;
						//( pResData++ ) = res;
					}
				}
			}
			else
			{
				int iv;
				int index = 0;
				((CqMatrix)res).assignment((CqMatrix)(pValue_get( 0 , ArrayIndex )));
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ ){
						((CqMatrix)pResData.elementAt(index)).assignment((CqMatrix)res);
						index++;
						//( pResData++ ) = res;
					}
				}
			}
		}else if(TClass.equals(CqColor.class) && SLTClass.equals(CqColor.class)){
			//-----------------CqColoȑꍇ-----------------------
			// Check if a valid 4 point quad, do nothing if not.
			if ( m_aValues.size() >= 4 )
			{
				// Note it is assumed that the variable has been
				// initialised to the correct size prior to calling.
				Float diu = 1.0f / u;
				Float div = 1.0f / v;
				int iv;
				int index = 0;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ )
					{
						
						((CqColor)res).assignment((CqColor)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , ArrayIndex )),
								(T)(pValue_get( 1 , ArrayIndex )),
								(T)(pValue_get( 2 , ArrayIndex )),
								(T)(pValue_get( 3 , ArrayIndex )),
								iu * diu, iv * div,TClass ));
						((CqColor)pResData.elementAt(index)).assignment((CqColor)res);
						index++;
						//( pResData++ ) = res;
					}
				}
			}
			else
			{
				//pResdatãTCYl`FbNĂȂExceptionԉ\
				int iv;
				int index = 0;
				((CqColor)res).assignment((CqColor)(pValue_get( 0 , ArrayIndex )));
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ ){
						((CqColor)pResData.elementAt(index)).assignment((CqColor)res);
						index++;
						//( pResData++ ) = res;
					}
				}
			}
		}else if(TClass.equals(CqVector3D.class) && SLTClass.equals(CqVector3D.class)){
			//-----------------CqVector3D̏ꍇ-----------------------
			// Check if a valid 4 point quad, do nothing if not.
			if ( m_aValues.size() >= 4 )
			{
				// Note it is assumed that the variable has been
				// initialised to the correct size prior to calling.
				Float diu = 1.0f / u;
				Float div = 1.0f / v;
				int iv;
				int index = 0;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ )
					{
						
						((CqVector3D)res).assignment((CqVector3D)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , ArrayIndex )),
								(T)(pValue_get( 1 , ArrayIndex )),
								(T)(pValue_get( 2 , ArrayIndex )),
								(T)(pValue_get( 3 , ArrayIndex )),
								iu * diu, iv * div,TClass ));
						((CqVector3D)pResData.elementAt(index)).assignment((CqVector3D)res);
						index++;
						//( pResData++ ) = res;
					}
				}
			}
			else
			{
				//pResdatãTCYl`FbNĂȂExceptionԉ\
				int iv;
				int index = 0;
				((CqVector3D)res).assignment((CqVector3D)(pValue_get( 0 , ArrayIndex )));
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ ){
						((CqVector3D)pResData.elementAt(index)).assignment((CqVector3D)res);
						index++;
						//( pResData++ ) = res;
					}
				}
			}
		}else if(TClass.equals(p_float.class) && SLTClass.equals(p_float.class)){
			//-----------------p_float̏ꍇ-----------------------
			// Check if a valid 4 point quad, do nothing if not.
			if ( m_aValues.size() >= 4 )
			{
				// Note it is assumed that the variable has been
				// initialised to the correct size prior to calling.
				Float diu = 1.0f / u;
				Float div = 1.0f / v;
				int iv;
				int index = 0;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ )
					{
						
						((p_float)res).value = ((p_float)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , ArrayIndex )),
								(T)(pValue_get( 1 , ArrayIndex )),
								(T)(pValue_get( 2 , ArrayIndex )),
								(T)(pValue_get( 3 , ArrayIndex )),
								iu * diu, iv * div,TClass )).value;
						
						((p_float)pResData.elementAt(index)).value = ((p_float)res).value;
						index++;
						//( pResData++ ) = res;
					}
				}
			}
			else
			{
				//pResdatãTCYl`FbNĂȂExceptionԉ\
				int iv;
				int index = 0;
				((p_float)res).value = ((p_float)(pValue_get( 0 , ArrayIndex ))).value;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ ){
						((p_float)pResData.elementAt(index)).value = ((p_float)res).value;
						index++;
						//( pResData++ ) = res;
					}
				}
			}
		}else if(TClass.equals(p_int.class) && SLTClass.equals(p_float.class)){
			//-----------------p_int̏ꍇ-----------------------
			// Check if a valid 4 point quad, do nothing if not.
			if ( m_aValues.size() >= 4 )
			{
				// Note it is assumed that the variable has been
				// initialised to the correct size prior to calling.
				Float diu = 1.0f / u;
				Float div = 1.0f / v;
				int iv;
				int index = 0;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ )
					{
						
						((p_int)res).value = ((p_int)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , ArrayIndex )),
								(T)(pValue_get( 1 , ArrayIndex )),
								(T)(pValue_get( 2 , ArrayIndex )),
								(T)(pValue_get( 3 , ArrayIndex )),
								iu * diu, iv * div,TClass )).value;
						((p_float)pResData.elementAt(index)).value = ((p_int)res).value;
						index++;
						//( pResData++ ) = res;
					}
				}
			}
			else
			{
				//pResdatãTCYl`FbNĂȂExceptionԉ\
				int iv;
				int index = 0;
				((p_int)res).value = ((p_int)(pValue_get( 0 , ArrayIndex ))).value;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ ){
						((p_float)pResData.elementAt(index)).value = ((p_int)res).value;
						index++;
						//( pResData++ ) = res;
					}
				}
			}
		}else if(TClass.equals(CqVector4D.class) && SLTClass.equals(CqVector3D.class)){
			//-----------------CqVector4D̏ꍇ-----------------------
			// Check if a valid 4 point quad, do nothing if not.
			if ( m_aValues.size() >= 4 )
			{
				// Note it is assumed that the variable has been
				// initialised to the correct size prior to calling.
				Float diu = 1.0f / u;
				Float div = 1.0f / v;
				int iv;
				int index = 0;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ )
					{
						
						((CqVector4D)res).assignment((CqVector4D)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , ArrayIndex )),
								(T)(pValue_get( 1 , ArrayIndex )),
								(T)(pValue_get( 2 , ArrayIndex )),
								(T)(pValue_get( 3 , ArrayIndex )),
								iu * diu, iv * div,TClass ));
						((CqVector3D)pResData.elementAt(index)).assignment((CqVector4D)res);
						index++;
						//( pResData++ ) = res;
					}
				}
			}
			else
			{
				//pResdatãTCYl`FbNĂȂExceptionԉ\
				int iv;
				int index = 0;
				((CqVector4D)res).assignment((CqVector4D)(pValue_get( 0 , ArrayIndex )));
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ ){
						((CqVector3D)pResData.elementAt(index)).assignment((CqVector4D)res);
						index++;
						//( pResData++ ) = res;
					}
				}
			}
		}else if(TClass.equals(p_String.class) && SLTClass.equals(p_String.class)){
			//-----------------p_String̏ꍇ-----------------------
			// Check if a valid 4 point quad, do nothing if not.
			if ( m_aValues.size() >= 4 )
			{
				// Note it is assumed that the variable has been
				// initialised to the correct size prior to calling.
				Float diu = 1.0f / u;
				Float div = 1.0f / v;
				int iv;
				int index = 0;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ )
					{
						
						((p_String)res).value = ((p_String)RiGlobal.BilinearEvaluate( (T)(pValue_get( 0 , ArrayIndex )),
								(T)(pValue_get( 1 , ArrayIndex )),
								(T)(pValue_get( 2 , ArrayIndex )),
								(T)(pValue_get( 3 , ArrayIndex )),
								iu * diu, iv * div,TClass )).value;
						
						((p_String)pResData.elementAt(index)).value = ((p_String)res).value;
						index++;
						//( pResData++ ) = res;
					}
				}
			}
			else
			{
				//pResdatãTCYl`FbNĂȂExceptionԉ\
				int iv;
				int index = 0;
				((p_String)res).value = ((p_String)(pValue_get( 0 , ArrayIndex ))).value;
				for ( iv = 0; iv <= v; iv++ )
				{
					int iu;
					for ( iu = 0; iu <= u; iu++ ){
						((p_String)pResData.elementAt(index)).value = ((p_String)res).value;
						index++;
						//( pResData++ ) = res;
					}
				}
			}
		}
		
	}
	/**
	 * 
	 * Ŏw肵CX^XVectorAw肵l
	 * gVector̎w肵ʒuɃRs[s
	 * w肳ꂽSTLVector̒g͑SăRs[B
	 * ̂߁ApFromƎgCount()̒l͈vȂ΂Ȃ炸
	 * 
	 * 
	 * @param pFrom Rs[CX^X
	 * @param idxTarget Rs[̔zԍB
	 * @param idxSource Rs[̔zԍ
	 */
	public 	void SetValue( CqParameter pFrom, int idxTarget, int idxSource )
	{
		assert( pFrom.Type().getValue() == Type().getValue() );
		assert( pFrom.Count() == Count() );
		
		CqParameterTyped<T, SLT> pFromTyped = (CqParameterTyped<T, SLT>)( pFrom );
		int index;
		Object[] pTargetValues = pValue( idxTarget );
		Object[] pSourceValues = pFromTyped.pValue( idxSource );
		if(TClass.equals(CqMatrix.class)){
			for( index = 0; index < this.Count(); index++ )
				((CqMatrix)pTargetValues[ index ]).assignment((CqMatrix)pSourceValues[ index ]);
		}else if(TClass.equals(CqVector3D.class)){
			for( index = 0; index < this.Count(); index++ )
				((CqVector3D)pTargetValues[ index ]).assignment((CqVector3D)pSourceValues[ index ]);
		}else if(TClass.equals(CqVector4D.class)){
			for( index = 0; index < this.Count(); index++ )
				((CqVector4D)pTargetValues[ index ]).assignment((CqVector4D)pSourceValues[ index ]);
		}else if(TClass.equals(CqColor.class)){
			for( index = 0; index < this.Count(); index++ )
				((CqColor)pTargetValues[ index ]).assignment((CqColor)pSourceValues[ index ]);
		}else if(TClass.equals(p_int.class)){
			for( index = 0; index < this.Count(); index++ )
				((p_int)pTargetValues[ index ]).value = ((p_int)pSourceValues[ index ]).value;
		}else if(TClass.equals(p_float.class)){
			for( index = 0; index < this.Count(); index++ )
				((p_float)pTargetValues[ index ]).value = ((p_float)pSourceValues[ index ]).value;
		}else if(TClass.equals(p_String.class)){
			for( index = 0; index < this.Count(); index++ )
				((p_String)pTargetValues[ index ]).value = ((p_String)pSourceValues[ index ]).value;
		}
	}
	
	/**
	 * u=vZq̃I[o[[h
	 * xN^̒lRs[
	 * 
	 * @param From
	 */
    public CqParameterTypedVaryingArray<T,SLT> assignment( final CqParameterTypedVaryingArray<T, SLT> From )
    {
        //m_aValues.resize( From.m_aValues.size(), new STLVector<T>(From.Count(),TClass) );
		resizeSTLVector(From.m_aValues.size(),From.Count());
		
    	this.m_Count = From.m_Count;
        int j;
        if(TClass.equals(CqMatrix.class)){
            for ( j = 0; j < m_aValues.size(); j++ )
            {
                int i;
                for ( i = 0; i <  this.m_Count; i++ )
                    ((CqMatrix)m_aValues.elementAt(j).elementAt(i)).assignment((CqMatrix)From.m_aValues.elementAt(j).elementAt(i));
            }
        }else if(TClass.equals(CqVector3D.class)){
            for ( j = 0; j < m_aValues.size(); j++ )
            {
                int i;
                for ( i = 0; i <  this.m_Count; i++ )
                    ((CqVector3D)m_aValues.elementAt(j).elementAt(i)).assignment((CqVector3D)From.m_aValues.elementAt(j).elementAt(i));
            }
        }else if(TClass.equals(CqVector4D.class)){
            for ( j = 0; j < m_aValues.size(); j++ )
            {
                int i;
                for ( i = 0; i <  this.m_Count; i++ )
                    ((CqVector4D)m_aValues.elementAt(j).elementAt(i)).assignment((CqVector4D)From.m_aValues.elementAt(j).elementAt(i));
            }
        }else if(TClass.equals(CqColor.class)){
            for ( j = 0; j < m_aValues.size(); j++ )
            {
                int i;
                for ( i = 0; i <  this.m_Count; i++ )
                    ((CqColor)m_aValues.elementAt(j).elementAt(i)).assignment((CqColor)From.m_aValues.elementAt(j).elementAt(i));
            }
        }else if(TClass.equals(p_int.class)){
            for ( j = 0; j < m_aValues.size(); j++ )
            {
                int i;
                for ( i = 0; i <  this.m_Count; i++ )
                    ((p_int)m_aValues.elementAt(j).elementAt(i)).value = ((p_int)From.m_aValues.elementAt(j).elementAt(i)).value;
            }
        }else if(TClass.equals(p_float.class)){
            for ( j = 0; j < m_aValues.size(); j++ )
            {
                int i;
                for ( i = 0; i <  this.m_Count; i++ )
                    ((p_float)m_aValues.elementAt(j).elementAt(i)).value = ((p_float)From.m_aValues.elementAt(j).elementAt(i)).value;
            }
        }else if(TClass.equals(p_String.class)){
            for ( j = 0; j < m_aValues.size(); j++ )
            {
                int i;
                for ( i = 0; i <  this.m_Count; i++ )
                    ((p_String)m_aValues.elementAt(j).elementAt(i)).value = ((p_String)From.m_aValues.elementAt(j).elementAt(i)).value;
            }
        }

        return ( this );
    }
    
    /** Static constructor, to allow type free parameter construction.
     * \param strName Character pointer to new parameter name.
     * \param Count Integer array size.
     */
    /**
	 * static RXgN^
	 * RXgN^Ɠlɗpł
	 */
    public static	<T,SLT>	CqParameter	Create( final String strName, int Count,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass)
    {
        return ( new CqParameterTypedVaryingArray<T, SLT>( strName, Count ,I,TClass,SLTClass) );
    }
    /**
	 * static RXgN^(countȗn)
	 * RXgN^Ɠlɗpł
	 */
    public static	<T,SLT>	CqParameter	Create( final String strName,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass)
    {
        return ( new CqParameterTypedVaryingArray<T, SLT>( strName, 1 ,I,TClass,SLTClass) );
    }
}
