// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLArray;
import net.cellcomputing.himawari.accessory.STLArrayList;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;

/**
 * l̃^CvƁAid̃^CvŃev[gꂽÃp[^^CvB
 * @author NTT DATA Corporation
 */
public strictfp class CqParameterTypedUniform <T,SLT>extends CqParameterTyped<T,SLT> {
	
	 //private STLVector<T>		m_aValues;
	 private STLArray<T>		m_aValues;
	 private EqVariableType 	I;			//C++łGenericsƂĎw肳Ăl
	
	 /**
	  * RXgN^
	  * @param str O
	  * @param count TCY
	  * @param I Generics I
	  * @param TClass Generics TClass
	  * @param SLTClass Generics SLTClass
	  */
	 public CqParameterTypedUniform(final String str,int count,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass){
		 super(str,count,TClass,SLTClass);
		 
		 //m_aValues = new STLVector<T>(TClass);
		 m_aValues = new STLArray<T>(TClass);
		 m_aValues.setSize(1);
		 this.I = I;
	 }
	 
	 /**
	  * Rs[RXgN^
	  * @param From Rs[
	  * @param I Generics I
	  */
	 public CqParameterTypedUniform(CqParameterTypedUniform<T,SLT> From,EqVariableType I){
		 super(From);
//		m_aValues = new STLVector<T>(TClass);
		 m_aValues = new STLArray<T>(TClass);
		 m_aValues.setSize(1);
		 this.I = I;
		 
		 this.assignment(From);
	 }
	 
	 /**
	  * RXgN^
	  * CountȗĂ
	  * 
	  * @param name O
	  * @param I Genrics I
	  * @param TClass Generics SClass
	  */
	 public CqParameterTypedUniform(final String name,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass){
		 this(name,1,I,TClass,SLTClass);
	 }
	 
	/**
	 * fXgN^
	 */
	public void destruct(){
		super.destruct();
	}
		
	/**
	 * ̎Vector̒lzƂđSĕԂB
	 * 
	 */
	public Object[] pValue() {
		assert( 0 < m_aValues.size() );
		
		return m_aValues.toArray();
	}
	
	/**
	 * CR[Zq
	 * Vector̒lSĎgVectorɃRs[
	 * 
	 * @param From CX^X
	 * @return g
	 */
	public  CqParameterTypedUniform<T,SLT> assignment(CqParameterTypedUniform<T,SLT> From){
		int size = From.m_aValues.size();
		
        m_aValues.resize( size );

        T t =m_aValues.elementAt(0);
        if(t instanceof CqVector3D){
            for ( int j = 0; j <  size; j++ )
            {
                ((CqVector3D)m_aValues.elementAt(j)).assignment((CqVector3D)(From.m_aValues.get(j)));
            }
        	
        }else if(t instanceof CqVector4D){
            for ( int j = 0; j <  size; j++ )
            {
                ((CqVector4D)m_aValues.elementAt(j)).assignment((CqVector4D)(From.m_aValues.get(j)));
            }
        	
        }else if(t instanceof CqColor){
            for ( int j = 0; j <  size; j++ )
            {
                ((CqColor)m_aValues.elementAt(j)).assignment((CqColor)(From.m_aValues.get(j)));
            }
        	
        }else if(t instanceof CqMatrix){
            for ( int j = 0; j <  size; j++ )
            {
                ((CqMatrix)m_aValues.elementAt(j)).assignment((CqMatrix)(From.m_aValues.get(j)));
            }
        	
        }else if(t instanceof p_float){
            for ( int j = 0; j <  size; j++ )
            {
                ((p_float)m_aValues.elementAt(j)).value = ((p_float)(From.m_aValues.get(j))).value;
            }
        	
        }else if(t instanceof p_int){
            for ( int j = 0; j <  size; j++ )
            {
                ((p_int)m_aValues.elementAt(j)).value = ((p_int)(From.m_aValues.get(j))).value;
            }
        	
        }else if(t instanceof p_String){
            for ( int j = 0; j <  size; j++ )
            {
                ((p_String)m_aValues.elementAt(j)).value = ((p_String)(From.m_aValues.get(j))).value;
            }
        	
        }

        return ( this );
	}
	/**
	 * ̎Vectorɑ΂āAw肳ꂽʒuȍ~̒l
	 * zƂĕԋpB
	 * 
	 * ԋplZbgȂƂVector̎lωB
	 * 
	 * @param Index Vector̒l̊Jnʒu
	 * @exception Vector̃TCY傫lw肷NegativeArraySizeException
	 */
//	nttdata 
//	public Object[] pValue(int Index) {
//		assert( Index < m_aValues.size() );//ύX {Ƃ̃oOƎv 0< m_aValues.size()
//		Object[] retval = new Object[m_aValues.size()-Index];
//		
//		//retvalɌ݂Vector̒gRs[Ă
//		for(int i=0;i< m_aValues.size() -Index;i++){
//			retval[i] = m_aValues.elementAt(Index + i);
//		}
//		return retval;
//	}
	public Object[] pValue(final int Index) {
		assert( Index < m_aValues.size()  );
			//@STLVecterɂύXĂB
		return m_aValues.toArray(Index);
		}
	
	public T pValue_get(final int Index ,final int arrayIndex)
	{
		return m_aValues.elementAt(Index+arrayIndex);
	}
//	nttdata  I
	/**
	 * Type̓N[𐶐ĕԂ
	 * 
	 * @param Name O
	 * @param Count JEg
	 * @return VCqParameter
	 */
	public CqParameter CloneType(final String Name, int Count) {
		return ( new CqParameterTypedUniform<T,SLT>( Name, Count,I,TClass,SLTClass ) );
	}

	/**
	 * gƓlCX^X𐶐B
	 */
	public CqParameter Clone() {
		return ( new CqParameterTypedUniform<T,SLT>( this , I ) );
	}

	/**
	 * EqVariableClassԂ
	 *
	 * @return EqVariableClass
	 */
	public EqVariableClass Class() {
		return ( new EqVariableClass(EqVariableClass.class_uniform) );
	}

	/**
	 * ̂EqVariableTypeԂ
	 * (C++łGenericsŗpĂ)
	 * @return EqVariableType
	 */
	public EqVariableType Type() {
		return I;
	}

	/**
	 * Vector̃TCYw̑傫ɕύX
	 * @param size ύXTCY
	 */
	public void SetSize(int size) {
		m_aValues.setSize(size);
	}

	/**
	 * ̎Vector̃TCYԋp	
	 * @return ݂Vector̃TCY
	 */
	public int Size() {
		return m_aValues.size();
	}

	/** 
	 * Vector̒gSăNA
	 */
	public void Clear() {
		m_aValues.clear();
	}

	/**
	 * w肳ꂽɑ΂SubdividesB
	 * TypeClass`FbNāAł
	 * gɑ(assignment)B<br>
	 * (eNX̐)<br>
	 * u ̒̕lAɕB̒lw̕ϐŕB
	 * 
	 * @param pResult1 
	 * @param pResult2 
	 * @param u pȂ
	 * @param pSurface pȂ
	 */
	public void Subdivide(CqParameter pResult1, CqParameter pResult2, boolean u,
			IqSurface pSurface) {
		
        assert( pResult1.Type().getValue() == Type().getValue() && pResult2.Type().getValue() == Type().getValue() &&
                pResult1.Class().getValue() == Class().getValue() && pResult2.Class().getValue() == Class().getValue() );

        CqParameterTypedUniform<T,SLT> pTResult1 = (CqParameterTypedUniform<T,SLT>)( pResult1 );
        CqParameterTypedUniform<T,SLT> pTResult2 = (CqParameterTypedUniform<T,SLT>)( pResult2 );
        pTResult1.assignment(pTResult2.assignment( this ));
	}
	/**
	 * IqShaderDataɒl<br>
	 * (eNXł̐)<br>
	 * z̒P̗vfl̃NX̓K؂ȕ⊮păObhɐ؂o(Dice)
	 * @param u
	 * @param v
	 * @param pResult 
	 * @param pSurface gpȂ
	 */
	public void Dice(int u, int v, IqShaderData pResult, IqSurface pSurface) {
        // Just promote the uniform value to varying by duplication.
        //
		assert( pResult.Type().getValue() == Type().getValue() );
        // Note it is assumed that the variable has been
        // initialised to the correct size prior to calling.
        // Also note that the only time a Uniform value is diced is when it is on a single element, i.e. the patchmesh
        // has been split into isngle patches, or the polymesh has been split into polys.
        int i;
        long max = Math.max( (long)(u * v), pResult.Size() );
        
        T tmp = m_aValues.elementAt(0);
        //Genericsɓ^ɂďꍇ킯s
        if(tmp instanceof CqMatrix){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( (CqMatrix)m_aValues.elementAt(0), i );
            }
        }else if(tmp instanceof CqVector3D){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( (CqVector3D)m_aValues.elementAt(0), i );
            }
        }else if(tmp instanceof CqVector4D){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( new CqVector3D(((CqVector4D)(m_aValues.elementAt(0)))), i );
            }
        }else if(tmp instanceof CqColor){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( (CqColor)m_aValues.elementAt(0), i );
            }
        }else if(tmp instanceof p_float){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( ((p_float)m_aValues.elementAt(0)).value, i );
            }
        }else if(tmp instanceof p_int){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( ((p_int)m_aValues.elementAt(0)).value, i );
            }
        }else if(tmp instanceof p_String){
            for ( i = 0; i < max; i++ ){
                pResult.SetValue( ((p_String)m_aValues.elementAt(0)).value, i );
            }
        }
	}
	
	/**
	 * Ɏs郁\bh
	 */
	public void DiceOne(int u, int v, IqShaderData pResult, IqSurface pSurface,
			int ArrayIndex) {
        assert( false );
        return;

	}
	
	/**
	 * CqParameterTypedŒ`Ă
	 * Ŏw肵CX^XVectorAw肵l
	 * gVector̎w肵ʒuɃRs[s
	 * 
	 * @param pFrom Rs[CX^X
	 * @param idxTarget Rs[̔zԍB
	 * @param idxSource Rs[̔zԍ
	 */
	public void SetValue(CqParameter pFrom, int idxTarget, int idxSource){
		assert( pFrom.Type().getValue() == Type().getValue() );
		
        CqParameterTyped<T, SLT> pFromTyped = (CqParameterTyped<T, SLT>)( pFrom );
        T tmp = (T)pValue_get( idxTarget , 0 );//|C^Ȃ̂Œlo
        if(tmp instanceof CqMatrix){
        	((CqMatrix)tmp).assignment((CqMatrix)(pFromTyped.pValue_get( idxSource , 0 )));
        }else if(tmp instanceof CqVector3D){
        	((CqVector3D)tmp).assignment((CqVector3D)(pFromTyped.pValue_get( idxSource , 0 )));
        }else if(tmp instanceof CqVector4D){
        	((CqVector4D)tmp).assignment((CqVector4D)(pFromTyped.pValue_get( idxSource , 0 )));
        }else if(tmp instanceof CqColor){
        	((CqColor)tmp).assignment((CqColor)(pFromTyped.pValue_get( idxSource , 0 )));
        }else if(tmp instanceof p_float){
        	((p_float)tmp).value = ((p_float)(pFromTyped.pValue_get( idxSource , 0 ))).value;
        }else if(tmp instanceof p_int){
        	((p_int)tmp).value = ((p_int)(pFromTyped.pValue_get( idxSource , 0 ))).value;
        }else if(tmp instanceof p_String){
        	((p_String)tmp).value = ((p_String)(pFromTyped.pValue_get( idxSource , 0 ))).value;
        }
	}
	
	/**
	 * static RXgN^
	 * RXgN^Ɠlɗpł
	 * @param strName O
	 * @param Count JEg
	 * @param I Generics I
	 * @param myClass Generics TClass
	 */
     public static	<T,SLT> CqParameter	Create( final String strName, int Count,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass)
    {
        return ( new CqParameterTypedUniform<T,SLT>( strName, Count ,I,TClass,SLTClass) );
    }

     /**
 	 * static RXgN^
 	 * RXgN^Ɠlɗpł(countȗn)
	 * @param strName O
	 * @param I Generics I
	 * @param TClass Generics TClass
	 * @param SLTClass Generics SLTClass
 	 */
     public static	<T,SLT> CqParameter	Create( final String strName,EqVariableType I,Class<? extends T> TClass,Class<? extends SLT> SLTClass)
     {
    	 return CqParameterTypedUniform.<T,SLT>Create(strName,1,I,TClass,SLTClass);
     }

}
