// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.Vector;

/**
 * 
 * 
 *  Renderman option/attribute class, has a name and a number of parameter name/value pairs.
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqNamedParameterList {
	
	private String	m_strName;					///< The name of this parameter list.
	private STLVector<CqParameter> m_aParameters = new STLVector<CqParameter>(CqParameter.class);	///< A vector of name/value parameters.
	private long m_hash;
	
	
	//************************************************************************//
	//*** RXgN^̒`
	//************************************************************************//
	
	/**
	 * RXgN^
	 * @param strName	IvV
	 */
	public CqNamedParameterList( String strName )
	{
		m_strName = strName;
		m_hash = strName.hashCode();
	}
	
	/**
	 * Rs[RXgN^
	 * @param From	Rs[
	 */
	public CqNamedParameterList( final CqNamedParameterList From )
	{
		m_strName = From.m_strName;
		m_hash = From.m_hash;
		int i = From.m_aParameters.size();
		while ( i-- > 0 )
		{
			m_aParameters.add( From.m_aParameters.get(i).Clone() );
		}
	}
	
	/**
	 * fXgN^ 
	 */
	public void destruct()
	{
		for ( CqParameter i : m_aParameters ){
			i.destruct();
		}
	}
	
	//************************************************************************//
	//*** \bh̒`
	//************************************************************************//
	
	/** Get a refernece to the option name.
	 * IvV̎擾
	 * @return IvV
	 */
	public String strName() 
	{
		return ( m_strName );
	}
	
	/** Add a new name/value pair to this option/attribute.
	 * OƒlƂ̃yAip[^jǉB
	 * @param pParameter OƒlƂ̃yAłCqParameter
	 */
	public void AddParameter( CqParameter pParameter )
	{
		for( int i=0; i<m_aParameters.size(); i++ )
		{
			CqParameter pi = m_aParameters.get(i);
			
			if ( pi.hash() == pParameter.hash() )
			{
				pi.destruct();
				m_aParameters.set( i, pParameter );
				return ;
			}
		}
		// If not append it.
		m_aParameters.add( pParameter );
	}
	
	/**
	 * w薼̂𖼂Âꂽp[^ԂB
	 * @param strName p[^
	 * @return ΉCqParameterIuWFNgBΉ̂ȂꍇnullB
	 */
	public CqParameter pParameter(  final String strName ) 
	{
		long hash = strName.hashCode();
		//nttdata 
//		for( CqParameter i : m_aParameters )
//			if( i.hash() == hash )	return i;
		int size = m_aParameters.size();
		CqParameter tmp;
		for( int i = 0; i < size ;i++)
		{
			tmp = m_aParameters.get(i);
			if( tmp.hash() == hash )	return tmp;
		}
		
		return ( null );
	}
	
	/**
	 * 
	 * p[^̃nbVR[h擾
	 * 
	 * @return	p[^̃nbVR[h
	 */
	public long hash()
	{
		return m_hash;
	}
	
	
	
}
