// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.util.HimawariLogger;

import static net.cellcomputing.himawari.library.EqModeBlock.*;

/**
 * Abstract base class to handle the current context of the renderer,
 * stores information about the current scoping and previous contexts.
 * 
 * _[݂̌̔wi߂ɊNX𔲂āA
 * ݂̌̂ƑÕReLXgɊւۑ܂B
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqModeBlock {	
			
	    /**
	     * ftHgRXgN^
	     */
		public CqModeBlock(){}
		
		/**
		 * l^ꂽꍇ̃RXgN^<br>
		 * 
		 * @param pconParent ÕReLXg
	     */
		public CqModeBlock( final CqModeBlock pconParent)
		{
			m_pattrCurrent = null;
	        m_ptransCurrent = null;
	        m_pconParent = pconParent;
	        m_modetype.setValue(Outside);
		}
		
		/**
		 * l2^ꂽꍇ̃RXgN^
		 * 
		 * @param pconParent	 ÕReLXg
		 * @param modetype	[h^Cv
		 */
		public CqModeBlock( final CqModeBlock pconParent, int modetype )
		{
			m_pattrCurrent = null;
	        m_ptransCurrent = null;
	        m_pconParent = pconParent;
	        m_modetype.setValue(modetype);
		}
		
		/**
		 *@fXgN^B<br>
		 *@hNXŃI[o[ChB 
		 */
		public void destruct(){};

		//***********************************************************************************
		//*  Note: These inline functions are defined here to allow full definition of all
		//*		 required classes first.
		//*		̃CC@\́AKvȂNXSĂSɒ`邽߁Aŏɒ`ĂB
		//************************************************************************************
		
		/** 
		 * Create a new main context, and link it to the current one.<br>
		 * @CReLXgV쐬Ã݂ReLXgƃNB
		 * 
		 * @return	VReLXg	
		 */
		public CqModeBlock BeginMainModeBlock()
		{
		   return  new CqMainModeBlock( this );
		}

		/**
		 * Create a new frame context, and link it to the current one.<br>
		 * 	t[ReLXgV쐬Ã݂ReLXgƃNB
		 *  
		 * @return a pointer to the new context.<br>
		 */
	    public CqModeBlock	BeginFrameModeBlock()
	    {
	    	return new CqFrameModeBlock( this );
	    }
	    
	    /** 
	     * Create a new world context, and link it to the current one.<br>
	     * 	[hReLXgV쐬Ã݂ReLXgƃNB
	     * 
	     * @return VReLXgB
	     * 
	     */
	    public CqModeBlock	BeginWorldModeBlock()
	    {
	        return new CqWorldModeBlock( this );
	    }
	    
	    /**
	     *  Create a new attribute context, and link it to the current one.<br>
	     * 	Agr[gReLXgV쐬Ã݂ReLXgƃNB
	     * 
	     * @return VReLXgB
	     */
	    public CqModeBlock	BeginAttributeModeBlock()
	    {
	    	return new CqAttributeModeBlock( this );
	    }

	    /**
	     * Create a new transform context, and link it to the current one.<br>
	     * 	gXtH[ReLXgV쐬Ã݂ReLXgƃNB
	     * 
	     * @return VReLXgB
	     */
	    public CqModeBlock	BeginTransformModeBlock()
	    {
	    	return new CqTransformModeBlock( this );
	    }
	    
	    /**
	     *  Create a new solid context, and link it to the current one.<br>
	     * 	\bhReLXgV쐬Ã݂ReLXgƃNB
	     * 
	     * @param	type
	     * @return	VReLXgB 
	     */
	    public CqModeBlock	BeginSolidModeBlock( String type )
	    {
	    	return new CqSolidModeBlock( type, this );
	    }
	    
	    
	    /** 
	     * Create a new object context, and link it to the current one.<br>
	     * 	IuWFNgReLXgV쐬Ã݂ReLXgƃNB
	     * 	
	     * @return VReLXgB
	     */
	    public CqModeBlock	BeginObjectModeBlock()
	    {
	    	return new CqObjectModeBlock( this );
	    }

	    /**
	     * Create a new motion context, and link it to the current one.<br>
	     * 	V[ṼReLXg쐬AČ݂̃ReLXgƃNB
	     * 
	     * @param	N
	     * @param	times[]
	     * @return	VReLXgB
	     */
	    public CqModeBlock	BeginMotionModeBlock( int N, float times[] )
	    {
	    	return new CqMotionModeBlock( N, times, this );
	    }

	    /** 
	     * Delete the main context, overridable per derived class.<br>
	     * 	C̃ReLXgB hNXŃI[oChB
	     * 
	     * @warning ̃NXxł̃\bhĂ΂ꂽꍇAOG[óB
	     */
	    public void	EndMainModeBlock()
	    {
	        logInvalidNesting();
	    }
	    /** 
	     * Delete the frame context, overridable per derived class.<br>
	     * 	t[̃ReLXgB hNXŃI[oChB
	     * 
	     * @warning ̃NXxł̃\bhĂ΂ꂽꍇAOG[óB
	     */
	    
	    public	void	EndFrameModeBlock()
	    {
	        logInvalidNesting();
	    }
	    
	    /** 
	     * Delete the world context, overridable per derived class.<br>
	     * 	[h̃ReLXgB@hNXŃI[oChB
	     * 
	     * @warning ̃NXxł̃\bhĂ΂ꂽꍇAOG[óB
	     */
	    public	void	EndWorldModeBlock()
	    {
	        logInvalidNesting();
	    }
	    
	    /** 
	     * Delete the Attribute context, overridable per derived class.<br>
	     * 	Agr[g̃ReLXgB@hNXŃI[oChB
	     * 
	     * @warning ̃NXxł̃\bhĂ΂ꂽꍇAOG[óB
	     */
	    public	void	EndAttributeModeBlock()
	    {
	        logInvalidNesting();
	    }
	    
	    /** 
	     * Delete the Transform context, overridable per derived class.<br>
	     * 	gXtH[̃ReLXgB@hNXŃI[oChB
	     * 
	     * @warning ̃NXxł̃\bhĂ΂ꂽꍇAOG[óB
	     */
	    public	void	EndTransformModeBlock()
	    {
	        logInvalidNesting();
	    }
	    
	    /**
	     * Delete the SolidMode context, overridable per derived class.<br>
	     * 	\bhf̃ReLXgB@hNXŃI[oChB
	     * 
	     * @warning ̃NXxł̃\bhĂ΂ꂽꍇAOG[óB
	     */
	    public	void	EndSolidModeBlock()
	    {
	        logInvalidNesting();
	    }
	    
	    /** 
	     * Delete the ObjectMode context, overridable per derived class.<br>
	     * 	IuWFNgf̃ReLXgB@hNXŃI[oChB
	     * 
	     * @warning ̃NXxł̃\bhĂ΂ꂽꍇAOG[óB
	     */
	    public	void	EndObjectModeBlock()
	    {
	        logInvalidNesting();
	    }
	    
	    /** 
	     * Delete the MotionMode context, overridable per derived class.<br>
	     * 	[V[h̃ReLXgB@hNXŃI[oChB
	     * 
	     * @warning ̃NXxł̃\bhĂ΂ꂽꍇAOG[óB
	     */
	    public	void	EndMotionModeBlock()
	    {
	        logInvalidNesting();
	    }

	    /**
	     * KpăI[oCh邱ƁB<br>
	     * ModeBlock̂CX^X邽߁Aabstruct邱ƂłȂB
	     */
	    public	CqOptions optCurrent(){
	    	return null;
	    }
	    
	    /**
	     * Get a read only pointer to the current attributes.<br>
	     * ݂̃Agr[g̃Qb^B
	     * 
	     * @return	m_pattrCurrent	݂̃Agr[g
	     */
	    public CqAttributes pattrCurrent()
	    {	
	        return ( m_pattrCurrent );
	    }
	    
	    /** 
	     * Set the current set of attributes<br>
	     * ݂̃Agr[g̃Zb^B
	     * 
	     * @param	newattrs	ZbgAgr[g
	     * @return prev@ÂAgr[g
	     */
	    public final CqAttributes pattrCurrent(CqAttributes newattrs)
	    {
	        CqAttributes prev = m_pattrCurrent;
	        m_pattrCurrent = newattrs;
	        return ( prev );
	    }
	    
	    /** 
	     * Get a pointer to the current attributes suitable for writing.<br>
	     * ݂̏ރAgr[g̃Qb^B
	     * 
	     * @return 	m_pattrCurrent	݂̃Agr[g
	     */
	    public	CqAttributes pattrWriteCurrent()
	    {
	        m_pattrCurrent = m_pattrCurrent.Write();
	        return ( m_pattrCurrent );
	    }
	    
	    /** 
	     * Get a read only pointer to the current transform.<br>
	     * ݂̃gXtH[mQb^B
	     * @return	 m_ptransCurrent	݂̃gXtH[
	     */
	    public	CqTransform	ptransCurrent()
	    {
	        return ( m_ptransCurrent );
	    }
	    
	    /**
	     * Set the current transform.<br>
	     * 	݂̃gXtH[̃Zb^B
	     * 
	     * @param
	     * @return 	prev	ÂgXtH[
	     */
	    public	CqTransform ptransSetCurrent(final CqTransform NewTrans)
	    {
	        CqTransform prev = m_ptransCurrent;
	        m_ptransCurrent = NewTrans;
	        return ( prev );
	    }
	    
	    
	    /** 
	     * Get the current time, used only within Motion blocks, all other contexts return 0.<br>
	     * 	݂̎Ԃ擾B ݗp̃[VubNł̂ݎgpB<br>
	     * 	̑SẴReLXgł0ԂB
	     * 
	     * @return 0.0f	t[Ƃ݂̌̎ԂԂB
	     * 
	     */
	    public	float	Time()
	    {
	        return ( 0.0f );
	    }
	    
	    /**
	     * Advance the current frame time to the next specified time.<br>
	     *@	݂̃t[Ԃw肳ꂽ̎Ԃi߂ĂB
	     */
	    public	void	AdvanceTime(){}
	    
	    
	    /**
	     *  Get the current frame index if in a motion block.<br>
	     * 	݂̃t[CfbNX擾B
	     */
	    public	int	TimeIndex()
	    {
			return( 0 );
		}
	    
	    /**
	     * Is this a motion block, should be overridden per derived class.<br>
	     * 	݃[VubN̒ɂ邩ǂ𔻒B<br>
	     * 	hNXSĂɃI[o[ChB
	     * 
	     * @return false	[VubN̓ or@O̔B
	     */
	    public	boolean	fMotionBlock()
	    {
	        return ( false );
	    }

	    /** 
	     * Get a pointer to the previuos context.<br>
	     * ÕReLXg̃Qb^B
	     * 
	     * @return	m_pconParent	ReLXg
	     */
	    public CqModeBlock pconParent()
	    {
	        return ( m_pconParent );
	    }

	    /** 
	     * Get the type.<br>
	     * [h^CṽQb^B
	     * 
	     * @return m_ModeType	[h^Cv
	     */
	    public EqModeBlock Type()
	    {
	        return ( m_modetype );
	    }
	    
	    
	    /**
	     * Get a reference to the current transformation matrix, <br>
	     *	the result of combining all transformations up to this point.<br>
	     * 	݂́AgXtH[}gbNX擾B<br>
	     * 	̃\bhĂяo鎞ɂ́AׂĂ̕ωʂłĂB
	     * 
	     * @param time
	     * @return	}gbNX
	     */
	    public CqMatrix	matCurrent( float time )
	    {
	        return ( ptransCurrent().matObjectToWorld( time ) );
	    }

	    /**
	     * Cg\[XX^bNɒǉ<br>
	     * CqWorldModeBlockNX(h)ɂ̂݁AI[o[ChB
	     * 
	     * @param pLS Cg\[X
	     */
	    public	void	AddContextLightSource( final CqLightsource pLS )
	    {
	        if ( pconParent() != null)
	            pconParent().AddContextLightSource( pLS );
	    }

	    /**
	     * ReLXg\bhǂ𔻒B<br>
	     * CqSolidModeBlockNX(h)ɂ̂݁AI[o[ChB
	     * 
	     * @return	true / false 
	     */
	    public	boolean	isSolid()
	    {
	        return ( ( pconParent() != null) ? pconParent().isSolid() : false );
	    }
	    
	    /** 
	     * Get a pointer to the CSG tree node related to this context.<br>
	     * ݂̃ReLXgɊ֘ACSG؂̃m[h擾B<br>
	     * CqSolidModeBlockNX(h)ɂ̂݁AI[o[ChB
	     * 
	     * @return IvVQ
	     */
	    public CqCSGTreeNode pCSGNode()
	    {
	    	return ( ( pconParent()!= null ) ? pconParent().pCSGNode() : null );
	    }

	    /** 
	     * G[O\
	     */
	    public void logInvalidNesting()
	    { 
	    	logger.critical( "Invalid context nesting" );
	    }
	    
	    public CqAttributes m_pattrCurrent ;	//@ݎĂAgr[g	The current attributes.
	    public CqTransform 	m_ptransCurrent ;	// ݎĂϊ	The current transformation
	    
	    private CqModeBlock	m_pconParent;		//@ÕReLXg	The previous context.
	    private EqModeBlock	m_modetype = new EqModeBlock();	//The current type of motionblock in order to double check the delete				
	    private HimawariLogger logger = HimawariLogger.getLogger();

}
