// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.display;

import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.UserParameter;
import net.cellcomputing.himawari.library.types.CqMatrix;

/**
 * 
 * ddmanagerpbP[W̃O[ö
 * 
 * @author NTT DATA Corporation
 */
public strictfp class GrobalDDManager {

	public static void ConstructMatrixParameter(final String name, final CqMatrix[] mats, int count, UserParameter parameter)
	{
		// Allocate and fill in the name.
//		char* pname = reinterpret_cast<char*>(malloc(strlen(name)+1));
//		strcpy(pname, name);
//		parameter.name = pname;
		parameter.name = name;

//		// Allocate a 16 element float array.
//		int totallen = 16 * count * Float.SIZE;
//		float[] pfloats = new float[16 * count];
//		int i;
//		for( i=0; i<count; i++)
//		{
//			float[] floats = mats[i].pElements();
//			int m;
//			for(m=0; m<16; m++)
//				pfloats[(i*16)+m]=floats[m];
//		}
//		parameter.value = pfloats;
//		parameter.vtype = 'f';
//		parameter.vcount = count * 16;
//		parameter.nbytes = totallen;
//		
//		//𒼂float[]ƂĊi[Ă邪ACqMatrixƂĊi[Ă悢ȂBisawa
	}


	public static void ConstructFloatsParameter(final String name, final p_float[] floats, int count, UserParameter parameter)
	{
		// Allocate and fill in the name.
//		char* pname = reinterpret_cast<char*>(malloc(strlen(name)+1));
//		strcpy(pname, name);
//		parameter.name = pname;
		parameter.name = name;
		
		// Allocate a float array.
		int totallen = count * Float.SIZE;
		float[] pfloats = new float[count];
		
		// Then just copy the whole lot in one go.
//		memcpy(pfloats, floats, totallen);
		//2007/05/10 watanabei floatp_floatɕύX
		for(int i=0; i < count ; i++)
			pfloats[i] = floats[i].value;
//		pfloats = floats.clone(); //폜 2007/05/10
		parameter.value = pfloats;
		parameter.vtype = 'f';
		parameter.vcount = count;
		parameter.nbytes = totallen;
	}


	public static void ConstructIntsParameter(final String name, final p_int[] ints, int count, UserParameter parameter)
	{
		// Allocate and fill in the name.
//		char* pname = reinterpret_cast<char*>(malloc(strlen(name)+1));
//		strcpy(pname, name);
//		parameter.name = pname;
		parameter.name = name;
		
		// Allocate a float array.
		int totallen = count * Integer.SIZE;
		int[] pints = new int[count]
		                      ;
		// Then just copy the whole lot in one go.
//		memcpy(pints, ints, totallen);
		//2007/05/10 watanabei intp_intɕύX
		for(int i=0; i < count ; i++)
			pints[i] = ints[i].value;
//		pints = ints.clone(); //폜 2007/05/10
		parameter.value = pints;
		parameter.vtype = 'i';
		parameter.vcount = count;
		parameter.nbytes = totallen;
	}


	public static void ConstructStringsParameter(final String name, final p_String[] strings, int count, UserParameter parameter)
	{
		// Allocate and fill in the name.
//		char* pname = reinterpret_cast<char*>(malloc(strlen(name)+1));
//		strcpy(pname, name);
//		parameter.name = pname;
		parameter.name = name;
		
		// Allocate enough space for the string pointers, and the strings, in one big block,
		// makes it easy to deallocate later.
//		TqInt totallen = count * sizeof(char*);
//		TqInt i;
//		for( i = 0; i < count; i++ )
//			totallen += (strlen(strings[i])+1) * sizeof(char);
//		char** pstringptrs = reinterpret_cast<char**>(malloc(totallen));
//		char* pstrings = reinterpret_cast<char*>(&pstringptrs[count]);
//		for( i = 0; i < count; i++ )
//		{
//			// Copy each string to the end of the block.
//			strcpy(pstrings, strings[i]);
//			pstringptrs[i] = pstrings;
//			pstrings += strlen(strings[i])+1;
//		}
		
		// Allocate enough space for the string pointers, and the strings, in one big block,
		// makes it easy to deallocate later.
		int totallen = count;
		int i;
		for( i = 0; i < count; i++ )
			totallen += strings[i].value.length() * Character.SIZE;
		
		String[] pstringptrs = new String[count];
		for( i = 0; i < count; i++ )
		{
			// Copy each string to the end of the block.
			pstringptrs[i] = strings[i].value;
		}
		
		parameter.value = pstringptrs;
		parameter.vtype = 's';
		parameter.vcount = count;
		parameter.nbytes = totallen;
	}

	
}
