/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.display;

import net.cellcomputing.himawari.library.types.CqFile;

/**
 * @author NTT DATA Corporation
 * Display߂ɑΉ钊ۃNX
 * RI߂Display̓eǗ
 * 
 */
public abstract strictfp class DisplayRequest {
	protected String name;
	protected String m_type;
	protected String m_mode;
	protected int modeID;
	protected int dataOffset;
	protected int dataSize;
	protected ImageData imageData;			//imageData
	
	public abstract void openRequest();
	public abstract void display();			//Viewɕ\s
	public abstract void closeRequest();		//Fileւ̏os
	
	protected int m_modeHash; 
	
	/**
	 * RXgN^
	 * @param name fBXvC
	 * @param type fBXvC^Cv(TIFF)
	 * @param mode fBXvC[h(RGB)
	 * @param modeID
	 * @param dataOffset
	 * @param dataSize
	 * @param imageData Ή摜f[^
	 */
	public DisplayRequest(String name, final String type,final String mode,
			int modeID, int dataOffset, int dataSize,ImageData imageData){
//		this.name = name;
		this.name = CqFile.FixupPathIfNeed(name);
		this.m_type = type;
		this.m_mode = mode;
		this.modeID = modeID;
		this.dataOffset = dataOffset;
		this.dataSize = dataSize;
		this.imageData = imageData;
		m_modeHash = mode.hashCode();
	}
}
