/* Simple argument-parsing class
 * Copyright (C) 2001 Patrick E. Pelletier <ppelleti@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.argparse;

import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.accessory.primitive.p_double;

/**
 * O[o\bh`NX
 * @author NTT DATA Corporation
 */
public strictfp class ArgParseGlobal {

	/**
	 * IvV̏ڍ׃p[^𕶎񂩂int^֕ϊALۂŊebZ[WԂB
	 * @param arg	ڍ׃p[^(String^)
	 * @param val	ڍ׃p[^(int^)
	 * @return	L : ""
	 * @return	 : "\"" + arg + "\" is not a valid integer"
	 */
	public static final String parseInt(String arg, p_int val)
	{	
		int newvalue; 
		
		try{
			newvalue = Integer.parseInt(arg);
		}catch(Exception e){
			//arg̒gA܂͐lɕϊłȂꍇ
			return new String("\"" + arg + "\" is not a valid integer");
		}
		
	    val.value = newvalue;
	    return "";
	}

	/**
	 * IvV̏ڍ׃p[^𕶎񂩂double^ϊALۂŊebZ[WԂB
	 * @param arg	ڍ׃p[^()
	 * @param val	ڍ׃p[^(double^)
	 * @return	L@F@""
	 * @return	@F@"\"" + arg + "\" is not a valid integer"
	 */
	public static String parseFloat(String arg, p_double val)
	{   
		double newvalue;
		
		try{
			 newvalue = Double.parseDouble(arg);
		}catch(Exception e){
			//arg̒gA܂͐lɕϊłȂꍇ
			return new String("\"" + arg + "\" is not a valid floating-point number");
		}
		
		val.value = newvalue;
		return "";
	}	
}
