/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import net.cellcomputing.himawari.util.HimawariLogFormatter;

public class HimawariLogger {
    public static final String LEVEL_DEBUG = "DEBUG";
    public static final String LEVEL_INFO = "INFO";
    public static final String LEVEL_WARNING = "WARNING";
    public static final String LEVEL_CRITICAL = "CRITICAL";
    public static final String LEVEL_ERROR = "ERROR";
    private static final String LOGGER_NAME = "net.cellcomputing.himawari";
    private Logger logger;
    private ConsoleHandler handler;
    private static HimawariLogger logInstance;
    private static final String LOG_FILE_NAME = "stacktrace.log";
    private static final DateFormat df;
    private final String REPEATED_MESSAGE = " Last message repeated ";
    private final String REPEATED_TIMES = " time";
    private final String DEFALUT_MESSAGE = "";
    private String lastMessage = "";
    private int count = 0;
    private Level lastLevel = Level.OFF;
    private Date date;
    private static File logFile;

    static {
        df = DateFormat.getDateTimeInstance(2, 2);
    }

    private HimawariLogger() {
        if (this.logger == null) {
            LogManager.getLogManager().reset();
            this.logger = Logger.getLogger(LOGGER_NAME);
            this.handler = new ConsoleHandler();
            this.handler.setFormatter(new HimawariLogFormatter());
            this.logger.addHandler(this.handler);
        }
    }

    public void setLogLevel(Level level) {
        this.logger.setLevel(level);
        this.handler.setLevel(level);
    }

    public void setLogLevel(String level) {
        if (level.equals(LEVEL_CRITICAL)) {
            this.logger.setLevel(Level.SEVERE);
            this.handler.setLevel(Level.SEVERE);
        } else if (level.equals(LEVEL_ERROR)) {
            this.logger.setLevel(Level.WARNING);
            this.handler.setLevel(Level.WARNING);
        } else if (level.equals(LEVEL_WARNING)) {
            this.logger.setLevel(Level.INFO);
            this.handler.setLevel(Level.INFO);
        } else if (level.equals(LEVEL_INFO)) {
            this.logger.setLevel(Level.CONFIG);
            this.handler.setLevel(Level.CONFIG);
        } else if (level.equals(LEVEL_DEBUG)) {
            this.logger.setLevel(Level.FINE);
            this.handler.setLevel(Level.FINE);
        }
    }

    public Level getLevel() {
        return this.logger.getLevel();
    }

    public static HimawariLogger getLogger() {
        if (logInstance == null) {
            logInstance = new HimawariLogger();
        }
        return logInstance;
    }

    private boolean checkRepeatedMessage(String str, Level level) {
        if (this.lastLevel.equals(level) && str.equals(this.lastMessage)) {
            ++this.count;
            return true;
        }
        this.flushLogger();
        this.lastMessage = str;
        this.count = 0;
        this.lastLevel = level;
        return false;
    }

    public void info(String str) {
        if (!this.checkRepeatedMessage(str, Level.CONFIG)) {
            this.logger.config(str);
        }
    }

    public void critical(String str) {
        if (!this.checkRepeatedMessage(str, Level.SEVERE)) {
            this.logger.severe(str);
        }
    }

    public void error(String str) {
        if (!this.checkRepeatedMessage(str, Level.WARNING)) {
            this.logger.warning(str);
        }
    }

    public void warning(String str) {
        if (!this.checkRepeatedMessage(str, Level.INFO)) {
            this.logger.info(str);
        }
    }

    public void debug(String str) {
        if (!this.checkRepeatedMessage(str, Level.FINE)) {
            this.logger.fine(str);
        }
    }

    public static void outputException(Exception e) {
        PrintWriter writer;
        if (logFile == null) {
            logFile = new File(LOG_FILE_NAME);
            logFile.delete();
        }
        try {
            writer = new PrintWriter(new FileWriter(logFile, true));
        }
        catch (IOException e1) {
            logInstance = HimawariLogger.getLogger();
            logInstance.error("log file open error. file is stacktrace.log\n");
            return;
        }
        StackTraceElement[] elements = e.getStackTrace();
        Date date = new Date();
        writer.println(String.valueOf(df.format(date)) + " Threw Exceptiln is...");
        writer.println(e);
        StackTraceElement[] stackTraceElementArray = elements;
        int n = 0;
        int n2 = stackTraceElementArray.length;
        while (n < n2) {
            StackTraceElement ele = stackTraceElementArray[n];
            writer.print("\tat ");
            writer.println(ele);
            ++n;
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            writer.print("Caused by: ");
            cause.printStackTrace(writer);
        }
        writer.close();
    }

    public void flushLogger() {
        if (this.count > 0) {
            this.date = new Date();
            StringBuffer mes = new StringBuffer();
            mes.append(df.format(this.date));
            mes.append(" Last message repeated ");
            mes.append(this.count);
            mes.append(" time");
            if (this.count > 1) {
                mes.append("s");
            }
            if (this.logger.isLoggable(this.lastLevel)) {
                System.err.println(mes.toString());
            }
            this.lastMessage = "";
            this.count = 0;
            this.lastLevel = Level.OFF;
        }
    }
}

