/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.cellcomputing.himawari.util.HimawariLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AccessSupplier {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Object getField(Object instance, String fieldName) {
        return AccessSupplier.getField(instance, fieldName, 0);
    }

    private static Object getField(Object instance, String fieldName, int rank) {
        Class<?> cls = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        try {
            int depth = rank;
            while (depth > 0) {
                cls = cls.getSuperclass();
                --depth;
            }
            Field field = cls.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (NoSuchFieldException ne) {
            if (cls.getSuperclass() != null) {
                return AccessSupplier.getField(instance, fieldName, rank + 1);
            }
            HimawariLogger.outputException(ne);
            return null;
        }
        catch (Exception e) {
            HimawariLogger.outputException(e);
            return null;
        }
    }

    public static void setField(Object instance, String fieldName, Object value) {
        AccessSupplier.setField(instance, fieldName, value, 0);
    }

    private static void setField(Object instance, String fieldName, Object value, int rank) {
        Class<?> cls = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        try {
            while (rank > 0) {
                cls = cls.getSuperclass();
                --rank;
            }
            Field field = cls.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(instance, value);
            return;
        }
        catch (NoSuchFieldException ne) {
            if (cls.getSuperclass() != null) {
                AccessSupplier.setField(instance, fieldName, value, rank + 1);
                return;
            }
            HimawariLogger.outputException(ne);
            return;
        }
        catch (Exception e) {
            HimawariLogger.outputException(e);
            return;
        }
    }

    public static Method getMethod(Object instance, String methodName, Class ... parameterTypes) {
        try {
            Class<?> cls = instance instanceof Class ? (Class<?>)instance : instance.getClass();
            int i = 0;
            while (i < parameterTypes.length) {
                Class tmpCls = parameterTypes[i];
                if (tmpCls.getSuperclass() == Number.class || tmpCls == Boolean.class) {
                    tmpCls = (Class)tmpCls.getField("TYPE").get(tmpCls);
                }
                parameterTypes[i] = tmpCls;
                ++i;
            }
            Method method = cls.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (Exception e) {
            HimawariLogger.outputException(e);
            return null;
        }
    }

    public static Object invokeMethod(Object instance, String methodName, Object ... args) {
        try {
            Class[] parameterTypes = new Class[args.length];
            int i = 0;
            while (i < parameterTypes.length) {
                parameterTypes[i] = args[i].getClass();
                ++i;
            }
            Method method = AccessSupplier.getMethod(instance, methodName, parameterTypes);
            Object ret = method.invoke(instance, args);
            return ret;
        }
        catch (Exception e) {
            HimawariLogger.outputException(e);
            return null;
        }
    }

    public static Constructor getConstructor(Class cls, Class ... parameterTypes) {
        try {
            Constructor constr = cls.getDeclaredConstructor(parameterTypes);
            constr.setAccessible(true);
            return constr;
        }
        catch (Exception e) {
            HimawariLogger.outputException(e);
            return null;
        }
    }

    public static <T> T getNewInstance(Class<T> cls, Object ... args) {
        try {
            Class[] argsClss = new Class[args.length];
            int i = 0;
            while (i < argsClss.length) {
                Class tmpCls = args[i].getClass();
                if (tmpCls.getSuperclass() == Number.class || tmpCls == Boolean.class) {
                    tmpCls = (Class)tmpCls.getField("TYPE").get(tmpCls);
                }
                argsClss[i] = tmpCls;
                ++i;
            }
            Constructor<T> cnst = cls.getConstructor(argsClss);
            return cnst.newInstance(args);
        }
        catch (Exception e) {
            HimawariLogger.outputException(e);
            return null;
        }
    }

    public static Class getInnerClass(Object instance, String clsname) {
        try {
            Class<?> cls = instance instanceof Class ? (Class<?>)instance : instance.getClass();
            Class<?>[] classes = cls.getDeclaredClasses();
            if (classes.length == 0) {
                return null;
            }
            Class<?>[] classArray = classes;
            int n = 0;
            int n2 = classArray.length;
            while (n < n2) {
                Class<?> decClass = classArray[n];
                if (decClass.getSimpleName().equals(clsname)) {
                    cls = decClass;
                }
                ++n;
            }
            return cls;
        }
        catch (Exception e) {
            HimawariLogger.outputException(e);
            return null;
        }
    }

    public static Object getInnerClassInstance(Object instance, String clsname) {
        try {
            Object ins;
            Class innerClass = AccessSupplier.getInnerClass(instance, clsname);
            if (innerClass == null) {
                return null;
            }
            if (Modifier.isStatic(innerClass.getModifiers())) {
                Constructor constr = AccessSupplier.getConstructor(innerClass, new Class[0]);
                ins = constr.newInstance(new Object[0]);
            } else {
                Constructor constr = AccessSupplier.getConstructor(innerClass, instance.getClass());
                ins = constr.newInstance(instance);
            }
            return ins;
        }
        catch (Exception e) {
            HimawariLogger.outputException(e);
            return null;
        }
    }
}

