/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.teqser;

import java.io.PrintStream;
import java.lang.reflect.Method;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_boolean;
import net.cellcomputing.himawari.accessory.primitive.p_double;
import net.cellcomputing.himawari.argparse.ArgParse;
import net.cellcomputing.himawari.library.RendermanInterface;
import net.cellcomputing.himawari.main.Himawari;
import net.cellcomputing.himawari.util.HimawariLogger;

public strictfp class TeqserMain {
    static p_boolean g_version = new p_boolean(false);
    static p_boolean g_help = new p_boolean(false);
    static p_boolean g_envcube = new p_boolean(false);
    static p_boolean g_envlatl = new p_boolean(false);
    static p_boolean g_shadow = new p_boolean(false);
    static p_String g_swrap = new p_String("black");
    static p_String g_twrap = new p_String("black");
    static p_String g_wrap = new p_String("");
    static p_String g_filter = new p_String("box");
    static p_String g_resize = new p_String("up");
    static p_double g_swidth = new p_double(1.0);
    static p_double g_twidth = new p_double(1.0);
    static p_double g_fov = new p_double(90.0);
    static p_double g_width = new p_double(-1.0);
    static p_String g_compress = new p_String("none");
    static p_double g_quality = new p_double(70.0);
    static p_double g_bake = new p_double(64.0);
    public static final String VERSION_STR = "1.0.0";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static void main(String[] args) {
        ArgParse ap = new ArgParse();
        Method filterfunc = null;
        ap.usageHeader("Usage: " + Himawari.class.getSimpleName() + " [options] outfile");
        ap.argFlag("help", "print this help and exit", g_help);
        ap.argFlag("version", "print version information and exit", g_version);
        ap.argString("compression", "=string[none|lzw|packbits|deflate]", g_compress);
        ap.argFlag("envcube", " px nx py ny pz nzproduce a cubeface environment map from 6 images.", g_envcube);
        ap.argFlag("envlatl", "produce a latlong environment map from an image file.", g_envlatl);
        ap.argFlag("shadow", "produce a shadow map from a z file.", g_shadow);
        ap.argString("swrap", "=strings wrap [black|periodic|clamp]", g_swrap);
        ap.argString("smode", "=string(equivalent to swrap for BMRT compatibility)", g_swrap);
        ap.argString("twrap", "=stringt wrap [black|periodic|clamp]", g_twrap);
        ap.argString("tmode", "=string(equivalent to twrap for BMRT compatibility)", g_swrap);
        ap.argString("wrap", "=stringwrap st [black|periodic|clamp]", g_wrap);
        ap.argString("mode", "=strings (equivalent to wrap for BMRT compatibility)", g_wrap);
        ap.argString("filter", "=string[box|bessel|catmull-rom|disk|gaussian|sinc|triangle]", g_filter);
        ap.argFloat("fov(envcube)", "=float[>=0.0f]", g_fov);
        ap.argFloat("swidth", "=floats width [>0.0f]", g_swidth);
        ap.argFloat("twidth", "=floatt width [>0.0f]", g_twidth);
        ap.argFloat("width", "=floatwidth [>0,0f] set both swidth and twidth", g_width);
        ap.argFloat("quality", "=float[>=1.0f &&  <= 100.0f]", g_quality);
        ap.argFloat("bake", "=float[>=2.0f && <= 2048.0f]", g_bake);
        ap.argString("resize", "=string[up|down|round|up-|down-|round-]\nNot used, for BMRT compatibility only!", g_resize);
        if (args.length > 0 && !ap.parse(args.length, args)) {
            System.err.print(String.valueOf(ap.errmsg()) + "\n");
            System.err.print(ap.usagemsg());
            System.exit(1);
        }
        if (TeqserMain.g_version.value) {
            TeqserMain.version(System.out);
            System.exit(0);
        }
        if (TeqserMain.g_help.value || ap.leftovers().size() <= 1) {
            System.out.print(ap.usagemsg());
            System.exit(0);
        }
        if (TeqserMain.g_envcube.value && TeqserMain.g_shadow.value) {
            System.out.println("Specify only one of envcube or shadow");
            System.exit(1);
        }
        try {
            filterfunc = RendermanInterface.class.getMethod("RiBoxFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            if (TeqserMain.g_filter.value.equals("box")) {
                filterfunc = RendermanInterface.class.getMethod("RiBoxFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            } else if (TeqserMain.g_filter.value.equals("sinc")) {
                filterfunc = RendermanInterface.class.getMethod("RiSincFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            } else if (TeqserMain.g_filter.value.equals("catmull-rom")) {
                filterfunc = RendermanInterface.class.getMethod("RiCatmullRomFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            } else if (TeqserMain.g_filter.value.equals("disk")) {
                filterfunc = RendermanInterface.class.getMethod("RiDiskFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            } else if (TeqserMain.g_filter.value.equals("bessel")) {
                filterfunc = RendermanInterface.class.getMethod("RiBesselFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            } else if (TeqserMain.g_filter.value.equals("triangle")) {
                filterfunc = RendermanInterface.class.getMethod("RiTriangleFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            } else if (TeqserMain.g_filter.value.equals("gaussian")) {
                filterfunc = RendermanInterface.class.getMethod("RiGaussianFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            }
        }
        catch (SecurityException e) {
            HimawariLogger.outputException(e);
            filterfunc = null;
        }
        catch (NoSuchMethodException e) {
            HimawariLogger.outputException(e);
            filterfunc = null;
        }
        if (TeqserMain.g_swidth.value < 1.0) {
            System.err.print("g_swidth is smaller than 1.0. 1.0 will be used instead.\n");
            TeqserMain.g_swidth.value = 1.0;
        }
        if (TeqserMain.g_twidth.value < 1.0) {
            System.err.print("g_twidth is smaller than 1.0. 1.0 will be used instead.\n");
            TeqserMain.g_twidth.value = 1.0;
        }
        if (!(TeqserMain.g_swrap.value.equals("black") || TeqserMain.g_swrap.value.equals("periodic") || TeqserMain.g_swrap.value.equals("clamp"))) {
            System.err.print("Unknown s wrap mode: " + TeqserMain.g_swrap.value + ". black will be used instead." + "\n");
            TeqserMain.g_swrap.value = "black";
        }
        if (!(TeqserMain.g_twrap.value.equals("black") || TeqserMain.g_twrap.value.equals("periodic") || TeqserMain.g_twrap.value.equals("clamp"))) {
            System.err.print("Unknown t wrap mode: " + TeqserMain.g_twrap.value + ". black will be used instead." + "\n");
            TeqserMain.g_twrap.value = "black";
        }
        if (!(TeqserMain.g_wrap.value.equals("") || TeqserMain.g_wrap.value.equals("black") || TeqserMain.g_wrap.value.equals("periodic") || TeqserMain.g_wrap.value.equals("clamp"))) {
            System.err.print("Unknown wrap mode: " + TeqserMain.g_wrap.value + ". black will be used instead." + "\n");
            TeqserMain.g_wrap.value = "black";
        }
        if (!TeqserMain.g_wrap.value.equals("")) {
            TeqserMain.g_twrap.value = TeqserMain.g_wrap.value;
            TeqserMain.g_swrap.value = TeqserMain.g_wrap.value;
        }
        if (TeqserMain.g_width.value > 0.0) {
            TeqserMain.g_twidth.value = TeqserMain.g_swidth.value = TeqserMain.g_width.value;
        }
        if (!(TeqserMain.g_compress.value.equals("deflate") || TeqserMain.g_compress.value.equals("lzw") || TeqserMain.g_compress.value.equals("none") || TeqserMain.g_compress.value.equals("packbits"))) {
            System.err.print("Unknown compression mode: " + g_compress + ". none." + "\n");
            TeqserMain.g_compress.value = "none";
        }
        if (TeqserMain.g_quality.value < 1.0) {
            TeqserMain.g_quality.value = 1.0;
        }
        if (TeqserMain.g_quality.value > 100.0) {
            TeqserMain.g_quality.value = 100.0;
        }
        if (TeqserMain.g_bake.value < 2.0) {
            TeqserMain.g_bake.value = 2.0;
        }
        if (TeqserMain.g_bake.value > 2048.0) {
            TeqserMain.g_bake.value = 2048.0;
        }
        String compression = TeqserMain.g_compress.value;
        float quality = (float)TeqserMain.g_quality.value;
        RendermanInterface.RiBegin("teqser");
        if (TeqserMain.g_envcube.value) {
            if (ap.leftovers().size() != 7) {
                System.err.print("Need 6 images for cubic environment map\n");
                System.exit(-1);
            }
            System.out.printf("CubeFace Environment %s %s %s %s %s %s ----> %s \n\t\"fov\"= %4.1f\n\t\"filter\"= %s \n\t\"swidth\"= %4.1f\n\t\"twidth\"= %4.1f\n\t\"compression\" = %s\n", (String)ap.leftovers().elementAt(0), (String)ap.leftovers().elementAt(1), (String)ap.leftovers().elementAt(2), (String)ap.leftovers().elementAt(3), (String)ap.leftovers().elementAt(4), (String)ap.leftovers().elementAt(5), (String)ap.leftovers().elementAt(6), TeqserMain.g_fov.value, TeqserMain.g_filter.value, TeqserMain.g_swidth.value, TeqserMain.g_twidth.value, TeqserMain.g_compress.value);
            RendermanInterface.RiMakeCubeFaceEnvironment((String)ap.leftovers().elementAt(0), (String)ap.leftovers().elementAt(1), (String)ap.leftovers().elementAt(2), (String)ap.leftovers().elementAt(3), (String)ap.leftovers().elementAt(4), (String)ap.leftovers().elementAt(5), (String)ap.leftovers().elementAt(6), (float)TeqserMain.g_fov.value, filterfunc, (float)TeqserMain.g_swidth.value, (float)TeqserMain.g_twidth.value, "compression", compression, "quality", Float.valueOf(quality), null);
        } else if (TeqserMain.g_shadow.value) {
            System.out.printf("Shadow %s ----> %s \n\t\"compression\" = %s\n", (String)ap.leftovers().elementAt(0), (String)ap.leftovers().elementAt(1), TeqserMain.g_compress.value);
            RendermanInterface.RiMakeShadow((String)ap.leftovers().elementAt(0), (String)ap.leftovers().elementAt(1), Float.valueOf((float)TeqserMain.g_twidth.value), "compression", compression, "quality", Float.valueOf(quality), null);
        } else if (TeqserMain.g_envlatl.value) {
            System.out.printf("LatLong Environment %s ----> %s \n\t\"compression\" = %s \n", (String)ap.leftovers().elementAt(0), (String)ap.leftovers().elementAt(1), TeqserMain.g_compress.value);
            RendermanInterface.RiMakeLatLongEnvironment((String)ap.leftovers().elementAt(0), (String)ap.leftovers().elementAt(1), filterfunc, (float)TeqserMain.g_swidth.value, (float)TeqserMain.g_twidth.value, "compression", compression, "quality", Float.valueOf(quality), null);
        } else {
            System.out.printf("Texture %s ----> %s \n\t\"swrap\"= %s \n\t\"twrap\"= %s \n\t\"filter\"= %s \n\t\"swidth\"= %4.1f\n\t\"twidth\"= %4.1f\n\t\"compression\" = %s\n", (String)ap.leftovers().elementAt(0), (String)ap.leftovers().elementAt(1), TeqserMain.g_swrap.value, TeqserMain.g_twrap.value, TeqserMain.g_filter.value, TeqserMain.g_swidth.value, TeqserMain.g_twidth.value, compression);
            ((String)ap.leftovers().elementAt(0)).contains(".bake");
            RendermanInterface.RiMakeTexture((String)ap.leftovers().elementAt(0), (String)ap.leftovers().elementAt(1), TeqserMain.g_swrap.value, TeqserMain.g_twrap.value, filterfunc, (float)TeqserMain.g_swidth.value, (float)TeqserMain.g_twidth.value, "compression", compression, "quality", Float.valueOf(quality), null);
        }
        RendermanInterface.RiEnd();
        System.exit(0);
    }

    public static void version(PrintStream Stream2) {
        Stream2.println("teqser version 1.0.0");
    }
}

