/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.main;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.argparse.ArgParse;
import net.cellcomputing.himawari.display.DisplayManager;
import net.cellcomputing.himawari.library.RendermanInterface;
import net.cellcomputing.himawari.main.Globalmain;
import net.cellcomputing.himawari.parser.Global;
import net.cellcomputing.himawari.parser.Parser;
import net.cellcomputing.himawari.util.HimawariLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Himawari {
    static long tick = 0L;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static void main(String[] args) {
        String rootPath;
        String acPath = System.getProperty("user.dir");
        Globalmain.g_rc_path = rootPath = acPath.concat(File.separator);
        Globalmain.g_shader_path = rootPath.concat("shaders");
        Globalmain.g_archive_path = rootPath.concat("archives");
        Globalmain.g_texture_path = rootPath.concat("textures");
        Globalmain.g_display_path = rootPath.concat("bin");
        Globalmain.g_dso_path = rootPath.concat("dsos");
        Globalmain.g_procedural_path = rootPath.concat("procedures");
        Globalmain.g_plugin_path = rootPath.concat("plugins");
        ArgParse ap = new ArgParse();
        ap.usageHeader(String.valueOf(new String("Usage: ")) + Himawari.class.getSimpleName() + " [options] [RIB file...]");
        ap.argFlag("help", "\tPrint this help and exit", Globalmain.g_cl_help);
        ap.alias("help", "h");
        ap.argFlag("version", "\tPrint version information and exit", Globalmain.g_cl_version);
        ap.argFlag("pause", "\tWait for a keypress on completion", Globalmain.g_cl_pause);
        ap.argFlag("progress", "\tPrint progress information", Globalmain.g_cl_progress);
        ap.argFlag("Progress", "\tPrint prman-compatible progress information (ignores -progressformat)", Globalmain.g_cl_Progress);
        ap.argString("progressformat", "=string printf-style format string for -progress", Globalmain.g_cl_strprogress);
        ap.argInt("endofframe", "=integer\tEquivalent to \"endofframe\" RIB option", Globalmain.g_cl_endofframe);
        ap.argFlag("nostandard", "\tDo not declare standard RenderMan parameters", Globalmain.g_cl_nostandard);
        ap.argInt("verbose", "=integer\tSet log output level\n\t0 = errors\n\t1 = warnings (default)\n\t2 = information\n\t3 = debug", Globalmain.g_cl_verbose);
        ap.alias("verbose", "v");
        ap.argFlag("renderinfo", "\tPrint out infos about base rendering settings", Globalmain.g_cl_rinfo);
        ap.argString("type", "=string\tSpecify a display device type to use", Globalmain.g_cl_type);
        ap.argString("addtype", "=string\tSpecify a display device type to add", Globalmain.g_cl_addtype);
        ap.argString("mode", "=string\tSpecify a display device mode to use", Globalmain.g_cl_mode);
        ap.argFlag("fb", "\tSame as --type=\"framebuffer\" --mode=\"rgb\"", Globalmain.g_cl_fb);
        ap.alias("fb", "d");
        ap.argFloats("crop", " x1 x2 y1 y2\tSpecify a crop window, values are in screen space.", Globalmain.g_cl_cropWindow, ArgParse.SEP_ARGV, 4);
        ap.argString("rc", "=string\tOverride the default RIB configuration file [" + Globalmain.g_rc_path + "]", Globalmain.g_cl_rc_path);
        ap.argString("shaders", "=string\tOverride the default shader searchpath(s) [" + Globalmain.g_shader_path + "]", Globalmain.g_cl_shader_path);
        ap.argString("archives", "=string\tOverride the default archive searchpath(s) [" + Globalmain.g_archive_path + "]", Globalmain.g_cl_archive_path);
        ap.argString("textures", "=string\tOverride the default texture searchpath(s) [" + Globalmain.g_texture_path + "]", Globalmain.g_cl_texture_path);
        ap.argString("displays", "=string\tOverride the default display searchpath(s) [" + Globalmain.g_display_path + "]", Globalmain.g_cl_display_path);
        ap.argString("dsolibs", "=string\tOverride the default dso searchpath(s) [" + Globalmain.g_dso_path + "]", Globalmain.g_cl_dso_path);
        ap.argString("procedurals", "=string\tOverride the default procedural searchpath(s) [" + Globalmain.g_procedural_path + "]", Globalmain.g_cl_procedural_path);
        ap.argString("plugins", "=string\tOverride the default plugin searchpath(s) [" + Globalmain.g_plugin_path + "]", Globalmain.g_cl_plugin_path);
        ap.argInts("frames", " f1 f2\tSpecify a starting/ending frame to render (inclusive).", Globalmain.g_cl_frames, ArgParse.SEP_ARGV, 2);
        ap.argString("frameslist", "=string\tSpecify a range of frames to render, ',' separated with '-' to indicate ranges.", Globalmain.g_cl_framesList);
        ap.argFlag("nocolor", "\tDisable colored output", Globalmain.g_cl_no_color);
        ap.argFlag("beep", "\tBeep on completion of all ribs", Globalmain.g_cl_beep);
        ap.alias("nocolor", "nc");
        ap.argFlag("enc", "\tRead encrypted file.", Globalmain.g_enc_flag);
        ap.allowUnrecognizedOptions();
        if (args.length > 0 && !ap.parse(args.length, args)) {
            System.err.println(ap.errmsg());
            System.err.flush();
            System.err.println(ap.usagemsg());
            System.err.flush();
            System.exit(1);
        }
        if (Globalmain.g_cl_cropWindow.size() > 0 && Globalmain.g_cl_cropWindow.size() != 4) {
            System.out.println("Error: invalid number of arguments to -crop, expected 4, got " + Globalmain.g_cl_cropWindow.size());
            System.out.flush();
            Globalmain.g_cl_help.value = true;
        }
        if (Globalmain.g_cl_help.value) {
            System.out.println(ap.usagemsg());
            System.exit(0);
        }
        if (Globalmain.g_cl_version.value) {
            System.out.print("himawari version 2.0.1");
            System.exit(0);
        }
        if (System.getenv("HIMAWARI_RC_PATH") != null) {
            Globalmain.g_rc_path = System.getenv("HIMAWARI_RC_PATH");
        }
        if (System.getenv("HIMAWARI_SHADER_PATH") != null) {
            Globalmain.g_shader_path = System.getenv("HIMAWARI_SHADER_PATH");
        }
        if (System.getenv("HIMAWARI_ARCHIVE_PATH") != null) {
            Globalmain.g_archive_path = System.getenv("HIMAWARI_ARCHIVE_PATH");
        }
        if (System.getenv("HIMAWARI_TEXTURE_PATH") != null) {
            Globalmain.g_texture_path = System.getenv("HIMAWARI_TEXTURE_PATH");
        }
        if (System.getenv("HIMAWARI_DISPLAY_PATH") != null) {
            Globalmain.g_display_path = System.getenv("HIMAWARI_DISPLAY_PATH");
        }
        if (System.getenv("HIMAWARI_DSO_PATH") != null) {
            Globalmain.g_dso_path = System.getenv("HIMAWARI_DSO_PATH");
        }
        if (System.getenv("HIMAWARI_PROCEDURAL_PATH") != null) {
            Globalmain.g_procedural_path = System.getenv("HIMAWARI_PROCEDURAL_PATH");
        }
        if (System.getenv("HIMAWARI_PLUGIN_PATH") != null) {
            Globalmain.g_procedural_path = System.getenv("HIMAWARI_PLUGIN_PATH");
        }
        if (Globalmain.g_cl_rc_path.value.length() != 0) {
            Globalmain.g_rc_path = Globalmain.g_cl_rc_path.value;
        }
        if (Globalmain.g_cl_shader_path.value.length() != 0) {
            Globalmain.g_shader_path = Globalmain.g_cl_shader_path.value;
        }
        if (Globalmain.g_cl_archive_path.value.length() != 0) {
            Globalmain.g_archive_path = Globalmain.g_cl_archive_path.value;
        }
        if (Globalmain.g_cl_texture_path.value.length() != 0) {
            Globalmain.g_texture_path = Globalmain.g_cl_texture_path.value;
        }
        if (Globalmain.g_cl_display_path.value.length() != 0) {
            Globalmain.g_display_path = Globalmain.g_cl_display_path.value;
        }
        if (Globalmain.g_cl_dso_path.value.length() != 0) {
            Globalmain.g_dso_path = Globalmain.g_cl_dso_path.value;
        }
        if (Globalmain.g_cl_procedural_path.value.length() != 0) {
            Globalmain.g_procedural_path = Globalmain.g_cl_procedural_path.value;
        }
        if (Globalmain.g_cl_plugin_path.value.length() != 0) {
            Globalmain.g_plugin_path = Globalmain.g_cl_plugin_path.value;
        }
        HimawariLogger logger = HimawariLogger.getLogger();
        logger.setLogLevel("ERROR");
        if (Globalmain.g_cl_verbose.value > 0) {
            logger.setLogLevel("WARNING");
        }
        if (Globalmain.g_cl_verbose.value > 1) {
            logger.setLogLevel("INFO");
        }
        if (Globalmain.g_cl_verbose.value > 2) {
            logger.setLogLevel("DEBUG");
        }
        logger.info("rc path: " + Globalmain.g_rc_path + "\n");
        logger.info("shader path(s): " + Globalmain.g_shader_path + "\n");
        logger.info("archive path(s): " + Globalmain.g_archive_path + "\n");
        logger.info("texture path(s): " + Globalmain.g_texture_path + "\n");
        logger.info("display path(s): " + Globalmain.g_display_path + "\n");
        logger.info("dso path(s): " + Globalmain.g_dso_path + "\n");
        logger.info("procedural path(s): " + Globalmain.g_procedural_path + "\n");
        logger.info("plugin path(s): " + Globalmain.g_plugin_path + "\n");
        if (ap.leftovers().size() == 0) {
            String name = "System.in";
            Himawari.RenderFile(System.in, name);
        } else {
            int e = 0;
            while (e < ap.leftovers().size()) {
                try {
                    String name = new String((String)ap.leftovers().get(e));
                    DataInputStream file = new DataInputStream(new FileInputStream(name));
                    Himawari.RenderFile(file, name);
                    file.close();
                }
                catch (IOException ioe) {
                    System.err.println("Warning: Cannot open file \"" + (String)ap.leftovers().get(e) + "\"\n");
                }
                ++e;
            }
        }
        if (Globalmain.g_cl_pause.value) {
            System.out.print("Press any key...");
            System.out.flush();
            try {
                System.in.read();
                System.in.close();
            }
            catch (IOException e) {
                return;
            }
        }
    }

    public static void PrintProgress(float percent, int FrameNo) {
        int itag;
        String strProgress;
        if (!Globalmain.g_cl_progress.value && !Globalmain.g_cl_Progress.value) {
            return;
        }
        if (percent >= 100.0f && !Globalmain.g_cl_Progress.value) {
            System.out.print("                                                                              \r");
            System.out.flush();
            return;
        }
        if (tick == 0L) {
            tick = System.currentTimeMillis() / 1000L;
        }
        long now = System.currentTimeMillis() / 1000L;
        float total_secs = now - tick;
        float total_mins = total_secs / 60.0f;
        float total_hrs = total_mins / 60.0f;
        float sub_secs = total_secs - (float)((int)total_mins) * 60.0f;
        float sub_mins = total_mins - (float)((int)total_hrs) * 60.0f;
        float total_secsleft = 100.0f / percent * total_secs - total_secs;
        float total_minsleft = total_secsleft / 60.0f;
        float total_hrsleft = total_minsleft / 60.0f;
        float sub_secsleft = total_secsleft - (float)((int)total_minsleft) * 60.0f;
        float sub_minsleft = total_minsleft - (float)((int)total_hrsleft) * 60.0f;
        int ipos = 0;
        int last_percent = 0;
        if (Globalmain.g_cl_Progress.value) {
            strProgress = "R90000%p%%";
            if ((float)last_percent == (percent = (float)((int)percent))) {
                return;
            }
            last_percent = (int)percent;
        } else {
            strProgress = Globalmain.g_cl_strprogress.value;
        }
        StringBuilder strOutput = new StringBuilder(100);
        DecimalFormat dcformat = new DecimalFormat("00.00");
        do {
            if ((itag = strProgress.indexOf(37, ipos)) == -1) {
                strOutput.append(strProgress.substring(ipos));
                break;
            }
            if (ipos != itag) {
                strOutput.append(strProgress.substring(ipos, ipos + (itag - ipos)));
            }
            switch (strProgress.charAt(itag + 1)) {
                case 'p': {
                    String percentOut = dcformat.format(percent);
                    strOutput.append(' ');
                    strOutput.append(percentOut);
                    break;
                }
                case 's': {
                    strOutput.append((int)total_secs);
                    break;
                }
                case 'S': {
                    strOutput.append((int)total_secsleft);
                    break;
                }
                case 'm': {
                    strOutput.append((int)total_mins);
                    break;
                }
                case 'M': {
                    strOutput.append((int)total_minsleft);
                    break;
                }
                case 'h': {
                    strOutput.append((int)total_hrs);
                    break;
                }
                case 'H': {
                    strOutput.append((int)total_hrsleft);
                    break;
                }
                case 't': {
                    strOutput.append(String.valueOf((int)total_hrs) + ":" + String.valueOf((int)sub_mins) + ":" + String.valueOf((int)sub_secs));
                    break;
                }
                case 'T': {
                    strOutput.append(String.valueOf((int)total_hrsleft) + ":" + String.valueOf((int)sub_minsleft) + ":" + String.valueOf((int)sub_secsleft));
                    break;
                }
                case 'f': {
                    strOutput.append(FrameNo);
                    break;
                }
                case '%': {
                    strOutput.append('%');
                }
            }
        } while ((ipos = itag + 2) < strProgress.length());
        while (strOutput.length() < 79) {
            strOutput.append(' ');
        }
        System.out.print(strOutput);
        if (Globalmain.g_cl_Progress.value) {
            System.out.print("\n");
        } else {
            System.out.print("\r");
        }
        System.out.flush();
    }

    public static void PreWorld() {
        if (Globalmain.g_cl_fb.value) {
            RendermanInterface.RiDisplay("himawari", "framebuffer", "rgb", new Object[]{null});
        } else if (Globalmain.g_cl_type.value != null && Globalmain.g_cl_type.value.length() != 0) {
            RendermanInterface.RiDisplay("himawari" + Himawari.TypeToExtension(Globalmain.g_cl_type.value), Globalmain.g_cl_type.value, Globalmain.g_cl_mode.value, new Object[]{null});
        } else if (Globalmain.g_cl_addtype.value != null && Globalmain.g_cl_addtype.value.length() != 0) {
            RendermanInterface.RiDisplay("+himawari" + Himawari.TypeToExtension(Globalmain.g_cl_addtype.value), Globalmain.g_cl_addtype.value, Globalmain.g_cl_mode.value, new Object[]{null});
        }
        if (Globalmain.g_cl_endofframe.value >= 0) {
            p_int[] tmp = new p_int[]{Globalmain.g_cl_endofframe};
            RendermanInterface.RiOption("statistics", "endofframe", tmp, null);
        }
        if (Globalmain.g_cl_cropWindow.size() == 4) {
            RendermanInterface.RiCropWindow(((Double)Globalmain.g_cl_cropWindow.get(0)).floatValue(), ((Double)Globalmain.g_cl_cropWindow.get(1)).floatValue(), ((Double)Globalmain.g_cl_cropWindow.get(2)).floatValue(), ((Double)Globalmain.g_cl_cropWindow.get(3)).floatValue());
        }
    }

    private static String TypeToExtension(String type) {
        if (type.equals("tiff") || type.equals("tif")) {
            return ".tif";
        }
        if (type.equals("bmp")) {
            return ".bmp";
        }
        if (type.equals("png")) {
            return ".png";
        }
        if (type.equals("jpg")) {
            return ".jpg";
        }
        if (type.equals("jpeg2000")) {
            return ".j2k";
        }
        if (type.equals("hdr")) {
            return ".hdr";
        }
        return "";
    }

    public static void RenderFile(InputStream file, String name) {
        Parser parser = new Parser();
        RendermanInterface.RiBegin("CRIBBER");
        if (!Globalmain.g_cl_nostandard.value) {
            Global.StandardDeclarations();
        }
        if (Globalmain.g_cl_rinfo.value) {
            p_int[] g_cl_rinfo_al = new p_int[]{new p_int(1)};
            RendermanInterface.RiOption("statistics", "renderinfo", g_cl_rinfo_al, null);
        }
        p_String[] popt = new p_String[]{new p_String()};
        popt[0].value = Globalmain.g_shader_path;
        RendermanInterface.RiOption("searchpath", "shader", popt, null);
        popt[0].value = Globalmain.g_archive_path;
        RendermanInterface.RiOption("searchpath", "archive", popt, null);
        popt[0].value = Globalmain.g_texture_path;
        RendermanInterface.RiOption("searchpath", "texture", popt, null);
        popt[0].value = Globalmain.g_display_path;
        RendermanInterface.RiOption("searchpath", "display", popt, null);
        popt[0].value = Globalmain.g_dso_path;
        RendermanInterface.RiOption("searchpath", "dsolibs", popt, null);
        popt[0].value = Globalmain.g_procedural_path;
        RendermanInterface.RiOption("searchpath", "procedural", popt, null);
        popt[0].value = Globalmain.g_plugin_path;
        RendermanInterface.RiOption("searchpath", "plugin", popt, null);
        try {
            RendermanInterface.RiProgressHandler(Himawari.class.getMethod("PrintProgress", Float.TYPE, Integer.TYPE));
            RendermanInterface.RiPreWorldFunction(Himawari.class.getMethod("PreWorld", new Class[0]));
        }
        catch (SecurityException e1) {
            HimawariLogger.outputException(e1);
        }
        catch (NoSuchMethodException e1) {
            HimawariLogger.outputException(e1);
        }
        HimawariLogger logger = HimawariLogger.getLogger();
        logger.info("Loading config file " + Globalmain.g_rc_path + "\n");
        try {
            String rcfile = Globalmain.g_rc_path;
            if (rcfile != null) {
                parser.parse(rcfile);
            }
        }
        catch (FileNotFoundException rcfile) {
        }
        catch (Exception e) {
            HimawariLogger.outputException(e);
        }
        Global.ClearFrames();
        if (Globalmain.g_cl_frames.size() == 2) {
            Global.AppendFrames(Globalmain.g_cl_frames.get(0) + "-" + Globalmain.g_cl_frames.get(1));
        }
        if (Globalmain.g_cl_framesList.value.length() != 0) {
            Global.AppendFrames(Globalmain.g_cl_framesList.value);
        }
        try {
            parser.parse(name);
        }
        catch (Exception e) {
            HimawariLogger.outputException(e);
        }
        RendermanInterface.RiEnd();
        if (!Globalmain.g_cl_nostandard.value) {
            Global.CleanupDeclarations();
        }
        parser = null;
    }

    public static synchronized ArrayList<String> start(String[] args) {
        Himawari.main(args);
        return DisplayManager.getDisplayNames();
    }
}

