/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library.types;

import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqVector3D;

public strictfp class PublicFunctions {
    public static final float LERP(float t, float x0, float x1) {
        return x0 + t * (x1 - x0);
    }

    public static final float CLAMP(float a, float min, float max) {
        return a < min ? min : (a > max ? max : a);
    }

    public static final CqColor CMIN(CqColor a, CqColor b) {
        return new CqColor(Math.min(a.fRed(), b.fRed()), Math.min(a.fGreen(), b.fGreen()), Math.min(a.fBlue(), b.fBlue()));
    }

    public static final CqColor CMAX(CqColor a, CqColor b) {
        return new CqColor(Math.max(a.fRed(), b.fRed()), Math.max(a.fGreen(), b.fGreen()), Math.max(a.fBlue(), b.fBlue()));
    }

    public static final CqColor CCLAMP(CqColor a, CqColor min, CqColor max) {
        return new CqColor(PublicFunctions.CLAMP(a.fRed(), min.fRed(), max.fRed()), PublicFunctions.CLAMP(a.fGreen(), min.fGreen(), max.fGreen()), PublicFunctions.CLAMP(a.fBlue(), min.fBlue(), max.fBlue()));
    }

    public static final CqVector3D VMIN(CqVector3D a, CqVector3D b) {
        return new CqVector3D(Math.min(a.x, b.x), Math.min(a.y, b.y), Math.min(a.z, b.z));
    }

    public static final CqVector3D VMAX(CqVector3D a, CqVector3D b) {
        return new CqVector3D(Math.max(a.x, b.x), Math.max(a.y, b.y), Math.max(a.z, b.z));
    }

    public static final CqVector3D VCLAMP(CqVector3D a, CqVector3D min, CqVector3D max) {
        return new CqVector3D(PublicFunctions.CLAMP(a.x, min.x, max.x), PublicFunctions.CLAMP(a.y, min.y, max.y), PublicFunctions.CLAMP(a.z, min.z, max.z));
    }

    public static final long LOWEST_BIT(long x) {
        return x & (x ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
    }

    public static final boolean IS_POW2(long x) {
        return x != 0L && x == PublicFunctions.LOWEST_BIT(x);
    }

    public static final long CEIL_POW2_MINUS1(long x) {
        long i = 1L;
        while (i != 0L) {
            x |= x >> (int)i;
            i <<= 1;
        }
        return x;
    }

    public static final long CEIL_POW2(long x) {
        return PublicFunctions.CEIL_POW2_MINUS1(x - 1L) + 1L;
    }

    public static final float RAD(float a) {
        return (float)((double)a / 57.29577951308232);
    }

    public static final float DEG(float a) {
        return (float)((double)a / (Math.PI / 180));
    }
}

