/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqQuadric;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqTorus
extends CqQuadric {
    private float m_MajorRadius;
    private float m_MinorRadius;
    private float m_PhiMin;
    private float m_PhiMax;
    private float m_ThetaMin;
    private float m_ThetaMax;
    static /* synthetic */ Class class$0;

    public CqTorus() {
        this(1.0f, 0.2f, 0.0f, 360.0f, 0.0f, 360.0f);
    }

    public CqTorus(float majorradius) {
        this(majorradius, 0.2f, 0.0f, 360.0f, 0.0f, 360.0f);
    }

    public CqTorus(float majorradius, float minorradius) {
        this(majorradius, minorradius, 0.0f, 360.0f, 0.0f, 360.0f);
    }

    public CqTorus(float majorradius, float minorradius, float phimin) {
        this(majorradius, minorradius, phimin, 360.0f, 0.0f, 360.0f);
    }

    public CqTorus(float majorradius, float minorradius, float phimin, float phimax) {
        this(majorradius, minorradius, phimin, phimax, 0.0f, 360.0f);
    }

    public CqTorus(float majorradius, float minorradius, float phimin, float phimax, float thetamin) {
        this(majorradius, minorradius, phimin, phimax, thetamin, 360.0f);
    }

    public CqTorus(float majorradius, float minorradius, float phimin, float phimax, float thetamin, float thetamax) {
        this.m_MajorRadius = majorradius;
        this.m_MinorRadius = minorradius;
        this.m_PhiMin = phimin;
        this.m_PhiMax = phimax;
        this.m_ThetaMin = thetamin;
        this.m_ThetaMax = thetamax;
    }

    public CqTorus(CqTorus From) {
        this.assginment(From);
    }

    @Override
    public void destruct() {
    }

    @Override
    public CqBound Bound() {
        STLVector<CqVector3D> curve = new STLVector<CqVector3D>(CqVector3D.class);
        CqVector3D vA = new CqVector3D(this.m_MajorRadius, 0.0f, 0.0f);
        CqVector3D vB = new CqVector3D(1.0f, 0.0f, 0.0f);
        CqVector3D vC = new CqVector3D(0.0f, 0.0f, 1.0f);
        CqVector3D vD = new CqVector3D(0.0f, 0.0f, 0.0f);
        this.Circle(vA, vB, vC, this.m_MinorRadius, (float)StrictMath.toRadians(this.m_PhiMin), (float)StrictMath.toRadians(this.m_PhiMax), curve);
        CqMatrix matRot = new CqMatrix((float)StrictMath.toRadians(this.m_ThetaMin), vC);
        for (CqVector3D i : curve) {
            i.assignment(matRot.multiply(i));
        }
        CqBound B = new CqBound(this.RevolveForBound(curve, vD, vC, (float)StrictMath.toRadians(this.m_ThetaMax - this.m_ThetaMin)));
        B.Transform(this.m_matTx);
        return this.AdjustBoundForTransformationMotion(B);
    }

    @Override
    public CqVector3D DicePoint(int u, int v) {
        float theta = (float)StrictMath.toRadians(this.m_ThetaMin + (float)u * (this.m_ThetaMax - this.m_ThetaMin) / (float)this.m_uDiceSize);
        float phi = (float)StrictMath.toRadians(this.m_PhiMin + (float)v * (this.m_PhiMax - this.m_PhiMin) / (float)this.m_vDiceSize);
        float r = (float)((double)this.m_MinorRadius * StrictMath.cos(phi));
        float z = (float)((double)this.m_MinorRadius * StrictMath.sin(phi));
        return new CqVector3D((float)((double)(this.m_MajorRadius + r) * StrictMath.cos(theta)), (float)((double)(this.m_MajorRadius + r) * StrictMath.sin(theta)), z);
    }

    @Override
    public CqVector3D DicePoint(int u, int v, CqVector3D Normal) {
        float theta = (float)StrictMath.toRadians(this.m_ThetaMin + (float)u * (this.m_ThetaMax - this.m_ThetaMin) / (float)this.m_uDiceSize);
        float phi = (float)StrictMath.toRadians(this.m_PhiMin + (float)v * (this.m_PhiMax - this.m_PhiMin) / (float)this.m_vDiceSize);
        float r = (float)((double)this.m_MinorRadius * StrictMath.cos(phi));
        float z = (float)((double)this.m_MinorRadius * StrictMath.sin(phi));
        Normal.x((float)(StrictMath.cos(phi) * StrictMath.cos(theta)));
        Normal.y((float)(StrictMath.cos(phi) * StrictMath.sin(theta)));
        Normal.z((float)StrictMath.sin(phi));
        return new CqVector3D((float)((double)(this.m_MajorRadius + r) * StrictMath.cos(theta)), (float)((double)(this.m_MajorRadius + r) * StrictMath.sin(theta)), z);
    }

    @Override
    public int PreSubdivide(STLVector<CqBasicSurface> aSplits, boolean u) {
        float zcent = (float)((double)(this.m_PhiMax + this.m_PhiMin) * 0.5);
        float arccent = (float)((double)(this.m_ThetaMin + this.m_ThetaMax) * 0.5);
        CqTorus pNew1 = new CqTorus(this);
        CqTorus pNew2 = new CqTorus(this);
        if (u) {
            pNew1.m_ThetaMax = arccent;
            pNew2.m_ThetaMin = arccent;
        } else {
            pNew1.m_PhiMax = zcent;
            pNew2.m_PhiMin = zcent;
        }
        aSplits.add(pNew1);
        aSplits.add(pNew2);
        return 2;
    }

    public CqTorus assginment(CqTorus From) {
        super.assignment(From);
        this.m_MajorRadius = From.m_MajorRadius;
        this.m_MinorRadius = From.m_MinorRadius;
        this.m_PhiMax = From.m_PhiMax;
        this.m_PhiMin = From.m_PhiMin;
        this.m_ThetaMin = From.m_ThetaMin;
        this.m_ThetaMax = From.m_ThetaMax;
        return this;
    }
}

